/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=SerializableLibrary.class)
final class SerializableLibraryGen
extends LibraryFactory<SerializableLibrary> {
    private static final Class<SerializableLibrary> LIBRARY_CLASS = SerializableLibraryGen.lazyLibraryClass();
    private static final Message IS_SERIALIZABLE = new MessageImpl("isSerializable", 0, false, Boolean.TYPE, Object.class);
    private static final Message SERIALIZE = new MessageImpl("serialize", 1, false, Void.TYPE, Object.class, Object.class);
    private static final SerializableLibraryGen INSTANCE = new SerializableLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private SerializableLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(IS_SERIALIZABLE, SERIALIZE)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return SerializableLibrary.class;
    }

    protected SerializableLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected SerializableLibrary createDelegate(SerializableLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        SerializableLibrary lib = (SerializableLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isSerializable(receiver);
            }
            case 1: {
                lib.serialize(receiver, args[offset]);
                return null;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected SerializableLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected SerializableLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<SerializableLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.api.SerializableLibrary", false, SerializableLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=SerializableLibrary.class)
    private static final class Proxy
    extends SerializableLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isSerializable(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_SERIALIZABLE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void serialize(Object receiver_, Object buffer) throws UnsupportedMessageException {
            try {
                this.lib.send(receiver_, SERIALIZE, new Object[]{buffer});
                return;
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=SerializableLibrary.class)
    private static final class Delegate
    extends SerializableLibrary {
        @Node.Child
        private SerializableLibrary delegateLibrary;

        Delegate(SerializableLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isSerializable(Object receiver_) {
            if (SerializableLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = SerializableLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((SerializableLibrary)SerializableLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isSerializable(delegate);
            }
            return this.delegateLibrary.isSerializable(receiver_);
        }

        @Override
        public void serialize(Object receiver_, Object buffer) throws UnsupportedMessageException {
            if (SerializableLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = SerializableLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((SerializableLibrary)SerializableLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).serialize(delegate, buffer);
                return;
            }
            this.delegateLibrary.serialize(receiver_, buffer);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=SerializableLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(SerializableLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                SerializableLibrary exportLibrary = (SerializableLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (SerializableLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=SerializableLibrary.class)
    private static abstract class CachedDispatch
    extends SerializableLibrary {
        @Node.Child
        SerializableLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(SerializableLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public boolean isSerializable(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializableLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isSerializable(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void serialize(Object receiver_, Object buffer) throws UnsupportedMessageException {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    SerializableLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.serialize(receiver_, buffer);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                SerializableLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (SerializableLibrary)this.insert((Node)((SerializableLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        SerializableLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (SerializableLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((SerializableLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=SerializableLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends SerializableLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isSerializable(Object receiver_) {
            return ((SerializableLibrary)INSTANCE.getUncached(receiver_)).isSerializable(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void serialize(Object receiver_, Object buffer) throws UnsupportedMessageException {
            ((SerializableLibrary)INSTANCE.getUncached(receiver_)).serialize(receiver_, buffer);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=SerializableLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=SerializableLibrary.class)
    private static final class Default
    extends LibraryExport<SerializableLibrary> {
        private Default() {
            super(SerializableLibrary.class, Object.class, false, false, 0);
        }

        protected SerializableLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected SerializableLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=SerializableLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends SerializableLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isSerializable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isSerializable(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void serialize(Object receiver, Object buffer) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.serialize(receiver, buffer);
            }
        }

        @GeneratedBy(value=SerializableLibrary.class)
        private static final class Cached
        extends SerializableLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isSerializable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isSerializable(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public void serialize(Object receiver, Object buffer) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.serialize(this.dynamicDispatch_.cast(receiver), buffer);
            }
        }
    }

    @GeneratedBy(value=SerializableLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(SerializableLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=SerializableLibrary.class)
    private static final class CachedToUncachedDispatch
    extends SerializableLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isSerializable(Object receiver_) {
            assert (SerializableLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((SerializableLibrary)INSTANCE.getUncached(receiver_)).isSerializable(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void serialize(Object receiver_, Object buffer) throws UnsupportedMessageException {
            assert (SerializableLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((SerializableLibrary)INSTANCE.getUncached(receiver_)).serialize(receiver_, buffer);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

