// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode.CachedCallSignatureNode;
import com.oracle.truffle.nfi.CallSignatureNodeFactory.CachedCallSignatureNodeGen;
import com.oracle.truffle.nfi.NFISignature.BindMsg;
import com.oracle.truffle.nfi.NFISignature.CreateClosure;
import com.oracle.truffle.nfi.NFISignature.InvokeMember;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(NFISignature.class)
@SuppressWarnings({"javadoc", "unused"})
public final class NFISignatureGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<SignatureLibrary> SIGNATURE_LIBRARY_ = LibraryFactory.resolve(SignatureLibrary.class);
    private static final LibraryFactory<NFIBackendSignatureLibrary> N_F_I_BACKEND_SIGNATURE_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureLibrary.class);

    static  {
        LibraryExport.register(NFISignature.class, new InteropLibraryExports(), new SignatureLibraryExports());
    }

    private NFISignatureGen() {
    }

    private static void init() {
        // This method is intended to ensure class initialization.
    }

    @GeneratedBy(NFISignature.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NFISignature.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NFISignature;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NFISignature;
            return new Cached(receiver);
        }

        @GeneratedBy(NFISignature.class)
        private static final class Cached extends InteropLibrary {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link InvokeMember#doBind}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_INVOKE_EXCEPTION = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(3, 1)));

            @Child private SignatureLibrary receiverSignatureLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link InvokeMember#doBind}
             *   1: SpecializationActive {@link InvokeMember#doCreateClosure}
             *   2: SpecializationActive {@link InvokeMember#doUnknown}
             *   3: InlinedCache
             *        Specialization: {@link InvokeMember#doBind}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            protected Cached(Object receiver) {
                NFISignature castReceiver = ((NFISignature) receiver) ;
                this.receiverSignatureLibrary_ = SIGNATURE_LIBRARY_.create((castReceiver));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISignature)) {
                    return false;
                } else if (!this.receiverSignatureLibrary_.accepts((receiver))) {
                    return false;
                } else {
                    return true;
                }
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFISignature arg0Value, String arg1Value, Object[] arg2Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[NFISignature.InvokeMember.doBind(NFISignature, String, Object[], Node, SignatureLibrary, InlinedBranchProfile)] */) && (NFISignature.isBind(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[NFISignature.InvokeMember.doCreateClosure(NFISignature, String, Object[], Node, SignatureLibrary, InlinedBranchProfile)] */) && (NFISignature.isCreateClosure(arg1Value))) {
                    return false;
                }
                return true;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link InvokeMember#doBind}
             *     Activation probability: 0.48333
             *     With/without class size: 11/0 bytes
             *   Specialization {@link InvokeMember#doCreateClosure}
             *     Activation probability: 0.33333
             *     With/without class size: 9/0 bytes
             *   Specialization {@link InvokeMember#doUnknown}
             *     Activation probability: 0.18333
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert arg0Value_ instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[NFISignature.InvokeMember.doBind(NFISignature, String, Object[], Node, SignatureLibrary, InlinedBranchProfile)] || SpecializationActive[NFISignature.InvokeMember.doCreateClosure(NFISignature, String, Object[], Node, SignatureLibrary, InlinedBranchProfile)] || SpecializationActive[NFISignature.InvokeMember.doUnknown(NFISignature, String, Object[])] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[NFISignature.InvokeMember.doBind(NFISignature, String, Object[], Node, SignatureLibrary, InlinedBranchProfile)] */) {
                        if ((NFISignature.isBind(arg1Value))) {
                            Node node__ = (this);
                            SignatureLibrary signatureLibrary__ = this.receiverSignatureLibrary_;
                            return InvokeMember.doBind(arg0Value, arg1Value, arg2Value, node__, signatureLibrary__, INLINED_INVOKE_EXCEPTION);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[NFISignature.InvokeMember.doCreateClosure(NFISignature, String, Object[], Node, SignatureLibrary, InlinedBranchProfile)] */) {
                        if ((NFISignature.isCreateClosure(arg1Value))) {
                            Node node__1 = (this);
                            SignatureLibrary signatureLibrary__1 = this.receiverSignatureLibrary_;
                            return InvokeMember.doCreateClosure(arg0Value, arg1Value, arg2Value, node__1, signatureLibrary__1, INLINED_INVOKE_EXCEPTION);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[NFISignature.InvokeMember.doUnknown(NFISignature, String, Object[])] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                            return InvokeMember.doUnknown(arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(NFISignature arg0Value, String arg1Value, Object[] arg2Value) throws ArityException, UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    SignatureLibrary signatureLibrary__ = null;
                    Node node__ = null;
                    if ((NFISignature.isBind(arg1Value))) {
                        node__ = (this);
                        signatureLibrary__ = this.receiverSignatureLibrary_;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[NFISignature.InvokeMember.doBind(NFISignature, String, Object[], Node, SignatureLibrary, InlinedBranchProfile)] */;
                        this.state_0_ = state_0;
                        return InvokeMember.doBind(arg0Value, arg1Value, arg2Value, node__, signatureLibrary__, INLINED_INVOKE_EXCEPTION);
                    }
                }
                {
                    SignatureLibrary signatureLibrary__1 = null;
                    Node node__1 = null;
                    if ((NFISignature.isCreateClosure(arg1Value))) {
                        node__1 = (this);
                        signatureLibrary__1 = this.receiverSignatureLibrary_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[NFISignature.InvokeMember.doCreateClosure(NFISignature, String, Object[], Node, SignatureLibrary, InlinedBranchProfile)] */;
                        this.state_0_ = state_0;
                        return InvokeMember.doCreateClosure(arg0Value, arg1Value, arg2Value, node__1, signatureLibrary__1, INLINED_INVOKE_EXCEPTION);
                    }
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[NFISignature.InvokeMember.doUnknown(NFISignature, String, Object[])] */;
                this.state_0_ = state_0;
                return InvokeMember.doUnknown(arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b111) & ((state_0 & 0b111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert receiver instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISignature) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert receiver instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISignature) receiver)).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                assert receiver instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISignature) receiver)).isMemberInvocable(member);
            }

        }
        @GeneratedBy(NFISignature.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISignature;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws ArityException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                if ((NFISignature.isBind(arg1Value))) {
                    return InvokeMember.doBind(arg0Value, arg1Value, arg2Value, (this), SIGNATURE_LIBRARY_.getUncached((arg0Value)), (InlinedBranchProfile.getUncached()));
                }
                if ((NFISignature.isCreateClosure(arg1Value))) {
                    return InvokeMember.doCreateClosure(arg0Value, arg1Value, arg2Value, (this), SIGNATURE_LIBRARY_.getUncached((arg0Value)), (InlinedBranchProfile.getUncached()));
                }
                return InvokeMember.doUnknown(arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISignature) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISignature) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISignature) receiver) .isMemberInvocable(member);
            }

        }
    }
    @GeneratedBy(NFISignature.class)
    public static final class SignatureLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            NFISignatureGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.nfi.api.SignatureLibrary";
        }

    }
    @GeneratedBy(NFISignature.class)
    private static final class SignatureLibraryExports extends LibraryExport<SignatureLibrary> {

        private SignatureLibraryExports() {
            super(SignatureLibrary.class, NFISignature.class, false, true, 1);
        }

        @Override
        protected SignatureLibrary createUncached(Object receiver) {
            assert receiver instanceof NFISignature;
            SignatureLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected SignatureLibrary createCached(Object receiver) {
            assert receiver instanceof NFISignature || receiver instanceof LibraryExport<?>;
            return new Cached(receiver);
        }

        @GeneratedBy(NFISignature.class)
        private static final class Cached extends SignatureLibrary implements GenerateAOT.Provider {

            static final ReferenceField<CreateClosureCachedData> CREATE_CLOSURE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "createClosure_cached_cache", CreateClosureCachedData.class);

            @Child private NFIBackendSignatureLibrary receiverNativeSignatureNFIBackendSignatureLibrary_;
            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link BindMsg#doSymbol}
             *   2: SpecializationActive {@link BindMsg#doOther}
             *   3: SpecializationActive {@link CreateClosure#doCached}
             *   4: SpecializationActive {@link CreateClosure#doCreate}
             *   5: SpecializationActive {@link NFISignature#call(NFISignature, Object, Object[], CachedCallSignatureNode)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private CreateClosureCachedData createClosure_cached_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NFISignature#call(NFISignature, Object, Object[], CachedCallSignatureNode)}
             *   Parameter: {@link CachedCallSignatureNode} call</pre>
             */
            @Child private CachedCallSignatureNode callNode__call_call_;

            protected Cached(Object receiver) {
                if (!(receiver instanceof LibraryExport<?>)) {
                    NFISignature castReceiver = ((NFISignature) receiver) ;
                    this.receiverNativeSignatureNFIBackendSignatureLibrary_ = N_F_I_BACKEND_SIGNATURE_LIBRARY_.create((castReceiver.nativeSignature));
                }
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISignature)) {
                    return false;
                } else if (this.receiverNativeSignatureNFIBackendSignatureLibrary_ != null && !this.receiverNativeSignatureNFIBackendSignatureLibrary_.accepts((((NFISignature) receiver).nativeSignature))) {
                    return false;
                } else {
                    return true;
                }
            }

            @SuppressWarnings("static-method")
            private boolean bindMsgFallbackGuard_(int state_0, NFISignature arg0Value, Object arg1Value) {
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[NFISignature.BindMsg.doSymbol(NFISignature, NFISymbol)] */) && arg1Value instanceof NFISymbol) {
                    return false;
                }
                return true;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BindMsg#doSymbol}
             *     Activation probability: 0.21667
             *     With/without class size: 6/0 bytes
             *   Specialization {@link BindMsg#doOther}
             *     Activation probability: 0.11667
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public Object bind(Object arg0Value_, Object arg1Value) {
                assert arg0Value_ instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return bindMsgAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[NFISignature.BindMsg.doSymbol(NFISignature, NFISymbol)] || SpecializationActive[NFISignature.BindMsg.doOther(NFISignature, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[NFISignature.BindMsg.doSymbol(NFISignature, NFISymbol)] */ && arg1Value instanceof NFISymbol) {
                        NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                        return BindMsg.doSymbol(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[NFISignature.BindMsg.doOther(NFISignature, Object)] */) {
                        if (bindMsgFallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return BindMsg.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return bindMsgAndSpecialize(arg0Value, arg1Value);
            }

            private Object bindMsgAndSpecialize(NFISignature arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof NFISymbol) {
                    NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[NFISignature.BindMsg.doSymbol(NFISignature, NFISymbol)] */;
                    this.state_0_ = state_0;
                    return BindMsg.doSymbol(arg0Value, arg1Value_);
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[NFISignature.BindMsg.doOther(NFISignature, Object)] */;
                this.state_0_ = state_0;
                return BindMsg.doOther(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b110) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b110) & ((state_0 & 0b110) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[NFISignature.BindMsg.doSymbol(NFISignature, NFISymbol)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[NFISignature.BindMsg.doOther(NFISignature, Object)] */;
                }
                {
                    CachedCallSignatureNode call__ = this.insert((CachedCallSignatureNodeGen.create()));
                    Objects.requireNonNull(call__, "Specialization 'call(NFISignature, Object, Object[], CachedCallSignatureNode)' cache 'call' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.callNode__call_call_ = call__;
                    assert NodeUtil.assertRecursion(this.callNode__call_call_, 1);
                    ((GenerateAOT.Provider) this.callNode__call_call_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[NFISignature.call(NFISignature, Object, Object[], CachedCallSignatureNode)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.callNode__call_call_ = null;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link CreateClosure#doCached}
             *     Activation probability: 0.21667
             *     With/without class size: 10/12 bytes
             *   Specialization {@link CreateClosure#doCreate}
             *     Activation probability: 0.11667
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert arg0Value_ instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return createClosureAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[NFISignature.CreateClosure.doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object)] || SpecializationActive[NFISignature.CreateClosure.doCreate(NFISignature, Object, NFIBackendSignatureLibrary)] */) {
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NFISignature.CreateClosure.doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object)] */) {
                        CreateClosureCachedData s0_ = this.createClosure_cached_cache;
                        while (s0_ != null) {
                            if (!Assumption.isValidAssumption(s0_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                removeCached_(s0_);
                                return createClosureAndSpecialize(arg0Value, arg1Value);
                            }
                            if ((s0_.lib_.accepts(s0_.cachedClosure_.signature.nativeSignature)) && (arg1Value == s0_.cachedClosure_.executable) && (arg0Value == s0_.cachedClosure_.signature)) {
                                return CreateClosure.doCached(arg0Value, arg1Value, s0_.cachedClosure_, s0_.lib_, s0_.cachedRet_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NFISignature.CreateClosure.doCreate(NFISignature, Object, NFIBackendSignatureLibrary)] */) {
                        {
                            NFIBackendSignatureLibrary lib__ = this.receiverNativeSignatureNFIBackendSignatureLibrary_;
                            return CreateClosure.doCreate(arg0Value, arg1Value, lib__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return createClosureAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("unused")
            private Object createClosureAndSpecialize(NFISignature arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[NFISignature.CreateClosure.doCreate(NFISignature, Object, NFIBackendSignatureLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        CreateClosureCachedData s0_ = CREATE_CLOSURE_CACHED_CACHE_UPDATER.getVolatile(this);
                        CreateClosureCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.lib_.accepts(s0_.cachedClosure_.signature.nativeSignature)) && (arg1Value == s0_.cachedClosure_.executable) && (arg0Value == s0_.cachedClosure_.signature) && Assumption.isValidAssumption(s0_.assumption0_)) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                NFIClosure cachedClosure__ = (CreateClosure.createClosure(arg1Value, arg0Value));
                                // assert (s0_.lib_.accepts(s0_.cachedClosure_.signature.nativeSignature));
                                if ((arg1Value == cachedClosure__.executable) && (arg0Value == cachedClosure__.signature)) {
                                    Assumption assumption0 = (NFILanguage.getSingleContextAssumption());
                                    if (Assumption.isValidAssumption(assumption0)) {
                                        if (count0_ < (3)) {
                                            s0_ = this.insert(new CreateClosureCachedData(s0_original));
                                            Objects.requireNonNull(cachedClosure__, "Specialization 'doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object)' cache 'cachedClosure' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                            s0_.cachedClosure_ = cachedClosure__;
                                            NFIBackendSignatureLibrary lib__1 = s0_.insert((N_F_I_BACKEND_SIGNATURE_LIBRARY_.create(cachedClosure__.signature.nativeSignature)));
                                            Objects.requireNonNull(lib__1, "Specialization 'doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object)' cache 'lib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                            s0_.lib_ = lib__1;
                                            s0_.cachedRet_ = (lib__1.createClosure(cachedClosure__.signature.nativeSignature, cachedClosure__));
                                            s0_.assumption0_ = assumption0;
                                            if (!CREATE_CLOSURE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b1000 /* add SpecializationActive[NFISignature.CreateClosure.doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                        }
                        if (s0_ != null) {
                            return CreateClosure.doCached(arg0Value, arg1Value, s0_.cachedClosure_, s0_.lib_, s0_.cachedRet_);
                        }
                        break;
                    }
                }
                {
                    NFIBackendSignatureLibrary lib__ = null;
                    lib__ = this.receiverNativeSignatureNFIBackendSignatureLibrary_;
                    this.createClosure_cached_cache = null;
                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[NFISignature.CreateClosure.doCached(NFISignature, Object, NFIClosure, NFIBackendSignatureLibrary, Object)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[NFISignature.CreateClosure.doCreate(NFISignature, Object, NFIBackendSignatureLibrary)] */;
                    this.state_0_ = state_0;
                    return CreateClosure.doCreate(arg0Value, arg1Value, lib__);
                }
            }

            void removeCached_(CreateClosureCachedData s0_) {
                while (true) {
                    CreateClosureCachedData cur = this.createClosure_cached_cache;
                    CreateClosureCachedData original = cur;
                    CreateClosureCachedData update = null;
                    while (cur != null) {
                        if (cur == s0_) {
                            if (cur == original) {
                                update = cur.next_;
                            } else {
                                update = original.remove(this, s0_);
                            }
                            break;
                        }
                        cur = cur.next_;
                    }
                    if (cur != null && !CREATE_CLOSURE_CACHED_CACHE_UPDATER.compareAndSet(this, original, update)) {
                        continue;
                    }
                    break;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFISignature#call(NFISignature, Object, Object[], CachedCallSignatureNode)}
             *     Activation probability: 0.33333
             *     With/without class size: 10/4 bytes
             * </pre>
             */
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert arg0Value_ instanceof NFISignature : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[NFISignature.call(NFISignature, Object, Object[], CachedCallSignatureNode)] */) {
                    {
                        CachedCallSignatureNode call__ = this.callNode__call_call_;
                        if (call__ != null) {
                            return arg0Value.call(arg1Value, arg2Value, call__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object callNode_AndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                CachedCallSignatureNode call__ = this.insert((CachedCallSignatureNodeGen.create()));
                Objects.requireNonNull(call__, "Specialization 'call(NFISignature, Object, Object[], CachedCallSignatureNode)' cache 'call' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.callNode__call_call_ = call__;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[NFISignature.call(NFISignature, Object, Object[], CachedCallSignatureNode)] */;
                this.state_0_ = state_0;
                return arg0Value.call(arg1Value, arg2Value, call__);
            }

            @GeneratedBy(NFISignature.class)
            @DenyReplace
            private static final class CreateClosureCachedData extends Node implements SpecializationDataNode {

                @Child CreateClosureCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link CreateClosure#doCached}
                 *   Parameter: {@link NFIClosure} cachedClosure</pre>
                 */
                @CompilationFinal NFIClosure cachedClosure_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link CreateClosure#doCached}
                 *   Parameter: {@link NFIBackendSignatureLibrary} lib</pre>
                 */
                @Child NFIBackendSignatureLibrary lib_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link CreateClosure#doCached}
                 *   Parameter: {@link Object} cachedRet</pre>
                 */
                @CompilationFinal Object cachedRet_;
                @CompilationFinal Assumption assumption0_;

                CreateClosureCachedData(CreateClosureCachedData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                CreateClosureCachedData remove(Node parent, CreateClosureCachedData search) {
                    CreateClosureCachedData newNext = this.next_;
                    if (newNext != null) {
                        if (search == newNext) {
                            newNext = newNext.next_;
                        } else {
                            newNext = newNext.remove(this, search);
                        }
                    }
                    CreateClosureCachedData copy = parent.insert(new CreateClosureCachedData(newNext));
                    copy.cachedClosure_ = this.cachedClosure_;
                    copy.lib_ = copy.insert(this.lib_);
                    copy.cachedRet_ = this.cachedRet_;
                    copy.assumption0_ = this.assumption0_;
                    return copy;
                }

            }
        }
        @GeneratedBy(NFISignature.class)
        @DenyReplace
        private static final class Uncached extends SignatureLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISignature;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object bind(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                if (arg1Value instanceof NFISymbol) {
                    NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                    return BindMsg.doSymbol(arg0Value, arg1Value_);
                }
                return BindMsg.doOther(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                return CreateClosure.doCreate(arg0Value, arg1Value, N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached((arg0Value.nativeSignature)));
            }

            @TruffleBoundary
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = ((NFISignature) arg0Value_);
                return arg0Value.call(arg1Value, arg2Value, (CachedCallSignatureNodeGen.getUncached()));
            }

        }
    }
}
