// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFIBackendLibrary.class)
final class NFIBackendLibraryGen extends LibraryFactory<NFIBackendLibrary> {

    private static final Class<NFIBackendLibrary> LIBRARY_CLASS = NFIBackendLibraryGen.lazyLibraryClass();
    private static final Message GET_SIMPLE_TYPE = new MessageImpl("getSimpleType", 0, false, Object.class, Object.class, NativeSimpleType.class);
    private static final Message GET_ARRAY_TYPE = new MessageImpl("getArrayType", 1, false, Object.class, Object.class, NativeSimpleType.class);
    private static final Message GET_ENV_TYPE = new MessageImpl("getEnvType", 2, false, Object.class, Object.class);
    private static final Message CREATE_SIGNATURE_BUILDER = new MessageImpl("createSignatureBuilder", 3, false, Object.class, Object.class);
    private static final NFIBackendLibraryGen INSTANCE = new NFIBackendLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NFIBackendLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(NFIBackendLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private NFIBackendLibraryGen() {
        super(NFIBackendLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(NFIBackendLibraryGen.GET_SIMPLE_TYPE, NFIBackendLibraryGen.GET_ARRAY_TYPE, NFIBackendLibraryGen.GET_ENV_TYPE, NFIBackendLibraryGen.CREATE_SIGNATURE_BUILDER)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return NFIBackendLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected NFIBackendLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected NFIBackendLibrary createDelegate(NFIBackendLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NFIBackendLibrary lib = (NFIBackendLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.getSimpleType(receiver, (NativeSimpleType) args[offset]);
            case 1 :
                return lib.getArrayType(receiver, (NativeSimpleType) args[offset]);
            case 2 :
                return lib.getEnvType(receiver);
            case 3 :
                return lib.createSignatureBuilder(receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected NFIBackendLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected NFIBackendLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<NFIBackendLibrary> lazyLibraryClass() {
        try {
            return (Class<NFIBackendLibrary>) Class.forName("com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary", false, NFIBackendLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(NFIBackendLibrary.class)
    private static final class Default extends LibraryExport<NFIBackendLibrary> {

        private Default() {
            super(NFIBackendLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected NFIBackendLibrary createUncached(Object receiver) {
            NFIBackendLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NFIBackendLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(NFIBackendLibrary.class)
        private static final class Cached extends NFIBackendLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public Object getSimpleType(Object receiver, NativeSimpleType type) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object getArrayType(Object receiver, NativeSimpleType type) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object getEnvType(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object createSignatureBuilder(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
        @GeneratedBy(NFIBackendLibrary.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object getSimpleType(Object receiver, NativeSimpleType type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object getArrayType(Object receiver, NativeSimpleType type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object getEnvType(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object createSignatureBuilder(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
    }
    @GeneratedBy(NFIBackendLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(NFIBackendLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(NFIBackendLibrary.class)
    private static final class Proxy extends NFIBackendLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            try {
                return lib.send(receiver_, NFIBackendLibraryGen.GET_SIMPLE_TYPE, type);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            try {
                return lib.send(receiver_, NFIBackendLibraryGen.GET_ARRAY_TYPE, type);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object getEnvType(Object receiver_) {
            try {
                return lib.send(receiver_, NFIBackendLibraryGen.GET_ENV_TYPE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object createSignatureBuilder(Object receiver_) {
            try {
                return lib.send(receiver_, NFIBackendLibraryGen.CREATE_SIGNATURE_BUILDER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(NFIBackendLibrary.class)
    private static final class Delegate extends NFIBackendLibrary {

        @Child private NFIBackendLibrary delegateLibrary;

        Delegate(NFIBackendLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getSimpleType(delegate, type);
            } else {
                return this.delegateLibrary.getSimpleType(receiver_, type);
            }
        }

        @Override
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getArrayType(delegate, type);
            } else {
                return this.delegateLibrary.getArrayType(receiver_, type);
            }
        }

        @Override
        public Object getEnvType(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getEnvType(delegate);
            } else {
                return this.delegateLibrary.getEnvType(receiver_);
            }
        }

        @Override
        public Object createSignatureBuilder(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).createSignatureBuilder(delegate);
            } else {
                return this.delegateLibrary.createSignatureBuilder(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(NFIBackendLibrary.class)
    private static final class CachedToUncachedDispatch extends NFIBackendLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getSimpleType(receiver_, type);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getArrayType(receiver_, type);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object getEnvType(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getEnvType(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object createSignatureBuilder(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).createSignatureBuilder(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(NFIBackendLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends NFIBackendLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            return INSTANCE.getUncached(receiver_).getSimpleType(receiver_, type);
        }

        @TruffleBoundary
        @Override
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            return INSTANCE.getUncached(receiver_).getArrayType(receiver_, type);
        }

        @TruffleBoundary
        @Override
        public Object getEnvType(Object receiver_) {
            return INSTANCE.getUncached(receiver_).getEnvType(receiver_);
        }

        @TruffleBoundary
        @Override
        public Object createSignatureBuilder(Object receiver_) {
            return INSTANCE.getUncached(receiver_).createSignatureBuilder(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(NFIBackendLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(NFIBackendLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(NFIBackendLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(NFIBackendLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(NFIBackendLibrary.class)
    private abstract static class CachedDispatch extends NFIBackendLibrary {

        @Child NFIBackendLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(NFIBackendLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public Object getSimpleType(Object receiver_, NativeSimpleType type) {
            do {
                CachedDispatch current = this;
                do {
                    NFIBackendLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getSimpleType(receiver_, type);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object getArrayType(Object receiver_, NativeSimpleType type) {
            do {
                CachedDispatch current = this;
                do {
                    NFIBackendLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getArrayType(receiver_, type);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object getEnvType(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    NFIBackendLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getEnvType(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object createSignatureBuilder(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    NFIBackendLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.createSignatureBuilder(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                NFIBackendLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        NFIBackendLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
