// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(BackendNativePointerLibrary.class)
final class BackendNativePointerLibraryGen extends LibraryFactory<BackendNativePointerLibrary> {

    private static final Class<BackendNativePointerLibrary> LIBRARY_CLASS = BackendNativePointerLibraryGen.lazyLibraryClass();
    private static final Message IS_POINTER = new MessageImpl("isPointer", 0, false, boolean.class, Object.class);
    private static final Message AS_POINTER = new MessageImpl("asPointer", 1, false, long.class, Object.class);
    private static final BackendNativePointerLibraryGen INSTANCE = new BackendNativePointerLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(BackendNativePointerLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(BackendNativePointerLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private BackendNativePointerLibraryGen() {
        super(BackendNativePointerLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(BackendNativePointerLibraryGen.IS_POINTER, BackendNativePointerLibraryGen.AS_POINTER)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return BackendNativePointerLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected BackendNativePointerLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected BackendNativePointerLibrary createDelegate(BackendNativePointerLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        BackendNativePointerLibrary lib = (BackendNativePointerLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isPointer(receiver);
            case 1 :
                return lib.asPointer(receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected BackendNativePointerLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected BackendNativePointerLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<BackendNativePointerLibrary> lazyLibraryClass() {
        try {
            return (Class<BackendNativePointerLibrary>) Class.forName("com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary", false, BackendNativePointerLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(BackendNativePointerLibrary.class)
    private static final class Default extends LibraryExport<BackendNativePointerLibrary> {

        private Default() {
            super(BackendNativePointerLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected BackendNativePointerLibrary createUncached(Object receiver) {
            BackendNativePointerLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected BackendNativePointerLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(BackendNativePointerLibrary.class)
        private static final class Cached extends BackendNativePointerLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPointer((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.asPointer((dynamicDispatch_.cast(receiver)));
            }

        }
        @GeneratedBy(BackendNativePointerLibrary.class)
        @DenyReplace
        private static final class Uncached extends BackendNativePointerLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPointer(receiver);
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.asPointer(receiver);
            }

        }
    }
    @GeneratedBy(BackendNativePointerLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(BackendNativePointerLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(BackendNativePointerLibrary.class)
    private static final class Proxy extends BackendNativePointerLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, BackendNativePointerLibraryGen.IS_POINTER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            try {
                return (long) lib.send(receiver_, BackendNativePointerLibraryGen.AS_POINTER);
            } catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(BackendNativePointerLibrary.class)
    private static final class Delegate extends BackendNativePointerLibrary {

        @Child private BackendNativePointerLibrary delegateLibrary;

        Delegate(BackendNativePointerLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isPointer(delegate);
            } else {
                return this.delegateLibrary.isPointer(receiver_);
            }
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).asPointer(delegate);
            } else {
                return this.delegateLibrary.asPointer(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(BackendNativePointerLibrary.class)
    private static final class CachedToUncachedDispatch extends BackendNativePointerLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean isPointer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isPointer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).asPointer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(BackendNativePointerLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends BackendNativePointerLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean isPointer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isPointer(receiver_);
        }

        @TruffleBoundary
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            return INSTANCE.getUncached(receiver_).asPointer(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(BackendNativePointerLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(BackendNativePointerLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(BackendNativePointerLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch implements GenerateAOT.Provider {

        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(BackendNativePointerLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport<BackendNativePointerLibrary> export : INSTANCE.getAOTExports()) {
                BackendNativePointerLibrary exportLibrary = INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = insert(exportLibrary);
                } else {
                    this.next = insert(new CachedDispatchNext(exportLibrary, this.next));
                }
            }
            this.aot_ = true;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(BackendNativePointerLibrary.class)
    private abstract static class CachedDispatch extends BackendNativePointerLibrary {

        @Child BackendNativePointerLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(BackendNativePointerLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean value);

        @ExplodeLoop
        @Override
        public boolean isPointer(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    BackendNativePointerLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isPointer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    BackendNativePointerLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.asPointer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                if (isAOT()) {
                    this.library = null;
                    this.next = null;
                    setAOT(false);
                }
                CachedDispatch current = this;
                BackendNativePointerLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        BackendNativePointerLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
