// CheckStyle: start generated
package com.oracle.truffle.nfi.backend.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
final class NFIBackendSignatureBuilderLibraryGen extends LibraryFactory<NFIBackendSignatureBuilderLibrary> {

    private static final Class<NFIBackendSignatureBuilderLibrary> LIBRARY_CLASS = NFIBackendSignatureBuilderLibraryGen.lazyLibraryClass();
    private static final Message SET_RETURN_TYPE = new MessageImpl("setReturnType", 0, false, void.class, Object.class, Object.class);
    private static final Message ADD_ARGUMENT = new MessageImpl("addArgument", 1, false, void.class, Object.class, Object.class);
    private static final Message MAKE_VARARGS = new MessageImpl("makeVarargs", 2, false, void.class, Object.class);
    private static final Message BUILD = new MessageImpl("build", 3, false, Object.class, Object.class);
    private static final NFIBackendSignatureBuilderLibraryGen INSTANCE = new NFIBackendSignatureBuilderLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NFIBackendSignatureBuilderLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(NFIBackendSignatureBuilderLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private NFIBackendSignatureBuilderLibraryGen() {
        super(NFIBackendSignatureBuilderLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(NFIBackendSignatureBuilderLibraryGen.SET_RETURN_TYPE, NFIBackendSignatureBuilderLibraryGen.ADD_ARGUMENT, NFIBackendSignatureBuilderLibraryGen.MAKE_VARARGS, NFIBackendSignatureBuilderLibraryGen.BUILD)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return NFIBackendSignatureBuilderLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected NFIBackendSignatureBuilderLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected NFIBackendSignatureBuilderLibrary createDelegate(NFIBackendSignatureBuilderLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NFIBackendSignatureBuilderLibrary lib = (NFIBackendSignatureBuilderLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                lib.setReturnType(receiver, args[offset]);
                return null;
            case 1 :
                lib.addArgument(receiver, args[offset]);
                return null;
            case 2 :
                lib.makeVarargs(receiver);
                return null;
            case 3 :
                return lib.build(receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected NFIBackendSignatureBuilderLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected NFIBackendSignatureBuilderLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<NFIBackendSignatureBuilderLibrary> lazyLibraryClass() {
        try {
            return (Class<NFIBackendSignatureBuilderLibrary>) Class.forName("com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureBuilderLibrary", false, NFIBackendSignatureBuilderLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    private static final class Default extends LibraryExport<NFIBackendSignatureBuilderLibrary> {

        private Default() {
            super(NFIBackendSignatureBuilderLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createUncached(Object receiver) {
            NFIBackendSignatureBuilderLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
        private static final class Cached extends NFIBackendSignatureBuilderLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public void setReturnType(Object receiver, Object type) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public void addArgument(Object receiver, Object type) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public void makeVarargs(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.makeVarargs((dynamicDispatch_.cast(receiver)));
                return;
            }

            @TruffleBoundary
            @Override
            public Object build(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
        @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendSignatureBuilderLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void setReturnType(Object receiver, Object type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public void addArgument(Object receiver, Object type) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public void makeVarargs(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.makeVarargs(receiver);
                return;
            }

            @TruffleBoundary
            @Override
            public Object build(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
    }
    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(NFIBackendSignatureBuilderLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    private static final class Proxy extends NFIBackendSignatureBuilderLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void setReturnType(Object receiver_, Object type) {
            try {
                lib.send(receiver_, NFIBackendSignatureBuilderLibraryGen.SET_RETURN_TYPE, type);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void addArgument(Object receiver_, Object type) {
            try {
                lib.send(receiver_, NFIBackendSignatureBuilderLibraryGen.ADD_ARGUMENT, type);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void makeVarargs(Object receiver_) {
            try {
                lib.send(receiver_, NFIBackendSignatureBuilderLibraryGen.MAKE_VARARGS);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object build(Object receiver_) {
            try {
                return lib.send(receiver_, NFIBackendSignatureBuilderLibraryGen.BUILD);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    private static final class Delegate extends NFIBackendSignatureBuilderLibrary {

        @Child private NFIBackendSignatureBuilderLibrary delegateLibrary;

        Delegate(NFIBackendSignatureBuilderLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public void setReturnType(Object receiver_, Object type) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).setReturnType(delegate, type);
                return;
            } else {
                this.delegateLibrary.setReturnType(receiver_, type);
                return;
            }
        }

        @Override
        public void addArgument(Object receiver_, Object type) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).addArgument(delegate, type);
                return;
            } else {
                this.delegateLibrary.addArgument(receiver_, type);
                return;
            }
        }

        @Override
        public void makeVarargs(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).makeVarargs(delegate);
                return;
            } else {
                this.delegateLibrary.makeVarargs(receiver_);
                return;
            }
        }

        @Override
        public Object build(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).build(delegate);
            } else {
                return this.delegateLibrary.build(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    private static final class CachedToUncachedDispatch extends NFIBackendSignatureBuilderLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public void setReturnType(Object receiver_, Object type) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).setReturnType(receiver_, type);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void addArgument(Object receiver_, Object type) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).addArgument(receiver_, type);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void makeVarargs(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).makeVarargs(receiver_);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object build(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).build(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends NFIBackendSignatureBuilderLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public void setReturnType(Object receiver_, Object type) {
            INSTANCE.getUncached(receiver_).setReturnType(receiver_, type);
            return;
        }

        @TruffleBoundary
        @Override
        public void addArgument(Object receiver_, Object type) {
            INSTANCE.getUncached(receiver_).addArgument(receiver_, type);
            return;
        }

        @TruffleBoundary
        @Override
        public void makeVarargs(Object receiver_) {
            INSTANCE.getUncached(receiver_).makeVarargs(receiver_);
            return;
        }

        @TruffleBoundary
        @Override
        public Object build(Object receiver_) {
            return INSTANCE.getUncached(receiver_).build(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(NFIBackendSignatureBuilderLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(NFIBackendSignatureBuilderLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(NFIBackendSignatureBuilderLibrary.class)
    private abstract static class CachedDispatch extends NFIBackendSignatureBuilderLibrary {

        @Child NFIBackendSignatureBuilderLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(NFIBackendSignatureBuilderLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public void setReturnType(Object receiver_, Object type) {
            do {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureBuilderLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.setReturnType(receiver_, type);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void addArgument(Object receiver_, Object type) {
            do {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureBuilderLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.addArgument(receiver_, type);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void makeVarargs(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureBuilderLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.makeVarargs(receiver_);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object build(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureBuilderLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.build(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                NFIBackendSignatureBuilderLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        NFIBackendSignatureBuilderLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
