/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.API;
import com.oracle.truffle.nfi.NFIContext;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.NFIUnsupportedTypeException;
import com.oracle.truffle.nfi.SignatureTypeCachedState;
import com.oracle.truffle.nfi.SimpleTypeCachedState;
import com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureBuilderLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder;

final class SignatureRootNode
extends RootNode {
    final String backendId;
    @Node.Child
    BuildSignatureNode buildSignature;

    SignatureRootNode(NFILanguage language, String backendId, BuildSignatureNode buildSignature) {
        super((TruffleLanguage)language);
        this.backendId = backendId;
        this.buildSignature = buildSignature;
    }

    public String getName() {
        return "buildSignature";
    }

    public Object execute(VirtualFrame frame) {
        API api = NFIContext.get((Node)this).getAPI(this.backendId);
        return this.buildSignature.execute(api);
    }

    static abstract class BuildSignatureNode
    extends Node {
        @Node.Children
        ArgumentBuilderNode[] argBuilders;
        private static final ProfiledArrayBuilder.ArrayFactory<NFIType> FACTORY = new ProfiledArrayBuilder.ArrayFactory<NFIType>(){

            public NFIType[] create(int size) {
                return new NFIType[size];
            }
        };

        abstract Object execute(API var1);

        BuildSignatureNode(ArgumentBuilderNode[] argBuilders) {
            this.argBuilders = argBuilders;
        }

        @Specialization(limit="3")
        @ExplodeLoop
        Object doBuild(API api, @CachedLibrary(value="api.backend") NFIBackendLibrary backendLibrary, @CachedLibrary(limit="1") NFIBackendSignatureBuilderLibrary sigBuilderLibrary, @Cached ProfiledArrayBuilder.ArrayBuilderFactory factory) {
            Object backendBuilder = backendLibrary.createSignatureBuilder(api.backend);
            NFISignature.SignatureBuilder sigBuilder = new NFISignature.SignatureBuilder(api.backendId, backendBuilder, factory.allocate(FACTORY));
            for (int i = 0; i < this.argBuilders.length; ++i) {
                this.argBuilders[i].execute(api, sigBuilder);
            }
            return sigBuilderLibrary.build(sigBuilder);
        }
    }

    static abstract class GetSignatureTypeNode
    extends GetTypeNode {
        @Node.Child
        BuildSignatureNode buildSignature;

        GetSignatureTypeNode(BuildSignatureNode buildSignature) {
            this.buildSignature = buildSignature;
        }

        @Specialization(limit="1")
        Object getType(API api, @CachedLibrary(value="api.backend") NFIBackendLibrary backend) {
            Object signature = this.buildSignature.execute(api);
            Object backendType = backend.getSimpleType(api.backend, NativeSimpleType.POINTER);
            return new NFIType(SignatureTypeCachedState.INSTANCE, backendType, signature);
        }
    }

    @GenerateInline(value=false)
    static abstract class GetEnvTypeNode
    extends GetTypeNode {
        GetEnvTypeNode() {
        }

        @Specialization(limit="1")
        Object getType(API api, @CachedLibrary(value="api.backend") NFIBackendLibrary backend) {
            Object backendType = backend.getEnvType(api.backend);
            if (backendType == null) {
                throw new NFIUnsupportedTypeException("ENV");
            }
            return new NFIType(SimpleTypeCachedState.injected(), backendType, null);
        }
    }

    static abstract class GetArrayTypeNode
    extends GetTypeNode {
        private final NativeSimpleType type;

        GetArrayTypeNode(NativeSimpleType type) {
            this.type = type;
        }

        @Specialization(limit="1")
        Object getType(API api, @CachedLibrary(value="api.backend") NFIBackendLibrary backendLibrary) {
            Object backendType = backendLibrary.getArrayType(api.backend, this.type);
            if (backendType == null) {
                throw new NFIUnsupportedTypeException("[%s]", this.type.name());
            }
            return new NFIType(SimpleTypeCachedState.nop(), backendType);
        }
    }

    static abstract class GetSimpleTypeNode
    extends GetTypeNode {
        private final NativeSimpleType type;

        GetSimpleTypeNode(NativeSimpleType type) {
            this.type = type;
        }

        @Specialization(limit="1")
        Object getType(API api, @CachedLibrary(value="api.backend") NFIBackendLibrary backendLibrary) {
            Object backendType = backendLibrary.getSimpleType(api.backend, this.type);
            if (backendType == null) {
                throw new NFIUnsupportedTypeException(this.type.name());
            }
            return new NFIType(SimpleTypeCachedState.get(this.type), backendType);
        }
    }

    static abstract class GetTypeNode
    extends Node {
        GetTypeNode() {
        }

        abstract Object execute(API var1);
    }

    @GenerateInline(value=false)
    static abstract class MakeVarargs
    extends ArgumentBuilderNode {
        MakeVarargs() {
        }

        @Specialization(limit="1")
        void makeVarargs(API api, Object sigBuilder, @CachedLibrary(value="sigBuilder") NFIBackendSignatureBuilderLibrary sigBuilderLib) {
            sigBuilderLib.makeVarargs(sigBuilder);
        }
    }

    static abstract class AddArgumentNode
    extends ArgumentBuilderNode {
        @Node.Child
        GetTypeNode argType;

        AddArgumentNode(GetTypeNode argType) {
            this.argType = argType;
        }

        @Specialization(limit="1")
        void addArgument(API api, Object sigBuilder, @CachedLibrary(value="sigBuilder") NFIBackendSignatureBuilderLibrary sigBuilderLib) {
            sigBuilderLib.addArgument(sigBuilder, this.argType.execute(api));
        }
    }

    static abstract class SetRetTypeNode
    extends ArgumentBuilderNode {
        @Node.Child
        GetTypeNode retType;

        SetRetTypeNode(GetTypeNode retType) {
            this.retType = retType;
        }

        @Specialization(limit="1")
        void setRetType(API api, Object sigBuilder, @CachedLibrary(value="sigBuilder") NFIBackendSignatureBuilderLibrary sigBuilderLib) {
            sigBuilderLib.setReturnType(sigBuilder, this.retType.execute(api));
        }
    }

    static abstract class ArgumentBuilderNode
    extends Node {
        static final ArgumentBuilderNode[] EMPTY = new ArgumentBuilderNode[0];

        ArgumentBuilderNode() {
        }

        abstract void execute(API var1, Object var2);
    }
}

