// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode.BackendSymbolUnwrapNode;
import com.oracle.truffle.nfi.CallSignatureNode.CachedCallSignatureNode;
import com.oracle.truffle.nfi.CallSignatureNode.OptimizedCallClosureNode;
import com.oracle.truffle.nfi.CallSignatureNode.OptimizedCallSignatureNode;
import com.oracle.truffle.nfi.ConvertTypeNode.ConvertFromNativeNode;
import com.oracle.truffle.nfi.ConvertTypeNode.ConvertToNativeNode;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory.ConvertFromNativeNodeGen;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory.ConvertToNativeNodeGen;
import com.oracle.truffle.nfi.NFISignature.ArgsCachedState;
import com.oracle.truffle.nfi.NFISignature.SignatureCachedState;
import com.oracle.truffle.nfi.NFIType.TypeCachedState;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(CallSignatureNode.class)
@SuppressWarnings({"javadoc", "unused"})
final class CallSignatureNodeFactory {

    private static final LibraryFactory<NFIBackendSignatureLibrary> N_F_I_BACKEND_SIGNATURE_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link CachedCallSignatureNode#doOptimizedDirect}
     *     Activation probability: 0.48333
     *     With/without class size: 17/8 bytes
     *   Specialization {@link CachedCallSignatureNode#doOptimizedIndirect}
     *     Activation probability: 0.33333
     *     With/without class size: 10/4 bytes
     *   Specialization {@link CachedCallSignatureNode#doSlowPath}
     *     Activation probability: 0.18333
     *     With/without class size: 9/14 bytes
     * </pre>
     */
    @GeneratedBy(CachedCallSignatureNode.class)
    @SuppressWarnings("javadoc")
    static final class CachedCallSignatureNodeGen extends CachedCallSignatureNode implements GenerateAOT.Provider {

        private static final StateField SLOW_PATH__CACHED_CALL_SIGNATURE_NODE_SLOW_PATH_STATE_0_UPDATER = StateField.create(SlowPathData.lookup_(), "slowPath_state_0_");
        static final ReferenceField<OptimizedDirectData> OPTIMIZED_DIRECT_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "optimizedDirect_cache", OptimizedDirectData.class);
        /**
         * Source Info: <pre>
         *   Specialization: {@link CachedCallSignatureNode#doSlowPath}
         *   Parameter: {@link InlinedBranchProfile} exception
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_SLOW_PATH_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, SLOW_PATH__CACHED_CALL_SIGNATURE_NODE_SLOW_PATH_STATE_0_UPDATER.subUpdater(0, 1)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link CachedCallSignatureNode#doSlowPath}
         *   Parameter: {@link ConvertToNativeNode} convertArg
         *   Inline method: {@link ConvertToNativeNodeGen#inline}</pre>
         */
        private static final ConvertToNativeNode INLINED_SLOW_PATH_CONVERT_ARG_ = ConvertToNativeNodeGen.inline(InlineTarget.create(ConvertToNativeNode.class, SLOW_PATH__CACHED_CALL_SIGNATURE_NODE_SLOW_PATH_STATE_0_UPDATER.subUpdater(1, 3), ReferenceField.create(SlowPathData.lookup_(), "slowPath_convertArg__field1_", Node.class)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link CachedCallSignatureNode#doSlowPath}
         *   Parameter: {@link ConvertFromNativeNode} convertRet
         *   Inline method: {@link ConvertFromNativeNodeGen#inline}</pre>
         */
        private static final ConvertFromNativeNode INLINED_SLOW_PATH_CONVERT_RET_ = ConvertFromNativeNodeGen.inline(InlineTarget.create(ConvertFromNativeNode.class, SLOW_PATH__CACHED_CALL_SIGNATURE_NODE_SLOW_PATH_STATE_0_UPDATER.subUpdater(4, 3), ReferenceField.create(SlowPathData.lookup_(), "slowPath_convertRet__field1_", Node.class)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link CachedCallSignatureNode#doSlowPath}
         *   Parameter: {@link BackendSymbolUnwrapNode} backendSymbolUnwrapNode
         *   Inline method: {@link BackendSymbolUnwrapNodeGen#inline}</pre>
         */
        private static final BackendSymbolUnwrapNode INLINED_SLOW_PATH_BACKEND_SYMBOL_UNWRAP_NODE_ = BackendSymbolUnwrapNodeGen.inline(InlineTarget.create(BackendSymbolUnwrapNode.class, SLOW_PATH__CACHED_CALL_SIGNATURE_NODE_SLOW_PATH_STATE_0_UPDATER.subUpdater(7, 3)));
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link CachedCallSignatureNode#doOptimizedDirect}
         *   2: SpecializationActive {@link CachedCallSignatureNode#doOptimizedIndirect}
         *   3: SpecializationActive {@link CachedCallSignatureNode#doSlowPath}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private OptimizedDirectData optimizedDirect_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CachedCallSignatureNode#doOptimizedIndirect}
         *   Parameter: {@link IndirectCallNode} call</pre>
         */
        @Child private IndirectCallNode optimizedIndirect_call_;
        @Child private SlowPathData slowPath_cache;

        private CachedCallSignatureNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 0b1110) != 0 /* is SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedDirect(NFISignature, Object, Object[], SignatureCachedState, CallSignatureNode)] || SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedIndirect(NFISignature, Object, Object[], IndirectCallNode)] || SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doSlowPath(NFISignature, Object, Object[], Node, InlinedBranchProfile, ConvertToNativeNode, ConvertFromNativeNode, NFIBackendSignatureLibrary, BackendSymbolUnwrapNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedDirect(NFISignature, Object, Object[], SignatureCachedState, CallSignatureNode)] */) {
                    OptimizedDirectData s0_ = this.optimizedDirect_cache;
                    while (s0_ != null) {
                        assert DSLSupport.assertIdempotence((s0_.cachedState_ != null));
                        if ((arg0Value.cachedState == s0_.cachedState_)) {
                            return doOptimizedDirect(arg0Value, arg1Value, arg2Value, s0_.cachedState_, s0_.call_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedIndirect(NFISignature, Object, Object[], IndirectCallNode)] */) {
                    {
                        IndirectCallNode call__ = this.optimizedIndirect_call_;
                        if (call__ != null) {
                            if ((arg0Value.cachedState != null)) {
                                return doOptimizedIndirect(arg0Value, arg1Value, arg2Value, call__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doSlowPath(NFISignature, Object, Object[], Node, InlinedBranchProfile, ConvertToNativeNode, ConvertFromNativeNode, NFIBackendSignatureLibrary, BackendSymbolUnwrapNode)] */) {
                    SlowPathData s2_ = this.slowPath_cache;
                    if (s2_ != null) {
                        if ((arg0Value.cachedState == null)) {
                            Node node__ = (s2_);
                            return CachedCallSignatureNode.doSlowPath(arg0Value, arg1Value, arg2Value, node__, INLINED_SLOW_PATH_EXCEPTION_, INLINED_SLOW_PATH_CONVERT_ARG_, INLINED_SLOW_PATH_CONVERT_RET_, s2_.nativeLibrary_, INLINED_SLOW_PATH_BACKEND_SYMBOL_UNWRAP_NODE_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            int oldState_0 = (state_0 & 0b1110);
            try {
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedIndirect(NFISignature, Object, Object[], IndirectCallNode)] */) {
                    while (true) {
                        int count0_ = 0;
                        OptimizedDirectData s0_ = OPTIMIZED_DIRECT_CACHE_UPDATER.getVolatile(this);
                        OptimizedDirectData s0_original = s0_;
                        while (s0_ != null) {
                            assert DSLSupport.assertIdempotence((s0_.cachedState_ != null));
                            if ((arg0Value.cachedState == s0_.cachedState_)) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                SignatureCachedState cachedState__ = (arg0Value.cachedState);
                                if ((cachedState__ != null)) {
                                    // assert (arg0Value.cachedState == cachedState__);
                                    if (count0_ < (3)) {
                                        s0_ = this.insert(new OptimizedDirectData(s0_original));
                                        s0_.cachedState_ = cachedState__;
                                        CallSignatureNode call__1 = s0_.insert((cachedState__.createOptimizedSignatureCall()));
                                        Objects.requireNonNull(call__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.call_ = call__1;
                                        if (!OPTIMIZED_DIRECT_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedDirect(NFISignature, Object, Object[], SignatureCachedState, CallSignatureNode)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doOptimizedDirect(arg0Value, arg1Value, arg2Value, s0_.cachedState_, s0_.call_);
                        }
                        break;
                    }
                }
                if ((arg0Value.cachedState != null)) {
                    VarHandle.storeStoreFence();
                    this.optimizedIndirect_call_ = this.insert((IndirectCallNode.create()));
                    this.optimizedDirect_cache = null;
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedDirect(NFISignature, Object, Object[], SignatureCachedState, CallSignatureNode)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedIndirect(NFISignature, Object, Object[], IndirectCallNode)] */;
                    this.state_0_ = state_0;
                    return doOptimizedIndirect(arg0Value, arg1Value, arg2Value, this.optimizedIndirect_call_);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.cachedState == null)) {
                        SlowPathData s2_ = this.insert(new SlowPathData());
                        node__ = (s2_);
                        NFIBackendSignatureLibrary nativeLibrary__ = s2_.insert((N_F_I_BACKEND_SIGNATURE_LIBRARY_.createDispatched(3)));
                        Objects.requireNonNull(nativeLibrary__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.nativeLibrary_ = nativeLibrary__;
                        VarHandle.storeStoreFence();
                        this.slowPath_cache = s2_;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doSlowPath(NFISignature, Object, Object[], Node, InlinedBranchProfile, ConvertToNativeNode, ConvertFromNativeNode, NFIBackendSignatureLibrary, BackendSymbolUnwrapNode)] */;
                        this.state_0_ = state_0;
                        return CachedCallSignatureNode.doSlowPath(arg0Value, arg1Value, arg2Value, node__, INLINED_SLOW_PATH_EXCEPTION_, INLINED_SLOW_PATH_CONVERT_ARG_, INLINED_SLOW_PATH_CONVERT_RET_, nativeLibrary__, INLINED_SLOW_PATH_BACKEND_SYMBOL_UNWRAP_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            } finally {
                if (oldState_0 != 0) {
                    checkForPolymorphicSpecialize(oldState_0);
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState_0) {
            if (((oldState_0 & 0b1100) == 0 && (state_0_ & 0b1100) != 0)) {
                this.reportPolymorphicSpecialize();
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                VarHandle.storeStoreFence();
                this.optimizedIndirect_call_ = this.insert((IndirectCallNode.create()));
                this.optimizedDirect_cache = null;
                this.state_0_ = state_0_ & 0xfffffffd /* remove SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedDirect(NFISignature, Object, Object[], SignatureCachedState, CallSignatureNode)] */;
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doOptimizedIndirect(NFISignature, Object, Object[], IndirectCallNode)] */;
            }
            {
                SlowPathData s2_ = this.insert(new SlowPathData());
                NFIBackendSignatureLibrary nativeLibrary__ = s2_.insert((N_F_I_BACKEND_SIGNATURE_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeLibrary__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s2_.nativeLibrary_ = nativeLibrary__;
                INLINED_SLOW_PATH_EXCEPTION_.disable(s2_);
                VarHandle.storeStoreFence();
                this.slowPath_cache = s2_;
                assert NodeUtil.assertRecursion(INLINED_SLOW_PATH_CONVERT_ARG_, 1);
                ((GenerateAOT.Provider) INLINED_SLOW_PATH_CONVERT_ARG_).prepareForAOT(language, root, this);
                assert NodeUtil.assertRecursion(INLINED_SLOW_PATH_CONVERT_RET_, 1);
                ((GenerateAOT.Provider) INLINED_SLOW_PATH_CONVERT_RET_).prepareForAOT(language, root, this);
                if (s2_.nativeLibrary_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(s2_.nativeLibrary_, 1);
                    ((GenerateAOT.Provider) s2_.nativeLibrary_).prepareForAOT(language, root);
                }
                assert NodeUtil.assertRecursion(INLINED_SLOW_PATH_BACKEND_SYMBOL_UNWRAP_NODE_, 1);
                ((GenerateAOT.Provider) INLINED_SLOW_PATH_BACKEND_SYMBOL_UNWRAP_NODE_).prepareForAOT(language, root, this);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[CallSignatureNode.CachedCallSignatureNode.doSlowPath(NFISignature, Object, Object[], Node, InlinedBranchProfile, ConvertToNativeNode, ConvertFromNativeNode, NFIBackendSignatureLibrary, BackendSymbolUnwrapNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.optimizedIndirect_call_ = null;
            this.slowPath_cache = null;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException3(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
        }

        @NeverDefault
        public static CachedCallSignatureNode create() {
            return new CachedCallSignatureNodeGen();
        }

        @NeverDefault
        public static CachedCallSignatureNode getUncached() {
            return CachedCallSignatureNodeGen.UNCACHED;
        }

        @GeneratedBy(CachedCallSignatureNode.class)
        @DenyReplace
        private static final class OptimizedDirectData extends Node implements SpecializationDataNode {

            @Child OptimizedDirectData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CachedCallSignatureNode#doOptimizedDirect}
             *   Parameter: {@link SignatureCachedState} cachedState</pre>
             */
            @CompilationFinal SignatureCachedState cachedState_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CachedCallSignatureNode#doOptimizedDirect}
             *   Parameter: {@link CallSignatureNode} call</pre>
             */
            @Child CallSignatureNode call_;

            OptimizedDirectData(OptimizedDirectData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(CachedCallSignatureNode.class)
        @DenyReplace
        private static final class SlowPathData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0: InlinedCache
             *        Specialization: {@link CachedCallSignatureNode#doSlowPath}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   1-3: InlinedCache
             *        Specialization: {@link CachedCallSignatureNode#doSlowPath}
             *        Parameter: {@link ConvertToNativeNode} convertArg
             *        Inline method: {@link ConvertToNativeNodeGen#inline}
             *   4-6: InlinedCache
             *        Specialization: {@link CachedCallSignatureNode#doSlowPath}
             *        Parameter: {@link ConvertFromNativeNode} convertRet
             *        Inline method: {@link ConvertFromNativeNodeGen#inline}
             *   7-9: InlinedCache
             *        Specialization: {@link CachedCallSignatureNode#doSlowPath}
             *        Parameter: {@link BackendSymbolUnwrapNode} backendSymbolUnwrapNode
             *        Inline method: {@link BackendSymbolUnwrapNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int slowPath_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CachedCallSignatureNode#doSlowPath}
             *   Parameter: {@link ConvertToNativeNode} convertArg
             *   Inline method: {@link ConvertToNativeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node slowPath_convertArg__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CachedCallSignatureNode#doSlowPath}
             *   Parameter: {@link ConvertFromNativeNode} convertRet
             *   Inline method: {@link ConvertFromNativeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node slowPath_convertRet__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CachedCallSignatureNode#doSlowPath}
             *   Parameter: {@link NFIBackendSignatureLibrary} nativeLibrary</pre>
             */
            @Child NFIBackendSignatureLibrary nativeLibrary_;

            SlowPathData() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(CachedCallSignatureNode.class)
        @DenyReplace
        private static final class Uncached extends CachedCallSignatureNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                if ((arg0Value.cachedState != null)) {
                    return doOptimizedIndirect(arg0Value, arg1Value, arg2Value, (IndirectCallNode.getUncached()));
                }
                if ((arg0Value.cachedState == null)) {
                    return CachedCallSignatureNode.doSlowPath(arg0Value, arg1Value, arg2Value, (this), (InlinedBranchProfile.getUncached()), (ConvertToNativeNodeGen.getUncached()), (ConvertFromNativeNodeGen.getUncached()), (N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached()), (BackendSymbolUnwrapNodeGen.getUncached()));
                }
                throw newUnsupportedSpecializationException3(this, arg0Value, arg1Value, arg2Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link OptimizedCallSignatureNode#doCall}
     *     Activation probability: 1.00000
     *     With/without class size: 28/5 bytes
     * </pre>
     */
    @GeneratedBy(OptimizedCallSignatureNode.class)
    @SuppressWarnings("javadoc")
    static final class OptimizedCallSignatureNodeGen extends OptimizedCallSignatureNode implements GenerateAOT.Provider {

        private static final StateField STATE_0_OptimizedCallSignatureNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        /**
         * Source Info: <pre>
         *   Specialization: {@link OptimizedCallSignatureNode#doCall}
         *   Parameter: {@link InlinedBranchProfile} exception
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_OptimizedCallSignatureNode_UPDATER.subUpdater(2, 1)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link OptimizedCallSignatureNode#doCall}
         *   Parameter: {@link BackendSymbolUnwrapNode} backendSymbolUnwrapNode
         *   Inline method: {@link BackendSymbolUnwrapNodeGen#inline}</pre>
         */
        private static final BackendSymbolUnwrapNode INLINED_BACKEND_SYMBOL_UNWRAP_NODE_ = BackendSymbolUnwrapNodeGen.inline(InlineTarget.create(BackendSymbolUnwrapNode.class, STATE_0_OptimizedCallSignatureNode_UPDATER.subUpdater(3, 3)));

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link OptimizedCallSignatureNode#doCall}
         *   2: InlinedCache
         *        Specialization: {@link OptimizedCallSignatureNode#doCall}
         *        Parameter: {@link InlinedBranchProfile} exception
         *        Inline method: {@link InlinedBranchProfile#inline}
         *   3-5: InlinedCache
         *        Specialization: {@link OptimizedCallSignatureNode#doCall}
         *        Parameter: {@link BackendSymbolUnwrapNode} backendSymbolUnwrapNode
         *        Inline method: {@link BackendSymbolUnwrapNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link OptimizedCallSignatureNode#doCall}
         *   Parameter: {@link NFIBackendSignatureLibrary} backendLibrary</pre>
         */
        @Child private NFIBackendSignatureLibrary backendLibrary_;

        private OptimizedCallSignatureNodeGen(TypeCachedState retType, ArgsCachedState argsState) {
            super(retType, argsState);
        }

        @Override
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[CallSignatureNode.OptimizedCallSignatureNode.doCall(NFISignature, Object, Object[], InlinedBranchProfile, NFIBackendSignatureLibrary, BackendSymbolUnwrapNode)] */) {
                {
                    NFIBackendSignatureLibrary backendLibrary__ = this.backendLibrary_;
                    if (backendLibrary__ != null) {
                        return doCall(arg0Value, arg1Value, arg2Value, INLINED_EXCEPTION_, backendLibrary__, INLINED_BACKEND_SYMBOL_UNWRAP_NODE_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            NFIBackendSignatureLibrary backendLibrary__ = this.insert((N_F_I_BACKEND_SIGNATURE_LIBRARY_.createDispatched(1)));
            Objects.requireNonNull(backendLibrary__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.backendLibrary_ = backendLibrary__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[CallSignatureNode.OptimizedCallSignatureNode.doCall(NFISignature, Object, Object[], InlinedBranchProfile, NFIBackendSignatureLibrary, BackendSymbolUnwrapNode)] */;
            this.state_0_ = state_0;
            return doCall(arg0Value, arg1Value, arg2Value, INLINED_EXCEPTION_, backendLibrary__, INLINED_BACKEND_SYMBOL_UNWRAP_NODE_);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                NFIBackendSignatureLibrary backendLibrary__ = this.insert((N_F_I_BACKEND_SIGNATURE_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(backendLibrary__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.backendLibrary_ = backendLibrary__;
                INLINED_EXCEPTION_.disable(this);
                if (this.backendLibrary_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.backendLibrary_, 1);
                    ((GenerateAOT.Provider) this.backendLibrary_).prepareForAOT(language, root);
                }
                assert NodeUtil.assertRecursion(INLINED_BACKEND_SYMBOL_UNWRAP_NODE_, 1);
                ((GenerateAOT.Provider) INLINED_BACKEND_SYMBOL_UNWRAP_NODE_).prepareForAOT(language, root, this);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[CallSignatureNode.OptimizedCallSignatureNode.doCall(NFISignature, Object, Object[], InlinedBranchProfile, NFIBackendSignatureLibrary, BackendSymbolUnwrapNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            INLINED_EXCEPTION_.reset(this);
            this.backendLibrary_ = null;
        }

        @NeverDefault
        public static OptimizedCallSignatureNode create(TypeCachedState retType, ArgsCachedState argsState) {
            return new OptimizedCallSignatureNodeGen(retType, argsState);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link OptimizedCallClosureNode#doCall}
     *     Activation probability: 0.65000
     *     With/without class size: 19/5 bytes
     *   Specialization {@link OptimizedCallClosureNode#doCall}
     *     Activation probability: 0.35000
     *     With/without class size: 11/1 bytes
     * </pre>
     */
    @GeneratedBy(OptimizedCallClosureNode.class)
    @SuppressWarnings("javadoc")
    static final class OptimizedCallClosureNodeGen extends OptimizedCallClosureNode implements GenerateAOT.Provider {

        private static final StateField CALL0__OPTIMIZED_CALL_CLOSURE_NODE_CALL0_STATE_0_UPDATER = StateField.create(Call0Data.lookup_(), "call0_state_0_");
        private static final StateField STATE_0_OptimizedCallClosureNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
        static final ReferenceField<Call0Data> CALL0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "call0_cache", Call0Data.class);
        /**
         * Source Info: <pre>
         *   Specialization: {@link OptimizedCallClosureNode#doCall}
         *   Parameter: {@link InlinedBranchProfile} exception
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_CALL0_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, CALL0__OPTIMIZED_CALL_CLOSURE_NODE_CALL0_STATE_0_UPDATER.subUpdater(0, 1)));
        /**
         * Source Info: <pre>
         *   Specialization: {@link OptimizedCallClosureNode#doCall}
         *   Parameter: {@link InlinedBranchProfile} exception
         *   Inline method: {@link InlinedBranchProfile#inline}</pre>
         */
        private static final InlinedBranchProfile INLINED_CALL1_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_OptimizedCallClosureNode_UPDATER.subUpdater(3, 1)));

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link OptimizedCallClosureNode#doCall}
         *   2: SpecializationActive {@link OptimizedCallClosureNode#doCall}
         *   3: InlinedCache
         *        Specialization: {@link OptimizedCallClosureNode#doCall}
         *        Parameter: {@link InlinedBranchProfile} exception
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int state_0_;
        @UnsafeAccessedField @Child private Call0Data call0_cache;

        private OptimizedCallClosureNodeGen(TypeCachedState retType, ArgsCachedState argsState) {
            super(retType, argsState);
        }

        @Override
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[CallSignatureNode.OptimizedCallClosureNode.doCall(NFISignature, Object, Object[], Node, InlinedBranchProfile, InteropLibrary)] || SpecializationActive[CallSignatureNode.OptimizedCallClosureNode.doCall(NFISignature, Object, Object[], Node, InlinedBranchProfile, InteropLibrary)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CallSignatureNode.OptimizedCallClosureNode.doCall(NFISignature, Object, Object[], Node, InlinedBranchProfile, InteropLibrary)] */) {
                    Call0Data s0_ = this.call0_cache;
                    if (s0_ != null) {
                        if ((s0_.interop_.accepts(arg1Value))) {
                            Node node__ = (s0_);
                            return doCall(arg0Value, arg1Value, arg2Value, node__, INLINED_CALL0_EXCEPTION_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[CallSignatureNode.OptimizedCallClosureNode.doCall(NFISignature, Object, Object[], Node, InlinedBranchProfile, InteropLibrary)] */) {
                    return this.call1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object call1Boundary(int state_0, NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    Node node__ = (this);
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                    return doCall(arg0Value, arg1Value, arg2Value, node__, INLINED_CALL1_EXCEPTION_, interop__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            {
                Node node__ = null;
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[CallSignatureNode.OptimizedCallClosureNode.doCall(NFISignature, Object, Object[], Node, InlinedBranchProfile, InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        Call0Data s0_ = CALL0_CACHE_UPDATER.getVolatile(this);
                        Call0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value))) {
                                node__ = (s0_);
                                break;
                            }
                            count0_++;
                            s0_ = null;
                            break;
                        }
                        if (s0_ == null && count0_ < 1) {
                            // assert (s0_.interop_.accepts(arg1Value));
                            s0_ = this.insert(new Call0Data());
                            node__ = (s0_);
                            InteropLibrary interop__ = s0_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                            Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.interop_ = interop__;
                            if (!CALL0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[CallSignatureNode.OptimizedCallClosureNode.doCall(NFISignature, Object, Object[], Node, InlinedBranchProfile, InteropLibrary)] */;
                            this.state_0_ = state_0;
                        }
                        if (s0_ != null) {
                            return doCall(arg0Value, arg1Value, arg2Value, node__, INLINED_CALL0_EXCEPTION_, s0_.interop_);
                        }
                        break;
                    }
                }
            }
            {
                InteropLibrary interop__ = null;
                Node node__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        node__ = (this);
                        interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                        this.call0_cache = null;
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[CallSignatureNode.OptimizedCallClosureNode.doCall(NFISignature, Object, Object[], Node, InlinedBranchProfile, InteropLibrary)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[CallSignatureNode.OptimizedCallClosureNode.doCall(NFISignature, Object, Object[], Node, InlinedBranchProfile, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doCall(arg0Value, arg1Value, arg2Value, node__, INLINED_CALL1_EXCEPTION_, interop__);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static OptimizedCallClosureNode create(TypeCachedState retType, ArgsCachedState argsState) {
            return new OptimizedCallClosureNodeGen(retType, argsState);
        }

        @GeneratedBy(OptimizedCallClosureNode.class)
        @DenyReplace
        private static final class Call0Data extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0: InlinedCache
             *        Specialization: {@link OptimizedCallClosureNode#doCall}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int call0_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link OptimizedCallClosureNode#doCall}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            Call0Data() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link BackendSymbolUnwrapNode#unwrapNFISymbol}
     *     Activation probability: 0.65000
     *     With/without class size: 11/0 bytes
     *   Specialization {@link BackendSymbolUnwrapNode#noUnwrap}
     *     Activation probability: 0.35000
     *     With/without class size: 8/0 bytes
     * </pre>
     */
    @GeneratedBy(BackendSymbolUnwrapNode.class)
    @SuppressWarnings("javadoc")
    static final class BackendSymbolUnwrapNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static BackendSymbolUnwrapNode getUncached() {
            return BackendSymbolUnwrapNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * </ul>
         */
        @NeverDefault
        public static BackendSymbolUnwrapNode inline(@RequiredField(bits = 3, value = StateField.class) InlineTarget target) {
            return new BackendSymbolUnwrapNodeGen.Inlined(target);
        }

        @GeneratedBy(BackendSymbolUnwrapNode.class)
        @DenyReplace
        private static final class Inlined extends BackendSymbolUnwrapNode implements UnadoptableNode, GenerateAOT.Provider {

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link BackendSymbolUnwrapNode#unwrapNFISymbol}
             *   2: SpecializationActive {@link BackendSymbolUnwrapNode#noUnwrap}
             * </pre>
             */
            private final StateField state_0_;

            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(BackendSymbolUnwrapNode.class);
                this.state_0_ = target.getState(0, 3);
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value) {
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.unwrapNFISymbol(NFISymbol)] */) && arg1Value instanceof NFISymbol) {
                    return false;
                }
                return true;
            }

            @Override
            Object execute(Node arg0Value, Object arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.unwrapNFISymbol(NFISymbol)] || SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.noUnwrap(Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.unwrapNFISymbol(NFISymbol)] */ && arg1Value instanceof NFISymbol) {
                        NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                        return unwrapNFISymbol(arg1Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.noUnwrap(Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return noUnwrap(arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Node arg0Value, Object arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_(arg0Value);
                    state_0 = this.state_0_.get(arg0Value);
                }
                if (arg1Value instanceof NFISymbol) {
                    NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.unwrapNFISymbol(NFISymbol)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return unwrapNFISymbol(arg1Value_);
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.noUnwrap(Object)] */;
                this.state_0_.set(arg0Value, state_0);
                return noUnwrap(arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root, Node arg0Value) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_.get(arg0Value) & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_.set(arg0Value, state_0_.get(arg0Value) | 0b10 /* add SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.unwrapNFISymbol(NFISymbol)] */);
                }
                {
                    this.state_0_.set(arg0Value, state_0_.get(arg0Value) | 0b100 /* add SpecializationActive[CallSignatureNode.BackendSymbolUnwrapNode.noUnwrap(Object)] */);
                }
                int state_0 = this.state_0_.get(arg0Value);
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_.set(arg0Value, state_0);
            }

            private void resetAOT_(Node arg0Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_.set(arg0Value, 0);
            }

        }
        @GeneratedBy(BackendSymbolUnwrapNode.class)
        @DenyReplace
        private static final class Uncached extends BackendSymbolUnwrapNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            Object execute(Node arg0Value, Object arg1Value) {
                if (arg1Value instanceof NFISymbol) {
                    NFISymbol arg1Value_ = (NFISymbol) arg1Value;
                    return unwrapNFISymbol(arg1Value_);
                }
                return noUnwrap(arg1Value);
            }

        }
    }
}
