// CheckStyle: start generated
package com.oracle.truffle.nfi.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.api.NativePointerLibrary.LongNativePointerLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(NativePointerLibrary.class)
final class NativePointerLibraryGen extends LibraryFactory<NativePointerLibrary> {

    private static final Class<NativePointerLibrary> LIBRARY_CLASS = NativePointerLibraryGen.lazyLibraryClass();
    private static final Message IS_POINTER = new MessageImpl("isPointer", 0, false, boolean.class, Object.class);
    private static final Message AS_POINTER = new MessageImpl("asPointer", 1, false, long.class, Object.class);
    private static final NativePointerLibraryGen INSTANCE = new NativePointerLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NativePointerLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(NativePointerLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private NativePointerLibraryGen() {
        super(NativePointerLibraryGen.LIBRARY_CLASS, List.of(NativePointerLibraryGen.IS_POINTER, NativePointerLibraryGen.AS_POINTER));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof Long) {
            return LongNativePointerLibrary.class;
        } else {
            return NativePointerLibrary.class;
        }
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected NativePointerLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected NativePointerLibrary createDelegate(NativePointerLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NativePointerLibrary lib = (NativePointerLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isPointer(receiver);
            case 1 :
                return lib.asPointer(receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected NativePointerLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected NativePointerLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<NativePointerLibrary> lazyLibraryClass() {
        try {
            return (Class<NativePointerLibrary>) Class.forName("com.oracle.truffle.nfi.api.NativePointerLibrary", false, NativePointerLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(NativePointerLibrary.class)
    private static final class Default extends LibraryExport<NativePointerLibrary> {

        private Default() {
            super(NativePointerLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected NativePointerLibrary createUncached(Object receiver) {
            NativePointerLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NativePointerLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(NativePointerLibrary.class)
        private static final class Cached extends NativePointerLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPointer((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.asPointer((dynamicDispatch_.cast(receiver)));
            }

        }
        @GeneratedBy(NativePointerLibrary.class)
        @DenyReplace
        private static final class Uncached extends NativePointerLibrary implements UnadoptableNode {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPointer(receiver);
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.asPointer(receiver);
            }

        }
    }
    @GeneratedBy(NativePointerLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(NativePointerLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(NativePointerLibrary.class)
    private static final class Proxy extends NativePointerLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, NativePointerLibraryGen.IS_POINTER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            try {
                return (long) lib.send(receiver_, NativePointerLibraryGen.AS_POINTER);
            } catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(NativePointerLibrary.class)
    private static final class Delegate extends NativePointerLibrary {

        @Child private NativePointerLibrary delegateLibrary;

        Delegate(NativePointerLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isPointer(delegate);
            } else {
                return this.delegateLibrary.isPointer(receiver_);
            }
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).asPointer(delegate);
            } else {
                return this.delegateLibrary.asPointer(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(NativePointerLibrary.class)
    private static final class CachedToUncachedDispatch extends NativePointerLibrary {

        @TruffleBoundary
        @Override
        public boolean isPointer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isPointer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).asPointer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(NativePointerLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends NativePointerLibrary implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public boolean isPointer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isPointer(receiver_);
        }

        @TruffleBoundary
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            return INSTANCE.getUncached(receiver_).asPointer(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(NativePointerLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(NativePointerLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

    }
    @GeneratedBy(NativePointerLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch implements GenerateAOT.Provider {

        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(NativePointerLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport<NativePointerLibrary> export : INSTANCE.getAOTExports()) {
                NativePointerLibrary exportLibrary = INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = insert(exportLibrary);
                } else {
                    this.next = insert(new CachedDispatchNext(exportLibrary, this.next));
                }
            }
            this.aot_ = true;
        }

    }
    @GeneratedBy(NativePointerLibrary.class)
    private abstract static class CachedDispatch extends NativePointerLibrary {

        @Child NativePointerLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(NativePointerLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean value);

        @ExplodeLoop
        @Override
        public boolean isPointer(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    NativePointerLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isPointer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (CompilerDirectives.inInterpreter() && isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            }
            do {
                CachedDispatch current = this;
                do {
                    NativePointerLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.asPointer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                if (isAOT()) {
                    this.library = null;
                    this.next = null;
                    setAOT(false);
                }
                CachedDispatch current = this;
                NativePointerLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        NativePointerLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
