/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.CallSignatureNodeFactory;
import com.oracle.truffle.nfi.NFIClosure;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=NFISignature.class)
public final class NFISignatureGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<SignatureLibrary> SIGNATURE_LIBRARY_ = LibraryFactory.resolve(SignatureLibrary.class);
    private static final LibraryFactory<NFIBackendSignatureLibrary> N_F_I_BACKEND_SIGNATURE_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureLibrary.class);

    private NFISignatureGen() {
    }

    private static void init() {
    }

    static {
        LibraryExport.register(NFISignature.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new SignatureLibraryExports()});
    }

    @GeneratedBy(value=NFISignature.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NFISignature.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFISignature);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NFISignature);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFISignature.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISignature;
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws ArityException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                if (NFISignature.isBind(arg1Value)) {
                    return NFISignature.InvokeMember.doBind(arg0Value, arg1Value, arg2Value, (Node)this, (SignatureLibrary)SIGNATURE_LIBRARY_.getUncached((Object)arg0Value), InlinedBranchProfile.getUncached());
                }
                if (NFISignature.isCreateClosure(arg1Value)) {
                    return NFISignature.InvokeMember.doCreateClosure(arg0Value, arg1Value, arg2Value, (Node)this, (SignatureLibrary)SIGNATURE_LIBRARY_.getUncached((Object)arg0Value), InlinedBranchProfile.getUncached());
                }
                return NFISignature.InvokeMember.doUnknown(arg0Value, arg1Value, arg2Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISignature)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISignature)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISignature)receiver).isMemberInvocable(member);
            }
        }

        @GeneratedBy(value=NFISignature.class)
        private static final class Cached
        extends InteropLibrary {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_INVOKE_EXCEPTION = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(3, 1)}));
            @Node.Child
            private SignatureLibrary receiverSignatureLibrary_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            protected Cached(Object receiver) {
                NFISignature castReceiver = (NFISignature)receiver;
                this.receiverSignatureLibrary_ = (SignatureLibrary)SIGNATURE_LIBRARY_.create((Object)castReceiver);
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISignature)) {
                    return false;
                }
                return this.receiverSignatureLibrary_.accepts(receiver);
            }

            private boolean fallbackGuard_(int state_0, NFISignature arg0Value, String arg1Value, Object[] arg2Value) {
                if ((state_0 & 1) == 0 && NFISignature.isBind(arg1Value)) {
                    return false;
                }
                return (state_0 & 2) != 0 || !NFISignature.isCreateClosure(arg1Value);
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (arg0Value_ instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISignature arg0Value = (NFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && NFISignature.isBind(arg1Value)) {
                        Cached node__ = this;
                        SignatureLibrary signatureLibrary__ = this.receiverSignatureLibrary_;
                        return NFISignature.InvokeMember.doBind(arg0Value, arg1Value, arg2Value, (Node)node__, signatureLibrary__, INLINED_INVOKE_EXCEPTION);
                    }
                    if ((state_0 & 2) != 0 && NFISignature.isCreateClosure(arg1Value)) {
                        Cached node__1 = this;
                        SignatureLibrary signatureLibrary__1 = this.receiverSignatureLibrary_;
                        return NFISignature.InvokeMember.doCreateClosure(arg0Value, arg1Value, arg2Value, (Node)node__1, signatureLibrary__1, INLINED_INVOKE_EXCEPTION);
                    }
                    if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                        return NFISignature.InvokeMember.doUnknown(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(NFISignature arg0Value, String arg1Value, Object[] arg2Value) throws ArityException, UnknownIdentifierException {
                int state_0 = this.state_0_;
                SignatureLibrary signatureLibrary__ = null;
                Cached node__ = null;
                if (NFISignature.isBind(arg1Value)) {
                    node__ = this;
                    signatureLibrary__ = this.receiverSignatureLibrary_;
                    this.state_0_ = state_0 |= 1;
                    return NFISignature.InvokeMember.doBind(arg0Value, arg1Value, arg2Value, (Node)node__, signatureLibrary__, INLINED_INVOKE_EXCEPTION);
                }
                SignatureLibrary signatureLibrary__1 = null;
                Cached node__1 = null;
                if (NFISignature.isCreateClosure(arg1Value)) {
                    node__1 = this;
                    signatureLibrary__1 = this.receiverSignatureLibrary_;
                    this.state_0_ = state_0 |= 2;
                    return NFISignature.InvokeMember.doCreateClosure(arg0Value, arg1Value, arg2Value, (Node)node__1, signatureLibrary__1, INLINED_INVOKE_EXCEPTION);
                }
                this.state_0_ = state_0 |= 4;
                return NFISignature.InvokeMember.doUnknown(arg0Value, arg1Value, arg2Value);
            }

            public boolean hasMembers(Object receiver) {
                assert (receiver instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISignature)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (receiver instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISignature)receiver).getMembers(includeInternal);
            }

            public boolean isMemberInvocable(Object receiver, String member) {
                assert (receiver instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISignature)receiver).isMemberInvocable(member);
            }
        }
    }

    @GeneratedBy(value=NFISignature.class)
    private static final class SignatureLibraryExports
    extends LibraryExport<SignatureLibrary> {
        private SignatureLibraryExports() {
            super(SignatureLibrary.class, NFISignature.class, false, true, 1);
        }

        protected SignatureLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFISignature);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected SignatureLibrary createCached(Object receiver) {
            assert (receiver instanceof NFISignature || receiver instanceof LibraryExport);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFISignature.class)
        @DenyReplace
        private static final class Uncached
        extends SignatureLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISignature;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object bind(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                if (arg1Value instanceof NFISymbol) {
                    NFISymbol arg1Value_ = (NFISymbol)arg1Value;
                    return NFISignature.BindMsg.doSymbol(arg0Value, arg1Value_);
                }
                return NFISignature.BindMsg.doOther(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                return NFISignature.CreateClosure.doCreate(arg0Value, arg1Value, (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached(arg0Value.nativeSignature));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                return arg0Value.call(arg1Value, arg2Value, CallSignatureNodeFactory.CachedCallSignatureNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=NFISignature.class)
        private static final class Cached
        extends SignatureLibrary
        implements GenerateAOT.Provider {
            static final InlineSupport.ReferenceField<CreateClosureCachedData> CREATE_CLOSURE_CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"createClosure_cached_cache", CreateClosureCachedData.class);
            @Node.Child
            private NFIBackendSignatureLibrary receiverNativeSignatureNFIBackendSignatureLibrary_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private CreateClosureCachedData createClosure_cached_cache;
            @Node.Child
            private CallSignatureNode.CachedCallSignatureNode callNode__call_call_;

            protected Cached(Object receiver) {
                if (!(receiver instanceof LibraryExport)) {
                    NFISignature castReceiver = (NFISignature)receiver;
                    this.receiverNativeSignatureNFIBackendSignatureLibrary_ = (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.create(castReceiver.nativeSignature);
                }
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISignature)) {
                    return false;
                }
                return this.receiverNativeSignatureNFIBackendSignatureLibrary_ == null || this.receiverNativeSignatureNFIBackendSignatureLibrary_.accepts(((NFISignature)receiver).nativeSignature);
            }

            private boolean bindMsgFallbackGuard_(int state_0, NFISignature arg0Value, Object arg1Value) {
                return (state_0 & 2) != 0 || !(arg1Value instanceof NFISymbol);
            }

            @Override
            public Object bind(Object arg0Value_, Object arg1Value) {
                assert (arg0Value_ instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (SignatureLibraryExports.assertAdopted((Node)((Node)this)));
                NFISignature arg0Value = (NFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.bindMsgAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof NFISymbol) {
                        NFISymbol arg1Value_ = (NFISymbol)arg1Value;
                        return NFISignature.BindMsg.doSymbol(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 4) != 0 && this.bindMsgFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return NFISignature.BindMsg.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.bindMsgAndSpecialize(arg0Value, arg1Value);
            }

            private Object bindMsgAndSpecialize(NFISignature arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof NFISymbol) {
                    NFISymbol arg1Value_ = (NFISymbol)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return NFISignature.BindMsg.doSymbol(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 4;
                return NFISignature.BindMsg.doOther(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 4;
                CallSignatureNode.CachedCallSignatureNode call__ = (CallSignatureNode.CachedCallSignatureNode)this.insert(CallSignatureNodeFactory.CachedCallSignatureNodeGen.create());
                Objects.requireNonNull(call__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.callNode__call_call_ = call__;
                assert (NodeUtil.assertRecursion((Node)this.callNode__call_call_, (int)1));
                ((GenerateAOT.Provider)this.callNode__call_call_).prepareForAOT(language, root);
                this.state_0_ |= 0x20;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
                this.callNode__call_call_ = null;
            }

            @Override
            @ExplodeLoop
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert (arg0Value_ instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (SignatureLibraryExports.assertAdopted((Node)((Node)this)));
                NFISignature arg0Value = (NFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.createClosureAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x18) != 0) {
                    if ((state_0 & 8) != 0) {
                        CreateClosureCachedData s0_ = this.createClosure_cached_cache;
                        while (s0_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s0_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeCached_(s0_);
                                return this.createClosureAndSpecialize(arg0Value, arg1Value);
                            }
                            if (s0_.lib_.accepts(s0_.cachedClosure_.signature.nativeSignature) && arg1Value == s0_.cachedClosure_.executable && arg0Value == s0_.cachedClosure_.signature) {
                                return NFISignature.CreateClosure.doCached(arg0Value, arg1Value, s0_.cachedClosure_, s0_.lib_, s0_.cachedRet_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        NFIBackendSignatureLibrary lib__ = this.receiverNativeSignatureNFIBackendSignatureLibrary_;
                        return NFISignature.CreateClosure.doCreate(arg0Value, arg1Value, lib__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.createClosureAndSpecialize(arg0Value, arg1Value);
            }

            private Object createClosureAndSpecialize(NFISignature arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 0x10) == 0) {
                    CreateClosureCachedData s0_;
                    block5: {
                        CreateClosureCachedData s0_original;
                        do {
                            Assumption assumption0;
                            int count0_ = 0;
                            s0_original = s0_ = (CreateClosureCachedData)((Object)CREATE_CLOSURE_CACHED_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s0_ == null || s0_.lib_.accepts(s0_.cachedClosure_.signature.nativeSignature) && arg1Value == s0_.cachedClosure_.executable && arg0Value == s0_.cachedClosure_.signature && Assumption.isValidAssumption((Assumption)s0_.assumption0_))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null) break block5;
                            NFIClosure cachedClosure__ = NFISignature.CreateClosure.createClosure(arg1Value, arg0Value);
                            if (arg1Value != cachedClosure__.executable || arg0Value != cachedClosure__.signature || !Assumption.isValidAssumption((Assumption)(assumption0 = NFILanguage.getSingleContextAssumption())) || count0_ >= 3) break block5;
                            s0_ = (CreateClosureCachedData)this.insert(new CreateClosureCachedData(s0_original));
                            Objects.requireNonNull(cachedClosure__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.cachedClosure_ = cachedClosure__;
                            NFIBackendSignatureLibrary lib__1 = (NFIBackendSignatureLibrary)s0_.insert((Node)((NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.create(cachedClosure__.signature.nativeSignature)));
                            Objects.requireNonNull(lib__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.lib_ = lib__1;
                            s0_.cachedRet_ = lib__1.createClosure(cachedClosure__.signature.nativeSignature, cachedClosure__);
                            s0_.assumption0_ = assumption0;
                        } while (!CREATE_CLOSURE_CACHED_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 8;
                    }
                    if (s0_ != null) {
                        return NFISignature.CreateClosure.doCached(arg0Value, arg1Value, s0_.cachedClosure_, s0_.lib_, s0_.cachedRet_);
                    }
                }
                NFIBackendSignatureLibrary lib__ = null;
                lib__ = this.receiverNativeSignatureNFIBackendSignatureLibrary_;
                this.createClosure_cached_cache = null;
                state_0 &= 0xFFFFFFF7;
                this.state_0_ = state_0 |= 0x10;
                return NFISignature.CreateClosure.doCreate(arg0Value, arg1Value, lib__);
            }

            void removeCached_(CreateClosureCachedData s0_) {
                CreateClosureCachedData update;
                CreateClosureCachedData original;
                CreateClosureCachedData cur;
                block0: do {
                    original = cur = this.createClosure_cached_cache;
                    update = null;
                    while (cur != null) {
                        if (cur == s0_) {
                            if (cur == original) {
                                update = cur.next_;
                                continue block0;
                            }
                            update = original.remove((Node)this, s0_);
                            continue block0;
                        }
                        cur = cur.next_;
                    }
                } while (cur != null && !CREATE_CLOSURE_CACHED_CACHE_UPDATER.compareAndSet((Node)this, (Object)original, update));
            }

            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                CallSignatureNode.CachedCallSignatureNode call__;
                assert (arg0Value_ instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (SignatureLibraryExports.assertAdopted((Node)((Node)this)));
                NFISignature arg0Value = (NFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                }
                if ((state_0 & 0x20) != 0 && (call__ = this.callNode__call_call_) != null) {
                    return arg0Value.call(arg1Value, arg2Value, call__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object callNode_AndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                CallSignatureNode.CachedCallSignatureNode call__ = (CallSignatureNode.CachedCallSignatureNode)this.insert(CallSignatureNodeFactory.CachedCallSignatureNodeGen.create());
                Objects.requireNonNull(call__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.callNode__call_call_ = call__;
                this.state_0_ = state_0 |= 0x20;
                return arg0Value.call(arg1Value, arg2Value, call__);
            }

            @GeneratedBy(value=NFISignature.class)
            @DenyReplace
            private static final class CreateClosureCachedData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                CreateClosureCachedData next_;
                @CompilerDirectives.CompilationFinal
                NFIClosure cachedClosure_;
                @Node.Child
                NFIBackendSignatureLibrary lib_;
                @CompilerDirectives.CompilationFinal
                Object cachedRet_;
                @CompilerDirectives.CompilationFinal
                Assumption assumption0_;

                CreateClosureCachedData(CreateClosureCachedData next_) {
                    this.next_ = next_;
                }

                CreateClosureCachedData remove(Node parent, CreateClosureCachedData search) {
                    CreateClosureCachedData newNext = this.next_;
                    if (newNext != null) {
                        newNext = search == newNext ? newNext.next_ : newNext.remove(this, search);
                    }
                    CreateClosureCachedData copy = (CreateClosureCachedData)parent.insert((Node)new CreateClosureCachedData(newNext));
                    copy.cachedClosure_ = this.cachedClosure_;
                    copy.lib_ = (NFIBackendSignatureLibrary)copy.insert((Node)this.lib_);
                    copy.cachedRet_ = this.cachedRet_;
                    copy.assumption0_ = this.assumption0_;
                    return copy;
                }
            }
        }
    }

    @GeneratedBy(value=NFISignature.class)
    public static final class SignatureLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            NFISignatureGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.nfi.api.SignatureLibrary";
        }
    }
}

