// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.LongDoubleUtil.FP128Buffer;
import java.math.BigInteger;

@GeneratedBy(FP128Buffer.class)
@SuppressWarnings("javadoc")
final class FP128BufferGen {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(FP128Buffer.class, new InteropLibraryExports());
    }

    private FP128BufferGen() {
    }

    @GeneratedBy(FP128Buffer.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        static final FinalBitSet ENABLED_MESSAGES = createMessageBitSet(INTEROP_LIBRARY_, "isNumber", "fitsInByte", "fitsInShort", "fitsInInt", "fitsInLong", "fitsInBigInteger", "fitsInFloat", "fitsInDouble", "asByte", "asShort", "asInt", "asLong", "asBigInteger", "asFloat", "asDouble", "toDisplayString");
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, FP128Buffer.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof FP128Buffer;
            InteropLibrary uncached = createDelegate(INTEROP_LIBRARY_, InteropLibraryExports.UNCACHED);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof FP128Buffer;
            return createDelegate(INTEROP_LIBRARY_, new Cached(receiver));
        }

        @GeneratedBy(FP128Buffer.class)
        private static final class Cached extends InteropLibrary implements DelegateExport {

            @Child private InteropLibrary receiverBufferInteropLibrary_;

            protected Cached(Object receiver) {
                FP128Buffer castReceiver = ((FP128Buffer) receiver) ;
                this.receiverBufferInteropLibrary_ = INTEROP_LIBRARY_.create((castReceiver.buffer));
            }

            @Override
            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            @Override
            public Object readDelegateExport(Object receiver_) {
                return ((FP128Buffer) receiver_).buffer;
            }

            @Override
            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverBufferInteropLibrary_;
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof FP128Buffer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof FP128Buffer)) {
                    return false;
                } else if (!this.receiverBufferInteropLibrary_.accepts((((FP128Buffer) receiver).buffer))) {
                    return false;
                } else {
                    return true;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#isNumber(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isNumber(Object arg0Value_) {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.isNumber(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#fitsInByte(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.fitsInByte(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#fitsInShort(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.fitsInShort(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#fitsInInt(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.fitsInInt(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#fitsInLong(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.fitsInLong(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#fitsInBigInteger(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInBigInteger(Object arg0Value_) {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.fitsInBigInteger(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#fitsInFloat(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.fitsInFloat(interop__);
                }
            }

            @Override
            public boolean fitsInDouble(Object receiver) {
                assert receiver instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                return (((FP128Buffer) receiver)).fitsInDouble();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#asByte(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.asByte(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#asShort(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.asShort(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#asInt(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.asInt(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#asLong(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.asLong(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#asBigInteger(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public BigInteger asBigInteger(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.asBigInteger(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#asFloat(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.asFloat(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#asDouble(FP128Buffer, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.asDouble(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FP128Buffer#toDisplayString(FP128Buffer, boolean, InteropLibrary)}
             *     Activation probability: 0.06250
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object toDisplayString(Object arg0Value_, boolean arg1Value) {
                assert arg0Value_ instanceof FP128Buffer : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverBufferInteropLibrary_;
                    return arg0Value.toDisplayString(arg1Value, interop__);
                }
            }

        }
        @GeneratedBy(FP128Buffer.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements DelegateExport, UnadoptableNode {

            protected Uncached() {
            }

            @Override
            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            @Override
            public Object readDelegateExport(Object receiver_) {
                return (((FP128Buffer) receiver_)).buffer;
            }

            @Override
            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof FP128Buffer) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof FP128Buffer;
            }

            @TruffleBoundary
            @Override
            public boolean isNumber(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.isNumber(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInByte(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.fitsInByte(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInShort(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.fitsInShort(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInInt(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.fitsInInt(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInLong(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.fitsInLong(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInBigInteger(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.fitsInBigInteger(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.fitsInFloat(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInDouble(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((FP128Buffer) receiver) .fitsInDouble();
            }

            @TruffleBoundary
            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.asByte(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.asShort(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.asInt(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.asLong(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public BigInteger asBigInteger(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.asBigInteger(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.asFloat(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.asDouble(INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object arg0Value_, boolean arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP128Buffer arg0Value = ((FP128Buffer) arg0Value_);
                return arg0Value.toDisplayString(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.buffer)));
            }

        }
    }
}
