// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.nfi.SignatureTypeCachedState.ClosureToNative;
import com.oracle.truffle.nfi.SignatureTypeCachedState.FunctionPtrFromNative;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(SignatureTypeCachedState.class)
@SuppressWarnings({"javadoc", "unused"})
final class SignatureTypeCachedStateFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<SignatureLibrary> SIGNATURE_LIBRARY_ = LibraryFactory.resolve(SignatureLibrary.class);

    public static List<NodeFactory<? extends ConvertTypeNode>> getFactories() {
        return List.of(ClosureToNativeFactory.getInstance(), FunctionPtrFromNativeFactory.getInstance());
    }

    @GeneratedBy(ClosureToNative.class)
    static final class ClosureToNativeFactory implements NodeFactory<ClosureToNative> {

        private static final ClosureToNativeFactory CLOSURE_TO_NATIVE_FACTORY_INSTANCE = new ClosureToNativeFactory();

        private ClosureToNativeFactory() {
        }

        @Override
        public Class<ClosureToNative> getNodeClass() {
            return ClosureToNative.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ClosureToNative createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ClosureToNative getUncachedInstance() {
            return ClosureToNativeNodeGen.UNCACHED;
        }

        static NodeFactory<ClosureToNative> getInstance() {
            return CLOSURE_TO_NATIVE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ClosureToNative create() {
            return new ClosureToNativeNodeGen();
        }

        @NeverDefault
        public static ClosureToNative getUncached() {
            return ClosureToNativeNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ClosureToNative#convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)}
         *     Activation probability: 0.48333
         *     With/without class size: 17/8 bytes
         *   Specialization {@link ClosureToNative#convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link ClosureToNative#convertToNative(NFIType, Object)}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre>
         */
        @GeneratedBy(ClosureToNative.class)
        @SuppressWarnings("javadoc")
        static final class ClosureToNativeNodeGen extends ClosureToNative implements GenerateAOT.Provider {

            static final ReferenceField<ConvertToNative0Data> CONVERT_TO_NATIVE0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "convertToNative0_cache", ConvertToNative0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ClosureToNative#convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)}
             *   2: SpecializationActive {@link ClosureToNative#convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)}
             *   3: SpecializationActive {@link ClosureToNative#convertToNative(NFIType, Object)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private ConvertToNative0Data convertToNative0_cache;

            private ClosureToNativeNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isExecutable(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b1110) != 0 /* is SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] || SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] || SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] */) {
                        ConvertToNative0Data s0_ = this.convertToNative0_cache;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.library_.accepts(arg0Value.runtimeData)) && (s0_.interop_.isExecutable(arg1Value))) {
                                return ClosureToNative.convertToNative(arg0Value, arg1Value, s0_.interop_, s0_.library_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isExecutable(arg1Value))) {
                                    return this.convertToNative1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return ClosureToNative.convertToNative(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object convertToNative1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    SignatureLibrary library__ = (SIGNATURE_LIBRARY_.getUncached());
                    return ClosureToNative.convertToNative(arg0Value, arg1Value, interop__, library__);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        ConvertToNative0Data s0_ = CONVERT_TO_NATIVE0_CACHE_UPDATER.getVolatile(this);
                        ConvertToNative0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.library_.accepts(arg0Value.runtimeData)) && (s0_.interop_.isExecutable(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s0_.interop_.accepts(arg1Value));
                                // assert (s0_.library_.accepts(arg0Value.runtimeData));
                                if ((interop__.isExecutable(arg1Value)) && count0_ < (3)) {
                                    s0_ = this.insert(new ConvertToNative0Data(s0_original));
                                    Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.interop_ = interop__;
                                    SignatureLibrary library__ = s0_.insert((SIGNATURE_LIBRARY_.create(arg0Value.runtimeData)));
                                    Objects.requireNonNull(library__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.library_ = library__;
                                    if (!CONVERT_TO_NATIVE0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return ClosureToNative.convertToNative(arg0Value, arg1Value, s0_.interop_, s0_.library_);
                        }
                        break;
                    }
                }
                {
                    SignatureLibrary library__ = null;
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isExecutable(arg1Value))) {
                                    library__ = (SIGNATURE_LIBRARY_.getUncached());
                                    this.convertToNative0_cache = null;
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)] */;
                                    this.state_0_ = state_0;
                                    return ClosureToNative.convertToNative(arg0Value, arg1Value, interop__, library__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object)] */;
                this.state_0_ = state_0;
                return ClosureToNative.convertToNative(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[SignatureTypeCachedState.ClosureToNative.convertToNative(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(ClosureToNative.class)
            @DenyReplace
            private static final class ConvertToNative0Data extends Node implements SpecializationDataNode {

                @Child ConvertToNative0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ClosureToNative#convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)}
                 *   Parameter: {@link InteropLibrary} interop</pre>
                 */
                @Child InteropLibrary interop_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ClosureToNative#convertToNative(NFIType, Object, InteropLibrary, SignatureLibrary)}
                 *   Parameter: {@link SignatureLibrary} library</pre>
                 */
                @Child SignatureLibrary library_;

                ConvertToNative0Data(ConvertToNative0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ClosureToNative.class)
            @DenyReplace
            private static final class Uncached extends ClosureToNative implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isExecutable(arg1Value))) {
                        return ClosureToNative.convertToNative(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (SIGNATURE_LIBRARY_.getUncached(arg0Value.runtimeData)));
                    }
                    return ClosureToNative.convertToNative(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(FunctionPtrFromNative.class)
    static final class FunctionPtrFromNativeFactory implements NodeFactory<FunctionPtrFromNative> {

        private static final FunctionPtrFromNativeFactory FUNCTION_PTR_FROM_NATIVE_FACTORY_INSTANCE = new FunctionPtrFromNativeFactory();

        private FunctionPtrFromNativeFactory() {
        }

        @Override
        public Class<FunctionPtrFromNative> getNodeClass() {
            return FunctionPtrFromNative.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FunctionPtrFromNative createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public FunctionPtrFromNative getUncachedInstance() {
            return FunctionPtrFromNativeNodeGen.UNCACHED;
        }

        static NodeFactory<FunctionPtrFromNative> getInstance() {
            return FUNCTION_PTR_FROM_NATIVE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FunctionPtrFromNative create() {
            return new FunctionPtrFromNativeNodeGen();
        }

        @NeverDefault
        public static FunctionPtrFromNative getUncached() {
            return FunctionPtrFromNativeNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FunctionPtrFromNative#doNull(NFIType, long)}
         *     Activation probability: 0.21250
         *     With/without class size: 6/0 bytes
         *   Specialization {@link FunctionPtrFromNative#doNull(NFIType, Object)}
         *     Activation probability: 0.18750
         *     With/without class size: 6/0 bytes
         *   Specialization {@link FunctionPtrFromNative#doNull(NFIType, Object, InteropLibrary)}
         *     Activation probability: 0.16250
         *     With/without class size: 7/4 bytes
         *   Specialization {@link FunctionPtrFromNative#doNull(NFIType, Object, InteropLibrary)}
         *     Activation probability: 0.13750
         *     With/without class size: 5/0 bytes
         *   Specialization {@link FunctionPtrFromNative#doBind(NFIType, long, SignatureLibrary)}
         *     Activation probability: 0.11250
         *     With/without class size: 6/4 bytes
         *   Specialization {@link FunctionPtrFromNative#doBind(NFIType, long, SignatureLibrary)}
         *     Activation probability: 0.08750
         *     With/without class size: 5/0 bytes
         *   Specialization {@link FunctionPtrFromNative#doBind(NFIType, Object, InteropLibrary, SignatureLibrary)}
         *     Activation probability: 0.06250
         *     With/without class size: 5/8 bytes
         *   Specialization {@link FunctionPtrFromNative#doBind(NFIType, Object, InteropLibrary, SignatureLibrary)}
         *     Activation probability: 0.03750
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(FunctionPtrFromNative.class)
        @SuppressWarnings("javadoc")
        static final class FunctionPtrFromNativeNodeGen extends FunctionPtrFromNative implements GenerateAOT.Provider {

            static final ReferenceField<Null2Data> NULL2_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "null2_cache", Null2Data.class);
            static final ReferenceField<Bind0Data> BIND0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "bind0_cache", Bind0Data.class);
            static final ReferenceField<Bind2Data> BIND2_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "bind2_cache", Bind2Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link FunctionPtrFromNative#doNull(NFIType, long)}
             *   2: SpecializationActive {@link FunctionPtrFromNative#doNull(NFIType, Object)}
             *   3: SpecializationActive {@link FunctionPtrFromNative#doNull(NFIType, Object, InteropLibrary)}
             *   4: SpecializationActive {@link FunctionPtrFromNative#doNull(NFIType, Object, InteropLibrary)}
             *   5: SpecializationActive {@link FunctionPtrFromNative#doBind(NFIType, long, SignatureLibrary)}
             *   6: SpecializationActive {@link FunctionPtrFromNative#doBind(NFIType, long, SignatureLibrary)}
             *   7: SpecializationActive {@link FunctionPtrFromNative#doBind(NFIType, Object, InteropLibrary, SignatureLibrary)}
             *   8: SpecializationActive {@link FunctionPtrFromNative#doBind(NFIType, Object, InteropLibrary, SignatureLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Null2Data null2_cache;
            @UnsafeAccessedField @Child private Bind0Data bind0_cache;
            @UnsafeAccessedField @Child private Bind2Data bind2_cache;

            private FunctionPtrFromNativeNodeGen() {
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, long)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, long)] */ && arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        if ((arg1Value_ == 0)) {
                            return FunctionPtrFromNative.doNull(arg0Value, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b11100) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] */) {
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object)] */) {
                            if ((arg1Value == null)) {
                                return FunctionPtrFromNative.doNull(arg0Value, arg1Value);
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] */) {
                            Null2Data s2_ = this.null2_cache;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNull(arg1Value))) {
                                    return FunctionPtrFromNative.doNull(arg0Value, arg1Value, s2_.interop_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.isNull(arg1Value))) {
                                        return this.null3Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] */ && arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] */) {
                            Bind0Data s4_ = this.bind0_cache;
                            while (s4_ != null) {
                                if ((s4_.library_.accepts(arg0Value.runtimeData)) && (arg1Value_ != 0)) {
                                    return FunctionPtrFromNative.doBind(arg0Value, arg1Value_, s4_.library_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] */) {
                            if ((arg1Value_ != 0)) {
                                return this.bind1Boundary(state_0, arg0Value, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] || SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] */) {
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] */) {
                            Bind2Data s6_ = this.bind2_cache;
                            while (s6_ != null) {
                                if ((s6_.interop_.accepts(arg1Value)) && (s6_.library_.accepts(arg0Value.runtimeData)) && (!(s6_.interop_.isNull(arg1Value)))) {
                                    return FunctionPtrFromNative.doBind(arg0Value, arg1Value, s6_.interop_, s6_.library_);
                                }
                                s6_ = s6_.next_;
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((!(interop__1.isNull(arg1Value)))) {
                                        return this.bind3Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object null3Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    return FunctionPtrFromNative.doNull(arg0Value, arg1Value, interop__);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object bind1Boundary(int state_0, NFIType arg0Value, long arg1Value_) throws UnsupportedTypeException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        SignatureLibrary library__ = (SIGNATURE_LIBRARY_.getUncached(arg0Value.runtimeData));
                        return FunctionPtrFromNative.doBind(arg0Value, arg1Value_, library__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object bind3Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                    SignatureLibrary library__1 = (SIGNATURE_LIBRARY_.getUncached());
                    return FunctionPtrFromNative.doBind(arg0Value, arg1Value, interop__1, library__1);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    if ((arg1Value_ == 0)) {
                        state_0 = state_0 | 0b10 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, long)] */;
                        this.state_0_ = state_0;
                        return FunctionPtrFromNative.doNull(arg0Value, arg1Value_);
                    }
                }
                if ((arg1Value == null)) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object)] */;
                    this.state_0_ = state_0;
                    return FunctionPtrFromNative.doNull(arg0Value, arg1Value);
                }
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Null2Data s2_ = NULL2_CACHE_UPDATER.getVolatile(this);
                        Null2Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNull(arg1Value))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            {
                                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s2_.interop_.accepts(arg1Value));
                                if ((interop__.isNull(arg1Value)) && count2_ < (3)) {
                                    s2_ = this.insert(new Null2Data(s2_original));
                                    Objects.requireNonNull(s2_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s2_.interop_ = interop__;
                                    if (!NULL2_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s2_ != null) {
                            return FunctionPtrFromNative.doNull(arg0Value, arg1Value, s2_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNull(arg1Value))) {
                                    this.null2_cache = null;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return FunctionPtrFromNative.doNull(arg0Value, arg1Value, interop__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] */) {
                        while (true) {
                            int count4_ = 0;
                            Bind0Data s4_ = BIND0_CACHE_UPDATER.getVolatile(this);
                            Bind0Data s4_original = s4_;
                            while (s4_ != null) {
                                if ((s4_.library_.accepts(arg0Value.runtimeData)) && (arg1Value_ != 0)) {
                                    break;
                                }
                                count4_++;
                                s4_ = s4_.next_;
                            }
                            if (s4_ == null) {
                                if ((arg1Value_ != 0) && count4_ < (3)) {
                                    // assert (s4_.library_.accepts(arg0Value.runtimeData));
                                    s4_ = this.insert(new Bind0Data(s4_original));
                                    SignatureLibrary library__ = s4_.insert((SIGNATURE_LIBRARY_.create(arg0Value.runtimeData)));
                                    Objects.requireNonNull(library__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s4_.library_ = library__;
                                    if (!BIND0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                            if (s4_ != null) {
                                return FunctionPtrFromNative.doBind(arg0Value, arg1Value_, s4_.library_);
                            }
                            break;
                        }
                    }
                    {
                        SignatureLibrary library__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                if ((arg1Value_ != 0)) {
                                    library__ = (SIGNATURE_LIBRARY_.getUncached(arg0Value.runtimeData));
                                    this.bind0_cache = null;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, long, SignatureLibrary)] */;
                                    this.state_0_ = state_0;
                                    return FunctionPtrFromNative.doBind(arg0Value, arg1Value_, library__);
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] */) {
                    while (true) {
                        int count6_ = 0;
                        Bind2Data s6_ = BIND2_CACHE_UPDATER.getVolatile(this);
                        Bind2Data s6_original = s6_;
                        while (s6_ != null) {
                            if ((s6_.interop_.accepts(arg1Value)) && (s6_.library_.accepts(arg0Value.runtimeData)) && (!(s6_.interop_.isNull(arg1Value)))) {
                                break;
                            }
                            count6_++;
                            s6_ = s6_.next_;
                        }
                        if (s6_ == null) {
                            {
                                InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s6_.interop_.accepts(arg1Value));
                                // assert (s6_.library_.accepts(arg0Value.runtimeData));
                                if ((!(interop__1.isNull(arg1Value))) && count6_ < (3)) {
                                    s6_ = this.insert(new Bind2Data(s6_original));
                                    Objects.requireNonNull(s6_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s6_.interop_ = interop__1;
                                    SignatureLibrary library__1 = s6_.insert((SIGNATURE_LIBRARY_.create(arg0Value.runtimeData)));
                                    Objects.requireNonNull(library__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s6_.library_ = library__1;
                                    if (!BIND2_CACHE_UPDATER.compareAndSet(this, s6_original, s6_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s6_ != null) {
                            return FunctionPtrFromNative.doBind(arg0Value, arg1Value, s6_.interop_, s6_.library_);
                        }
                        break;
                    }
                }
                {
                    SignatureLibrary library__1 = null;
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((!(interop__1.isNull(arg1Value)))) {
                                    library__1 = (SIGNATURE_LIBRARY_.getUncached());
                                    this.bind2_cache = null;
                                    state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] */;
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doBind(NFIType, Object, InteropLibrary, SignatureLibrary)] */;
                                    this.state_0_ = state_0;
                                    return FunctionPtrFromNative.doBind(arg0Value, arg1Value, interop__1, library__1);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, long)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[SignatureTypeCachedState.FunctionPtrFromNative.doNull(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
            }

            @GeneratedBy(FunctionPtrFromNative.class)
            @DenyReplace
            private static final class Null2Data extends Node implements SpecializationDataNode {

                @Child Null2Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FunctionPtrFromNative#doNull(NFIType, Object, InteropLibrary)}
                 *   Parameter: {@link InteropLibrary} interop</pre>
                 */
                @Child InteropLibrary interop_;

                Null2Data(Null2Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(FunctionPtrFromNative.class)
            @DenyReplace
            private static final class Bind0Data extends Node implements SpecializationDataNode {

                @Child Bind0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FunctionPtrFromNative#doBind(NFIType, long, SignatureLibrary)}
                 *   Parameter: {@link SignatureLibrary} library</pre>
                 */
                @Child SignatureLibrary library_;

                Bind0Data(Bind0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(FunctionPtrFromNative.class)
            @DenyReplace
            private static final class Bind2Data extends Node implements SpecializationDataNode {

                @Child Bind2Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FunctionPtrFromNative#doBind(NFIType, Object, InteropLibrary, SignatureLibrary)}
                 *   Parameter: {@link InteropLibrary} interop</pre>
                 */
                @Child InteropLibrary interop_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FunctionPtrFromNative#doBind(NFIType, Object, InteropLibrary, SignatureLibrary)}
                 *   Parameter: {@link SignatureLibrary} library</pre>
                 */
                @Child SignatureLibrary library_;

                Bind2Data(Bind2Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(FunctionPtrFromNative.class)
            @DenyReplace
            private static final class Uncached extends FunctionPtrFromNative implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        if ((arg1Value_ == 0)) {
                            return FunctionPtrFromNative.doNull(arg0Value, arg1Value_);
                        }
                    }
                    if ((arg1Value == null)) {
                        return FunctionPtrFromNative.doNull(arg0Value, arg1Value);
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNull(arg1Value))) {
                        return FunctionPtrFromNative.doNull(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        if ((arg1Value_ != 0)) {
                            return FunctionPtrFromNative.doBind(arg0Value, arg1Value_, (SIGNATURE_LIBRARY_.getUncached(arg0Value.runtimeData)));
                        }
                    }
                    if ((!((INTEROP_LIBRARY_.getUncached(arg1Value)).isNull(arg1Value)))) {
                        return FunctionPtrFromNative.doBind(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (SIGNATURE_LIBRARY_.getUncached(arg0Value.runtimeData)));
                    }
                    throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
                }

            }
        }
    }
}
