// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(NFILibrary.class)
@SuppressWarnings({"javadoc", "unused"})
final class NFILibraryGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(NFILibrary.class, new InteropLibraryExports());
    }

    private NFILibraryGen() {
    }

    @GeneratedBy(NFILibrary.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NFILibrary.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NFILibrary;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NFILibrary;
            return new Cached(receiver);
        }

        @GeneratedBy(NFILibrary.class)
        private static final class Cached extends InteropLibrary {

            private static final StateField STATE_0_InvokeMemberNode__UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            static final ReferenceField<IsMemberReadableNode_IsMemberReadable0Data> IS_MEMBER_READABLE_NODE__IS_MEMBER_READABLE0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberReadableNode__isMemberReadable0_cache", IsMemberReadableNode_IsMemberReadable0Data.class);
            static final ReferenceField<ReadMemberNode_ReadMember0Data> READ_MEMBER_NODE__READ_MEMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "readMemberNode__readMember0_cache", ReadMemberNode_ReadMember0Data.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link NFILibrary#invokeMember(NFILibrary, String, Object[], Node, InteropLibrary, InlinedBranchProfile)}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_INVOKE_MEMBER_NODE__INVOKE_MEMBER_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_InvokeMemberNode__UPDATER.subUpdater(5, 1)));

            @Child private InteropLibrary receiverLibraryInteropLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NFILibrary#isMemberReadable(NFILibrary, String, InteropLibrary)}
             *   1: SpecializationActive {@link NFILibrary#isMemberReadable(NFILibrary, String, InteropLibrary)}
             *   2: SpecializationActive {@link NFILibrary#readMember(NFILibrary, String, InteropLibrary)}
             *   3: SpecializationActive {@link NFILibrary#readMember(NFILibrary, String, InteropLibrary)}
             *   4: SpecializationActive {@link NFILibrary#invokeMember(NFILibrary, String, Object[], Node, InteropLibrary, InlinedBranchProfile)}
             *   5: InlinedCache
             *        Specialization: {@link NFILibrary#invokeMember}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private IsMemberReadableNode_IsMemberReadable0Data isMemberReadableNode__isMemberReadable0_cache;
            @UnsafeAccessedField @Child private ReadMemberNode_ReadMember0Data readMemberNode__readMember0_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NFILibrary#invokeMember(NFILibrary, String, Object[], Node, InteropLibrary, InlinedBranchProfile)}
             *   Parameter: {@link InteropLibrary} executables</pre> */
            @Child private InteropLibrary invokeMemberNode__invokeMember_executables_;

            protected Cached(Object receiver) {
                NFILibrary castReceiver = ((NFILibrary) receiver) ;
                this.receiverLibraryInteropLibrary_ = INTEROP_LIBRARY_.create((castReceiver.library));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFILibrary) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFILibrary)) {
                    return false;
                } else if (!this.receiverLibraryInteropLibrary_.accepts((((NFILibrary) receiver).library))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert receiver instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFILibrary) receiver)).hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert receiver instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFILibrary) receiver)).getMembers(includeInternal);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFILibrary#isMemberReadable(NFILibrary, String, InteropLibrary)}
             *     Activation probability: 0.10833
             *     With/without class size: 6/4 bytes
             *   Specialization {@link NFILibrary#isMemberReadable(NFILibrary, String, InteropLibrary)}
             *     Activation probability: 0.05833
             *     With/without class size: 4/0 bytes
             * </pre> */
            @ExplodeLoop
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert arg0Value_ instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[NFILibrary.isMemberReadable(NFILibrary, String, InteropLibrary)] || SpecializationActive[NFILibrary.isMemberReadable(NFILibrary, String, InteropLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[NFILibrary.isMemberReadable(NFILibrary, String, InteropLibrary)] */) {
                        IsMemberReadableNode_IsMemberReadable0Data s0_ = this.isMemberReadableNode__isMemberReadable0_cache;
                        while (s0_ != null) {
                            if ((s0_.recursive_.accepts(arg0Value.getLibrary()))) {
                                return arg0Value.isMemberReadable(arg1Value, s0_.recursive_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[NFILibrary.isMemberReadable(NFILibrary, String, InteropLibrary)] */) {
                        return this.isMemberReadableNode__IsMemberReadable1Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private boolean isMemberReadableNode__IsMemberReadable1Boundary(int state_0, NFILibrary arg0Value, String arg1Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        InteropLibrary recursive__ = (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary()));
                        return arg0Value.isMemberReadable(arg1Value, recursive__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private boolean isMemberReadableNode_AndSpecialize(NFILibrary arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[NFILibrary.isMemberReadable(NFILibrary, String, InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberReadableNode_IsMemberReadable0Data s0_ = IS_MEMBER_READABLE_NODE__IS_MEMBER_READABLE0_CACHE_UPDATER.getVolatile(this);
                        IsMemberReadableNode_IsMemberReadable0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.recursive_.accepts(arg0Value.getLibrary()))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.recursive_.accepts(arg0Value.getLibrary()));
                            if (count0_ < (3)) {
                                s0_ = this.insert(new IsMemberReadableNode_IsMemberReadable0Data(s0_original));
                                InteropLibrary recursive__ = s0_.insert((INTEROP_LIBRARY_.create(arg0Value.getLibrary())));
                                Objects.requireNonNull(recursive__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.recursive_ = recursive__;
                                if (!IS_MEMBER_READABLE_NODE__IS_MEMBER_READABLE0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[NFILibrary.isMemberReadable(NFILibrary, String, InteropLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return arg0Value.isMemberReadable(arg1Value, s0_.recursive_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary recursive__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            recursive__ = (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary()));
                            this.isMemberReadableNode__isMemberReadable0_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[NFILibrary.isMemberReadable(NFILibrary, String, InteropLibrary)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[NFILibrary.isMemberReadable(NFILibrary, String, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return arg0Value.isMemberReadable(arg1Value, recursive__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFILibrary#readMember(NFILibrary, String, InteropLibrary)}
             *     Activation probability: 0.10833
             *     With/without class size: 6/4 bytes
             *   Specialization {@link NFILibrary#readMember(NFILibrary, String, InteropLibrary)}
             *     Activation probability: 0.05833
             *     With/without class size: 4/0 bytes
             * </pre> */
            @ExplodeLoop
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert arg0Value_ instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1100) != 0 /* is SpecializationActive[NFILibrary.readMember(NFILibrary, String, InteropLibrary)] || SpecializationActive[NFILibrary.readMember(NFILibrary, String, InteropLibrary)] */) {
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[NFILibrary.readMember(NFILibrary, String, InteropLibrary)] */) {
                        ReadMemberNode_ReadMember0Data s0_ = this.readMemberNode__readMember0_cache;
                        while (s0_ != null) {
                            if ((s0_.recursive_.accepts(arg0Value.getLibrary()))) {
                                return arg0Value.readMember(arg1Value, s0_.recursive_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[NFILibrary.readMember(NFILibrary, String, InteropLibrary)] */) {
                        return this.readMemberNode__ReadMember1Boundary(state_0, arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object readMemberNode__ReadMember1Boundary(int state_0, NFILibrary arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        InteropLibrary recursive__ = (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary()));
                        return arg0Value.readMember(arg1Value, recursive__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object readMemberNode_AndSpecialize(NFILibrary arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[NFILibrary.readMember(NFILibrary, String, InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        ReadMemberNode_ReadMember0Data s0_ = READ_MEMBER_NODE__READ_MEMBER0_CACHE_UPDATER.getVolatile(this);
                        ReadMemberNode_ReadMember0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.recursive_.accepts(arg0Value.getLibrary()))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (s0_.recursive_.accepts(arg0Value.getLibrary()));
                            if (count0_ < (3)) {
                                s0_ = this.insert(new ReadMemberNode_ReadMember0Data(s0_original));
                                InteropLibrary recursive__ = s0_.insert((INTEROP_LIBRARY_.create(arg0Value.getLibrary())));
                                Objects.requireNonNull(recursive__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.recursive_ = recursive__;
                                if (!READ_MEMBER_NODE__READ_MEMBER0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100 /* add SpecializationActive[NFILibrary.readMember(NFILibrary, String, InteropLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return arg0Value.readMember(arg1Value, s0_.recursive_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary recursive__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            recursive__ = (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary()));
                            this.readMemberNode__readMember0_cache = null;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[NFILibrary.readMember(NFILibrary, String, InteropLibrary)] */;
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[NFILibrary.readMember(NFILibrary, String, InteropLibrary)] */;
                            this.state_0_ = state_0;
                            return arg0Value.readMember(arg1Value, recursive__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                assert receiver instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFILibrary) receiver)).isMemberInvocable(member);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFILibrary#invokeMember(NFILibrary, String, Object[], Node, InteropLibrary, InlinedBranchProfile)}
             *     Activation probability: 0.16667
             *     With/without class size: 8/5 bytes
             * </pre> */
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert arg0Value_ instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[NFILibrary.invokeMember(NFILibrary, String, Object[], Node, InteropLibrary, InlinedBranchProfile)] */) {
                    {
                        InteropLibrary executables__ = this.invokeMemberNode__invokeMember_executables_;
                        if (executables__ != null) {
                            Node node__ = (this);
                            return arg0Value.invokeMember(arg1Value, arg2Value, node__, executables__, INLINED_INVOKE_MEMBER_NODE__INVOKE_MEMBER_EXCEPTION_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(NFILibrary arg0Value, String arg1Value, Object[] arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary executables__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(executables__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.invokeMemberNode__invokeMember_executables_ = executables__;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[NFILibrary.invokeMember(NFILibrary, String, Object[], Node, InteropLibrary, InlinedBranchProfile)] */;
                    this.state_0_ = state_0;
                    return arg0Value.invokeMember(arg1Value, arg2Value, node__, executables__, INLINED_INVOKE_MEMBER_NODE__INVOKE_MEMBER_EXCEPTION_);
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert receiver instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return NFILibrary.hasLanguage((((NFILibrary) receiver)));
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert receiver instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return NFILibrary.getLanguage((((NFILibrary) receiver)));
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert receiver instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return NFILibrary.toDisplayString((((NFILibrary) receiver)), allowSideEffects);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFILibrary#isPointer(NFILibrary, InteropLibrary)}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre> */
            @Override
            public boolean isPointer(Object arg0Value_) {
                assert arg0Value_ instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverLibraryInteropLibrary_;
                    return arg0Value.isPointer(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFILibrary#asPointer(NFILibrary, InteropLibrary)}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre> */
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverLibraryInteropLibrary_;
                    return arg0Value.asPointer(interop__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFILibrary#toNative(NFILibrary, InteropLibrary)}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre> */
            @Override
            public void toNative(Object arg0Value_) {
                assert arg0Value_ instanceof NFILibrary : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverLibraryInteropLibrary_;
                    arg0Value.toNative(interop__);
                    return;
                }
            }

            @GeneratedBy(NFILibrary.class)
            @DenyReplace
            private static final class IsMemberReadableNode_IsMemberReadable0Data extends Node implements SpecializationDataNode {

                @Child IsMemberReadableNode_IsMemberReadable0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NFILibrary#isMemberReadable(NFILibrary, String, InteropLibrary)}
                 *   Parameter: {@link InteropLibrary} recursive</pre> */
                @Child InteropLibrary recursive_;

                IsMemberReadableNode_IsMemberReadable0Data(IsMemberReadableNode_IsMemberReadable0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(NFILibrary.class)
            @DenyReplace
            private static final class ReadMemberNode_ReadMember0Data extends Node implements SpecializationDataNode {

                @Child ReadMemberNode_ReadMember0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NFILibrary#readMember(NFILibrary, String, InteropLibrary)}
                 *   Parameter: {@link InteropLibrary} recursive</pre> */
                @Child InteropLibrary recursive_;

                ReadMemberNode_ReadMember0Data(ReadMemberNode_ReadMember0Data next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(NFILibrary.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFILibrary) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFILibrary;
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                return arg0Value.isMemberReadable(arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary())));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                return arg0Value.readMember(arg1Value, (INTEROP_LIBRARY_.getUncached(arg0Value.getLibrary())));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFILibrary) receiver) .isMemberInvocable(member);
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return NFILibrary.hasLanguage(((NFILibrary) receiver) );
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return NFILibrary.getLanguage(((NFILibrary) receiver) );
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return NFILibrary.toDisplayString(((NFILibrary) receiver) , allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                return arg0Value.isPointer(INTEROP_LIBRARY_.getUncached((arg0Value.library)));
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                return arg0Value.asPointer(INTEROP_LIBRARY_.getUncached((arg0Value.library)));
            }

            @TruffleBoundary
            @Override
            public void toNative(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFILibrary arg0Value = ((NFILibrary) arg0Value_);
                arg0Value.toNative(INTEROP_LIBRARY_.getUncached((arg0Value.library)));
                return;
            }

        }
    }
}
