// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.nfi.LongDoubleUtil.FP80Number;
import com.oracle.truffle.nfi.LongDoubleUtil.FP80Number.Serialize;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

@GeneratedBy(FP80Number.class)
@SuppressWarnings({"javadoc", "unused"})
final class FP80NumberGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(FP80Number.class, new SerializableLibraryExports());
    }

    private FP80NumberGen() {
    }

    @GeneratedBy(FP80Number.class)
    private static final class SerializableLibraryExports extends LibraryExport<SerializableLibrary> {

        private SerializableLibraryExports() {
            super(SerializableLibrary.class, FP80Number.class, false, false, 0);
        }

        @Override
        protected SerializableLibrary createUncached(Object receiver) {
            assert receiver instanceof FP80Number;
            SerializableLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected SerializableLibrary createCached(Object receiver) {
            assert receiver instanceof FP80Number;
            return new Cached(receiver);
        }

        @GeneratedBy(FP80Number.class)
        private static final class Cached extends SerializableLibrary {

            static final ReferenceField<Long0Data> LONG0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "long0_cache", Long0Data.class);
            static final ReferenceField<Double0Data> DOUBLE0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "double0_cache", Double0Data.class);

            @Child private InteropLibrary receiverNumberInteropLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Serialize#doLong}
             *   1: SpecializationActive {@link Serialize#doLong}
             *   2: SpecializationActive {@link Serialize#doDouble}
             *   3: SpecializationActive {@link Serialize#doDouble}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Long0Data long0_cache;
            @UnsafeAccessedField @Child private Double0Data double0_cache;

            protected Cached(Object receiver) {
                FP80Number castReceiver = ((FP80Number) receiver) ;
                this.receiverNumberInteropLibrary_ = INTEROP_LIBRARY_.create((castReceiver.number));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof FP80Number) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof FP80Number)) {
                    return false;
                } else if (!this.receiverNumberInteropLibrary_.accepts((((FP80Number) receiver).number))) {
                    return false;
                } else {
                    return true;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Serialize#doLong}
             *     Activation probability: 0.38500
             *     With/without class size: 11/4 bytes
             *   Specialization {@link Serialize#doLong}
             *     Activation probability: 0.29500
             *     With/without class size: 7/0 bytes
             *   Specialization {@link Serialize#doDouble}
             *     Activation probability: 0.20500
             *     With/without class size: 8/4 bytes
             *   Specialization {@link Serialize#doDouble}
             *     Activation probability: 0.11500
             *     With/without class size: 5/0 bytes
             * </pre> */
            @Override
            public void serialize(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert arg0Value_ instanceof FP80Number : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                FP80Number arg0Value = ((FP80Number) arg0Value_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[FP80Number.Serialize.doLong(FP80Number, Object, InteropLibrary, InteropLibrary)] || SpecializationActive[FP80Number.Serialize.doLong(FP80Number, Object, InteropLibrary, InteropLibrary)] || SpecializationActive[FP80Number.Serialize.doDouble(FP80Number, Object, InteropLibrary, InteropLibrary)] || SpecializationActive[FP80Number.Serialize.doDouble(FP80Number, Object, InteropLibrary, InteropLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[FP80Number.Serialize.doLong(FP80Number, Object, InteropLibrary, InteropLibrary)] */) {
                        Long0Data s0_ = this.long0_cache;
                        if (s0_ != null) {
                            if ((s0_.bufferInterop_.accepts(arg1Value))) {
                                InteropLibrary numberInterop__ = this.receiverNumberInteropLibrary_;
                                if ((numberInterop__.fitsInLong(arg0Value.number))) {
                                    Serialize.doLong(arg0Value, arg1Value, numberInterop__, s0_.bufferInterop_);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[FP80Number.Serialize.doLong(FP80Number, Object, InteropLibrary, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary numberInterop__ = this.receiverNumberInteropLibrary_;
                                if ((numberInterop__.fitsInLong(arg0Value.number))) {
                                    this.serialize_Long1Boundary(state_0, arg0Value, arg1Value);
                                    return;
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[FP80Number.Serialize.doDouble(FP80Number, Object, InteropLibrary, InteropLibrary)] */) {
                        Double0Data s2_ = this.double0_cache;
                        if (s2_ != null) {
                            if ((s2_.bufferInterop_.accepts(arg1Value))) {
                                InteropLibrary numberInterop__1 = this.receiverNumberInteropLibrary_;
                                if ((numberInterop__1.fitsInDouble(arg0Value.number))) {
                                    Serialize.doDouble(arg0Value, arg1Value, numberInterop__1, s2_.bufferInterop_);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[FP80Number.Serialize.doDouble(FP80Number, Object, InteropLibrary, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary numberInterop__1 = this.receiverNumberInteropLibrary_;
                                if ((numberInterop__1.fitsInDouble(arg0Value.number))) {
                                    this.serialize_Double1Boundary(state_0, arg0Value, arg1Value);
                                    return;
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(arg0Value, arg1Value);
                return;
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private void serialize_Long1Boundary(int state_0, FP80Number arg0Value, Object arg1Value) throws UnsupportedMessageException {
                {
                    InteropLibrary numberInterop__ = this.receiverNumberInteropLibrary_;
                    InteropLibrary bufferInterop__ = (INTEROP_LIBRARY_.getUncached());
                    Serialize.doLong(arg0Value, arg1Value, numberInterop__, bufferInterop__);
                    return;
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private void serialize_Double1Boundary(int state_0, FP80Number arg0Value, Object arg1Value) throws UnsupportedMessageException {
                {
                    InteropLibrary numberInterop__1 = this.receiverNumberInteropLibrary_;
                    InteropLibrary bufferInterop__1 = (INTEROP_LIBRARY_.getUncached());
                    Serialize.doDouble(arg0Value, arg1Value, numberInterop__1, bufferInterop__1);
                    return;
                }
            }

            private void executeAndSpecialize(FP80Number arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary numberInterop__ = null;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[FP80Number.Serialize.doLong(FP80Number, Object, InteropLibrary, InteropLibrary)] */) {
                        while (true) {
                            int count0_ = 0;
                            Long0Data s0_ = LONG0_CACHE_UPDATER.getVolatile(this);
                            Long0Data s0_original = s0_;
                            while (s0_ != null) {
                                if ((s0_.bufferInterop_.accepts(arg1Value))) {
                                    numberInterop__ = this.receiverNumberInteropLibrary_;
                                    if ((numberInterop__.fitsInLong(arg0Value.number))) {
                                        break;
                                    }
                                }
                                count0_++;
                                s0_ = null;
                                break;
                            }
                            if (s0_ == null && count0_ < 1) {
                                {
                                    numberInterop__ = this.receiverNumberInteropLibrary_;
                                    // assert (s0_.bufferInterop_.accepts(arg1Value));
                                    if ((numberInterop__.fitsInLong(arg0Value.number))) {
                                        s0_ = this.insert(new Long0Data());
                                        InteropLibrary bufferInterop__ = s0_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                        Objects.requireNonNull(bufferInterop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.bufferInterop_ = bufferInterop__;
                                        if (!LONG0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[FP80Number.Serialize.doLong(FP80Number, Object, InteropLibrary, InteropLibrary)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s0_ != null) {
                                Serialize.doLong(arg0Value, arg1Value, numberInterop__, s0_.bufferInterop_);
                                return;
                            }
                            break;
                        }
                    }
                }
                {
                    InteropLibrary bufferInterop__ = null;
                    InteropLibrary numberInterop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                numberInterop__ = this.receiverNumberInteropLibrary_;
                                if ((numberInterop__.fitsInLong(arg0Value.number))) {
                                    bufferInterop__ = (INTEROP_LIBRARY_.getUncached());
                                    this.long0_cache = null;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[FP80Number.Serialize.doLong(FP80Number, Object, InteropLibrary, InteropLibrary)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[FP80Number.Serialize.doLong(FP80Number, Object, InteropLibrary, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    Serialize.doLong(arg0Value, arg1Value, numberInterop__, bufferInterop__);
                                    return;
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                {
                    InteropLibrary numberInterop__1 = null;
                    if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[FP80Number.Serialize.doDouble(FP80Number, Object, InteropLibrary, InteropLibrary)] */) {
                        while (true) {
                            int count2_ = 0;
                            Double0Data s2_ = DOUBLE0_CACHE_UPDATER.getVolatile(this);
                            Double0Data s2_original = s2_;
                            while (s2_ != null) {
                                if ((s2_.bufferInterop_.accepts(arg1Value))) {
                                    numberInterop__1 = this.receiverNumberInteropLibrary_;
                                    if ((numberInterop__1.fitsInDouble(arg0Value.number))) {
                                        break;
                                    }
                                }
                                count2_++;
                                s2_ = null;
                                break;
                            }
                            if (s2_ == null && count2_ < 1) {
                                {
                                    numberInterop__1 = this.receiverNumberInteropLibrary_;
                                    // assert (s2_.bufferInterop_.accepts(arg1Value));
                                    if ((numberInterop__1.fitsInDouble(arg0Value.number))) {
                                        s2_ = this.insert(new Double0Data());
                                        InteropLibrary bufferInterop__1 = s2_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                        Objects.requireNonNull(bufferInterop__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s2_.bufferInterop_ = bufferInterop__1;
                                        if (!DOUBLE0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[FP80Number.Serialize.doDouble(FP80Number, Object, InteropLibrary, InteropLibrary)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s2_ != null) {
                                Serialize.doDouble(arg0Value, arg1Value, numberInterop__1, s2_.bufferInterop_);
                                return;
                            }
                            break;
                        }
                    }
                }
                {
                    InteropLibrary bufferInterop__1 = null;
                    InteropLibrary numberInterop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                numberInterop__1 = this.receiverNumberInteropLibrary_;
                                if ((numberInterop__1.fitsInDouble(arg0Value.number))) {
                                    bufferInterop__1 = (INTEROP_LIBRARY_.getUncached());
                                    this.double0_cache = null;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[FP80Number.Serialize.doDouble(FP80Number, Object, InteropLibrary, InteropLibrary)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[FP80Number.Serialize.doDouble(FP80Number, Object, InteropLibrary, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    Serialize.doDouble(arg0Value, arg1Value, numberInterop__1, bufferInterop__1);
                                    return;
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public boolean isSerializable(Object receiver) {
                assert receiver instanceof FP80Number : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((FP80Number) receiver)).isSerializable();
            }

            @GeneratedBy(FP80Number.class)
            @DenyReplace
            private static final class Long0Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Serialize#doLong}
                 *   Parameter: {@link InteropLibrary} bufferInterop</pre> */
                @Child InteropLibrary bufferInterop_;

                Long0Data() {
                }

            }
            @GeneratedBy(FP80Number.class)
            @DenyReplace
            private static final class Double0Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Serialize#doDouble}
                 *   Parameter: {@link InteropLibrary} bufferInterop</pre> */
                @Child InteropLibrary bufferInterop_;

                Double0Data() {
                }

            }
        }
        @GeneratedBy(FP80Number.class)
        @DenyReplace
        private static final class Uncached extends SerializableLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof FP80Number) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof FP80Number;
            }

            @TruffleBoundary
            @Override
            public void serialize(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                FP80Number arg0Value = ((FP80Number) arg0Value_);
                if ((INTEROP_LIBRARY_.getUncached((arg0Value.number)).fitsInLong(arg0Value.number))) {
                    Serialize.doLong(arg0Value, arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.number)), (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    return;
                }
                if ((INTEROP_LIBRARY_.getUncached((arg0Value.number)).fitsInDouble(arg0Value.number))) {
                    Serialize.doDouble(arg0Value, arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.number)), (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    return;
                }
                throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isSerializable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((FP80Number) receiver) .isSerializable();
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
            }

        }
    }
}
