// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import com.oracle.truffle.nfi.NFIRootNode.LoadLibraryNode;
import com.oracle.truffle.nfi.NFIRootNode.LookupAndBindNode;
import com.oracle.truffle.nfi.SignatureRootNode.BuildSignatureNode;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.types.NativeLibraryDescriptor;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(NFIRootNode.class)
@SuppressWarnings({"javadoc", "unused"})
final class NFIRootNodeFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<SignatureLibrary> SIGNATURE_LIBRARY_ = LibraryFactory.resolve(SignatureLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link LookupAndBindNode#doLookupAndBind}
     *     Activation probability: 0.65000
     *     With/without class size: 19/8 bytes
     *   Specialization {@link LookupAndBindNode#doLookupAndBind}
     *     Activation probability: 0.35000
     *     With/without class size: 11/4 bytes
     * </pre> */
    @GeneratedBy(LookupAndBindNode.class)
    @SuppressWarnings("javadoc")
    static final class LookupAndBindNodeGen extends LookupAndBindNode {

        static final ReferenceField<LookupAndBind0Data> LOOKUP_AND_BIND0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "lookupAndBind0_cache", LookupAndBind0Data.class);

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link LookupAndBindNode#doLookupAndBind}
         *   1: SpecializationActive {@link LookupAndBindNode#doLookupAndBind}
         * </pre> */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private LookupAndBind0Data lookupAndBind0_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LookupAndBindNode#doLookupAndBind}
         *   Parameter: {@link SignatureLibrary} signatures</pre> */
        @Child private SignatureLibrary lookupAndBind1_signatures_;

        private LookupAndBindNodeGen(String name, BuildSignatureNode signature) {
            super(name, signature);
        }

        @Override
        Object execute(API arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is SpecializationActive[NFIRootNode.LookupAndBindNode.doLookupAndBind(API, Object, InteropLibrary, SignatureLibrary)] || SpecializationActive[NFIRootNode.LookupAndBindNode.doLookupAndBind(API, Object, InteropLibrary, SignatureLibrary)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NFIRootNode.LookupAndBindNode.doLookupAndBind(API, Object, InteropLibrary, SignatureLibrary)] */) {
                    LookupAndBind0Data s0_ = this.lookupAndBind0_cache;
                    if (s0_ != null) {
                        if ((s0_.libInterop_.accepts(arg1Value))) {
                            return doLookupAndBind(arg0Value, arg1Value, s0_.libInterop_, s0_.signatures_);
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NFIRootNode.LookupAndBindNode.doLookupAndBind(API, Object, InteropLibrary, SignatureLibrary)] */) {
                    {
                        SignatureLibrary signatures__ = this.lookupAndBind1_signatures_;
                        if (signatures__ != null) {
                            return this.lookupAndBind1Boundary(state_0, arg0Value, arg1Value, signatures__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object lookupAndBind1Boundary(int state_0, API arg0Value, Object arg1Value, SignatureLibrary signatures__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary libInterop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                    return doLookupAndBind(arg0Value, arg1Value, libInterop__, signatures__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(API arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[NFIRootNode.LookupAndBindNode.doLookupAndBind(API, Object, InteropLibrary, SignatureLibrary)] */) {
                while (true) {
                    int count0_ = 0;
                    LookupAndBind0Data s0_ = LOOKUP_AND_BIND0_CACHE_UPDATER.getVolatile(this);
                    LookupAndBind0Data s0_original = s0_;
                    while (s0_ != null) {
                        if ((s0_.libInterop_.accepts(arg1Value))) {
                            break;
                        }
                        count0_++;
                        s0_ = null;
                        break;
                    }
                    if (s0_ == null && count0_ < 1) {
                        // assert (s0_.libInterop_.accepts(arg1Value));
                        s0_ = this.insert(new LookupAndBind0Data());
                        InteropLibrary libInterop__ = s0_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                        Objects.requireNonNull(libInterop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.libInterop_ = libInterop__;
                        SignatureLibrary signatures__ = s0_.insert((SIGNATURE_LIBRARY_.createDispatched(1)));
                        Objects.requireNonNull(signatures__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.signatures_ = signatures__;
                        if (!LOOKUP_AND_BIND0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[NFIRootNode.LookupAndBindNode.doLookupAndBind(API, Object, InteropLibrary, SignatureLibrary)] */;
                        this.state_0_ = state_0;
                    }
                    if (s0_ != null) {
                        return doLookupAndBind(arg0Value, arg1Value, s0_.libInterop_, s0_.signatures_);
                    }
                    break;
                }
            }
            {
                InteropLibrary libInterop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        libInterop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                        SignatureLibrary signatures__ = this.insert((SIGNATURE_LIBRARY_.createDispatched(1)));
                        Objects.requireNonNull(signatures__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.lookupAndBind1_signatures_ = signatures__;
                        this.lookupAndBind0_cache = null;
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[NFIRootNode.LookupAndBindNode.doLookupAndBind(API, Object, InteropLibrary, SignatureLibrary)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[NFIRootNode.LookupAndBindNode.doLookupAndBind(API, Object, InteropLibrary, SignatureLibrary)] */;
                        this.state_0_ = state_0;
                        return doLookupAndBind(arg0Value, arg1Value, libInterop__, signatures__);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }

        @NeverDefault
        public static LookupAndBindNode create(String name, BuildSignatureNode signature) {
            return new LookupAndBindNodeGen(name, signature);
        }

        @GeneratedBy(LookupAndBindNode.class)
        @DenyReplace
        private static final class LookupAndBind0Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LookupAndBindNode#doLookupAndBind}
             *   Parameter: {@link InteropLibrary} libInterop</pre> */
            @Child InteropLibrary libInterop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LookupAndBindNode#doLookupAndBind}
             *   Parameter: {@link SignatureLibrary} signatures</pre> */
            @Child SignatureLibrary signatures_;

            LookupAndBind0Data() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LoadLibraryNode#doCached}
     *     Activation probability: 0.65000
     *     With/without class size: 22/8 bytes
     *   Specialization {@link LoadLibraryNode#doGeneric}
     *     Activation probability: 0.35000
     *     With/without class size: 11/4 bytes
     * </pre> */
    @GeneratedBy(LoadLibraryNode.class)
    @SuppressWarnings("javadoc")
    static final class LoadLibraryNodeGen extends LoadLibraryNode {

        static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link LoadLibraryNode#doCached}
         *   1: SpecializationActive {@link LoadLibraryNode#doGeneric}
         * </pre> */
        @CompilationFinal private int state_0_;
        @UnsafeAccessedField @Child private CachedData cached_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LoadLibraryNode#doGeneric}
         *   Parameter: {@link IndirectCallNode} callNode</pre> */
        @Child private IndirectCallNode generic_callNode_;

        private LoadLibraryNodeGen(NativeLibraryDescriptor descriptor) {
            super(descriptor);
        }

        @ExplodeLoop
        @Override
        protected Object execute(NFIBackend arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is SpecializationActive[NFIRootNode.LoadLibraryNode.doCached(NFIBackend, NFIBackend, DirectCallNode)] || SpecializationActive[NFIRootNode.LoadLibraryNode.doGeneric(NFIBackend, IndirectCallNode)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[NFIRootNode.LoadLibraryNode.doCached(NFIBackend, NFIBackend, DirectCallNode)] */) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        {
                            NFIBackend cachedBackend__ = (s0_.weakCachedBackendGen__.get());
                            if ((cachedBackend__ != null) && (arg0Value == cachedBackend__)) {
                                return doCached(arg0Value, cachedBackend__, s0_.callNode_);
                            }
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NFIRootNode.LoadLibraryNode.doGeneric(NFIBackend, IndirectCallNode)] */) {
                    {
                        IndirectCallNode callNode__ = this.generic_callNode_;
                        if (callNode__ != null) {
                            return doGeneric(arg0Value, callNode__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(NFIBackend arg0Value) {
            int state_0 = this.state_0_;
            {
                NFIBackend cachedBackend__ = null;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[NFIRootNode.LoadLibraryNode.doGeneric(NFIBackend, IndirectCallNode)] */) {
                    while (true) {
                        int count0_ = 0;
                        CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                        CachedData s0_original = s0_;
                        while (s0_ != null) {
                            {
                                cachedBackend__ = (s0_.weakCachedBackendGen__.get());
                                if ((cachedBackend__ != null) && (arg0Value == cachedBackend__)) {
                                    break;
                                }
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                TruffleWeakReference<NFIBackend> weakCachedBackendGen___ = (new TruffleWeakReference<>(arg0Value));
                                cachedBackend__ = (weakCachedBackendGen___.get());
                                if ((cachedBackend__ != null) && (arg0Value == cachedBackend__) && count0_ < (5)) {
                                    s0_ = this.insert(new CachedData(s0_original));
                                    s0_.weakCachedBackendGen__ = weakCachedBackendGen___;
                                    s0_.callNode_ = s0_.insert((DirectCallNode.create(parseLibrary(cachedBackend__))));
                                    if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[NFIRootNode.LoadLibraryNode.doCached(NFIBackend, NFIBackend, DirectCallNode)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doCached(arg0Value, cachedBackend__, s0_.callNode_);
                        }
                        break;
                    }
                }
            }
            VarHandle.storeStoreFence();
            this.generic_callNode_ = this.insert((IndirectCallNode.create()));
            this.cached_cache = null;
            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[NFIRootNode.LoadLibraryNode.doCached(NFIBackend, NFIBackend, DirectCallNode)] */;
            state_0 = state_0 | 0b10 /* add SpecializationActive[NFIRootNode.LoadLibraryNode.doGeneric(NFIBackend, IndirectCallNode)] */;
            this.state_0_ = state_0;
            return doGeneric(arg0Value, this.generic_callNode_);
        }

        @NeverDefault
        public static LoadLibraryNode create(NativeLibraryDescriptor descriptor) {
            return new LoadLibraryNodeGen(descriptor);
        }

        @GeneratedBy(LoadLibraryNode.class)
        @DenyReplace
        private static final class CachedData extends Node implements SpecializationDataNode {

            @Child CachedData next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LoadLibraryNode#doCached}
             *   Parameter: {@link TruffleWeakReference} weakCachedBackendGen_</pre> */
            @CompilationFinal TruffleWeakReference<NFIBackend> weakCachedBackendGen__;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LoadLibraryNode#doCached}
             *   Parameter: {@link DirectCallNode} callNode</pre> */
            @Child DirectCallNode callNode_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
    }
}
