// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.nfi.CallSignatureNode.CachedCallSignatureNode;
import com.oracle.truffle.nfi.CallSignatureNodeFactory.CachedCallSignatureNodeGen;
import com.oracle.truffle.nfi.api.NativePointerLibrary;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(NFISymbol.class)
@SuppressWarnings("javadoc")
public final class NFISymbolGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<BackendNativePointerLibrary> BACKEND_NATIVE_POINTER_LIBRARY_ = LibraryFactory.resolve(BackendNativePointerLibrary.class);

    static  {
        LibraryExport.register(NFISymbol.class, new InteropLibraryExports(), new NativePointerLibraryExports());
    }

    private NFISymbolGen() {
    }

    private static void init() {
        // This method is intended to ensure class initialization.
    }

    @GeneratedBy(NFISymbol.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NFISymbol.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NFISymbol;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NFISymbol;
            return new Cached(receiver);
        }

        @GeneratedBy(NFISymbol.class)
        private static final class Cached extends InteropLibrary {

            @Child private InteropLibrary receiverNativeSymbolInteropLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NFISymbol#execute(NFISymbol, Object[], CachedCallSignatureNode)}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NFISymbol#execute(NFISymbol, Object[], CachedCallSignatureNode)}
             *   Parameter: {@link CachedCallSignatureNode} call</pre> */
            @Child private CachedCallSignatureNode executeNode__execute_call_;

            protected Cached(Object receiver) {
                NFISymbol castReceiver = ((NFISymbol) receiver) ;
                this.receiverNativeSymbolInteropLibrary_ = INTEROP_LIBRARY_.create((castReceiver.nativeSymbol));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISymbol) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISymbol)) {
                    return false;
                } else if (!this.receiverNativeSymbolInteropLibrary_.accepts((((NFISymbol) receiver).nativeSymbol))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).isExecutable();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFISymbol#execute(NFISymbol, Object[], CachedCallSignatureNode)}
             *     Activation probability: 0.20000
             *     With/without class size: 8/4 bytes
             * </pre> */
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[NFISymbol.execute(NFISymbol, Object[], CachedCallSignatureNode)] */) {
                    {
                        CachedCallSignatureNode call__ = this.executeNode__execute_call_;
                        if (call__ != null) {
                            return arg0Value.execute(arg1Value, call__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(NFISymbol arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                CachedCallSignatureNode call__ = this.insert((CachedCallSignatureNodeGen.create()));
                Objects.requireNonNull(call__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.executeNode__execute_call_ = call__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[NFISymbol.execute(NFISymbol, Object[], CachedCallSignatureNode)] */;
                this.state_0_ = state_0;
                return arg0Value.execute(arg1Value, call__);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFISymbol#isNull(NFISymbol, InteropLibrary)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre> */
            @Override
            public boolean isNull(Object arg0Value_) {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                {
                    InteropLibrary library__ = this.receiverNativeSymbolInteropLibrary_;
                    return arg0Value.isNull(library__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFISymbol#isPointerInterop(NFISymbol, InteropLibrary)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre> */
            @Override
            public boolean isPointer(Object arg0Value_) {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                {
                    InteropLibrary library__ = this.receiverNativeSymbolInteropLibrary_;
                    return arg0Value.isPointerInterop(library__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFISymbol#asPointerInterop(NFISymbol, InteropLibrary)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre> */
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                {
                    InteropLibrary library__ = this.receiverNativeSymbolInteropLibrary_;
                    return arg0Value.asPointerInterop(library__);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFISymbol#toNative(NFISymbol, InteropLibrary)}
             *     Activation probability: 0.20000
             *     With/without class size: 6/0 bytes
             * </pre> */
            @Override
            public void toNative(Object arg0Value_) {
                assert arg0Value_ instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                {
                    InteropLibrary library__ = this.receiverNativeSymbolInteropLibrary_;
                    arg0Value.toNative(library__);
                    return;
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert receiver instanceof NFISymbol : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((NFISymbol) receiver)).toDisplayString(allowSideEffects);
            }

        }
        @GeneratedBy(NFISymbol.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISymbol) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.execute(arg1Value, (CachedCallSignatureNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.isNull(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.isPointerInterop(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.asPointerInterop(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public void toNative(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                arg0Value.toNative(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .toDisplayString(allowSideEffects);
            }

        }
    }
    @GeneratedBy(NFISymbol.class)
    public static final class NativePointerLibraryEagerProvider implements EagerExportProvider {

        @Override
        public void ensureRegistered() {
            NFISymbolGen.init();
        }

        @Override
        public String getLibraryClassName() {
            return "com.oracle.truffle.nfi.api.NativePointerLibrary";
        }

    }
    @GeneratedBy(NFISymbol.class)
    private static final class NativePointerLibraryExports extends LibraryExport<NativePointerLibrary> {

        private NativePointerLibraryExports() {
            super(NativePointerLibrary.class, NFISymbol.class, false, true, 1);
        }

        @Override
        protected NativePointerLibrary createUncached(Object receiver) {
            assert receiver instanceof NFISymbol;
            NativePointerLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NativePointerLibrary createCached(Object receiver) {
            assert receiver instanceof NFISymbol || receiver instanceof LibraryExport<?>;
            return new Cached();
        }

        @GeneratedBy(NFISymbol.class)
        private static final class Cached extends NativePointerLibrary implements GenerateAOT.Provider {

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link NFISymbol#isPointerNFI(NFISymbol, BackendNativePointerLibrary)}
             *   2: SpecializationActive {@link NFISymbol#asPointerNFI(NFISymbol, BackendNativePointerLibrary)}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NFISymbol#isPointerNFI}
             *   Parameter: {@link BackendNativePointerLibrary} library</pre> */
            @Child private BackendNativePointerLibrary backendNativePointer;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISymbol) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFISymbol#isPointerNFI(NFISymbol, BackendNativePointerLibrary)}
             *     Activation probability: 0.50000
             *     With/without class size: 10/0 bytes
             * </pre> */
            @Override
            public boolean isPointer(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return isPointerNFINode_AndSpecialize(arg0Value);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[NFISymbol.isPointerNFI(NFISymbol, BackendNativePointerLibrary)] */) {
                    {
                        BackendNativePointerLibrary backendNativePointer_ = this.backendNativePointer;
                        if (backendNativePointer_ != null) {
                            return arg0Value.isPointerNFI(backendNativePointer_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isPointerNFINode_AndSpecialize(arg0Value);
            }

            private boolean isPointerNFINode_AndSpecialize(NFISymbol arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                BackendNativePointerLibrary backendNativePointer_;
                BackendNativePointerLibrary backendNativePointer__shared = this.backendNativePointer;
                if (backendNativePointer__shared != null) {
                    backendNativePointer_ = backendNativePointer__shared;
                } else {
                    backendNativePointer_ = this.insert((BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                    if (backendNativePointer_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.backendNativePointer == null) {
                    VarHandle.storeStoreFence();
                    this.backendNativePointer = backendNativePointer_;
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[NFISymbol.isPointerNFI(NFISymbol, BackendNativePointerLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.isPointerNFI(backendNativePointer_);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    BackendNativePointerLibrary backendNativePointer_;
                    BackendNativePointerLibrary backendNativePointer__shared = this.backendNativePointer;
                    if (backendNativePointer__shared != null) {
                        backendNativePointer_ = backendNativePointer__shared;
                    } else {
                        backendNativePointer_ = this.insert((BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                        if (backendNativePointer_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.backendNativePointer == null) {
                        VarHandle.storeStoreFence();
                        this.backendNativePointer = backendNativePointer_;
                    }
                    if (this.backendNativePointer instanceof GenerateAOT.Provider) {
                        assert NodeUtil.assertRecursion(this.backendNativePointer, 1);
                        ((GenerateAOT.Provider) this.backendNativePointer).prepareForAOT(language, root);
                    }
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[NFISymbol.isPointerNFI(NFISymbol, BackendNativePointerLibrary)] */;
                }
                {
                    BackendNativePointerLibrary backendNativePointer_1;
                    BackendNativePointerLibrary backendNativePointer_1_shared = this.backendNativePointer;
                    if (backendNativePointer_1_shared != null) {
                        backendNativePointer_1 = backendNativePointer_1_shared;
                    } else {
                        backendNativePointer_1 = this.insert((BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                        if (backendNativePointer_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.backendNativePointer == null) {
                        VarHandle.storeStoreFence();
                        this.backendNativePointer = backendNativePointer_1;
                    }
                    if (this.backendNativePointer instanceof GenerateAOT.Provider) {
                        assert NodeUtil.assertRecursion(this.backendNativePointer, 1);
                        ((GenerateAOT.Provider) this.backendNativePointer).prepareForAOT(language, root);
                    }
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[NFISymbol.asPointerNFI(NFISymbol, BackendNativePointerLibrary)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.backendNativePointer = null;
                this.backendNativePointer = null;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFISymbol#asPointerNFI(NFISymbol, BackendNativePointerLibrary)}
             *     Activation probability: 0.50000
             *     With/without class size: 10/0 bytes
             * </pre> */
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return asPointerNFINode_AndSpecialize(arg0Value);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[NFISymbol.asPointerNFI(NFISymbol, BackendNativePointerLibrary)] */) {
                    {
                        BackendNativePointerLibrary backendNativePointer_ = this.backendNativePointer;
                        if (backendNativePointer_ != null) {
                            return arg0Value.asPointerNFI(backendNativePointer_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asPointerNFINode_AndSpecialize(arg0Value);
            }

            private long asPointerNFINode_AndSpecialize(NFISymbol arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                BackendNativePointerLibrary backendNativePointer_;
                BackendNativePointerLibrary backendNativePointer__shared = this.backendNativePointer;
                if (backendNativePointer__shared != null) {
                    backendNativePointer_ = backendNativePointer__shared;
                } else {
                    backendNativePointer_ = this.insert((BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                    if (backendNativePointer_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.backendNativePointer == null) {
                    VarHandle.storeStoreFence();
                    this.backendNativePointer = backendNativePointer_;
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[NFISymbol.asPointerNFI(NFISymbol, BackendNativePointerLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.asPointerNFI(backendNativePointer_);
            }

        }
        @GeneratedBy(NFISymbol.class)
        @DenyReplace
        private static final class Uncached extends NativePointerLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISymbol) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.isPointerNFI((BACKEND_NATIVE_POINTER_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = ((NFISymbol) arg0Value_);
                return arg0Value.asPointerNFI((BACKEND_NATIVE_POINTER_LIBRARY_.getUncached()));
            }

        }
    }
}
