// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.nfi.SimpleTypeCachedState.FromFP128;
import com.oracle.truffle.nfi.SimpleTypeCachedState.FromFP80;
import com.oracle.truffle.nfi.SimpleTypeCachedState.FromUInt16;
import com.oracle.truffle.nfi.SimpleTypeCachedState.FromUInt32;
import com.oracle.truffle.nfi.SimpleTypeCachedState.FromUInt8;
import com.oracle.truffle.nfi.SimpleTypeCachedState.Injected;
import com.oracle.truffle.nfi.SimpleTypeCachedState.NopConvert;
import com.oracle.truffle.nfi.SimpleTypeCachedState.Nothing;
import com.oracle.truffle.nfi.SimpleTypeCachedState.NullableToNative;
import com.oracle.truffle.nfi.SimpleTypeCachedState.PointerFromNative;
import com.oracle.truffle.nfi.SimpleTypeCachedState.ToDouble;
import com.oracle.truffle.nfi.SimpleTypeCachedState.ToFP128;
import com.oracle.truffle.nfi.SimpleTypeCachedState.ToFP80;
import com.oracle.truffle.nfi.SimpleTypeCachedState.ToFloat;
import com.oracle.truffle.nfi.SimpleTypeCachedState.ToInt16;
import com.oracle.truffle.nfi.SimpleTypeCachedState.ToInt32;
import com.oracle.truffle.nfi.SimpleTypeCachedState.ToInt64;
import com.oracle.truffle.nfi.SimpleTypeCachedState.ToInt8;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(SimpleTypeCachedState.class)
@SuppressWarnings({"javadoc", "unused"})
final class SimpleTypeCachedStateFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<BackendNativePointerLibrary> BACKEND_NATIVE_POINTER_LIBRARY_ = LibraryFactory.resolve(BackendNativePointerLibrary.class);
    private static final LibraryFactory<SerializableLibrary> SERIALIZABLE_LIBRARY_ = LibraryFactory.resolve(SerializableLibrary.class);

    public static List<NodeFactory<? extends ConvertTypeNode>> getFactories() {
        return List.of(NopConvertFactory.getInstance(), NothingFactory.getInstance(), InjectedFactory.getInstance(), NullableToNativeFactory.getInstance(), PointerFromNativeFactory.getInstance(), ToInt8Factory.getInstance(), FromUInt8Factory.getInstance(), ToInt16Factory.getInstance(), FromUInt16Factory.getInstance(), ToInt32Factory.getInstance(), FromUInt32Factory.getInstance(), ToInt64Factory.getInstance(), ToFloatFactory.getInstance(), ToDoubleFactory.getInstance(), ToFP80Factory.getInstance(), FromFP80Factory.getInstance(), ToFP128Factory.getInstance(), FromFP128Factory.getInstance());
    }

    @GeneratedBy(NopConvert.class)
    static final class NopConvertFactory implements NodeFactory<NopConvert> {

        private static final NopConvertFactory NOP_CONVERT_FACTORY_INSTANCE = new NopConvertFactory();

        private NopConvertFactory() {
        }

        @Override
        public Class<NopConvert> getNodeClass() {
            return NopConvert.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NopConvert createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public NopConvert getUncachedInstance() {
            return NopConvertNodeGen.UNCACHED;
        }

        static NodeFactory<NopConvert> getInstance() {
            return NOP_CONVERT_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NopConvert create() {
            return new NopConvertNodeGen();
        }

        @NeverDefault
        public static NopConvert getUncached() {
            return NopConvertNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NopConvert#doConvert}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(NopConvert.class)
        @SuppressWarnings("javadoc")
        static final class NopConvertNodeGen extends NopConvert implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            private NopConvertNodeGen() {
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                return doConvert(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                {
                }
            }

            @GeneratedBy(NopConvert.class)
            @DenyReplace
            private static final class Uncached extends NopConvert implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    return doConvert(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(Nothing.class)
    static final class NothingFactory implements NodeFactory<Nothing> {

        private static final NothingFactory NOTHING_FACTORY_INSTANCE = new NothingFactory();

        private NothingFactory() {
        }

        @Override
        public Class<Nothing> getNodeClass() {
            return Nothing.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public Nothing createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public Nothing getUncachedInstance() {
            return NothingNodeGen.UNCACHED;
        }

        static NodeFactory<Nothing> getInstance() {
            return NOTHING_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static Nothing create() {
            return new NothingNodeGen();
        }

        @NeverDefault
        public static Nothing getUncached() {
            return NothingNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link Nothing#doConvert}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(Nothing.class)
        @SuppressWarnings("javadoc")
        static final class NothingNodeGen extends Nothing implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            private NothingNodeGen() {
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                return doConvert(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                {
                }
            }

            @GeneratedBy(Nothing.class)
            @DenyReplace
            private static final class Uncached extends Nothing implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    return doConvert(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(Injected.class)
    static final class InjectedFactory implements NodeFactory<Injected> {

        private static final InjectedFactory INJECTED_FACTORY_INSTANCE = new InjectedFactory();

        private InjectedFactory() {
        }

        @Override
        public Class<Injected> getNodeClass() {
            return Injected.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public Injected createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public Injected getUncachedInstance() {
            return InjectedNodeGen.UNCACHED;
        }

        static NodeFactory<Injected> getInstance() {
            return INJECTED_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static Injected create() {
            return new InjectedNodeGen();
        }

        @NeverDefault
        public static Injected getUncached() {
            return InjectedNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link Injected#doConvert}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(Injected.class)
        @SuppressWarnings("javadoc")
        static final class InjectedNodeGen extends Injected implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            private InjectedNodeGen() {
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                return doConvert(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                {
                }
            }

            @GeneratedBy(Injected.class)
            @DenyReplace
            private static final class Uncached extends Injected implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    return doConvert(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(NullableToNative.class)
    static final class NullableToNativeFactory implements NodeFactory<NullableToNative> {

        private static final NullableToNativeFactory NULLABLE_TO_NATIVE_FACTORY_INSTANCE = new NullableToNativeFactory();

        private NullableToNativeFactory() {
        }

        @Override
        public Class<NullableToNative> getNodeClass() {
            return NullableToNative.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NullableToNative createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public NullableToNative getUncachedInstance() {
            return NullableToNativeNodeGen.UNCACHED;
        }

        static NodeFactory<NullableToNative> getInstance() {
            return NULLABLE_TO_NATIVE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NullableToNative create() {
            return new NullableToNativeNodeGen();
        }

        @NeverDefault
        public static NullableToNative getUncached() {
            return NullableToNativeNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NullableToNative#doNull}
         *     Activation probability: 0.38500
         *     With/without class size: 13/4 bytes
         *   Specialization {@link NullableToNative#doNull}
         *     Activation probability: 0.29500
         *     With/without class size: 7/0 bytes
         *   Specialization {@link NullableToNative#doObject}
         *     Activation probability: 0.20500
         *     With/without class size: 8/4 bytes
         *   Specialization {@link NullableToNative#doObject}
         *     Activation probability: 0.11500
         *     With/without class size: 5/0 bytes
         * </pre> */
        @GeneratedBy(NullableToNative.class)
        @SuppressWarnings("javadoc")
        static final class NullableToNativeNodeGen extends NullableToNative implements GenerateAOT.Provider {

            static final ReferenceField<Null0Data> NULL0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "null0_cache", Null0Data.class);
            static final ReferenceField<Object0Data> OBJECT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "object0_cache", Object0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link NullableToNative#doNull}
             *   2: SpecializationActive {@link NullableToNative#doNull}
             *   3: SpecializationActive {@link NullableToNative#doObject}
             *   4: SpecializationActive {@link NullableToNative#doObject}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Null0Data null0_cache;
            @UnsafeAccessedField @Child private Object0Data object0_cache;

            private NullableToNativeNodeGen() {
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b11110) != 0 /* is SpecializationActive[SimpleTypeCachedState.NullableToNative.doNull(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.NullableToNative.doNull(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.NullableToNative.doObject(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.NullableToNative.doObject(NFIType, Object, InteropLibrary)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.NullableToNative.doNull(NFIType, Object, InteropLibrary)] */) {
                        Null0Data s0_ = this.null0_cache;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.isNull(arg1Value))) {
                                return doNull(arg0Value, arg1Value, s0_.interop_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.NullableToNative.doNull(NFIType, Object, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNull(arg1Value))) {
                                    return this.null1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SimpleTypeCachedState.NullableToNative.doObject(NFIType, Object, InteropLibrary)] */) {
                        Object0Data s2_ = this.object0_cache;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value)) && (!(s2_.interop_.isNull(arg1Value)))) {
                                return doObject(arg0Value, arg1Value, s2_.interop_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.NullableToNative.doObject(NFIType, Object, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((!(interop__1.isNull(arg1Value)))) {
                                    return this.object1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object null1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    return doNull(arg0Value, arg1Value, interop__);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object object1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                    return doObject(arg0Value, arg1Value, interop__1);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.NullableToNative.doNull(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        Null0Data s0_ = NULL0_CACHE_UPDATER.getVolatile(this);
                        Null0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.isNull(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s0_.interop_.accepts(arg1Value));
                                if ((interop__.isNull(arg1Value)) && count0_ < (3)) {
                                    s0_ = this.insert(new Null0Data(s0_original));
                                    Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.interop_ = interop__;
                                    if (!NULL0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.NullableToNative.doNull(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doNull(arg0Value, arg1Value, s0_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNull(arg1Value))) {
                                    this.null0_cache = null;
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.NullableToNative.doNull(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.NullableToNative.doNull(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doNull(arg0Value, arg1Value, interop__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.NullableToNative.doObject(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Object0Data s2_ = OBJECT0_CACHE_UPDATER.getVolatile(this);
                        Object0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value)) && (!(s2_.interop_.isNull(arg1Value)))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            {
                                InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s2_.interop_.accepts(arg1Value));
                                if ((!(interop__1.isNull(arg1Value))) && count2_ < (3)) {
                                    s2_ = this.insert(new Object0Data(s2_original));
                                    Objects.requireNonNull(s2_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s2_.interop_ = interop__1;
                                    if (!OBJECT0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.NullableToNative.doObject(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s2_ != null) {
                            return doObject(arg0Value, arg1Value, s2_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((!(interop__1.isNull(arg1Value)))) {
                                    this.object0_cache = null;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[SimpleTypeCachedState.NullableToNative.doObject(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.NullableToNative.doObject(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doObject(arg0Value, arg1Value, interop__1);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
            }

            @GeneratedBy(NullableToNative.class)
            @DenyReplace
            private static final class Null0Data extends Node implements SpecializationDataNode {

                @Child Null0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NullableToNative#doNull}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Null0Data(Null0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(NullableToNative.class)
            @DenyReplace
            private static final class Object0Data extends Node implements SpecializationDataNode {

                @Child Object0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link NullableToNative#doObject}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Object0Data(Object0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(NullableToNative.class)
            @DenyReplace
            private static final class Uncached extends NullableToNative implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNull(arg1Value))) {
                        return doNull(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    if ((!((INTEROP_LIBRARY_.getUncached(arg1Value)).isNull(arg1Value)))) {
                        return doObject(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(PointerFromNative.class)
    static final class PointerFromNativeFactory implements NodeFactory<PointerFromNative> {

        private static final PointerFromNativeFactory POINTER_FROM_NATIVE_FACTORY_INSTANCE = new PointerFromNativeFactory();

        private PointerFromNativeFactory() {
        }

        @Override
        public Class<PointerFromNative> getNodeClass() {
            return PointerFromNative.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PointerFromNative createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public PointerFromNative getUncachedInstance() {
            return PointerFromNativeNodeGen.UNCACHED;
        }

        static NodeFactory<PointerFromNative> getInstance() {
            return POINTER_FROM_NATIVE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PointerFromNative create() {
            return new PointerFromNativeNodeGen();
        }

        @NeverDefault
        public static PointerFromNative getUncached() {
            return PointerFromNativeNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PointerFromNative#doNull}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link PointerFromNative#doLong}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link PointerFromNative#doObject}
         *     Activation probability: 0.18333
         *     With/without class size: 8/5 bytes
         * </pre> */
        @GeneratedBy(PointerFromNative.class)
        @SuppressWarnings("javadoc")
        static final class PointerFromNativeNodeGen extends PointerFromNative implements GenerateAOT.Provider {

            private static final StateField STATE_0_PointerFromNative_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PointerFromNative#doObject}
             *   Parameter: {@link InlinedConditionProfile} isPointerProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_OBJECT_IS_POINTER_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_PointerFromNative_UPDATER.subUpdater(4, 2)));
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link PointerFromNative#doNull}
             *   2: SpecializationActive {@link PointerFromNative#doLong}
             *   3: SpecializationActive {@link PointerFromNative#doObject}
             *   4-5: InlinedCache
             *        Specialization: {@link PointerFromNative#doObject}
             *        Parameter: {@link InlinedConditionProfile} isPointerProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PointerFromNative#doObject}
             *   Parameter: {@link BackendNativePointerLibrary} library</pre> */
            @Child private BackendNativePointerLibrary object_library_;

            private PointerFromNativeNodeGen() {
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b1110) != 0 /* is SpecializationActive[SimpleTypeCachedState.PointerFromNative.doNull(NFIType, Object)] || SpecializationActive[SimpleTypeCachedState.PointerFromNative.doLong(NFIType, long)] || SpecializationActive[SimpleTypeCachedState.PointerFromNative.doObject(NFIType, Object, BackendNativePointerLibrary, Node, InlinedConditionProfile)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.PointerFromNative.doNull(NFIType, Object)] */) {
                        if ((arg1Value == null)) {
                            return doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.PointerFromNative.doLong(NFIType, long)] */ && arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        return doLong(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SimpleTypeCachedState.PointerFromNative.doObject(NFIType, Object, BackendNativePointerLibrary, Node, InlinedConditionProfile)] */) {
                        {
                            BackendNativePointerLibrary library__ = this.object_library_;
                            if (library__ != null) {
                                if ((arg1Value != null)) {
                                    Node node__ = (this);
                                    return doObject(arg0Value, arg1Value, library__, node__, INLINED_OBJECT_IS_POINTER_PROFILE_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((arg1Value == null)) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.PointerFromNative.doNull(NFIType, Object)] */;
                    this.state_0_ = state_0;
                    return doNull(arg0Value, arg1Value);
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.PointerFromNative.doLong(NFIType, long)] */;
                    this.state_0_ = state_0;
                    return doLong(arg0Value, arg1Value_);
                }
                {
                    Node node__ = null;
                    if ((arg1Value != null)) {
                        BackendNativePointerLibrary library__ = this.insert((BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                        Objects.requireNonNull(library__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.object_library_ = library__;
                        node__ = (this);
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.PointerFromNative.doObject(NFIType, Object, BackendNativePointerLibrary, Node, InlinedConditionProfile)] */;
                        this.state_0_ = state_0;
                        return doObject(arg0Value, arg1Value, library__, node__, INLINED_OBJECT_IS_POINTER_PROFILE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.PointerFromNative.doNull(NFIType, Object)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[SimpleTypeCachedState.PointerFromNative.doLong(NFIType, long)] */;
                }
                {
                    BackendNativePointerLibrary library__ = this.insert((BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(library__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.object_library_ = library__;
                    INLINED_OBJECT_IS_POINTER_PROFILE_.disable(this);
                    if (this.object_library_ instanceof GenerateAOT.Provider) {
                        assert NodeUtil.assertRecursion(this.object_library_, 1);
                        ((GenerateAOT.Provider) this.object_library_).prepareForAOT(language, root);
                    }
                    this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.PointerFromNative.doObject(NFIType, Object, BackendNativePointerLibrary, Node, InlinedConditionProfile)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.object_library_ = null;
                INLINED_OBJECT_IS_POINTER_PROFILE_.reset(this);
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
            }

            @GeneratedBy(PointerFromNative.class)
            @DenyReplace
            private static final class Uncached extends PointerFromNative implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if ((arg1Value == null)) {
                        return doNull(arg0Value, arg1Value);
                    }
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        return doLong(arg0Value, arg1Value_);
                    }
                    if ((arg1Value != null)) {
                        return doObject(arg0Value, arg1Value, (BACKEND_NATIVE_POINTER_LIBRARY_.getUncached()), (this), (InlinedConditionProfile.getUncached()));
                    }
                    throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(ToInt8.class)
    static final class ToInt8Factory implements NodeFactory<ToInt8> {

        private static final ToInt8Factory TO_INT8FACTORY_INSTANCE = new ToInt8Factory();

        private ToInt8Factory() {
        }

        @Override
        public Class<ToInt8> getNodeClass() {
            return ToInt8.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ToInt8 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ToInt8 getUncachedInstance() {
            return ToInt8NodeGen.UNCACHED;
        }

        static NodeFactory<ToInt8> getInstance() {
            return TO_INT8FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToInt8 create() {
            return new ToInt8NodeGen();
        }

        @NeverDefault
        public static ToInt8 getUncached() {
            return ToInt8NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToInt8#doPrimitive}
         *     Activation probability: 0.21250
         *     With/without class size: 6/0 bytes
         *   Specialization {@link ToInt8#doChar}
         *     Activation probability: 0.18750
         *     With/without class size: 6/0 bytes
         *   Specialization {@link ToInt8#doByte}
         *     Activation probability: 0.16250
         *     With/without class size: 7/4 bytes
         *   Specialization {@link ToInt8#doNumber}
         *     Activation probability: 0.13750
         *     With/without class size: 7/5 bytes
         *   Specialization {@link ToInt8#doNumber}
         *     Activation probability: 0.11250
         *     With/without class size: 6/1 bytes
         *   Specialization {@link ToInt8#doBoolean}
         *     Activation probability: 0.08750
         *     With/without class size: 6/4 bytes
         *   Specialization {@link ToInt8#doBoolean}
         *     Activation probability: 0.06250
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ToInt8#doFail}
         *     Activation probability: 0.03750
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ToInt8.class)
        @SuppressWarnings("javadoc")
        static final class ToInt8NodeGen extends ToInt8 implements GenerateAOT.Provider {

            private static final StateField NUMBER0_TO_INT8_NUMBER0_STATE_0_UPDATER = StateField.create(Number0Data.lookup_(), "number0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToInt8#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, NUMBER0_TO_INT8_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_ToInt8_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToInt8#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_ToInt8_UPDATER.subUpdater(10, 1)));
            static final ReferenceField<ByteData> BYTE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "byte_cache", ByteData.class);
            static final ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "number0_cache", Number0Data.class);
            static final ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToInt8#doPrimitive}
             *   2: SpecializationActive {@link ToInt8#doByte}
             *   3: SpecializationExcluded {@link ToInt8#doByte}
             *   4: SpecializationActive {@link ToInt8#doNumber}
             *   5: SpecializationActive {@link ToInt8#doNumber}
             *   6: SpecializationActive {@link ToInt8#doChar}
             *   7: SpecializationActive {@link ToInt8#doBoolean}
             *   8: SpecializationActive {@link ToInt8#doBoolean}
             *   9: SpecializationActive {@link ToInt8#doFail}
             *   10: InlinedCache
             *        Specialization: {@link ToInt8#doNumber}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private ByteData byte_cache;
            @UnsafeAccessedField @Child private Number0Data number0_cache;
            @UnsafeAccessedField @Child private Boolean0Data boolean0_cache;

            private ToInt8NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doChar(NFIType, char)] */) && arg1Value instanceof Character) {
                    return false;
                }
                if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) && ((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b1111110110) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doPrimitive(NFIType, byte)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doChar(NFIType, char)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doFail(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doPrimitive(NFIType, byte)] */ && arg1Value instanceof Byte) {
                        byte arg1Value_ = (byte) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doChar(NFIType, char)] */ && arg1Value instanceof Character) {
                        char arg1Value_ = (char) arg1Value;
                        return doChar(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b1110110100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt8.doFail(NFIType, Object)] */) {
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)] */) {
                            ByteData s2_ = this.byte_cache;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.fitsInByte(arg1Value))) {
                                    try {
                                        return doByte(arg0Value, arg1Value, s2_.interop_);
                                    } catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        this.byte_cache = null;
                                        return executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            Number0Data s3_ = this.number0_cache;
                            while (s3_ != null) {
                                if ((s3_.interop_.accepts(arg1Value)) && (s3_.interop_.isNumber(arg1Value))) {
                                    Node node__ = (s3_);
                                    return ToInt8.doNumber(arg0Value, arg1Value, s3_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s3_ = s3_.next_;
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.isNumber(arg1Value))) {
                                        return this.number1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            Boolean0Data s5_ = this.boolean0_cache;
                            while (s5_ != null) {
                                if ((s5_.interop_.accepts(arg1Value)) && (s5_.interop_.isBoolean(arg1Value))) {
                                    return doBoolean(arg0Value, arg1Value, s5_.interop_);
                                }
                                s5_ = s5_.next_;
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__1.isBoolean(arg1Value))) {
                                        return this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt8.doFail(NFIType, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return doFail(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    Node node__ = (this);
                    return ToInt8.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                    return doBoolean(arg0Value, arg1Value, interop__1);
                }
            }

            @SuppressWarnings("unused")
            private byte executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b110100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)] && SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && arg1Value instanceof Byte) {
                    byte arg1Value_ = (byte) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doPrimitive(NFIType, byte)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Character) {
                    char arg1Value_ = (char) arg1Value;
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doChar(NFIType, char)] */;
                    this.state_0_ = state_0;
                    return doChar(arg0Value, arg1Value_);
                }
                if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    while (true) {
                        int count2_ = 0;
                        ByteData s2_ = BYTE_CACHE_UPDATER.getVolatile(this);
                        ByteData s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.fitsInByte(arg1Value))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            {
                                InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s2_.interop_.accepts(arg1Value));
                                if ((interop__2.fitsInByte(arg1Value)) && count2_ < (3)) {
                                    s2_ = this.insert(new ByteData(s2_original));
                                    Objects.requireNonNull(s2_.insert(interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s2_.interop_ = interop__2;
                                    if (!BYTE_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.ToInt8.doPrimitive(NFIType, byte)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s2_ != null) {
                            try {
                                return doByte(arg0Value, arg1Value, s2_.interop_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.byte_cache = null;
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        break;
                    }
                }
                {
                    Node node__ = null;
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                        while (true) {
                            int count3_ = 0;
                            Number0Data s3_ = NUMBER0_CACHE_UPDATER.getVolatile(this);
                            Number0Data s3_original = s3_;
                            while (s3_ != null) {
                                if ((s3_.interop_.accepts(arg1Value)) && (s3_.interop_.isNumber(arg1Value))) {
                                    node__ = (s3_);
                                    break;
                                }
                                count3_++;
                                s3_ = s3_.next_;
                            }
                            if (s3_ == null) {
                                {
                                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                    // assert (s3_.interop_.accepts(arg1Value));
                                    if ((interop__.isNumber(arg1Value)) && count3_ < (3)) {
                                        s3_ = this.insert(new Number0Data(s3_original));
                                        Objects.requireNonNull(s3_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s3_.interop_ = interop__;
                                        node__ = (s3_);
                                        if (!NUMBER0_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                            continue;
                                        }
                                        this.byte_cache = null;
                                        state_0 = state_0 & 0xfffffff9 /* remove SpecializationActive[SimpleTypeCachedState.ToInt8.doPrimitive(NFIType, byte)], SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s3_ != null) {
                                return ToInt8.doNumber(arg0Value, arg1Value, s3_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                            }
                            break;
                        }
                    }
                }
                {
                    Node node__ = null;
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    node__ = (this);
                                    this.byte_cache = null;
                                    this.number0_cache = null;
                                    state_0 = state_0 & 0xffffffe9 /* remove SpecializationActive[SimpleTypeCachedState.ToInt8.doPrimitive(NFIType, byte)], SpecializationActive[SimpleTypeCachedState.ToInt8.doByte(NFIType, Object, InteropLibrary)], SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    this.state_0_ = state_0;
                                    return ToInt8.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count5_ = 0;
                        Boolean0Data s5_ = BOOLEAN0_CACHE_UPDATER.getVolatile(this);
                        Boolean0Data s5_original = s5_;
                        while (s5_ != null) {
                            if ((s5_.interop_.accepts(arg1Value)) && (s5_.interop_.isBoolean(arg1Value))) {
                                break;
                            }
                            count5_++;
                            s5_ = s5_.next_;
                        }
                        if (s5_ == null) {
                            {
                                InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s5_.interop_.accepts(arg1Value));
                                if ((interop__1.isBoolean(arg1Value)) && count5_ < (3)) {
                                    s5_ = this.insert(new Boolean0Data(s5_original));
                                    Objects.requireNonNull(s5_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s5_.interop_ = interop__1;
                                    if (!BOOLEAN0_CACHE_UPDATER.compareAndSet(this, s5_original, s5_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s5_ != null) {
                            return doBoolean(arg0Value, arg1Value, s5_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__1.isBoolean(arg1Value))) {
                                    this.boolean0_cache = null;
                                    state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doBoolean(arg0Value, arg1Value, interop__1);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doFail(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doFail(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doPrimitive(NFIType, byte)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doChar(NFIType, char)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt8.doFail(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(ToInt8.class)
            @DenyReplace
            private static final class ByteData extends Node implements SpecializationDataNode {

                @Child ByteData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt8#doByte}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                ByteData(ByteData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToInt8.class)
            @DenyReplace
            private static final class Number0Data extends Node implements SpecializationDataNode {

                @Child Number0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link ToInt8#doNumber}
                 *        Parameter: {@link InlinedBranchProfile} exception
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int number0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt8#doNumber}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
            @GeneratedBy(ToInt8.class)
            @DenyReplace
            private static final class Boolean0Data extends Node implements SpecializationDataNode {

                @Child Boolean0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt8#doBoolean}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToInt8.class)
            @DenyReplace
            private static final class Uncached extends ToInt8 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Byte) {
                        byte arg1Value_ = (byte) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if (arg1Value instanceof Character) {
                        char arg1Value_ = (char) arg1Value;
                        return doChar(arg0Value, arg1Value_);
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value))) {
                        return ToInt8.doNumber(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (this), (InlinedBranchProfile.getUncached()));
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value))) {
                        return doBoolean(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doFail(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(FromUInt8.class)
    static final class FromUInt8Factory implements NodeFactory<FromUInt8> {

        private static final FromUInt8Factory FROM_UINT8FACTORY_INSTANCE = new FromUInt8Factory();

        private FromUInt8Factory() {
        }

        @Override
        public Class<FromUInt8> getNodeClass() {
            return FromUInt8.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FromUInt8 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public FromUInt8 getUncachedInstance() {
            return FromUInt8NodeGen.UNCACHED;
        }

        static NodeFactory<FromUInt8> getInstance() {
            return FROM_UINT8FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FromUInt8 create() {
            return new FromUInt8NodeGen();
        }

        @NeverDefault
        public static FromUInt8 getUncached() {
            return FromUInt8NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FromUInt8#doPrimitive}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link FromUInt8#doOther}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre> */
        @GeneratedBy(FromUInt8.class)
        @SuppressWarnings("javadoc")
        static final class FromUInt8NodeGen extends FromUInt8 implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link FromUInt8#doPrimitive}
             *   2: SpecializationActive {@link FromUInt8#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;

            private FromUInt8NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt8.doPrimitive(NFIType, byte)] */) && arg1Value instanceof Byte) {
                    return false;
                }
                return true;
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt8.doPrimitive(NFIType, byte)] || SpecializationActive[SimpleTypeCachedState.FromUInt8.doOther(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt8.doPrimitive(NFIType, byte)] */ && arg1Value instanceof Byte) {
                        byte arg1Value_ = (byte) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt8.doOther(NFIType, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (byte) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.FromUInt8.doPrimitive(NFIType, byte)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.FromUInt8.doOther(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doOther(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.FromUInt8.doPrimitive(NFIType, byte)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[SimpleTypeCachedState.FromUInt8.doOther(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(FromUInt8.class)
            @DenyReplace
            private static final class Uncached extends FromUInt8 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Byte) {
                        byte arg1Value_ = (byte) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    return doOther(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(ToInt16.class)
    static final class ToInt16Factory implements NodeFactory<ToInt16> {

        private static final ToInt16Factory TO_INT16FACTORY_INSTANCE = new ToInt16Factory();

        private ToInt16Factory() {
        }

        @Override
        public Class<ToInt16> getNodeClass() {
            return ToInt16.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ToInt16 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ToInt16 getUncachedInstance() {
            return ToInt16NodeGen.UNCACHED;
        }

        static NodeFactory<ToInt16> getInstance() {
            return TO_INT16FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToInt16 create() {
            return new ToInt16NodeGen();
        }

        @NeverDefault
        public static ToInt16 getUncached() {
            return ToInt16NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToInt16#doPrimitive}
         *     Activation probability: 0.23929
         *     With/without class size: 6/0 bytes
         *   Specialization {@link ToInt16#doShort}
         *     Activation probability: 0.20714
         *     With/without class size: 8/4 bytes
         *   Specialization {@link ToInt16#doNumber}
         *     Activation probability: 0.17500
         *     With/without class size: 8/5 bytes
         *   Specialization {@link ToInt16#doNumber}
         *     Activation probability: 0.14286
         *     With/without class size: 6/1 bytes
         *   Specialization {@link ToInt16#doBoolean}
         *     Activation probability: 0.11071
         *     With/without class size: 6/4 bytes
         *   Specialization {@link ToInt16#doBoolean}
         *     Activation probability: 0.07857
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ToInt16#doFail}
         *     Activation probability: 0.04643
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ToInt16.class)
        @SuppressWarnings("javadoc")
        static final class ToInt16NodeGen extends ToInt16 implements GenerateAOT.Provider {

            private static final StateField NUMBER0_TO_INT16_NUMBER0_STATE_0_UPDATER = StateField.create(Number0Data.lookup_(), "number0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToInt16#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, NUMBER0_TO_INT16_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_ToInt16_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToInt16#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_ToInt16_UPDATER.subUpdater(9, 1)));
            static final ReferenceField<ShortData> SHORT_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "short_cache", ShortData.class);
            static final ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "number0_cache", Number0Data.class);
            static final ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToInt16#doPrimitive}
             *   2: SpecializationActive {@link ToInt16#doShort}
             *   3: SpecializationExcluded {@link ToInt16#doShort}
             *   4: SpecializationActive {@link ToInt16#doNumber}
             *   5: SpecializationActive {@link ToInt16#doNumber}
             *   6: SpecializationActive {@link ToInt16#doBoolean}
             *   7: SpecializationActive {@link ToInt16#doBoolean}
             *   8: SpecializationActive {@link ToInt16#doFail}
             *   9: InlinedCache
             *        Specialization: {@link ToInt16#doNumber}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private ShortData short_cache;
            @UnsafeAccessedField @Child private Number0Data number0_cache;
            @UnsafeAccessedField @Child private Boolean0Data boolean0_cache;

            private ToInt16NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) && ((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b111110110) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doPrimitive(NFIType, short)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doFail(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doPrimitive(NFIType, short)] */ && arg1Value instanceof Short) {
                        short arg1Value_ = (short) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b111110100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt16.doFail(NFIType, Object)] */) {
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)] */) {
                            ShortData s1_ = this.short_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value)) && (s1_.interop_.fitsInShort(arg1Value))) {
                                    try {
                                        return doShort(arg0Value, arg1Value, s1_.interop_);
                                    } catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        this.short_cache = null;
                                        return executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            Number0Data s2_ = this.number0_cache;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNumber(arg1Value))) {
                                    Node node__ = (s2_);
                                    return ToInt16.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.isNumber(arg1Value))) {
                                        return this.number1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            Boolean0Data s4_ = this.boolean0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(arg1Value)) && (s4_.interop_.isBoolean(arg1Value))) {
                                    return doBoolean(arg0Value, arg1Value, s4_.interop_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__1.isBoolean(arg1Value))) {
                                        return this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt16.doFail(NFIType, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return doFail(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    Node node__ = (this);
                    return ToInt16.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                    return doBoolean(arg0Value, arg1Value, interop__1);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b110100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)] && SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doPrimitive(NFIType, short)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    while (true) {
                        int count1_ = 0;
                        ShortData s1_ = SHORT_CACHE_UPDATER.getVolatile(this);
                        ShortData s1_original = s1_;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value)) && (s1_.interop_.fitsInShort(arg1Value))) {
                                break;
                            }
                            count1_++;
                            s1_ = s1_.next_;
                        }
                        if (s1_ == null) {
                            {
                                InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s1_.interop_.accepts(arg1Value));
                                if ((interop__2.fitsInShort(arg1Value)) && count1_ < (3)) {
                                    s1_ = this.insert(new ShortData(s1_original));
                                    Objects.requireNonNull(s1_.insert(interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.interop_ = interop__2;
                                    if (!SHORT_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.ToInt16.doPrimitive(NFIType, short)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s1_ != null) {
                            try {
                                return doShort(arg0Value, arg1Value, s1_.interop_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.short_cache = null;
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        break;
                    }
                }
                {
                    Node node__ = null;
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                        while (true) {
                            int count2_ = 0;
                            Number0Data s2_ = NUMBER0_CACHE_UPDATER.getVolatile(this);
                            Number0Data s2_original = s2_;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNumber(arg1Value))) {
                                    node__ = (s2_);
                                    break;
                                }
                                count2_++;
                                s2_ = s2_.next_;
                            }
                            if (s2_ == null) {
                                {
                                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                    // assert (s2_.interop_.accepts(arg1Value));
                                    if ((interop__.isNumber(arg1Value)) && count2_ < (3)) {
                                        s2_ = this.insert(new Number0Data(s2_original));
                                        Objects.requireNonNull(s2_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s2_.interop_ = interop__;
                                        node__ = (s2_);
                                        if (!NUMBER0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        this.short_cache = null;
                                        state_0 = state_0 & 0xfffffff9 /* remove SpecializationActive[SimpleTypeCachedState.ToInt16.doPrimitive(NFIType, short)], SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s2_ != null) {
                                return ToInt16.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                            }
                            break;
                        }
                    }
                }
                {
                    Node node__ = null;
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    node__ = (this);
                                    this.short_cache = null;
                                    this.number0_cache = null;
                                    state_0 = state_0 & 0xffffffe9 /* remove SpecializationActive[SimpleTypeCachedState.ToInt16.doPrimitive(NFIType, short)], SpecializationActive[SimpleTypeCachedState.ToInt16.doShort(NFIType, Object, InteropLibrary)], SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    this.state_0_ = state_0;
                                    return ToInt16.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count4_ = 0;
                        Boolean0Data s4_ = BOOLEAN0_CACHE_UPDATER.getVolatile(this);
                        Boolean0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(arg1Value)) && (s4_.interop_.isBoolean(arg1Value))) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            {
                                InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s4_.interop_.accepts(arg1Value));
                                if ((interop__1.isBoolean(arg1Value)) && count4_ < (3)) {
                                    s4_ = this.insert(new Boolean0Data(s4_original));
                                    Objects.requireNonNull(s4_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s4_.interop_ = interop__1;
                                    if (!BOOLEAN0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s4_ != null) {
                            return doBoolean(arg0Value, arg1Value, s4_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__1.isBoolean(arg1Value))) {
                                    this.boolean0_cache = null;
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doBoolean(arg0Value, arg1Value, interop__1);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doFail(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doFail(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doPrimitive(NFIType, short)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt16.doFail(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(ToInt16.class)
            @DenyReplace
            private static final class ShortData extends Node implements SpecializationDataNode {

                @Child ShortData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt16#doShort}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                ShortData(ShortData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToInt16.class)
            @DenyReplace
            private static final class Number0Data extends Node implements SpecializationDataNode {

                @Child Number0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link ToInt16#doNumber}
                 *        Parameter: {@link InlinedBranchProfile} exception
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int number0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt16#doNumber}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
            @GeneratedBy(ToInt16.class)
            @DenyReplace
            private static final class Boolean0Data extends Node implements SpecializationDataNode {

                @Child Boolean0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt16#doBoolean}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToInt16.class)
            @DenyReplace
            private static final class Uncached extends ToInt16 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Short) {
                        short arg1Value_ = (short) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value))) {
                        return ToInt16.doNumber(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (this), (InlinedBranchProfile.getUncached()));
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value))) {
                        return doBoolean(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doFail(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(FromUInt16.class)
    static final class FromUInt16Factory implements NodeFactory<FromUInt16> {

        private static final FromUInt16Factory FROM_UINT16FACTORY_INSTANCE = new FromUInt16Factory();

        private FromUInt16Factory() {
        }

        @Override
        public Class<FromUInt16> getNodeClass() {
            return FromUInt16.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FromUInt16 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public FromUInt16 getUncachedInstance() {
            return FromUInt16NodeGen.UNCACHED;
        }

        static NodeFactory<FromUInt16> getInstance() {
            return FROM_UINT16FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FromUInt16 create() {
            return new FromUInt16NodeGen();
        }

        @NeverDefault
        public static FromUInt16 getUncached() {
            return FromUInt16NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FromUInt16#doPrimitive}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link FromUInt16#doOther}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre> */
        @GeneratedBy(FromUInt16.class)
        @SuppressWarnings("javadoc")
        static final class FromUInt16NodeGen extends FromUInt16 implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link FromUInt16#doPrimitive}
             *   2: SpecializationActive {@link FromUInt16#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;

            private FromUInt16NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt16.doPrimitive(NFIType, short)] */) && arg1Value instanceof Short) {
                    return false;
                }
                return true;
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt16.doPrimitive(NFIType, short)] || SpecializationActive[SimpleTypeCachedState.FromUInt16.doOther(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt16.doPrimitive(NFIType, short)] */ && arg1Value instanceof Short) {
                        short arg1Value_ = (short) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt16.doOther(NFIType, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.FromUInt16.doPrimitive(NFIType, short)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.FromUInt16.doOther(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doOther(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.FromUInt16.doPrimitive(NFIType, short)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[SimpleTypeCachedState.FromUInt16.doOther(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(FromUInt16.class)
            @DenyReplace
            private static final class Uncached extends FromUInt16 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Short) {
                        short arg1Value_ = (short) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    return doOther(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(ToInt32.class)
    static final class ToInt32Factory implements NodeFactory<ToInt32> {

        private static final ToInt32Factory TO_INT32FACTORY_INSTANCE = new ToInt32Factory();

        private ToInt32Factory() {
        }

        @Override
        public Class<ToInt32> getNodeClass() {
            return ToInt32.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ToInt32 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ToInt32 getUncachedInstance() {
            return ToInt32NodeGen.UNCACHED;
        }

        static NodeFactory<ToInt32> getInstance() {
            return TO_INT32FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToInt32 create() {
            return new ToInt32NodeGen();
        }

        @NeverDefault
        public static ToInt32 getUncached() {
            return ToInt32NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToInt32#doPrimitive}
         *     Activation probability: 0.23929
         *     With/without class size: 6/0 bytes
         *   Specialization {@link ToInt32#doInt}
         *     Activation probability: 0.20714
         *     With/without class size: 8/4 bytes
         *   Specialization {@link ToInt32#doNumber}
         *     Activation probability: 0.17500
         *     With/without class size: 8/5 bytes
         *   Specialization {@link ToInt32#doNumber}
         *     Activation probability: 0.14286
         *     With/without class size: 6/1 bytes
         *   Specialization {@link ToInt32#doBoolean}
         *     Activation probability: 0.11071
         *     With/without class size: 6/4 bytes
         *   Specialization {@link ToInt32#doBoolean}
         *     Activation probability: 0.07857
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ToInt32#doFail}
         *     Activation probability: 0.04643
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ToInt32.class)
        @SuppressWarnings("javadoc")
        static final class ToInt32NodeGen extends ToInt32 implements GenerateAOT.Provider {

            private static final StateField NUMBER0_TO_INT32_NUMBER0_STATE_0_UPDATER = StateField.create(Number0Data.lookup_(), "number0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToInt32#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, NUMBER0_TO_INT32_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_ToInt32_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToInt32#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_ToInt32_UPDATER.subUpdater(9, 1)));
            static final ReferenceField<IntData> INT_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "int_cache", IntData.class);
            static final ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "number0_cache", Number0Data.class);
            static final ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToInt32#doPrimitive}
             *   2: SpecializationActive {@link ToInt32#doInt}
             *   3: SpecializationExcluded {@link ToInt32#doInt}
             *   4: SpecializationActive {@link ToInt32#doNumber}
             *   5: SpecializationActive {@link ToInt32#doNumber}
             *   6: SpecializationActive {@link ToInt32#doBoolean}
             *   7: SpecializationActive {@link ToInt32#doBoolean}
             *   8: SpecializationActive {@link ToInt32#doFail}
             *   9: InlinedCache
             *        Specialization: {@link ToInt32#doNumber}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private IntData int_cache;
            @UnsafeAccessedField @Child private Number0Data number0_cache;
            @UnsafeAccessedField @Child private Boolean0Data boolean0_cache;

            private ToInt32NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) && ((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b111110110) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doPrimitive(NFIType, int)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doFail(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doPrimitive(NFIType, int)] */ && arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b111110100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt32.doFail(NFIType, Object)] */) {
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)] */) {
                            IntData s1_ = this.int_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value)) && (s1_.interop_.fitsInInt(arg1Value))) {
                                    try {
                                        return doInt(arg0Value, arg1Value, s1_.interop_);
                                    } catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        this.int_cache = null;
                                        return executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            Number0Data s2_ = this.number0_cache;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNumber(arg1Value))) {
                                    Node node__ = (s2_);
                                    return ToInt32.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.isNumber(arg1Value))) {
                                        return this.number1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            Boolean0Data s4_ = this.boolean0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(arg1Value)) && (s4_.interop_.isBoolean(arg1Value))) {
                                    return doBoolean(arg0Value, arg1Value, s4_.interop_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__1.isBoolean(arg1Value))) {
                                        return this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt32.doFail(NFIType, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return doFail(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    Node node__ = (this);
                    return ToInt32.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                    return doBoolean(arg0Value, arg1Value, interop__1);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b110100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)] && SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doPrimitive(NFIType, int)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    while (true) {
                        int count1_ = 0;
                        IntData s1_ = INT_CACHE_UPDATER.getVolatile(this);
                        IntData s1_original = s1_;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value)) && (s1_.interop_.fitsInInt(arg1Value))) {
                                break;
                            }
                            count1_++;
                            s1_ = s1_.next_;
                        }
                        if (s1_ == null) {
                            {
                                InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s1_.interop_.accepts(arg1Value));
                                if ((interop__2.fitsInInt(arg1Value)) && count1_ < (3)) {
                                    s1_ = this.insert(new IntData(s1_original));
                                    Objects.requireNonNull(s1_.insert(interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.interop_ = interop__2;
                                    if (!INT_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.ToInt32.doPrimitive(NFIType, int)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s1_ != null) {
                            try {
                                return doInt(arg0Value, arg1Value, s1_.interop_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.int_cache = null;
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        break;
                    }
                }
                {
                    Node node__ = null;
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                        while (true) {
                            int count2_ = 0;
                            Number0Data s2_ = NUMBER0_CACHE_UPDATER.getVolatile(this);
                            Number0Data s2_original = s2_;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNumber(arg1Value))) {
                                    node__ = (s2_);
                                    break;
                                }
                                count2_++;
                                s2_ = s2_.next_;
                            }
                            if (s2_ == null) {
                                {
                                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                    // assert (s2_.interop_.accepts(arg1Value));
                                    if ((interop__.isNumber(arg1Value)) && count2_ < (3)) {
                                        s2_ = this.insert(new Number0Data(s2_original));
                                        Objects.requireNonNull(s2_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s2_.interop_ = interop__;
                                        node__ = (s2_);
                                        if (!NUMBER0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        this.int_cache = null;
                                        state_0 = state_0 & 0xfffffff9 /* remove SpecializationActive[SimpleTypeCachedState.ToInt32.doPrimitive(NFIType, int)], SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s2_ != null) {
                                return ToInt32.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                            }
                            break;
                        }
                    }
                }
                {
                    Node node__ = null;
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    node__ = (this);
                                    this.int_cache = null;
                                    this.number0_cache = null;
                                    state_0 = state_0 & 0xffffffe9 /* remove SpecializationActive[SimpleTypeCachedState.ToInt32.doPrimitive(NFIType, int)], SpecializationActive[SimpleTypeCachedState.ToInt32.doInt(NFIType, Object, InteropLibrary)], SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    this.state_0_ = state_0;
                                    return ToInt32.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count4_ = 0;
                        Boolean0Data s4_ = BOOLEAN0_CACHE_UPDATER.getVolatile(this);
                        Boolean0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(arg1Value)) && (s4_.interop_.isBoolean(arg1Value))) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            {
                                InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s4_.interop_.accepts(arg1Value));
                                if ((interop__1.isBoolean(arg1Value)) && count4_ < (3)) {
                                    s4_ = this.insert(new Boolean0Data(s4_original));
                                    Objects.requireNonNull(s4_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s4_.interop_ = interop__1;
                                    if (!BOOLEAN0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s4_ != null) {
                            return doBoolean(arg0Value, arg1Value, s4_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__1.isBoolean(arg1Value))) {
                                    this.boolean0_cache = null;
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doBoolean(arg0Value, arg1Value, interop__1);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doFail(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doFail(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doPrimitive(NFIType, int)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt32.doFail(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(ToInt32.class)
            @DenyReplace
            private static final class IntData extends Node implements SpecializationDataNode {

                @Child IntData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt32#doInt}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                IntData(IntData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToInt32.class)
            @DenyReplace
            private static final class Number0Data extends Node implements SpecializationDataNode {

                @Child Number0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link ToInt32#doNumber}
                 *        Parameter: {@link InlinedBranchProfile} exception
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int number0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt32#doNumber}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
            @GeneratedBy(ToInt32.class)
            @DenyReplace
            private static final class Boolean0Data extends Node implements SpecializationDataNode {

                @Child Boolean0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt32#doBoolean}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToInt32.class)
            @DenyReplace
            private static final class Uncached extends ToInt32 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value))) {
                        return ToInt32.doNumber(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (this), (InlinedBranchProfile.getUncached()));
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value))) {
                        return doBoolean(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doFail(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(FromUInt32.class)
    static final class FromUInt32Factory implements NodeFactory<FromUInt32> {

        private static final FromUInt32Factory FROM_UINT32FACTORY_INSTANCE = new FromUInt32Factory();

        private FromUInt32Factory() {
        }

        @Override
        public Class<FromUInt32> getNodeClass() {
            return FromUInt32.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FromUInt32 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public FromUInt32 getUncachedInstance() {
            return FromUInt32NodeGen.UNCACHED;
        }

        static NodeFactory<FromUInt32> getInstance() {
            return FROM_UINT32FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FromUInt32 create() {
            return new FromUInt32NodeGen();
        }

        @NeverDefault
        public static FromUInt32 getUncached() {
            return FromUInt32NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FromUInt32#doPrimitive}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link FromUInt32#doOther}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre> */
        @GeneratedBy(FromUInt32.class)
        @SuppressWarnings("javadoc")
        static final class FromUInt32NodeGen extends FromUInt32 implements GenerateAOT.Provider {

            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link FromUInt32#doPrimitive}
             *   2: SpecializationActive {@link FromUInt32#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;

            private FromUInt32NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt32.doPrimitive(NFIType, int)] */) && arg1Value instanceof Integer) {
                    return false;
                }
                return true;
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt32.doPrimitive(NFIType, int)] || SpecializationActive[SimpleTypeCachedState.FromUInt32.doOther(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt32.doPrimitive(NFIType, int)] */ && arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromUInt32.doOther(NFIType, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.FromUInt32.doPrimitive(NFIType, int)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.FromUInt32.doOther(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doOther(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.FromUInt32.doPrimitive(NFIType, int)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[SimpleTypeCachedState.FromUInt32.doOther(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(FromUInt32.class)
            @DenyReplace
            private static final class Uncached extends FromUInt32 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    return doOther(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(ToInt64.class)
    static final class ToInt64Factory implements NodeFactory<ToInt64> {

        private static final ToInt64Factory TO_INT64FACTORY_INSTANCE = new ToInt64Factory();

        private ToInt64Factory() {
        }

        @Override
        public Class<ToInt64> getNodeClass() {
            return ToInt64.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ToInt64 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ToInt64 getUncachedInstance() {
            return ToInt64NodeGen.UNCACHED;
        }

        static NodeFactory<ToInt64> getInstance() {
            return TO_INT64FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToInt64 create() {
            return new ToInt64NodeGen();
        }

        @NeverDefault
        public static ToInt64 getUncached() {
            return ToInt64NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToInt64#doPrimitive}
         *     Activation probability: 0.23929
         *     With/without class size: 6/0 bytes
         *   Specialization {@link ToInt64#doLong}
         *     Activation probability: 0.20714
         *     With/without class size: 8/4 bytes
         *   Specialization {@link ToInt64#doNumber}
         *     Activation probability: 0.17500
         *     With/without class size: 8/5 bytes
         *   Specialization {@link ToInt64#doNumber}
         *     Activation probability: 0.14286
         *     With/without class size: 6/1 bytes
         *   Specialization {@link ToInt64#doBoolean}
         *     Activation probability: 0.11071
         *     With/without class size: 6/4 bytes
         *   Specialization {@link ToInt64#doBoolean}
         *     Activation probability: 0.07857
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ToInt64#doFail}
         *     Activation probability: 0.04643
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ToInt64.class)
        @SuppressWarnings("javadoc")
        static final class ToInt64NodeGen extends ToInt64 implements GenerateAOT.Provider {

            private static final StateField NUMBER0_TO_INT64_NUMBER0_STATE_0_UPDATER = StateField.create(Number0Data.lookup_(), "number0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToInt64#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, NUMBER0_TO_INT64_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_ToInt64_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToInt64#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_ToInt64_UPDATER.subUpdater(9, 1)));
            static final ReferenceField<LongData> LONG_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "long_cache", LongData.class);
            static final ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "number0_cache", Number0Data.class);
            static final ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToInt64#doPrimitive}
             *   2: SpecializationActive {@link ToInt64#doLong}
             *   3: SpecializationExcluded {@link ToInt64#doLong}
             *   4: SpecializationActive {@link ToInt64#doNumber}
             *   5: SpecializationActive {@link ToInt64#doNumber}
             *   6: SpecializationActive {@link ToInt64#doBoolean}
             *   7: SpecializationActive {@link ToInt64#doBoolean}
             *   8: SpecializationActive {@link ToInt64#doFail}
             *   9: InlinedCache
             *        Specialization: {@link ToInt64#doNumber}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private LongData long_cache;
            @UnsafeAccessedField @Child private Number0Data number0_cache;
            @UnsafeAccessedField @Child private Boolean0Data boolean0_cache;

            private ToInt64NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) && ((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b111110110) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doPrimitive(NFIType, long)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doFail(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doPrimitive(NFIType, long)] */ && arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b111110100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToInt64.doFail(NFIType, Object)] */) {
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)] */) {
                            LongData s1_ = this.long_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value)) && (s1_.interop_.fitsInLong(arg1Value))) {
                                    try {
                                        return doLong(arg0Value, arg1Value, s1_.interop_);
                                    } catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        this.long_cache = null;
                                        return executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            Number0Data s2_ = this.number0_cache;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNumber(arg1Value))) {
                                    Node node__ = (s2_);
                                    return ToInt64.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.isNumber(arg1Value))) {
                                        return this.number1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            Boolean0Data s4_ = this.boolean0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(arg1Value)) && (s4_.interop_.isBoolean(arg1Value))) {
                                    return doBoolean(arg0Value, arg1Value, s4_.interop_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__1.isBoolean(arg1Value))) {
                                        return this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToInt64.doFail(NFIType, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return doFail(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    Node node__ = (this);
                    return ToInt64.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                    return doBoolean(arg0Value, arg1Value, interop__1);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b110100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)] && SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doPrimitive(NFIType, long)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    while (true) {
                        int count1_ = 0;
                        LongData s1_ = LONG_CACHE_UPDATER.getVolatile(this);
                        LongData s1_original = s1_;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value)) && (s1_.interop_.fitsInLong(arg1Value))) {
                                break;
                            }
                            count1_++;
                            s1_ = s1_.next_;
                        }
                        if (s1_ == null) {
                            {
                                InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s1_.interop_.accepts(arg1Value));
                                if ((interop__2.fitsInLong(arg1Value)) && count1_ < (3)) {
                                    s1_ = this.insert(new LongData(s1_original));
                                    Objects.requireNonNull(s1_.insert(interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.interop_ = interop__2;
                                    if (!LONG_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.ToInt64.doPrimitive(NFIType, long)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s1_ != null) {
                            try {
                                return doLong(arg0Value, arg1Value, s1_.interop_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.long_cache = null;
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        break;
                    }
                }
                {
                    Node node__ = null;
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                        while (true) {
                            int count2_ = 0;
                            Number0Data s2_ = NUMBER0_CACHE_UPDATER.getVolatile(this);
                            Number0Data s2_original = s2_;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNumber(arg1Value))) {
                                    node__ = (s2_);
                                    break;
                                }
                                count2_++;
                                s2_ = s2_.next_;
                            }
                            if (s2_ == null) {
                                {
                                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                    // assert (s2_.interop_.accepts(arg1Value));
                                    if ((interop__.isNumber(arg1Value)) && count2_ < (3)) {
                                        s2_ = this.insert(new Number0Data(s2_original));
                                        Objects.requireNonNull(s2_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s2_.interop_ = interop__;
                                        node__ = (s2_);
                                        if (!NUMBER0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        this.long_cache = null;
                                        state_0 = state_0 & 0xfffffff9 /* remove SpecializationActive[SimpleTypeCachedState.ToInt64.doPrimitive(NFIType, long)], SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s2_ != null) {
                                return ToInt64.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                            }
                            break;
                        }
                    }
                }
                {
                    Node node__ = null;
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    node__ = (this);
                                    this.long_cache = null;
                                    this.number0_cache = null;
                                    state_0 = state_0 & 0xffffffe9 /* remove SpecializationActive[SimpleTypeCachedState.ToInt64.doPrimitive(NFIType, long)], SpecializationActive[SimpleTypeCachedState.ToInt64.doLong(NFIType, Object, InteropLibrary)], SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    this.state_0_ = state_0;
                                    return ToInt64.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count4_ = 0;
                        Boolean0Data s4_ = BOOLEAN0_CACHE_UPDATER.getVolatile(this);
                        Boolean0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(arg1Value)) && (s4_.interop_.isBoolean(arg1Value))) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            {
                                InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s4_.interop_.accepts(arg1Value));
                                if ((interop__1.isBoolean(arg1Value)) && count4_ < (3)) {
                                    s4_ = this.insert(new Boolean0Data(s4_original));
                                    Objects.requireNonNull(s4_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s4_.interop_ = interop__1;
                                    if (!BOOLEAN0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s4_ != null) {
                            return doBoolean(arg0Value, arg1Value, s4_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__1.isBoolean(arg1Value))) {
                                    this.boolean0_cache = null;
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doBoolean(arg0Value, arg1Value, interop__1);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doFail(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doFail(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doPrimitive(NFIType, long)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToInt64.doFail(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(ToInt64.class)
            @DenyReplace
            private static final class LongData extends Node implements SpecializationDataNode {

                @Child LongData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt64#doLong}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                LongData(LongData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToInt64.class)
            @DenyReplace
            private static final class Number0Data extends Node implements SpecializationDataNode {

                @Child Number0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link ToInt64#doNumber}
                 *        Parameter: {@link InlinedBranchProfile} exception
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int number0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt64#doNumber}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
            @GeneratedBy(ToInt64.class)
            @DenyReplace
            private static final class Boolean0Data extends Node implements SpecializationDataNode {

                @Child Boolean0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToInt64#doBoolean}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToInt64.class)
            @DenyReplace
            private static final class Uncached extends ToInt64 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (long) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value))) {
                        return ToInt64.doNumber(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (this), (InlinedBranchProfile.getUncached()));
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value))) {
                        return doBoolean(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doFail(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(ToFloat.class)
    static final class ToFloatFactory implements NodeFactory<ToFloat> {

        private static final ToFloatFactory TO_FLOAT_FACTORY_INSTANCE = new ToFloatFactory();

        private ToFloatFactory() {
        }

        @Override
        public Class<ToFloat> getNodeClass() {
            return ToFloat.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ToFloat createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ToFloat getUncachedInstance() {
            return ToFloatNodeGen.UNCACHED;
        }

        static NodeFactory<ToFloat> getInstance() {
            return TO_FLOAT_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToFloat create() {
            return new ToFloatNodeGen();
        }

        @NeverDefault
        public static ToFloat getUncached() {
            return ToFloatNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToFloat#doPrimitive(NFIType, float)}
         *     Activation probability: 0.21250
         *     With/without class size: 6/0 bytes
         *   Specialization {@link ToFloat#doPrimitive(NFIType, double)}
         *     Activation probability: 0.18750
         *     With/without class size: 6/0 bytes
         *   Specialization {@link ToFloat#doFloat}
         *     Activation probability: 0.16250
         *     With/without class size: 7/4 bytes
         *   Specialization {@link ToFloat#doNumber}
         *     Activation probability: 0.13750
         *     With/without class size: 7/5 bytes
         *   Specialization {@link ToFloat#doNumber}
         *     Activation probability: 0.11250
         *     With/without class size: 6/1 bytes
         *   Specialization {@link ToFloat#doBoolean}
         *     Activation probability: 0.08750
         *     With/without class size: 6/4 bytes
         *   Specialization {@link ToFloat#doBoolean}
         *     Activation probability: 0.06250
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ToFloat#doFail}
         *     Activation probability: 0.03750
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ToFloat.class)
        @SuppressWarnings("javadoc")
        static final class ToFloatNodeGen extends ToFloat implements GenerateAOT.Provider {

            private static final StateField NUMBER0_TO_FLOAT_NUMBER0_STATE_0_UPDATER = StateField.create(Number0Data.lookup_(), "number0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToFloat#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, NUMBER0_TO_FLOAT_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_ToFloat_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToFloat#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_ToFloat_UPDATER.subUpdater(10, 1)));
            static final ReferenceField<FloatData> FLOAT_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "float_cache", FloatData.class);
            static final ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "number0_cache", Number0Data.class);
            static final ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToFloat#doPrimitive(NFIType, float)}
             *   2: SpecializationActive {@link ToFloat#doFloat}
             *   3: SpecializationExcluded {@link ToFloat#doFloat}
             *   4: SpecializationActive {@link ToFloat#doNumber}
             *   5: SpecializationActive {@link ToFloat#doNumber}
             *   6: SpecializationActive {@link ToFloat#doPrimitive(NFIType, double)}
             *   7: SpecializationActive {@link ToFloat#doBoolean}
             *   8: SpecializationActive {@link ToFloat#doBoolean}
             *   9: SpecializationActive {@link ToFloat#doFail}
             *   10: InlinedCache
             *        Specialization: {@link ToFloat#doNumber}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private FloatData float_cache;
            @UnsafeAccessedField @Child private Number0Data number0_cache;
            @UnsafeAccessedField @Child private Boolean0Data boolean0_cache;

            private ToFloatNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) && ((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b1111110110) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, float)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, double)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doFail(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, float)] */ && arg1Value instanceof Float) {
                        float arg1Value_ = (float) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, double)] */ && arg1Value instanceof Double) {
                        double arg1Value_ = (double) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b1110110100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFloat.doFail(NFIType, Object)] */) {
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] */) {
                            FloatData s2_ = this.float_cache;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.fitsInFloat(arg1Value))) {
                                    try {
                                        return doFloat(arg0Value, arg1Value, s2_.interop_);
                                    } catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        this.float_cache = null;
                                        return executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            Number0Data s3_ = this.number0_cache;
                            while (s3_ != null) {
                                if ((s3_.interop_.accepts(arg1Value)) && (s3_.interop_.isNumber(arg1Value))) {
                                    Node node__ = (s3_);
                                    return ToFloat.doNumber(arg0Value, arg1Value, s3_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s3_ = s3_.next_;
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.isNumber(arg1Value))) {
                                        return this.number1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            Boolean0Data s5_ = this.boolean0_cache;
                            while (s5_ != null) {
                                if ((s5_.interop_.accepts(arg1Value)) && (s5_.interop_.isBoolean(arg1Value))) {
                                    return doBoolean(arg0Value, arg1Value, s5_.interop_);
                                }
                                s5_ = s5_.next_;
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__1.isBoolean(arg1Value))) {
                                        return this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFloat.doFail(NFIType, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return doFail(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    Node node__ = (this);
                    return ToFloat.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                    return doBoolean(arg0Value, arg1Value, interop__1);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b110100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] && SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && arg1Value instanceof Float) {
                    float arg1Value_ = (float) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, float)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                if (((state_0 & 0b110100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] && SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && arg1Value instanceof Double) {
                    double arg1Value_ = (double) arg1Value;
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, double)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    while (true) {
                        int count2_ = 0;
                        FloatData s2_ = FLOAT_CACHE_UPDATER.getVolatile(this);
                        FloatData s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.fitsInFloat(arg1Value))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            {
                                InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s2_.interop_.accepts(arg1Value));
                                if ((interop__2.fitsInFloat(arg1Value)) && count2_ < (3)) {
                                    s2_ = this.insert(new FloatData(s2_original));
                                    Objects.requireNonNull(s2_.insert(interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s2_.interop_ = interop__2;
                                    if (!FLOAT_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = state_0 & 0xffffffbd /* remove SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, float)], SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, double)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s2_ != null) {
                            try {
                                return doFloat(arg0Value, arg1Value, s2_.interop_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.float_cache = null;
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        break;
                    }
                }
                {
                    Node node__ = null;
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                        while (true) {
                            int count3_ = 0;
                            Number0Data s3_ = NUMBER0_CACHE_UPDATER.getVolatile(this);
                            Number0Data s3_original = s3_;
                            while (s3_ != null) {
                                if ((s3_.interop_.accepts(arg1Value)) && (s3_.interop_.isNumber(arg1Value))) {
                                    node__ = (s3_);
                                    break;
                                }
                                count3_++;
                                s3_ = s3_.next_;
                            }
                            if (s3_ == null) {
                                {
                                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                    // assert (s3_.interop_.accepts(arg1Value));
                                    if ((interop__.isNumber(arg1Value)) && count3_ < (3)) {
                                        s3_ = this.insert(new Number0Data(s3_original));
                                        Objects.requireNonNull(s3_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s3_.interop_ = interop__;
                                        node__ = (s3_);
                                        if (!NUMBER0_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                            continue;
                                        }
                                        this.float_cache = null;
                                        state_0 = state_0 & 0xffffffb9 /* remove SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, float)], SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, double)], SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s3_ != null) {
                                return ToFloat.doNumber(arg0Value, arg1Value, s3_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                            }
                            break;
                        }
                    }
                }
                {
                    Node node__ = null;
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    node__ = (this);
                                    this.float_cache = null;
                                    this.number0_cache = null;
                                    state_0 = state_0 & 0xffffffa9 /* remove SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, float)], SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, double)], SpecializationActive[SimpleTypeCachedState.ToFloat.doFloat(NFIType, Object, InteropLibrary)], SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    this.state_0_ = state_0;
                                    return ToFloat.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count5_ = 0;
                        Boolean0Data s5_ = BOOLEAN0_CACHE_UPDATER.getVolatile(this);
                        Boolean0Data s5_original = s5_;
                        while (s5_ != null) {
                            if ((s5_.interop_.accepts(arg1Value)) && (s5_.interop_.isBoolean(arg1Value))) {
                                break;
                            }
                            count5_++;
                            s5_ = s5_.next_;
                        }
                        if (s5_ == null) {
                            {
                                InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s5_.interop_.accepts(arg1Value));
                                if ((interop__1.isBoolean(arg1Value)) && count5_ < (3)) {
                                    s5_ = this.insert(new Boolean0Data(s5_original));
                                    Objects.requireNonNull(s5_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s5_.interop_ = interop__1;
                                    if (!BOOLEAN0_CACHE_UPDATER.compareAndSet(this, s5_original, s5_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s5_ != null) {
                            return doBoolean(arg0Value, arg1Value, s5_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__1.isBoolean(arg1Value))) {
                                    this.boolean0_cache = null;
                                    state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doBoolean(arg0Value, arg1Value, interop__1);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doFail(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doFail(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, float)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doPrimitive(NFIType, double)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[SimpleTypeCachedState.ToFloat.doFail(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(ToFloat.class)
            @DenyReplace
            private static final class FloatData extends Node implements SpecializationDataNode {

                @Child FloatData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToFloat#doFloat}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                FloatData(FloatData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToFloat.class)
            @DenyReplace
            private static final class Number0Data extends Node implements SpecializationDataNode {

                @Child Number0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link ToFloat#doNumber}
                 *        Parameter: {@link InlinedBranchProfile} exception
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int number0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToFloat#doNumber}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
            @GeneratedBy(ToFloat.class)
            @DenyReplace
            private static final class Boolean0Data extends Node implements SpecializationDataNode {

                @Child Boolean0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToFloat#doBoolean}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToFloat.class)
            @DenyReplace
            private static final class Uncached extends ToFloat implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Float) {
                        float arg1Value_ = (float) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (double) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value))) {
                        return ToFloat.doNumber(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (this), (InlinedBranchProfile.getUncached()));
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value))) {
                        return doBoolean(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doFail(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(ToDouble.class)
    static final class ToDoubleFactory implements NodeFactory<ToDouble> {

        private static final ToDoubleFactory TO_DOUBLE_FACTORY_INSTANCE = new ToDoubleFactory();

        private ToDoubleFactory() {
        }

        @Override
        public Class<ToDouble> getNodeClass() {
            return ToDouble.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ToDouble createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ToDouble getUncachedInstance() {
            return ToDoubleNodeGen.UNCACHED;
        }

        static NodeFactory<ToDouble> getInstance() {
            return TO_DOUBLE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToDouble create() {
            return new ToDoubleNodeGen();
        }

        @NeverDefault
        public static ToDouble getUncached() {
            return ToDoubleNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToDouble#doPrimitive}
         *     Activation probability: 0.23929
         *     With/without class size: 6/0 bytes
         *   Specialization {@link ToDouble#doDouble}
         *     Activation probability: 0.20714
         *     With/without class size: 8/4 bytes
         *   Specialization {@link ToDouble#doNumber}
         *     Activation probability: 0.17500
         *     With/without class size: 8/5 bytes
         *   Specialization {@link ToDouble#doNumber}
         *     Activation probability: 0.14286
         *     With/without class size: 6/1 bytes
         *   Specialization {@link ToDouble#doBoolean}
         *     Activation probability: 0.11071
         *     With/without class size: 6/4 bytes
         *   Specialization {@link ToDouble#doBoolean}
         *     Activation probability: 0.07857
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ToDouble#doFail}
         *     Activation probability: 0.04643
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ToDouble.class)
        @SuppressWarnings("javadoc")
        static final class ToDoubleNodeGen extends ToDouble implements GenerateAOT.Provider {

            private static final StateField NUMBER0_TO_DOUBLE_NUMBER0_STATE_0_UPDATER = StateField.create(Number0Data.lookup_(), "number0_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToDouble#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, NUMBER0_TO_DOUBLE_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_0_ToDouble_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToDouble#doNumber}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_ToDouble_UPDATER.subUpdater(9, 1)));
            static final ReferenceField<DoubleData> DOUBLE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "double_cache", DoubleData.class);
            static final ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "number0_cache", Number0Data.class);
            static final ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToDouble#doPrimitive}
             *   2: SpecializationActive {@link ToDouble#doDouble}
             *   3: SpecializationExcluded {@link ToDouble#doDouble}
             *   4: SpecializationActive {@link ToDouble#doNumber}
             *   5: SpecializationActive {@link ToDouble#doNumber}
             *   6: SpecializationActive {@link ToDouble#doBoolean}
             *   7: SpecializationActive {@link ToDouble#doBoolean}
             *   8: SpecializationActive {@link ToDouble#doFail}
             *   9: InlinedCache
             *        Specialization: {@link ToDouble#doNumber}
             *        Parameter: {@link InlinedBranchProfile} exception
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            @UnsafeAccessedField @Child private DoubleData double_cache;
            @UnsafeAccessedField @Child private Number0Data number0_cache;
            @UnsafeAccessedField @Child private Boolean0Data boolean0_cache;

            private ToDoubleNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) && ((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b111110110) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doPrimitive(NFIType, double)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doFail(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doPrimitive(NFIType, double)] */ && arg1Value instanceof Double) {
                        double arg1Value_ = (double) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b111110100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToDouble.doFail(NFIType, Object)] */) {
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)] */) {
                            DoubleData s1_ = this.double_cache;
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value)) && (s1_.interop_.fitsInDouble(arg1Value))) {
                                    try {
                                        return doDouble(arg0Value, arg1Value, s1_.interop_);
                                    } catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        this.double_cache = null;
                                        return executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            Number0Data s2_ = this.number0_cache;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNumber(arg1Value))) {
                                    Node node__ = (s2_);
                                    return ToDouble.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__.isNumber(arg1Value))) {
                                        return this.number1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            Boolean0Data s4_ = this.boolean0_cache;
                            while (s4_ != null) {
                                if ((s4_.interop_.accepts(arg1Value)) && (s4_.interop_.isBoolean(arg1Value))) {
                                    return doBoolean(arg0Value, arg1Value, s4_.interop_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] */) {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                                    if ((interop__1.isBoolean(arg1Value))) {
                                        return this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToDouble.doFail(NFIType, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return doFail(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    Node node__ = (this);
                    return ToDouble.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__1 = (INTEROP_LIBRARY_.getUncached());
                    return doBoolean(arg0Value, arg1Value, interop__1);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b110100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)] && SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && arg1Value instanceof Double) {
                    double arg1Value_ = (double) arg1Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doPrimitive(NFIType, double)] */;
                    this.state_0_ = state_0;
                    return doPrimitive(arg0Value, arg1Value_);
                }
                if (((state_0 & 0b110000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] && SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                    while (true) {
                        int count1_ = 0;
                        DoubleData s1_ = DOUBLE_CACHE_UPDATER.getVolatile(this);
                        DoubleData s1_original = s1_;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value)) && (s1_.interop_.fitsInDouble(arg1Value))) {
                                break;
                            }
                            count1_++;
                            s1_ = s1_.next_;
                        }
                        if (s1_ == null) {
                            {
                                InteropLibrary interop__2 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s1_.interop_.accepts(arg1Value));
                                if ((interop__2.fitsInDouble(arg1Value)) && count1_ < (3)) {
                                    s1_ = this.insert(new DoubleData(s1_original));
                                    Objects.requireNonNull(s1_.insert(interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.interop_ = interop__2;
                                    if (!DOUBLE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.ToDouble.doPrimitive(NFIType, double)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s1_ != null) {
                            try {
                                return doDouble(arg0Value, arg1Value, s1_.interop_);
                            } catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                this.double_cache = null;
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        break;
                    }
                }
                {
                    Node node__ = null;
                    if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */) {
                        while (true) {
                            int count2_ = 0;
                            Number0Data s2_ = NUMBER0_CACHE_UPDATER.getVolatile(this);
                            Number0Data s2_original = s2_;
                            while (s2_ != null) {
                                if ((s2_.interop_.accepts(arg1Value)) && (s2_.interop_.isNumber(arg1Value))) {
                                    node__ = (s2_);
                                    break;
                                }
                                count2_++;
                                s2_ = s2_.next_;
                            }
                            if (s2_ == null) {
                                {
                                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                    // assert (s2_.interop_.accepts(arg1Value));
                                    if ((interop__.isNumber(arg1Value)) && count2_ < (3)) {
                                        s2_ = this.insert(new Number0Data(s2_original));
                                        Objects.requireNonNull(s2_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s2_.interop_ = interop__;
                                        node__ = (s2_);
                                        if (!NUMBER0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                            continue;
                                        }
                                        this.double_cache = null;
                                        state_0 = state_0 & 0xfffffff9 /* remove SpecializationActive[SimpleTypeCachedState.ToDouble.doPrimitive(NFIType, double)], SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s2_ != null) {
                                return ToDouble.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                            }
                            break;
                        }
                    }
                }
                {
                    Node node__ = null;
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    node__ = (this);
                                    this.double_cache = null;
                                    this.number0_cache = null;
                                    state_0 = state_0 & 0xffffffe9 /* remove SpecializationActive[SimpleTypeCachedState.ToDouble.doPrimitive(NFIType, double)], SpecializationActive[SimpleTypeCachedState.ToDouble.doDouble(NFIType, Object, InteropLibrary)], SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doNumber(NFIType, Object, InteropLibrary, Node, InlinedBranchProfile)] */;
                                    this.state_0_ = state_0;
                                    return ToDouble.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count4_ = 0;
                        Boolean0Data s4_ = BOOLEAN0_CACHE_UPDATER.getVolatile(this);
                        Boolean0Data s4_original = s4_;
                        while (s4_ != null) {
                            if ((s4_.interop_.accepts(arg1Value)) && (s4_.interop_.isBoolean(arg1Value))) {
                                break;
                            }
                            count4_++;
                            s4_ = s4_.next_;
                        }
                        if (s4_ == null) {
                            {
                                InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s4_.interop_.accepts(arg1Value));
                                if ((interop__1.isBoolean(arg1Value)) && count4_ < (3)) {
                                    s4_ = this.insert(new Boolean0Data(s4_original));
                                    Objects.requireNonNull(s4_.insert(interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s4_.interop_ = interop__1;
                                    if (!BOOLEAN0_CACHE_UPDATER.compareAndSet(this, s4_original, s4_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s4_ != null) {
                            return doBoolean(arg0Value, arg1Value, s4_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__1 = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__1.isBoolean(arg1Value))) {
                                    this.boolean0_cache = null;
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doBoolean(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doBoolean(arg0Value, arg1Value, interop__1);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doFail(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doFail(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doPrimitive(NFIType, double)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[SimpleTypeCachedState.ToDouble.doFail(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(ToDouble.class)
            @DenyReplace
            private static final class DoubleData extends Node implements SpecializationDataNode {

                @Child DoubleData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToDouble#doDouble}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                DoubleData(DoubleData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToDouble.class)
            @DenyReplace
            private static final class Number0Data extends Node implements SpecializationDataNode {

                @Child Number0Data next_;
                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link ToDouble#doNumber}
                 *        Parameter: {@link InlinedBranchProfile} exception
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int number0_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToDouble#doNumber}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
            @GeneratedBy(ToDouble.class)
            @DenyReplace
            private static final class Boolean0Data extends Node implements SpecializationDataNode {

                @Child Boolean0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToDouble#doBoolean}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToDouble.class)
            @DenyReplace
            private static final class Uncached extends ToDouble implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (double) arg1Value;
                        return doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value))) {
                        return ToDouble.doNumber(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (this), (InlinedBranchProfile.getUncached()));
                    }
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value))) {
                        return doBoolean(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doFail(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(ToFP80.class)
    static final class ToFP80Factory implements NodeFactory<ToFP80> {

        private static final ToFP80Factory TO_FP80FACTORY_INSTANCE = new ToFP80Factory();

        private ToFP80Factory() {
        }

        @Override
        public Class<ToFP80> getNodeClass() {
            return ToFP80.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ToFP80 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ToFP80 getUncachedInstance() {
            return ToFP80NodeGen.UNCACHED;
        }

        static NodeFactory<ToFP80> getInstance() {
            return TO_FP80FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToFP80 create() {
            return new ToFP80NodeGen();
        }

        @NeverDefault
        public static ToFP80 getUncached() {
            return ToFP80NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToFP80#doNumber}
         *     Activation probability: 0.32000
         *     With/without class size: 11/4 bytes
         *   Specialization {@link ToFP80#doNumber}
         *     Activation probability: 0.26000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link ToFP80#doSerializable}
         *     Activation probability: 0.20000
         *     With/without class size: 8/4 bytes
         *   Specialization {@link ToFP80#doSerializable}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ToFP80#doFail}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ToFP80.class)
        @SuppressWarnings("javadoc")
        static final class ToFP80NodeGen extends ToFP80 implements GenerateAOT.Provider {

            static final ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "number0_cache", Number0Data.class);
            static final ReferenceField<Serializable0Data> SERIALIZABLE0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "serializable0_cache", Serializable0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToFP80#doNumber}
             *   2: SpecializationActive {@link ToFP80#doNumber}
             *   3: SpecializationActive {@link ToFP80#doSerializable}
             *   4: SpecializationActive {@link ToFP80#doSerializable}
             *   5: SpecializationActive {@link ToFP80#doFail}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Number0Data number0_cache;
            @UnsafeAccessedField @Child private Serializable0Data serializable0_cache;

            private ToFP80NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] */) && ((SERIALIZABLE_LIBRARY_.getUncached()).isSerializable(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b111110) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFP80.doFail(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] */) {
                        Number0Data s0_ = this.number0_cache;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.isNumber(arg1Value))) {
                                return doNumber(arg0Value, arg1Value, s0_.interop_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    return this.number1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] */) {
                        Serializable0Data s2_ = this.serializable0_cache;
                        while (s2_ != null) {
                            if ((s2_.serialize_.accepts(arg1Value)) && (s2_.serialize_.isSerializable(arg1Value))) {
                                return doSerializable(arg0Value, arg1Value, s2_.serialize_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                SerializableLibrary serialize__ = (SERIALIZABLE_LIBRARY_.getUncached());
                                if ((serialize__.isSerializable(arg1Value))) {
                                    return this.serializable1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP80.doFail(NFIType, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return doFail(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    return doNumber(arg0Value, arg1Value, interop__);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object serializable1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    SerializableLibrary serialize__ = (SERIALIZABLE_LIBRARY_.getUncached());
                    return doSerializable(arg0Value, arg1Value, serialize__);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        Number0Data s0_ = NUMBER0_CACHE_UPDATER.getVolatile(this);
                        Number0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.isNumber(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s0_.interop_.accepts(arg1Value));
                                if ((interop__.isNumber(arg1Value)) && count0_ < (3)) {
                                    s0_ = this.insert(new Number0Data(s0_original));
                                    Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.interop_ = interop__;
                                    if (!NUMBER0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doNumber(arg0Value, arg1Value, s0_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    this.number0_cache = null;
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.ToFP80.doNumber(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doNumber(arg0Value, arg1Value, interop__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Serializable0Data s2_ = SERIALIZABLE0_CACHE_UPDATER.getVolatile(this);
                        Serializable0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.serialize_.accepts(arg1Value)) && (s2_.serialize_.isSerializable(arg1Value))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            {
                                SerializableLibrary serialize__ = this.insert((SERIALIZABLE_LIBRARY_.create(arg1Value)));
                                // assert (s2_.serialize_.accepts(arg1Value));
                                if ((serialize__.isSerializable(arg1Value)) && count2_ < (3)) {
                                    s2_ = this.insert(new Serializable0Data(s2_original));
                                    Objects.requireNonNull(s2_.insert(serialize__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s2_.serialize_ = serialize__;
                                    if (!SERIALIZABLE0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s2_ != null) {
                            return doSerializable(arg0Value, arg1Value, s2_.serialize_);
                        }
                        break;
                    }
                }
                {
                    SerializableLibrary serialize__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                serialize__ = (SERIALIZABLE_LIBRARY_.getUncached());
                                if ((serialize__.isSerializable(arg1Value))) {
                                    this.serializable0_cache = null;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doSerializable(arg0Value, arg1Value, serialize__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToFP80.doFail(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doFail(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    Serializable0Data s2_ = this.insert(new Serializable0Data(this.serializable0_cache));
                    SerializableLibrary serialize__ = s2_.insert((SERIALIZABLE_LIBRARY_.createDispatched(2)));
                    Objects.requireNonNull(serialize__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s2_.serialize_ = serialize__;
                    VarHandle.storeStoreFence();
                    this.serializable0_cache = s2_;
                    if (s2_.serialize_ instanceof GenerateAOT.Provider) {
                        assert NodeUtil.assertRecursion(s2_.serialize_, 1);
                        ((GenerateAOT.Provider) s2_.serialize_).prepareForAOT(language, root);
                    }
                    this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.ToFP80.doSerializable(NFIType, Object, SerializableLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToFP80.doFail(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.serializable0_cache = null;
            }

            @GeneratedBy(ToFP80.class)
            @DenyReplace
            private static final class Number0Data extends Node implements SpecializationDataNode {

                @Child Number0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToFP80#doNumber}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToFP80.class)
            @DenyReplace
            private static final class Serializable0Data extends Node implements SpecializationDataNode {

                @Child Serializable0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToFP80#doSerializable}
                 *   Parameter: {@link SerializableLibrary} serialize</pre> */
                @Child SerializableLibrary serialize_;

                Serializable0Data(Serializable0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToFP80.class)
            @DenyReplace
            private static final class Uncached extends ToFP80 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value))) {
                        return doNumber(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    if (((SERIALIZABLE_LIBRARY_.getUncached(arg1Value)).isSerializable(arg1Value))) {
                        return doSerializable(arg0Value, arg1Value, (SERIALIZABLE_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doFail(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(FromFP80.class)
    static final class FromFP80Factory implements NodeFactory<FromFP80> {

        private static final FromFP80Factory FROM_FP80FACTORY_INSTANCE = new FromFP80Factory();

        private FromFP80Factory() {
        }

        @Override
        public Class<FromFP80> getNodeClass() {
            return FromFP80.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FromFP80 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public FromFP80 getUncachedInstance() {
            return FromFP80NodeGen.UNCACHED;
        }

        static NodeFactory<FromFP80> getInstance() {
            return FROM_FP80FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FromFP80 create() {
            return new FromFP80NodeGen();
        }

        @NeverDefault
        public static FromFP80 getUncached() {
            return FromFP80NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FromFP80#doBuffer}
         *     Activation probability: 0.48333
         *     With/without class size: 13/4 bytes
         *   Specialization {@link FromFP80#doBuffer}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link FromFP80#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(FromFP80.class)
        @SuppressWarnings("javadoc")
        static final class FromFP80NodeGen extends FromFP80 implements GenerateAOT.Provider {

            static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link FromFP80#doBuffer}
             *   2: SpecializationActive {@link FromFP80#doBuffer}
             *   3: SpecializationActive {@link FromFP80#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;

            private FromFP80NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).hasBufferElements(arg1Value)) && (!((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)))) {
                    return false;
                }
                return true;
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b1110) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.FromFP80.doOther(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] */) {
                        Buffer0Data s0_ = this.buffer0_cache;
                        if (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.hasBufferElements(arg1Value)) && (!(s0_.interop_.isNumber(arg1Value)))) {
                                return doBuffer(arg0Value, arg1Value, s0_.interop_);
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.hasBufferElements(arg1Value)) && (!(interop__.isNumber(arg1Value)))) {
                                    return this.buffer1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP80.doOther(NFIType, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object buffer1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    return doBuffer(arg0Value, arg1Value, interop__);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        Buffer0Data s0_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                        Buffer0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.hasBufferElements(arg1Value)) && (!(s0_.interop_.isNumber(arg1Value)))) {
                                break;
                            }
                            count0_++;
                            s0_ = null;
                            break;
                        }
                        if (s0_ == null && count0_ < 1) {
                            {
                                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s0_.interop_.accepts(arg1Value));
                                if ((interop__.hasBufferElements(arg1Value)) && (!(interop__.isNumber(arg1Value)))) {
                                    s0_ = this.insert(new Buffer0Data());
                                    Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.interop_ = interop__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doBuffer(arg0Value, arg1Value, s0_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.hasBufferElements(arg1Value)) && (!(interop__.isNumber(arg1Value)))) {
                                    this.buffer0_cache = null;
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.FromFP80.doBuffer(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doBuffer(arg0Value, arg1Value, interop__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.FromFP80.doOther(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doOther(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.FromFP80.doOther(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(FromFP80.class)
            @DenyReplace
            private static final class Buffer0Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FromFP80#doBuffer}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Buffer0Data() {
                }

            }
            @GeneratedBy(FromFP80.class)
            @DenyReplace
            private static final class Uncached extends FromFP80 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).hasBufferElements(arg1Value)) && (!((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)))) {
                        return doBuffer(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doOther(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(ToFP128.class)
    static final class ToFP128Factory implements NodeFactory<ToFP128> {

        private static final ToFP128Factory TO_FP128FACTORY_INSTANCE = new ToFP128Factory();

        private ToFP128Factory() {
        }

        @Override
        public Class<ToFP128> getNodeClass() {
            return ToFP128.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ToFP128 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public ToFP128 getUncachedInstance() {
            return ToFP128NodeGen.UNCACHED;
        }

        static NodeFactory<ToFP128> getInstance() {
            return TO_FP128FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToFP128 create() {
            return new ToFP128NodeGen();
        }

        @NeverDefault
        public static ToFP128 getUncached() {
            return ToFP128NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToFP128#doNumber}
         *     Activation probability: 0.32000
         *     With/without class size: 11/4 bytes
         *   Specialization {@link ToFP128#doNumber}
         *     Activation probability: 0.26000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link ToFP128#doSerializable}
         *     Activation probability: 0.20000
         *     With/without class size: 8/4 bytes
         *   Specialization {@link ToFP128#doSerializable}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ToFP128#doFail}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ToFP128.class)
        @SuppressWarnings("javadoc")
        static final class ToFP128NodeGen extends ToFP128 implements GenerateAOT.Provider {

            static final ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "number0_cache", Number0Data.class);
            static final ReferenceField<Serializable0Data> SERIALIZABLE0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "serializable0_cache", Serializable0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link ToFP128#doNumber}
             *   2: SpecializationActive {@link ToFP128#doNumber}
             *   3: SpecializationActive {@link ToFP128#doSerializable}
             *   4: SpecializationActive {@link ToFP128#doSerializable}
             *   5: SpecializationActive {@link ToFP128#doFail}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Number0Data number0_cache;
            @UnsafeAccessedField @Child private Serializable0Data serializable0_cache;

            private ToFP128NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value))) {
                    return false;
                }
                if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] */) && ((SERIALIZABLE_LIBRARY_.getUncached()).isSerializable(arg1Value))) {
                    return false;
                }
                return true;
            }

            @ExplodeLoop
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b111110) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] || SpecializationActive[SimpleTypeCachedState.ToFP128.doFail(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] */) {
                        Number0Data s0_ = this.number0_cache;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.isNumber(arg1Value))) {
                                return doNumber(arg0Value, arg1Value, s0_.interop_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    return this.number1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] */) {
                        Serializable0Data s2_ = this.serializable0_cache;
                        while (s2_ != null) {
                            if ((s2_.serialize_.accepts(arg1Value)) && (s2_.serialize_.isSerializable(arg1Value))) {
                                return doSerializable(arg0Value, arg1Value, s2_.serialize_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                SerializableLibrary serialize__ = (SERIALIZABLE_LIBRARY_.getUncached());
                                if ((serialize__.isSerializable(arg1Value))) {
                                    return this.serializable1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[SimpleTypeCachedState.ToFP128.doFail(NFIType, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return doFail(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    return doNumber(arg0Value, arg1Value, interop__);
                }
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object serializable1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    SerializableLibrary serialize__ = (SERIALIZABLE_LIBRARY_.getUncached());
                    return doSerializable(arg0Value, arg1Value, serialize__);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        Number0Data s0_ = NUMBER0_CACHE_UPDATER.getVolatile(this);
                        Number0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.isNumber(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s0_.interop_.accepts(arg1Value));
                                if ((interop__.isNumber(arg1Value)) && count0_ < (3)) {
                                    s0_ = this.insert(new Number0Data(s0_original));
                                    Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.interop_ = interop__;
                                    if (!NUMBER0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doNumber(arg0Value, arg1Value, s0_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.isNumber(arg1Value))) {
                                    this.number0_cache = null;
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.ToFP128.doNumber(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doNumber(arg0Value, arg1Value, interop__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        Serializable0Data s2_ = SERIALIZABLE0_CACHE_UPDATER.getVolatile(this);
                        Serializable0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.serialize_.accepts(arg1Value)) && (s2_.serialize_.isSerializable(arg1Value))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            {
                                SerializableLibrary serialize__ = this.insert((SERIALIZABLE_LIBRARY_.create(arg1Value)));
                                // assert (s2_.serialize_.accepts(arg1Value));
                                if ((serialize__.isSerializable(arg1Value)) && count2_ < (3)) {
                                    s2_ = this.insert(new Serializable0Data(s2_original));
                                    Objects.requireNonNull(s2_.insert(serialize__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s2_.serialize_ = serialize__;
                                    if (!SERIALIZABLE0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s2_ != null) {
                            return doSerializable(arg0Value, arg1Value, s2_.serialize_);
                        }
                        break;
                    }
                }
                {
                    SerializableLibrary serialize__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                serialize__ = (SERIALIZABLE_LIBRARY_.getUncached());
                                if ((serialize__.isSerializable(arg1Value))) {
                                    this.serializable0_cache = null;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doSerializable(arg0Value, arg1Value, serialize__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToFP128.doFail(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doFail(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    Serializable0Data s2_ = this.insert(new Serializable0Data(this.serializable0_cache));
                    SerializableLibrary serialize__ = s2_.insert((SERIALIZABLE_LIBRARY_.createDispatched(2)));
                    Objects.requireNonNull(serialize__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s2_.serialize_ = serialize__;
                    VarHandle.storeStoreFence();
                    this.serializable0_cache = s2_;
                    if (s2_.serialize_ instanceof GenerateAOT.Provider) {
                        assert NodeUtil.assertRecursion(s2_.serialize_, 1);
                        ((GenerateAOT.Provider) s2_.serialize_).prepareForAOT(language, root);
                    }
                    this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.ToFP128.doSerializable(NFIType, Object, SerializableLibrary)] */;
                }
                {
                    this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[SimpleTypeCachedState.ToFP128.doFail(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
                this.serializable0_cache = null;
            }

            @GeneratedBy(ToFP128.class)
            @DenyReplace
            private static final class Number0Data extends Node implements SpecializationDataNode {

                @Child Number0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToFP128#doNumber}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToFP128.class)
            @DenyReplace
            private static final class Serializable0Data extends Node implements SpecializationDataNode {

                @Child Serializable0Data next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ToFP128#doSerializable}
                 *   Parameter: {@link SerializableLibrary} serialize</pre> */
                @Child SerializableLibrary serialize_;

                Serializable0Data(Serializable0Data next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(ToFP128.class)
            @DenyReplace
            private static final class Uncached extends ToFP128 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value))) {
                        return doNumber(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    if (((SERIALIZABLE_LIBRARY_.getUncached(arg1Value)).isSerializable(arg1Value))) {
                        return doSerializable(arg0Value, arg1Value, (SERIALIZABLE_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doFail(arg0Value, arg1Value);
                }

            }
        }
    }
    @GeneratedBy(FromFP128.class)
    static final class FromFP128Factory implements NodeFactory<FromFP128> {

        private static final FromFP128Factory FROM_FP128FACTORY_INSTANCE = new FromFP128Factory();

        private FromFP128Factory() {
        }

        @Override
        public Class<FromFP128> getNodeClass() {
            return FromFP128.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FromFP128 createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public FromFP128 getUncachedInstance() {
            return FromFP128NodeGen.UNCACHED;
        }

        static NodeFactory<FromFP128> getInstance() {
            return FROM_FP128FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FromFP128 create() {
            return new FromFP128NodeGen();
        }

        @NeverDefault
        public static FromFP128 getUncached() {
            return FromFP128NodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FromFP128#doBuffer}
         *     Activation probability: 0.48333
         *     With/without class size: 13/4 bytes
         *   Specialization {@link FromFP128#doBuffer}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link FromFP128#doOther}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(FromFP128.class)
        @SuppressWarnings("javadoc")
        static final class FromFP128NodeGen extends FromFP128 implements GenerateAOT.Provider {

            static final ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "buffer0_cache", Buffer0Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: AOTPrepared
             *   1: SpecializationActive {@link FromFP128#doBuffer}
             *   2: SpecializationActive {@link FromFP128#doBuffer}
             *   3: SpecializationActive {@link FromFP128#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Buffer0Data buffer0_cache;

            private FromFP128NodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] */) && ((INTEROP_LIBRARY_.getUncached()).hasBufferElements(arg1Value)) && (!((INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)))) {
                    return false;
                }
                return true;
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    return executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0b1110) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] || SpecializationActive[SimpleTypeCachedState.FromFP128.doOther(NFIType, Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] */) {
                        Buffer0Data s0_ = this.buffer0_cache;
                        if (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.hasBufferElements(arg1Value)) && (!(s0_.interop_.isNumber(arg1Value)))) {
                                return doBuffer(arg0Value, arg1Value, s0_.interop_);
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.hasBufferElements(arg1Value)) && (!(interop__.isNumber(arg1Value)))) {
                                    return this.buffer1Boundary(state_0, arg0Value, arg1Value);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SimpleTypeCachedState.FromFP128.doOther(NFIType, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object buffer1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached());
                    return doBuffer(arg0Value, arg1Value, interop__);
                }
            }

            @SuppressWarnings("unused")
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] */) {
                    while (true) {
                        int count0_ = 0;
                        Buffer0Data s0_ = BUFFER0_CACHE_UPDATER.getVolatile(this);
                        Buffer0Data s0_original = s0_;
                        while (s0_ != null) {
                            if ((s0_.interop_.accepts(arg1Value)) && (s0_.interop_.hasBufferElements(arg1Value)) && (!(s0_.interop_.isNumber(arg1Value)))) {
                                break;
                            }
                            count0_++;
                            s0_ = null;
                            break;
                        }
                        if (s0_ == null && count0_ < 1) {
                            {
                                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.create(arg1Value)));
                                // assert (s0_.interop_.accepts(arg1Value));
                                if ((interop__.hasBufferElements(arg1Value)) && (!(interop__.isNumber(arg1Value)))) {
                                    s0_ = this.insert(new Buffer0Data());
                                    Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s0_.interop_ = interop__;
                                    if (!BUFFER0_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                            }
                        }
                        if (s0_ != null) {
                            return doBuffer(arg0Value, arg1Value, s0_.interop_);
                        }
                        break;
                    }
                }
                {
                    InteropLibrary interop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                interop__ = (INTEROP_LIBRARY_.getUncached());
                                if ((interop__.hasBufferElements(arg1Value)) && (!(interop__.isNumber(arg1Value)))) {
                                    this.buffer0_cache = null;
                                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] */;
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[SimpleTypeCachedState.FromFP128.doBuffer(NFIType, Object, InteropLibrary)] */;
                                    this.state_0_ = state_0;
                                    return doBuffer(arg0Value, arg1Value, interop__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.FromFP128.doOther(NFIType, Object)] */;
                this.state_0_ = state_0;
                return doOther(arg0Value, arg1Value);
            }

            @Override
            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
                if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                    return;
                }
                {
                    this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[SimpleTypeCachedState.FromFP128.doOther(NFIType, Object)] */;
                }
                int state_0 = this.state_0_;
                state_0 = state_0 | 0b1 /* add AOTPrepared */;
                this.state_0_ = state_0;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(FromFP128.class)
            @DenyReplace
            private static final class Buffer0Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FromFP128#doBuffer}
                 *   Parameter: {@link InteropLibrary} interop</pre> */
                @Child InteropLibrary interop_;

                Buffer0Data() {
                }

            }
            @GeneratedBy(FromFP128.class)
            @DenyReplace
            private static final class Uncached extends FromFP128 implements UnadoptableNode {

                @TruffleBoundary
                @Override
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((INTEROP_LIBRARY_.getUncached(arg1Value)).hasBufferElements(arg1Value)) && (!((INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)))) {
                        return doBuffer(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return doOther(arg0Value, arg1Value);
                }

            }
        }
    }
}
