/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.FrameWithoutBoxing;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.runtime.BytecodeOSRRootNode;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class BytecodeOSRMetadata {
    public static final BytecodeOSRMetadata DISABLED = new BytecodeOSRMetadata(null, Integer.MAX_VALUE, 0);
    public static final int OSR_POLL_INTERVAL = 1024;
    private static final byte FRESH_STAGE = 0;
    private static final byte HOT_STAGE = 1;
    private static final byte DISABLED_STAGE = 99;
    private final BytecodeOSRNode osrNode;
    private static final Object PLACEHOLDER = new Object();
    private static final Object DISABLE = new Object();
    private final AtomicReference<Object> currentlyCompiling = new AtomicReference();
    private final ReAttemptsCounter compilationReAttempts = new ReAttemptsCounter();
    @CompilerDirectives.CompilationFinal
    private volatile LazyState lazyState;
    private final int osrThreshold;
    private final int secondaryOsrThreshold;
    private final int maxCompilationReAttempts;
    private int backEdgeCount;
    private byte stage = 0;

    private OptimizedCallTarget getCurrentlyCompiling() {
        Object value = this.currentlyCompiling.get();
        if (value instanceof OptimizedCallTarget) {
            return (OptimizedCallTarget)value;
        }
        return null;
    }

    LazyState getLazyState() {
        LazyState currentLazyState = this.lazyState;
        if (currentLazyState == null) {
            return this.getLazyStateBoundary();
        }
        return currentLazyState;
    }

    @CompilerDirectives.TruffleBoundary
    private LazyState getLazyStateBoundary() {
        return (LazyState)((Node)this.osrNode).atomic(() -> {
            LazyState lockedLazyState = this.lazyState;
            if (lockedLazyState == null) {
                lockedLazyState = this.lazyState = new LazyState();
            }
            return lockedLazyState;
        });
    }

    private void updateFrameSlots(FrameWithoutBoxing frame, OsrEntryDescription osrEntry) {
        CompilerAsserts.neverPartOfCompilation();
        LazyState state = this.getLazyState();
        ((Node)this.osrNode).atomic(() -> {
            if (state.frameDescriptor == null) {
                FrameDescriptor frameDescriptor;
                state.frameDescriptor = frameDescriptor = frame.getFrameDescriptor();
            }
            if (osrEntry != null) {
                osrEntry.indexedFrameTags = new byte[state.frameDescriptor.getNumberOfSlots()];
                for (int i = 0; i < osrEntry.indexedFrameTags.length; ++i) {
                    osrEntry.indexedFrameTags[i] = frame.getTag(i);
                }
            }
        });
    }

    BytecodeOSRMetadata(BytecodeOSRNode osrNode, int osrThreshold, int maxCompilationReAttempts) {
        this.osrNode = osrNode;
        this.osrThreshold = osrThreshold;
        this.secondaryOsrThreshold = Math.max(osrThreshold << 1, osrThreshold);
        this.maxCompilationReAttempts = maxCompilationReAttempts;
        this.backEdgeCount = 0;
        if (osrNode == null) {
            this.stage = (byte)99;
        }
    }

    Object tryOSR(int target, Object interpreterState, Runnable beforeTransfer, VirtualFrame parentFrame) {
        if (this.isDisabled()) {
            return null;
        }
        LazyState state = this.getLazyState();
        assert (state.frameDescriptor == null || state.frameDescriptor == parentFrame.getFrameDescriptor());
        OptimizedCallTarget callTarget = state.compilationMap.get(target);
        if (callTarget == null) {
            callTarget = (OptimizedCallTarget)((Node)this.osrNode).atomic(() -> {
                OptimizedCallTarget lockedTarget = state.compilationMap.get(target);
                if (lockedTarget == null) {
                    OsrEntryDescription entryDescription = new OsrEntryDescription();
                    lockedTarget = this.createOSRTarget(target, interpreterState, parentFrame.getFrameDescriptor(), entryDescription);
                    state.push(target, lockedTarget, entryDescription);
                    if (this.stage == 0) {
                        this.requestOSRCompilation(target, lockedTarget, (FrameWithoutBoxing)parentFrame);
                        this.stage = 1;
                    }
                }
                return lockedTarget;
            });
        }
        if (callTarget.isCompiling()) {
            return null;
        }
        boolean valid = callTarget.isValid();
        if (!valid) {
            if (callTarget.isCompilationFailed()) {
                this.markOSRDisabled();
            } else if (this.backEdgeCount >= this.secondaryOsrThreshold) {
                this.requestOSRCompilation(target, callTarget, (FrameWithoutBoxing)parentFrame);
                valid = callTarget.isValid();
            }
        }
        if (valid) {
            if (beforeTransfer != null) {
                beforeTransfer.run();
            }
            return callTarget.callOSR(this.osrNode.storeParentFrameInArguments(parentFrame));
        }
        return null;
    }

    public boolean incrementAndPoll() {
        int newBackEdgeCount;
        return (newBackEdgeCount = ++this.backEdgeCount) >= this.osrThreshold && (newBackEdgeCount & 0x3FF) == 0;
    }

    public boolean isDisabled() {
        return this.stage == 99;
    }

    public void forceDisable() {
        this.markOSRDisabled();
    }

    private void resetCounter() {
        this.backEdgeCount = this.osrThreshold;
    }

    private OptimizedCallTarget createOSRTarget(int target, Object interpreterState, FrameDescriptor frameDescriptor, Object frameEntryState) {
        TruffleLanguage language = OptimizedRuntimeAccessor.NODES.getLanguage(((Node)this.osrNode).getRootNode());
        return (OptimizedCallTarget)new BytecodeOSRRootNode(language, frameDescriptor, this.osrNode, target, interpreterState, frameEntryState).getCallTarget();
    }

    private void requestOSRCompilation(int target, OptimizedCallTarget callTarget, FrameWithoutBoxing frame) {
        OptimizedCallTarget previousCompilation = this.getCurrentlyCompiling();
        if (previousCompilation != null && !previousCompilation.isSubmittedForCompilation()) {
            this.currentlyCompiling.compareAndSet(previousCompilation, null);
        }
        if (!this.currentlyCompiling.compareAndSet(null, PLACEHOLDER)) {
            this.resetCounter();
            return;
        }
        this.compilationReAttempts.inc(target);
        if (this.compilationReAttempts.total() > this.maxCompilationReAttempts) {
            this.markOSRDisabled();
            if (callTarget.getOptionValue(OptimizedRuntimeOptions.ThrowOnMaxOSRCompilationReAttemptsReached).booleanValue()) {
                throw new AssertionError((Object)("Max OSR compilation re-attempts reached for " + this.osrNode));
            }
            return;
        }
        try {
            this.osrNode.prepareOSR(target);
            this.updateFrameSlots(frame, BytecodeOSRMetadata.getEntryCacheFromCallTarget(callTarget));
            callTarget.compile(true);
        }
        catch (Throwable e) {
            this.markOSRDisabled();
            throw e;
        }
        if (callTarget.isCompilationFailed()) {
            this.markOSRDisabled();
            return;
        }
        this.resetCounter();
        boolean submitted = this.currentlyCompiling.compareAndSet(PLACEHOLDER, callTarget);
        assert (submitted || this.currentlyCompiling.get() == DISABLE);
    }

    private static OsrEntryDescription getEntryCacheFromCallTarget(OptimizedCallTarget callTarget) {
        assert (callTarget.getRootNode() instanceof BytecodeOSRRootNode);
        return (OsrEntryDescription)((BytecodeOSRRootNode)callTarget.getRootNode()).getEntryTagsCache();
    }

    public void transferFrame(FrameWithoutBoxing source, FrameWithoutBoxing target, int bytecodeTarget, Object targetMetadata) {
        LazyState state = this.getLazyState();
        CompilerAsserts.partialEvaluationConstant((Object)state);
        BytecodeOSRMetadata.validateDescriptors(source, target, state);
        if (targetMetadata == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Transferring frame for OSR from an uninitialized bytecode target.");
        }
        if (!(targetMetadata instanceof OsrEntryDescription)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Wrong usage of targetMetadata during OSR frame transfer.");
        }
        assert (targetMetadata == state.get(bytecodeTarget));
        OsrEntryDescription description = (OsrEntryDescription)targetMetadata;
        CompilerAsserts.partialEvaluationConstant((Object)description);
        OptimizedRuntimeAccessor.ACCESSOR.startOSRFrameTransfer(target);
        BytecodeOSRMetadata.transferLoop(description.indexedFrameTags.length, source, target, description.indexedFrameTags);
        BytecodeOSRMetadata.transferAuxiliarySlots(source, target, state);
    }

    public void restoreFrame(FrameWithoutBoxing source, FrameWithoutBoxing target) {
        BytecodeOSRMetadata.forceStateSplit();
        CompilerDirectives.transferToInterpreter();
        LazyState state = this.getLazyState();
        CompilerAsserts.partialEvaluationConstant((Object)state);
        BytecodeOSRMetadata.validateDescriptors(source, target, state);
        BytecodeOSRMetadata.transferLoop(state.frameDescriptor.getNumberOfSlots(), source, target, null);
        BytecodeOSRMetadata.transferAuxiliarySlots(source, target, state);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=false)
    private static void forceStateSplit() {
    }

    private static void validateDescriptors(FrameWithoutBoxing source, FrameWithoutBoxing target, LazyState state) {
        if (source.getFrameDescriptor() != state.frameDescriptor) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Source frame descriptor is different from the descriptor used for compilation.");
        }
        if (target.getFrameDescriptor() != state.frameDescriptor) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Target frame descriptor is different from the descriptor used for compilation.");
        }
    }

    @ExplodeLoop
    private static void transferLoop(int length, FrameWithoutBoxing source, FrameWithoutBoxing target, byte[] expectedTags) {
        int i = 0;
        while (i < length) {
            boolean incompatibleTags;
            byte actualTag = source.getTag(i);
            byte expectedTag = expectedTags == null ? actualTag : expectedTags[i];
            boolean bl = incompatibleTags = expectedTag != actualTag;
            if (incompatibleTags) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                expectedTags[i] = actualTag;
                continue;
            }
            BytecodeOSRMetadata.transferIndexedFrameSlot(source, target, i, expectedTag);
            ++i;
        }
    }

    @ExplodeLoop
    private static void transferAuxiliarySlots(FrameWithoutBoxing source, FrameWithoutBoxing target, LazyState state) {
        for (int auxSlot = 0; auxSlot < state.frameDescriptor.getNumberOfAuxiliarySlots(); ++auxSlot) {
            target.setAuxiliarySlot(auxSlot, source.getAuxiliarySlot(auxSlot));
        }
    }

    private static void transferIndexedFrameSlot(FrameWithoutBoxing source, FrameWithoutBoxing target, int slot, byte expectedTag) {
        try {
            switch (expectedTag) {
                case 5: {
                    target.setBoolean(slot, source.getBoolean(slot));
                    break;
                }
                case 6: {
                    target.setByte(slot, source.getByte(slot));
                    break;
                }
                case 3: {
                    target.setDouble(slot, source.getDouble(slot));
                    break;
                }
                case 4: {
                    target.setFloat(slot, source.getFloat(slot));
                    break;
                }
                case 2: {
                    target.setInt(slot, source.getInt(slot));
                    break;
                }
                case 1: {
                    target.setLong(slot, source.getLong(slot));
                    break;
                }
                case 0: {
                    target.setObject(slot, source.getObject(slot));
                    break;
                }
                case 8: {
                    OptimizedRuntimeAccessor.ACCESSOR.transferOSRFrameStaticSlot(source, target, slot);
                    break;
                }
                case 7: {
                    target.clear(slot);
                }
            }
        }
        catch (FrameSlotTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new AssertionError((Object)"Cannot transfer source frame.");
        }
    }

    void nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        LazyState state = this.lazyState;
        if (state != null) {
            ((Node)this.osrNode).atomic(() -> {
                for (OptimizedCallTarget callTarget : state.compilationMap.values()) {
                    if (callTarget.isCompilationFailed()) {
                        this.markOSRDisabled();
                    }
                    callTarget.nodeReplaced(oldNode, newNode, reason);
                }
            });
        }
    }

    private void markOSRDisabled() {
        ((Node)this.osrNode).atomic(() -> {
            this.currentlyCompiling.set(DISABLE);
            this.stage = (byte)99;
            LazyState state = this.lazyState;
            if (state != null) {
                state.doClear();
            }
            this.compilationReAttempts.clear();
        });
    }

    public Map<Integer, OptimizedCallTarget> getOSRCompilations() {
        return this.getLazyState().compilationMap;
    }

    public int getBackEdgeCount() {
        return this.backEdgeCount;
    }

    static final class LazyState
    extends FinalCompilationListMap {
        private final Map<Integer, OptimizedCallTarget> compilationMap = new ConcurrentHashMap<Integer, OptimizedCallTarget>();
        @CompilerDirectives.CompilationFinal
        private FrameDescriptor frameDescriptor = null;

        LazyState() {
        }

        private void push(int target, OptimizedCallTarget callTarget, OsrEntryDescription entry) {
            this.compilationMap.put(target, callTarget);
            this.put(target, entry);
        }

        private void doClear() {
            this.compilationMap.clear();
        }
    }

    static final class OsrEntryDescription {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private byte[] indexedFrameTags;

        OsrEntryDescription() {
        }
    }

    private static final class ReAttemptsCounter {
        private final Set<Integer> knownTargets = new HashSet<Integer>(1);
        private int total = 0;

        private ReAttemptsCounter() {
        }

        public void inc(int target) {
            if (this.knownTargets.contains(target)) {
                ++this.total;
            } else {
                this.knownTargets.add(target);
            }
        }

        public int total() {
            return this.total;
        }

        public void clear() {
            this.knownTargets.clear();
        }
    }

    private static abstract class FinalCompilationListMap {
        @CompilerDirectives.CompilationFinal
        volatile Cell head = null;

        private FinalCompilationListMap() {
        }

        @ExplodeLoop
        public final OsrEntryDescription get(int target) {
            Cell cur = this.head;
            while (cur != null) {
                if (cur.target == target) {
                    return cur.entry;
                }
                cur = cur.next;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void put(int target, OsrEntryDescription value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            FinalCompilationListMap finalCompilationListMap = this;
            synchronized (finalCompilationListMap) {
                assert (this.get(target) == null);
                this.head = new Cell(target, value, this.head);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            FinalCompilationListMap finalCompilationListMap = this;
            synchronized (finalCompilationListMap) {
                this.head = null;
            }
        }

        private static final class Cell {
            final Cell next;
            final int target;
            final OsrEntryDescription entry;

            Cell(int target, OsrEntryDescription entry, Cell next) {
                this.next = next;
                this.target = target;
                this.entry = entry;
            }
        }
    }
}

