/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.FrameWithoutBoxing;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.runtime.BackgroundCompileQueue;
import com.oracle.truffle.runtime.BaseOSRRootNode;
import com.oracle.truffle.runtime.BytecodeOSRMetadata;
import com.oracle.truffle.runtime.EngineCacheSupport;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedAssumption;
import com.oracle.truffle.runtime.OptimizedBlockNode;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedOSRLoopNode;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.TruffleSplittingStrategy;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.SandboxPolicy;

final class OptimizedRuntimeSupport
extends Accessor.RuntimeSupport {
    static final String CALL_INLINED_METHOD_NAME = "callInlined";

    OptimizedRuntimeSupport(Object permission) {
        super(permission);
    }

    public RootCallTarget newCallTarget(CallTarget source, RootNode rootNode) {
        assert (OptimizedRuntimeAccessor.NODES.getCallTargetWithoutInitialization(rootNode) == null) : "CallTarget for root node already initialized.";
        CompilerAsserts.neverPartOfCompilation();
        return OptimizedTruffleRuntime.getRuntime().createOptimizedCallTarget((OptimizedCallTarget)source, rootNode);
    }

    public boolean isLoaded(CallTarget callTarget) {
        return ((OptimizedCallTarget)callTarget).isLoaded();
    }

    public void notifyOnLoad(CallTarget callTarget) {
        CompilerAsserts.neverPartOfCompilation();
        OptimizedCallTarget target = (OptimizedCallTarget)callTarget;
        OptimizedRuntimeAccessor.INSTRUMENT.onLoad(target.getRootNode());
        if (target.engine.compileAOTOnCreate && target.prepareForAOT()) {
            target.compile(true);
        }
        TruffleSplittingStrategy.newTargetCreated(target);
        target.setLoaded();
    }

    @ExplodeLoop
    public void onLoopCount(Node source, int count) {
        RootCallTarget target;
        Node parentNode;
        CompilerAsserts.partialEvaluationConstant((Object)source);
        Node node = parentNode = source != null ? source.getParent() : null;
        for (Node node2 = source; node2 != null; node2 = node2.getParent()) {
            if (node2 instanceof OptimizedOSRLoopNode) {
                ((OptimizedOSRLoopNode)node2).reportChildLoopCount(count);
            }
            parentNode = node2;
        }
        if (parentNode instanceof RootNode && (target = ((RootNode)parentNode).getCallTarget()) instanceof OptimizedCallTarget) {
            ((OptimizedCallTarget)target).onLoopCount(count);
        }
    }

    public boolean pollBytecodeOSRBackEdge(BytecodeOSRNode osrNode) {
        CompilerAsserts.neverPartOfCompilation();
        TruffleSafepoint.poll((Node)((Node)osrNode));
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        if (osrMetadata == null) {
            osrMetadata = OptimizedRuntimeSupport.initializeBytecodeOSRMetadata(osrNode);
        }
        if (osrMetadata.isDisabled()) {
            return false;
        }
        return osrMetadata.incrementAndPoll();
    }

    private static BytecodeOSRMetadata initializeBytecodeOSRMetadata(BytecodeOSRNode osrNode) {
        Node node = (Node)osrNode;
        return (BytecodeOSRMetadata)node.atomic(() -> {
            BytecodeOSRMetadata metadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
            if (metadata == null) {
                OptimizedCallTarget callTarget = (OptimizedCallTarget)node.getRootNode().getCallTarget();
                metadata = callTarget.engine.compilation && callTarget.getOptionValue(OptimizedRuntimeOptions.OSR) != false ? new BytecodeOSRMetadata(osrNode, callTarget.getOptionValue(OptimizedRuntimeOptions.OSRCompilationThreshold), callTarget.getOptionValue(OptimizedRuntimeOptions.OSRMaxCompilationReAttempts)) : BytecodeOSRMetadata.DISABLED;
                osrNode.setOSRMetadata((Object)metadata);
            }
            return metadata;
        });
    }

    public Object tryBytecodeOSR(BytecodeOSRNode osrNode, int target, Object interpreterState, Runnable beforeTransfer, VirtualFrame parentFrame) {
        CompilerAsserts.neverPartOfCompilation();
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        return osrMetadata.tryOSR(target, interpreterState, beforeTransfer, parentFrame);
    }

    public void onOSRNodeReplaced(BytecodeOSRNode osrNode, Node oldNode, Node newNode, CharSequence reason) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        if (osrMetadata != null) {
            osrMetadata.nodeReplaced(oldNode, newNode, reason);
        }
    }

    public void transferOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target, int bytecodeTarget) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        BytecodeOSRMetadata.OsrEntryDescription targetMetadata = osrMetadata.getLazyState().get(bytecodeTarget);
        osrMetadata.transferFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target, bytecodeTarget, targetMetadata);
    }

    public void transferOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target, int bytecodeTarget, Object targetMetadata) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        osrMetadata.transferFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target, bytecodeTarget, targetMetadata);
    }

    public void restoreOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        osrMetadata.restoreFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target);
    }

    public ThreadLocalHandshake getThreadLocalHandshake() {
        return OptimizedTruffleRuntime.getRuntime().getThreadLocalHandshake();
    }

    public OptionDescriptors getRuntimeOptionDescriptors() {
        return OptimizedTruffleRuntime.getRuntime().getOptionDescriptors();
    }

    public boolean isGuestCallStackFrame(StackTraceElement e) {
        return e.getMethodName().equals("executeRootNode") && e.getClassName().equals(OptimizedCallTarget.class.getName());
    }

    public void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
        ((OptimizedCallTarget)target).initializeUnsafeArgumentTypes(argumentTypes);
    }

    public <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        return new OptimizedBlockNode(elements, executor);
    }

    public Assumption createAlwaysValidAssumption() {
        return OptimizedAssumption.createAlwaysValid();
    }

    public void reportPolymorphicSpecialize(Node source) {
        OptimizedCallTarget callTarget;
        RootNode rootNode = source.getRootNode();
        OptimizedCallTarget optimizedCallTarget = callTarget = rootNode == null ? null : (OptimizedCallTarget)rootNode.getCallTarget();
        if (callTarget == null) {
            return;
        }
        TruffleSplittingStrategy.newPolymorphicSpecialize(source, callTarget.engine);
        callTarget.polymorphicSpecialize(source);
    }

    public Object callInlined(Node callNode, CallTarget target, Object ... arguments) {
        OptimizedCallTarget optimizedCallTarget = (OptimizedCallTarget)target;
        try {
            return optimizedCallTarget.callInlined(callNode, arguments);
        }
        catch (Throwable t) {
            OptimizedRuntimeAccessor.LANGUAGE.addStackFrameInfo(callNode, null, t, null);
            throw OptimizedCallTarget.rethrow(t);
        }
    }

    public Object callProfiled(CallTarget target, Object ... arguments) {
        OptimizedCallTarget castTarget = (OptimizedCallTarget)target;
        assert (castTarget.isValidArgumentProfile(arguments)) : "Invalid argument profile. callProfiled requires to explicity initialize the profile.";
        return castTarget.doInvoke(arguments);
    }

    public Object[] castArrayFixedLength(Object[] args, int length) {
        return OptimizedCallTarget.castArrayFixedLength(args, length);
    }

    public <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return OptimizedCallTarget.unsafeCast(value, type, condition, nonNull, exact);
    }

    public void flushCompileQueue(Object runtimeData) {
        EngineData engine = (EngineData)runtimeData;
        BackgroundCompileQueue queue = OptimizedTruffleRuntime.getRuntime().getCompileQueue();
        if (queue != null) {
            for (OptimizedCallTarget target : queue.getQueuedTargets(engine)) {
                target.cancelCompilation("Polyglot engine was closed.");
            }
        }
    }

    public Object tryLoadCachedEngine(OptionValues options, Function<String, TruffleLogger> loggerFactory) {
        return OptimizedTruffleRuntime.getRuntime().getEngineCacheSupport().tryLoadingCachedEngine(options, loggerFactory);
    }

    public boolean isStoreEnabled(OptionValues options) {
        return EngineCacheSupport.get().isStoreEnabled(options);
    }

    public Object createRuntimeData(Object engine, OptionValues engineOptions, Function<String, TruffleLogger> loggerFactory, SandboxPolicy sandboxPolicy) {
        return new EngineData(engine, engineOptions, loggerFactory, sandboxPolicy);
    }

    public void onEngineCreate(Object engine, Object runtimeData) {
        ((EngineData)runtimeData).onEngineCreated(engine);
    }

    public void onEnginePatch(Object runtimeData, OptionValues runtimeOptions, Function<String, TruffleLogger> loggerFactory, SandboxPolicy sandboxPolicy) {
        ((EngineData)runtimeData).onEnginePatch(runtimeOptions, loggerFactory, sandboxPolicy);
    }

    public boolean onEngineClosing(Object runtimeData) {
        return ((EngineData)runtimeData).onEngineClosing();
    }

    public void onEngineClosed(Object runtimeData) {
        ((EngineData)runtimeData).onEngineClosed();
    }

    public boolean isOSRRootNode(RootNode rootNode) {
        return rootNode instanceof BaseOSRRootNode;
    }

    public int getObjectAlignment() {
        return OptimizedTruffleRuntime.getRuntime().getObjectAlignment();
    }

    public int getArrayBaseOffset(Class<?> componentType) {
        return OptimizedTruffleRuntime.getRuntime().getArrayBaseOffset(componentType);
    }

    public int getArrayIndexScale(Class<?> componentType) {
        return OptimizedTruffleRuntime.getRuntime().getArrayIndexScale(componentType);
    }

    public int getBaseInstanceSize(Class<?> type) {
        return OptimizedTruffleRuntime.getRuntime().getBaseInstanceSize(type);
    }

    public boolean isLegacyCompilerOption(String key) {
        return OptimizedTruffleRuntime.CompilerOptionsDescriptors.isLegacyOption(key);
    }

    public int[] getFieldOffsets(Class<?> type, boolean includePrimitive, boolean includeSuperclasses) {
        return OptimizedTruffleRuntime.getRuntime().getFieldOffsets(type, includePrimitive, includeSuperclasses);
    }

    public AbstractFastThreadLocal getContextThreadLocal() {
        AbstractFastThreadLocal local = OptimizedTruffleRuntime.getRuntime().getFastThreadLocalImpl();
        if (local == null) {
            return super.getContextThreadLocal();
        }
        return local;
    }

    public <T> ThreadLocal<T> createTerminatingThreadLocal(Supplier<T> initialValue, Consumer<T> onThreadTermination) {
        return OptimizedTruffleRuntime.createTerminatingThreadLocal(initialValue, onThreadTermination);
    }
}

