/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;

public enum CompilationState {
    INTERPRETED,
    FIRST_TIER_ROOT,
    LAST_TIER_ROOT,
    FIRST_TIER_INLINED,
    LAST_TIER_INLINED;


    boolean isCompilationRoot() {
        return this == FIRST_TIER_ROOT || this == LAST_TIER_ROOT;
    }

    boolean isCompiled() {
        return this != INTERPRETED;
    }

    int getTier() {
        switch (this) {
            case INTERPRETED: {
                return 0;
            }
            case FIRST_TIER_INLINED: 
            case FIRST_TIER_ROOT: {
                return 1;
            }
            case LAST_TIER_INLINED: 
            case LAST_TIER_ROOT: {
                return 2;
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)"invalid state");
    }
}

