/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.FrameWithoutBoxing;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExecutionSignature;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.runtime.AbstractCompilationTask;
import com.oracle.truffle.runtime.BaseOSRRootNode;
import com.oracle.truffle.runtime.CompilationState;
import com.oracle.truffle.runtime.CompilationTask;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.FixedPointMath;
import com.oracle.truffle.runtime.OptimizedAssumption;
import com.oracle.truffle.runtime.OptimizedBlockNode;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTVMCI;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.OptimizedTruffleRuntimeListener;
import com.oracle.truffle.runtime.SuppressFBWarnings;
import com.oracle.truffle.runtime.TruffleCallBoundary;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public abstract class OptimizedCallTarget
implements TruffleCompilable,
RootCallTarget,
ReplaceObserver {
    private static final String NODE_REWRITING_ASSUMPTION_NAME = "nodeRewritingAssumption";
    private static final String VALID_ROOT_ASSUMPTION_NAME = "validRootAssumption";
    static final String EXECUTE_ROOT_NODE_METHOD_NAME = "executeRootNode";
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, SpeculationLog> SPECULATION_LOG_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, SpeculationLog.class, "speculationLog");
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, Assumption> NODE_REWRITING_ASSUMPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, Assumption.class, "nodeRewritingAssumption");
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, Assumption> VALID_ROOT_ASSUMPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, Assumption.class, "validRootAssumption");
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, ArgumentsProfile> ARGUMENTS_PROFILE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, ArgumentsProfile.class, "argumentsProfile");
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, ReturnProfile> RETURN_PROFILE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, ReturnProfile.class, "returnProfile");
    private static final WeakReference<OptimizedDirectCallNode> NO_CALL = new WeakReference<Object>(null);
    private static final WeakReference<OptimizedDirectCallNode> MULTIPLE_CALLS = null;
    private static final String SPLIT_LOG_FORMAT = "[poly-event] %-70s %s";
    private static final int MAX_PROFILED_ARGUMENTS = 256;
    private final RootNode rootNode;
    @CompilerDirectives.CompilationFinal
    protected volatile boolean initialized;
    @CompilerDirectives.CompilationFinal
    private volatile boolean loaded;
    private int callCount;
    private int callAndLoopCount;
    private int highestCompiledTier = 0;
    @CompilerDirectives.CompilationFinal
    private volatile ArgumentsProfile argumentsProfile;
    @CompilerDirectives.CompilationFinal
    private volatile ReturnProfile returnProfile;
    @CompilerDirectives.CompilationFinal
    private Class<? extends Throwable> profiledExceptionType;
    private volatile boolean dequeueInlined;
    private volatile boolean aotInitialized;
    private volatile boolean compilationFailed;
    @CompilerDirectives.CompilationFinal
    private boolean callProfiled;
    private volatile long initializedTimestamp;
    private volatile CompilationTask compilationTask;
    private int successfulCompilationsCount;
    private volatile boolean needsSplit;
    public final EngineData engine;
    private volatile RootNode uninitializedRootNode;
    private final OptimizedCallTarget sourceCallTarget;
    protected volatile SpeculationLog speculationLog;
    private volatile Assumption nodeRewritingAssumption;
    private volatile Assumption validRootAssumption;
    private volatile int cachedNonTrivialNodeCount = -1;
    private volatile int callSitesKnown;
    private volatile String nameCache;
    private final int uninitializedNodeCount;
    private volatile WeakReference<OptimizedDirectCallNode> singleCallNode = NO_CALL;
    volatile List<OptimizedCallTarget> blockCompilations;
    public final long id;
    private static final AtomicLong ID_COUNTER = new AtomicLong(0L);

    final void compiledTier(int tier) {
        this.highestCompiledTier = Math.max(this.highestCompiledTier, tier);
    }

    public final int highestCompiledTier() {
        return this.highestCompiledTier;
    }

    protected OptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        assert (sourceCallTarget == null || sourceCallTarget.sourceCallTarget == null) : "Cannot create a clone of a cloned CallTarget";
        this.sourceCallTarget = sourceCallTarget;
        this.speculationLog = sourceCallTarget != null ? sourceCallTarget.getSpeculationLog() : null;
        this.rootNode = rootNode;
        this.engine = OptimizedTVMCI.getEngineData(rootNode);
        this.resetCompilationProfile();
        this.uninitializedNodeCount = this.uninitializedNodeCount(rootNode);
        this.id = ID_COUNTER.getAndIncrement();
    }

    protected OptimizedCallTarget(EngineData engine) {
        this.speculationLog = null;
        this.rootNode = null;
        this.engine = engine;
        this.resetCompilationProfile();
        this.uninitializedNodeCount = 0;
        this.sourceCallTarget = null;
        this.id = ID_COUNTER.getAndIncrement();
    }

    private int uninitializedNodeCount(RootNode rootNode) {
        if (this.isOSR()) {
            return -1;
        }
        int childrenCount = OptimizedRuntimeAccessor.NODES.adoptChildrenAndCount(rootNode);
        int size = OptimizedRuntimeAccessor.NODES.computeSize(rootNode);
        return size > 0 ? size : childrenCount;
    }

    public final void prepareForCompilation() {
        if (this.rootNode == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"Initialization call targets cannot be compiled.");
        }
        if (this.nodeRewritingAssumption == null) {
            this.initializeNodeRewritingAssumption();
        }
        if (this.validRootAssumption == null) {
            this.initializeValidRootAssumption();
        }
    }

    final Assumption getNodeRewritingAssumption() {
        Assumption assumption = this.nodeRewritingAssumption;
        if (assumption == null) {
            assumption = this.initializeNodeRewritingAssumption();
        }
        return assumption;
    }

    final Assumption getValidRootAssumption() {
        Assumption assumption = this.validRootAssumption;
        if (assumption == null) {
            assumption = this.initializeValidRootAssumption();
        }
        return assumption;
    }

    public boolean isTrivial() {
        return OptimizedRuntimeAccessor.NODES.isTrivial(this.rootNode);
    }

    private FrameDescriptor getParentFrameDescriptor() {
        return OptimizedRuntimeAccessor.NODES.getParentFrameDescriptor(this.rootNode);
    }

    public final void dequeueInlined() {
        if (!this.dequeueInlined) {
            this.dequeueInlined = true;
            this.cancelCompilation("Target inlined into only caller");
        }
    }

    private Assumption initializeNodeRewritingAssumption() {
        return this.initializeAssumption(NODE_REWRITING_ASSUMPTION_UPDATER, NODE_REWRITING_ASSUMPTION_NAME);
    }

    private Assumption initializeAssumption(AtomicReferenceFieldUpdater<OptimizedCallTarget, Assumption> updater, String name) {
        Assumption newAssumption = OptimizedCallTarget.runtime().createAssumption((String)(this.getOptionValue(OptimizedRuntimeOptions.TraceAssumptions) == false ? name : name + " of " + this.rootNode));
        if (updater.compareAndSet(this, null, newAssumption)) {
            return newAssumption;
        }
        return Objects.requireNonNull(updater.get(this));
    }

    private void invalidateNodeRewritingAssumption() {
        this.invalidateAssumption(NODE_REWRITING_ASSUMPTION_UPDATER, "");
    }

    private boolean invalidateAssumption(AtomicReferenceFieldUpdater<OptimizedCallTarget, Assumption> updater, CharSequence reason) {
        Assumption oldAssumption = updater.getAndUpdate(this, prev -> prev == null ? null : OptimizedCallTarget.runtime().createAssumption(prev.getName()));
        if (oldAssumption == null) {
            return false;
        }
        oldAssumption.invalidate(reason != null ? reason.toString() : "");
        return true;
    }

    private Assumption initializeValidRootAssumption() {
        return this.initializeAssumption(VALID_ROOT_ASSUMPTION_UPDATER, VALID_ROOT_ASSUMPTION_NAME);
    }

    private boolean invalidateValidRootAssumption(CharSequence reason) {
        return this.invalidateAssumption(VALID_ROOT_ASSUMPTION_UPDATER, reason);
    }

    public final RootNode getRootNode() {
        return this.rootNode;
    }

    public final void resetCompilationProfile() {
        this.callCount = 0;
        this.callAndLoopCount = 0;
    }

    @CompilerDirectives.TruffleBoundary
    public final Object call(Object ... args) {
        EncapsulatingNodeReference encapsulating = EncapsulatingNodeReference.getCurrent();
        Node prev = encapsulating.set(null);
        try {
            Object object = this.callIndirect(prev, args);
            return object;
        }
        catch (Throwable t) {
            OptimizedRuntimeAccessor.LANGUAGE.addStackFrameInfo(prev, null, t, null);
            throw OptimizedCallTarget.rethrow(t);
        }
        finally {
            encapsulating.set(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callIndirect(Node location, Object ... args) {
        this.profileIndirectArguments(args);
        try {
            Object object = this.doInvoke(args);
            return object;
        }
        finally {
            Reference.reachabilityFence(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object callDirect(Node location, Object ... args) {
        try {
            this.profileArguments(args);
            Object result = this.doInvoke(args);
            if (CompilerDirectives.inCompiledCode()) {
                result = this.injectReturnValueProfile(result);
            }
            Object object = result;
            return object;
        }
        finally {
            Reference.reachabilityFence(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object callInlined(Node location, Object ... arguments) {
        try {
            this.ensureInitialized();
            Object object = this.executeRootNode((VirtualFrame)OptimizedCallTarget.createFrame(this.getRootNode().getFrameDescriptor(), arguments), OptimizedCallTarget.getTier());
            return object;
        }
        finally {
            Reference.reachabilityFence(location);
        }
    }

    private static CompilationState getTier() {
        if (CompilerDirectives.inCompiledCode()) {
            if (CompilerDirectives.hasNextTier()) {
                if (CompilerDirectives.inCompilationRoot()) {
                    return CompilationState.FIRST_TIER_ROOT;
                }
                return CompilationState.FIRST_TIER_INLINED;
            }
            if (CompilerDirectives.inCompilationRoot()) {
                return CompilationState.LAST_TIER_ROOT;
            }
            return CompilationState.LAST_TIER_INLINED;
        }
        return CompilationState.INTERPRETED;
    }

    public final Object callOSR(Object ... args) {
        return this.doInvoke(args);
    }

    protected Object doInvoke(Object[] args) {
        return this.callBoundary(args);
    }

    @TruffleCallBoundary
    protected final Object callBoundary(Object[] args) {
        if (this.interpreterCall()) {
            return this.doInvoke(args);
        }
        return this.profiledPERoot(args);
    }

    private boolean interpreterCall() {
        boolean bypassedInstalledCode = false;
        if (this.isValid()) {
            OptimizedCallTarget.runtime().bypassedInstalledCode(this);
            bypassedInstalledCode = true;
        }
        this.ensureInitialized();
        int intCallCount = this.callCount;
        this.callCount = intCallCount == Integer.MAX_VALUE ? intCallCount : ++intCallCount;
        int intLoopCallCount = this.callAndLoopCount;
        int n = this.callAndLoopCount = intLoopCallCount == Integer.MAX_VALUE ? intLoopCallCount : ++intLoopCallCount;
        if (this.shouldCompileImpl(intCallCount, intLoopCallCount)) {
            boolean isCompiled = this.compile(!this.engine.multiTier);
            return isCompiled && (TruffleOptions.AOT || !bypassedInstalledCode);
        }
        return false;
    }

    private boolean shouldCompileImpl(int intCallCount, int intLoopCallCount) {
        return !this.compilationFailed && !this.isSubmittedForCompilation() && !this.isOSR() && intCallCount >= this.engine.callThresholdInInterpreter && intLoopCallCount >= OptimizedCallTarget.scaledThreshold(this.engine.callAndLoopThresholdInInterpreter);
    }

    public static int scaledThreshold(int callAndLoopThresholdInInterpreter) {
        return FixedPointMath.multiply(OptimizedCallTarget.runtime().compilationThresholdScale(), callAndLoopThresholdInInterpreter);
    }

    public final boolean shouldCompile() {
        return !this.isValid() && this.shouldCompileImpl(this.callCount, this.callAndLoopCount);
    }

    public final boolean wasExecuted() {
        return this.callCount > 0 || this.callAndLoopCount > 0;
    }

    protected final Object profiledPERoot(Object[] originalArguments) {
        Object[] args = originalArguments;
        if (!CompilerDirectives.inInterpreter() && CompilerDirectives.hasNextTier()) {
            this.firstTierCall();
        }
        if (CompilerDirectives.inCompiledCode()) {
            args = this.injectArgumentsProfile(originalArguments);
        }
        Object result = this.executeRootNode((VirtualFrame)OptimizedCallTarget.createFrame(this.getRootNode().getFrameDescriptor(), args), OptimizedCallTarget.getTier());
        this.profileReturnValue(result);
        return result;
    }

    public final boolean firstTierCall() {
        int firstTierCallCount = this.callCount;
        this.callCount = firstTierCallCount == Integer.MAX_VALUE ? firstTierCallCount : ++firstTierCallCount;
        int firstTierLoopCallCount = this.callAndLoopCount;
        int n = this.callAndLoopCount = firstTierLoopCallCount == Integer.MAX_VALUE ? firstTierLoopCallCount : ++firstTierLoopCallCount;
        if (!this.compilationFailed && !this.isSubmittedForCompilation() && firstTierCallCount >= this.engine.callThresholdInFirstTier && firstTierLoopCallCount >= OptimizedCallTarget.scaledThreshold(this.engine.callAndLoopThresholdInFirstTier)) {
            return this.lastTierCompile();
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private boolean lastTierCompile() {
        return this.compile(true);
    }

    private void propagateCallAndLoopCount() {
        WeakReference<OptimizedDirectCallNode> currentSingleCallNode = this.singleCallNode;
        if (!this.engine.propagateCallAndLoopCount || currentSingleCallNode == MULTIPLE_CALLS || currentSingleCallNode == NO_CALL) {
            return;
        }
        FrameDescriptor parentFrameDescriptor = this.getParentFrameDescriptor();
        if (parentFrameDescriptor == null) {
            return;
        }
        int depth = 0;
        do {
            OptimizedDirectCallNode callerCallNode;
            if ((callerCallNode = (OptimizedDirectCallNode)((Object)currentSingleCallNode.get())) == null) {
                return;
            }
            RootNode callerRootNode = callerCallNode.getRootNode();
            if (callerRootNode == null) {
                return;
            }
            OptimizedCallTarget callerCallTarget = (OptimizedCallTarget)callerRootNode.getCallTarget();
            if (this.isSameOrSplit(callerCallTarget)) {
                return;
            }
            if (callerCallTarget.frameDescriptorEquals(parentFrameDescriptor)) {
                callerCallNode.forceInlining();
                callerCallTarget.callAndLoopCount += this.callAndLoopCount;
                return;
            }
            currentSingleCallNode = callerCallTarget.singleCallNode;
        } while (++depth < this.engine.propagateCallAndLoopCountMaxDepth && currentSingleCallNode != NO_CALL && currentSingleCallNode != MULTIPLE_CALLS);
    }

    private boolean frameDescriptorEquals(FrameDescriptor parentFrameDescriptor) {
        assert (parentFrameDescriptor != null);
        if (parentFrameDescriptor.equals(this.rootNode.getFrameDescriptor())) {
            return true;
        }
        if (this.isSplit()) {
            RootNode sourceRootNode = this.sourceCallTarget.getRootNode();
            return parentFrameDescriptor.equals(sourceRootNode.getFrameDescriptor());
        }
        return false;
    }

    private Object executeRootNode(VirtualFrame frame, CompilationState tier) {
        try {
            Object toRet = this.rootNode.execute(frame);
            TruffleSafepoint.poll((Node)this.rootNode);
            Object object = toRet;
            return object;
        }
        catch (Throwable t) {
            throw this.handleException(frame, t);
        }
        finally {
            if (CompilerDirectives.inInterpreter() && tier != CompilationState.INTERPRETED) {
                this.notifyDeoptimized(frame);
            }
            Reference.reachabilityFence(frame);
            Reference.reachabilityFence(this);
            Reference.reachabilityFence((Object)tier);
        }
    }

    private RuntimeException handleException(VirtualFrame frame, Throwable t) {
        Throwable profiledT = this.profileExceptionType(t);
        OptimizedRuntimeAccessor.LANGUAGE.addStackFrameInfo(null, (RootCallTarget)this, profiledT, (Frame)frame);
        throw OptimizedCallTarget.rethrow(profiledT);
    }

    private void notifyDeoptimized(VirtualFrame frame) {
        OptimizedCallTarget.runtime().getListener().onCompilationDeoptimized(this, (Frame)frame);
    }

    protected static OptimizedTruffleRuntime runtime() {
        return (OptimizedTruffleRuntime)Truffle.getRuntime();
    }

    public final void ensureInitialized() {
        if (!this.initialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initialize(true);
        }
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    private synchronized void initialize(boolean validate) {
        if (!this.initialized) {
            if (this.isSourceCallTarget() && this.rootNode.isCloningAllowed() && !OptimizedRuntimeAccessor.NODES.isCloneUninitializedSupported(this.rootNode)) {
                this.uninitializedRootNode = (RootNode)NodeUtil.cloneNode((Node)this.rootNode);
            }
            assert (!validate || OptimizedRuntimeAccessor.NODES.getCallTargetWithoutInitialization(this.rootNode) == this) : "Call target out of sync.";
            OptimizedRuntimeAccessor.INSTRUMENT.onFirstExecution(this.getRootNode(), validate);
            this.initializedTimestamp = this.engine.callTargetStatistics ? System.nanoTime() : 0L;
            this.initialized = true;
        }
    }

    public final OptionValues getOptionValues() {
        return this.engine.getEngineOptions();
    }

    public final <T> T getOptionValue(OptionKey<T> key) {
        return (T)this.getOptionValues().get(key);
    }

    final boolean acceptForCompilation() {
        return this.engine.acceptForCompilation(this);
    }

    final boolean isCompilationFailed() {
        return this.compilationFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compile(boolean lastTierCompilation) {
        boolean lastTier;
        boolean bl = lastTier = !this.engine.firstTierOnly && lastTierCompilation;
        if (!this.needsCompile(lastTier)) {
            return true;
        }
        if (!this.isSubmittedForCompilation()) {
            if (!this.acceptForCompilation()) {
                this.compilationFailed = true;
                return false;
            }
            CompilationTask task = null;
            OptimizedCallTarget optimizedCallTarget = this;
            synchronized (optimizedCallTarget) {
                if (!this.needsCompile(lastTier)) {
                    return true;
                }
                this.ensureInitialized();
                if (!this.isSubmittedForCompilation()) {
                    if (lastTier) {
                        this.propagateCallAndLoopCount();
                    }
                    if (!this.wasExecuted() && !this.engine.backgroundCompilation) {
                        this.prepareForAOTImpl();
                    }
                    try {
                        assert (this.compilationTask == null);
                        if (this.engine.maximumCompilations >= 0 && this.successfulCompilationsCount >= this.engine.maximumCompilations) {
                            this.compilationFailed = true;
                            OptimizedCallTarget.runtime().getListener().onCompilationStarted(this, new PresubmitFailureCompilationTask(this.engine.firstTierOnly, lastTier));
                            String failureReason = String.format("Maximum compilation count %d reached.", this.engine.maximumCompilations);
                            OptimizedCallTarget.runtime().getListener().onCompilationFailed(this, failureReason, true, true, lastTier ? 2 : 1, null);
                            this.handleCompilationFailure(() -> failureReason, false, true, true);
                            return false;
                        }
                        this.compilationTask = task = OptimizedCallTarget.runtime().submitForCompilation(this, lastTier);
                    }
                    catch (RejectedExecutionException e) {
                        return false;
                    }
                }
            }
            if (task != null) {
                OptimizedCallTarget.runtime().getListener().onCompilationQueued(this, lastTier ? 2 : 1);
                return this.maybeWaitForTask(task);
            }
        }
        return false;
    }

    public final boolean maybeWaitForTask(CompilationTask task) {
        boolean mayBeAsynchronous = this.engine.backgroundCompilation;
        OptimizedCallTarget.runtime().finishCompilation(this, task, mayBeAsynchronous);
        return !mayBeAsynchronous && this.isValid();
    }

    public final boolean needsCompile(boolean isLastTierCompilation) {
        return !this.isValid() || this.engine.multiTier && isLastTierCompilation && !this.isValidLastTier();
    }

    public final boolean isSubmittedForCompilation() {
        return this.compilationTask != null;
    }

    public final void waitForCompilation() {
        CompilationTask task = this.compilationTask;
        if (task != null) {
            OptimizedCallTarget.runtime().finishCompilation(this, task, false);
        }
    }

    boolean isCompiling() {
        return this.getCompilationTask() != null;
    }

    public abstract long getCodeAddress();

    public abstract boolean isValid();

    public abstract boolean isValidLastTier();

    public final boolean invalidate(CharSequence reason) {
        this.cachedNonTrivialNodeCount = -1;
        boolean invalidated = this.invalidateValidRootAssumption(reason);
        return this.cancelCompilation(reason) || invalidated;
    }

    final OptimizedCallTarget cloneUninitialized() {
        assert (!this.isSplit()) : "Cannot clone a clone.";
        this.ensureInitialized();
        RootNode clonedRoot = OptimizedRuntimeAccessor.NODES.cloneUninitialized((CallTarget)this, this.rootNode, this.uninitializedRootNode);
        return (OptimizedCallTarget)clonedRoot.getCallTarget();
    }

    public SpeculationLog getSpeculationLog() {
        if (this.speculationLog == null) {
            SPECULATION_LOG_UPDATER.compareAndSet(this, null, ((OptimizedTruffleRuntime)Truffle.getRuntime()).createSpeculationLog());
        }
        return this.speculationLog;
    }

    final void setSpeculationLog(SpeculationLog speculationLog) {
        this.speculationLog = speculationLog;
    }

    public final JavaConstant asJavaConstant() {
        return OptimizedTruffleRuntime.getRuntime().forObject(this);
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public final boolean isSameOrSplit(TruffleCompilable ast) {
        if (!(ast instanceof OptimizedCallTarget)) {
            return false;
        }
        OptimizedCallTarget other = (OptimizedCallTarget)ast;
        return this == other || this == other.sourceCallTarget || other == this.sourceCallTarget || this.sourceCallTarget != null && other.sourceCallTarget != null && this.sourceCallTarget == other.sourceCallTarget;
    }

    public boolean cancelCompilation(CharSequence reason) {
        if (!this.initialized) {
            return false;
        }
        CompilationTask task = this.compilationTask;
        if (this.cancelAndResetCompilationTask()) {
            OptimizedCallTarget.runtime().getListener().onCompilationDequeued(this, null, reason, task != null ? task.tier() : 0);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelAndResetCompilationTask() {
        CompilationTask task = this.compilationTask;
        if (task != null) {
            OptimizedCallTarget optimizedCallTarget = this;
            synchronized (optimizedCallTarget) {
                task = this.compilationTask;
                if (task != null) {
                    return task.cancel();
                }
            }
        }
        return false;
    }

    public final boolean computeBlockCompilations() {
        if (this.blockCompilations == null) {
            this.blockCompilations = OptimizedBlockNode.preparePartialBlockCompilations(this);
            if (!this.blockCompilations.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public void onCompilationSuccess(int compilationTier, boolean lastTier) {
        ++this.successfulCompilationsCount;
    }

    public final boolean onInvalidate(Object source, CharSequence reason, boolean wasActive) {
        this.cachedNonTrivialNodeCount = -1;
        if (wasActive) {
            OptimizedTruffleRuntime.getRuntime().getListener().onCompilationInvalidated(this, source, reason);
        }
        return this.cancelCompilation(reason) || wasActive;
    }

    public final void onCompilationFailed(Supplier<String> serializedException, boolean silent, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        if (graphTooBig && this.computeBlockCompilations()) {
            return;
        }
        this.handleCompilationFailure(serializedException, silent, bailout, permanentBailout);
    }

    private void handleCompilationFailure(Supplier<String> serializedException, boolean silent, boolean bailout, boolean permanentBailout) {
        OptimizedRuntimeOptions.ExceptionAction action;
        if (bailout && !permanentBailout) {
            action = OptimizedRuntimeOptions.ExceptionAction.Silent;
        } else {
            this.compilationFailed = true;
            OptimizedRuntimeOptions.ExceptionAction exceptionAction = action = silent ? OptimizedRuntimeOptions.ExceptionAction.Silent : this.engine.compilationFailureAction;
        }
        if (action == OptimizedRuntimeOptions.ExceptionAction.Throw) {
            InternalError error = new InternalError(serializedException.get());
            throw new OptimizationFailedException((Throwable)error, (RootCallTarget)this);
        }
        if (action.ordinal() >= OptimizedRuntimeOptions.ExceptionAction.Print.ordinal()) {
            OptimizedTruffleRuntime rt = OptimizedCallTarget.runtime();
            LinkedHashMap<String, Integer> properties = new LinkedHashMap<String, Integer>();
            properties.put("AST", this.getNonTrivialNodeCount());
            rt.logEvent(this, 0, "opt fail", this.toString(), properties, serializedException.get());
            if (action == OptimizedRuntimeOptions.ExceptionAction.ExitVM) {
                this.log(String.format("Exiting VM due to %s", "engine.CompilationFailureAction=ExitVM"));
                System.exit(-1);
            }
        }
    }

    public final void log(String message) {
        OptimizedCallTarget.runtime().log(this, message);
    }

    public final int getKnownCallSiteCount() {
        return this.callSitesKnown;
    }

    public final OptimizedCallTarget getSourceCallTarget() {
        return this.sourceCallTarget;
    }

    public final String getName() {
        CompilerAsserts.neverPartOfCompilation();
        Object result = this.nameCache;
        if (result == null) {
            result = this.rootNode.toString();
            if (this.isSplit()) {
                result = (String)result + " <split-" + this.id + ">";
            }
            this.nameCache = result;
        }
        return result;
    }

    public final String toString() {
        return this.getName();
    }

    static final Object[] castArrayFixedLength(Object[] args, int length) {
        return args;
    }

    static <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return (T)value;
    }

    public static FrameWithoutBoxing createFrame(FrameDescriptor descriptor, Object[] args) {
        return new FrameWithoutBoxing(descriptor, args);
    }

    final void onLoopCount(int count) {
        assert (count >= 0);
        int oldLoopCallCount = this.callAndLoopCount;
        int newLoopCallCount = oldLoopCallCount + count;
        this.callAndLoopCount = newLoopCallCount >= oldLoopCallCount ? newLoopCallCount : Integer.MAX_VALUE;
    }

    public final boolean nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        CompilerAsserts.neverPartOfCompilation();
        this.invalidate(reason);
        this.invalidateNodeRewritingAssumption();
        return false;
    }

    public final void accept(NodeVisitor visitor) {
        this.getRootNode().accept(visitor);
    }

    public final int getNonTrivialNodeCount() {
        if (this.cachedNonTrivialNodeCount == -1) {
            this.cachedNonTrivialNodeCount = OptimizedCallTarget.calculateNonTrivialNodes((Node)this.getRootNode());
        }
        return this.cachedNonTrivialNodeCount;
    }

    public final int getCallCount() {
        return this.callCount;
    }

    public final int getCallAndLoopCount() {
        return this.callAndLoopCount;
    }

    public final long getInitializedTimestamp() {
        return this.initializedTimestamp;
    }

    public static int calculateNonTrivialNodes(Node node) {
        NonTrivialNodeCountVisitor visitor = new NonTrivialNodeCountVisitor();
        node.accept((NodeVisitor)visitor);
        return visitor.nodeCount;
    }

    public final Map<String, Object> getDebugProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        OptimizedTruffleRuntimeListener.addASTSizeProperty(this, properties);
        String callsThresholdInInterpreter = String.format("%7d/%5d", this.getCallCount(), this.engine.callThresholdInInterpreter);
        String loopsThresholdInInterpreter = String.format("%7d/%5d", this.getCallAndLoopCount(), this.engine.callAndLoopThresholdInInterpreter);
        if (this.engine.multiTier) {
            if (this.isValidLastTier()) {
                String callsThresholdInFirstTier = String.format("%7d/%5d", this.getCallCount(), this.engine.callThresholdInFirstTier);
                String loopsThresholdInFirstTier = String.format("%7d/%5d", this.getCallCount(), this.engine.callAndLoopThresholdInFirstTier);
                properties.put("Tier", "2");
                properties.put("Calls/Thres", callsThresholdInFirstTier);
                properties.put("CallsAndLoop/Thres", loopsThresholdInFirstTier);
            } else {
                properties.put("Tier", "1");
                properties.put("Calls/Thres", callsThresholdInInterpreter);
                properties.put("CallsAndLoop/Thres", loopsThresholdInInterpreter);
            }
        } else {
            properties.put("Calls/Thres", callsThresholdInInterpreter);
            properties.put("CallsAndLoop/Thres", loopsThresholdInInterpreter);
        }
        return properties;
    }

    public int countDirectCallNodes() {
        DirectCallCounter counter = new DirectCallCounter();
        this.getRootNode().accept((NodeVisitor)counter);
        return counter.count;
    }

    final void initializeUnsafeArgumentTypes(Class<?>[] argumentTypes) {
        CompilerAsserts.neverPartOfCompilation();
        ArgumentsProfile newProfile = new ArgumentsProfile(argumentTypes, "Custom profiled argument types");
        if (!this.updateArgumentsProfile(null, newProfile)) {
            this.transitionToInvalidArgumentsProfile();
            throw new AssertionError((Object)"Argument types already initialized. initializeArgumentTypes() must be called before any profile is initialized.");
        }
        this.callProfiled = true;
    }

    final boolean isValidArgumentProfile(Object[] args) {
        assert (this.callProfiled);
        ArgumentsProfile argumentsProfile = this.argumentsProfile;
        return argumentsProfile.assumption.isValid() && OptimizedCallTarget.checkProfiledArgumentTypes(args, argumentsProfile.types);
    }

    private static boolean checkProfiledArgumentTypes(Object[] args, Class<?>[] types) {
        assert (types != null);
        if (args.length != types.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (types[0] != args[0].getClass()) {
            throw new ClassCastException();
        }
        for (int j = 1; j < types.length; ++j) {
            if (types[j] == null) continue;
            types[j].cast(args[j]);
            Objects.requireNonNull(args[j]);
        }
        return true;
    }

    private void transitionToInvalidArgumentsProfile() {
        ArgumentsProfile oldProfile;
        do {
            if ((oldProfile = this.argumentsProfile) != ArgumentsProfile.INVALID) continue;
            return;
        } while (!this.updateArgumentsProfile(oldProfile, ArgumentsProfile.INVALID));
    }

    private boolean updateArgumentsProfile(ArgumentsProfile oldProfile, ArgumentsProfile newProfile) {
        if (oldProfile != null) {
            oldProfile.assumption.invalidate();
        }
        return ARGUMENTS_PROFILE_UPDATER.compareAndSet(this, oldProfile, newProfile);
    }

    @CompilerDirectives.TruffleBoundary
    private void profileIndirectArguments(Object[] args) {
        this.profileArguments(args);
    }

    public final void profileArguments(Object[] args) {
        assert (!this.callProfiled);
        ArgumentsProfile argumentsProfile = this.argumentsProfile;
        if (argumentsProfile == ArgumentsProfile.INVALID) {
            return;
        }
        if (argumentsProfile == null) {
            if (CompilerDirectives.inCompiledCode()) {
                return;
            }
        } else {
            Class<?>[] types = argumentsProfile.types;
            assert (types != null) : "argument types must be set at this point";
            if (types.length == args.length && OptimizedCallTarget.areArgumentTypesValid(args, types)) {
                if (CompilerDirectives.inCompiledCode()) {
                    if (argumentsProfile.assumption.isValid()) {
                        return;
                    }
                } else {
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.profileArgumentsSlow(argumentsProfile, args);
    }

    @ExplodeLoop
    private static boolean areArgumentTypesValid(Object[] args, Class<?>[] types) {
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            Object value = args[i];
            if (type == null || value != null && value.getClass() == type) continue;
            return false;
        }
        return true;
    }

    private void profileArgumentsSlow(ArgumentsProfile profile, Object[] args) {
        if (profile == null) {
            this.initializeProfiledArgumentTypes(args);
        } else if (profile.types.length != args.length) {
            this.transitionToInvalidArgumentsProfile();
        } else {
            this.updateProfiledArgumentTypes(args, profile);
        }
    }

    private void initializeProfiledArgumentTypes(Object[] args) {
        ArgumentsProfile newProfile;
        CompilerAsserts.neverPartOfCompilation();
        assert (!this.callProfiled);
        if (args.length <= 256 && this.engine.argumentTypeSpeculation) {
            Class<?>[] types = args.length == 0 ? ArgumentsProfile.EMPTY_ARGUMENT_TYPES : new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                types[i] = OptimizedCallTarget.classOf(args[i]);
            }
            newProfile = new ArgumentsProfile(types, "Profiled Argument Types");
        } else {
            newProfile = ArgumentsProfile.INVALID;
        }
        if (!this.updateArgumentsProfile(null, newProfile)) {
            this.profileArguments(args);
        }
    }

    private void updateProfiledArgumentTypes(Object[] args, ArgumentsProfile oldProfile) {
        CompilerAsserts.neverPartOfCompilation();
        assert (!this.callProfiled);
        Class<?>[] oldTypes = oldProfile.types;
        Class[] newTypes = new Class[oldProfile.types.length];
        for (int j = 0; j < oldTypes.length; ++j) {
            newTypes[j] = OptimizedCallTarget.joinTypes(oldTypes[j], OptimizedCallTarget.classOf(args[j]));
        }
        ArgumentsProfile newProfile = new ArgumentsProfile(newTypes, "Profiled Argument Types");
        if (!this.updateArgumentsProfile(oldProfile, newProfile)) {
            this.profileArguments(args);
        }
    }

    public final Object[] injectArgumentsProfile(Object[] originalArguments) {
        assert (CompilerDirectives.inCompiledCode());
        ArgumentsProfile argumentsProfile = this.argumentsProfile;
        Object[] args = originalArguments;
        if (argumentsProfile != null && argumentsProfile.assumption.isValid()) {
            Class<?>[] types = argumentsProfile.types;
            args = OptimizedCallTarget.unsafeCast(OptimizedCallTarget.castArrayFixedLength(args, types.length), Object[].class, true, true, true);
            args = this.castArgumentsImpl(args, types);
        }
        return args;
    }

    @ExplodeLoop
    private Object[] castArgumentsImpl(Object[] originalArguments, Class<?>[] types) {
        Object[] castArguments = new Object[types.length];
        boolean isCallProfiled = this.callProfiled;
        for (int i = 0; i < types.length; ++i) {
            Class<?> targetType = types[i];
            boolean exact = !isCallProfiled || i == 0;
            castArguments[i] = targetType != null ? OptimizedCallTarget.unsafeCast(originalArguments[i], targetType, true, true, exact) : originalArguments[i];
        }
        return castArguments;
    }

    protected final ArgumentsProfile getInitializedArgumentsProfile() {
        if (this.argumentsProfile == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.updateArgumentsProfile(null, ArgumentsProfile.INVALID);
            assert (this.argumentsProfile != null);
        }
        return this.argumentsProfile;
    }

    private void profileReturnValue(Object result) {
        ReturnProfile returnProfile = this.returnProfile;
        if (returnProfile == ReturnProfile.INVALID) {
            return;
        }
        if (returnProfile == null) {
            if (CompilerDirectives.inCompiledCode()) {
                return;
            }
        } else if (result != null && returnProfile.type == result.getClass()) {
            if (CompilerDirectives.inCompiledCode()) {
                if (returnProfile.assumption.isValid()) {
                    return;
                }
            } else {
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.specializeReturnProfile(returnProfile, result);
    }

    private void specializeReturnProfile(ReturnProfile previousProfile, Object result) {
        Class<?> type = OptimizedCallTarget.classOf(result);
        if (previousProfile == null) {
            ReturnProfile newProfile = type == null || !this.engine.returnTypeSpeculation ? ReturnProfile.INVALID : new ReturnProfile(type);
            if (!RETURN_PROFILE_UPDATER.compareAndSet(this, null, newProfile)) {
                this.profileReturnValue(previousProfile);
            }
        } else if (previousProfile.assumption.isValid() && previousProfile.type != type) {
            previousProfile.assumption.invalidate();
            ReturnProfile previous = RETURN_PROFILE_UPDATER.getAndSet(this, ReturnProfile.INVALID);
            assert (previous == previousProfile || previous == ReturnProfile.INVALID);
        }
    }

    private Object injectReturnValueProfile(Object result) {
        ReturnProfile returnProfile = this.returnProfile;
        if (CompilerDirectives.inCompiledCode() && returnProfile != null && returnProfile.assumption.isValid()) {
            return OptimizedCallTarget.unsafeCast(result, returnProfile.type, true, true, true);
        }
        return result;
    }

    protected final ReturnProfile getInitializedReturnProfile() {
        if (this.returnProfile == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RETURN_PROFILE_UPDATER.compareAndSet(this, null, ReturnProfile.INVALID);
            assert (this.returnProfile != null);
        }
        return this.returnProfile;
    }

    private <T extends Throwable> T profileExceptionType(T value) {
        Class<? extends Throwable> clazz = this.profiledExceptionType;
        if (clazz != Throwable.class) {
            if (clazz != null && value.getClass() == clazz) {
                if (CompilerDirectives.inInterpreter()) {
                    return value;
                }
                return (T)((Throwable)CompilerDirectives.castExact(value, clazz));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.profiledExceptionType = clazz == null ? value.getClass() : Throwable.class;
        }
        return value;
    }

    private static Class<?> classOf(Object arg) {
        return arg != null ? arg.getClass() : null;
    }

    private static Class<?> joinTypes(Class<?> class1, Class<?> class2) {
        if (class1 == class2) {
            return class1;
        }
        return null;
    }

    public final boolean isSourceCallTarget() {
        return this.sourceCallTarget == null;
    }

    public final boolean isSplit() {
        return this.sourceCallTarget != null;
    }

    public final OptimizedDirectCallNode getCallSiteForSplit() {
        if (this.isSplit()) {
            OptimizedDirectCallNode callNode = this.getSingleCallNode();
            assert (callNode != null);
            return callNode;
        }
        return null;
    }

    final int getUninitializedNodeCount() {
        assert (this.uninitializedNodeCount >= 0);
        return this.uninitializedNodeCount;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    final CompilationTask getCompilationTask() {
        return this.compilationTask;
    }

    final synchronized void resetCompilationTask() {
        assert (this.compilationTask != null);
        this.compilationTask = null;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="All increments and decrements are synchronized.")
    final synchronized void addDirectCallNode(OptimizedDirectCallNode directCallNode) {
        Objects.requireNonNull(directCallNode);
        WeakReference<OptimizedDirectCallNode> nodeRef = this.singleCallNode;
        if (nodeRef != MULTIPLE_CALLS) {
            if (nodeRef == NO_CALL) {
                this.singleCallNode = new WeakReference<OptimizedDirectCallNode>(directCallNode);
            } else {
                if (nodeRef.get() == directCallNode) {
                    return;
                }
                this.singleCallNode = MULTIPLE_CALLS;
            }
        }
        ++this.callSitesKnown;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="All increments and decrements are synchronized.")
    final synchronized void removeDirectCallNode(OptimizedDirectCallNode directCallNode) {
        Objects.requireNonNull(directCallNode);
        WeakReference<OptimizedDirectCallNode> nodeRef = this.singleCallNode;
        if (nodeRef != MULTIPLE_CALLS) {
            if (nodeRef == NO_CALL) {
                return;
            }
            this.singleCallNode = nodeRef.get() == directCallNode ? NO_CALL : MULTIPLE_CALLS;
        }
        --this.callSitesKnown;
    }

    public final boolean isSingleCaller() {
        WeakReference<OptimizedDirectCallNode> nodeRef = this.singleCallNode;
        if (nodeRef != null) {
            return nodeRef.get() != null;
        }
        return false;
    }

    public final OptimizedDirectCallNode getSingleCallNode() {
        WeakReference<OptimizedDirectCallNode> nodeRef = this.singleCallNode;
        if (nodeRef != null) {
            return (OptimizedDirectCallNode)((Object)nodeRef.get());
        }
        return null;
    }

    final boolean isNeedsSplit() {
        return this.needsSplit;
    }

    final void polymorphicSpecialize(Node source) {
        ArrayList<Node> toDump = null;
        if (this.engine.splittingDumpDecisions) {
            toDump = new ArrayList<Node>();
            OptimizedCallTarget.pullOutParentChain(source, toDump);
        }
        this.logPolymorphicEvent(0, "Polymorphic event! Source:", source);
        this.maybeSetNeedsSplit(0, toDump);
    }

    public final void resetNeedsSplit() {
        this.needsSplit = false;
    }

    private boolean maybeSetNeedsSplit(int depth, List<Node> toDump) {
        OptimizedDirectCallNode onlyCaller = this.getSingleCallNode();
        if (depth > this.engine.splittingMaxPropagationDepth || this.needsSplit || this.callSitesKnown == 0 || this.getCallCount() == 1) {
            this.logEarlyReturn(depth, this.callSitesKnown);
            return this.needsSplit;
        }
        if (onlyCaller != null) {
            RootNode callerRootNode = onlyCaller.getRootNode();
            if (callerRootNode != null && callerRootNode.getCallTarget() != null) {
                OptimizedCallTarget callerTarget = (OptimizedCallTarget)callerRootNode.getCallTarget();
                if (this.engine.splittingDumpDecisions) {
                    OptimizedCallTarget.pullOutParentChain((Node)onlyCaller, toDump);
                }
                this.logPolymorphicEvent(depth, "One caller! Analysing parent.");
                if (callerTarget.maybeSetNeedsSplit(depth + 1, toDump)) {
                    this.logPolymorphicEvent(depth, "Set needs split to true via parent");
                    this.needsSplit = true;
                }
            }
        } else {
            this.logPolymorphicEvent(depth, "Set needs split to true");
            this.needsSplit = true;
        }
        this.logPolymorphicEvent(depth, "Return:", this.needsSplit);
        return this.needsSplit;
    }

    private void logEarlyReturn(int depth, int numberOfKnownCallNodes) {
        if (this.engine.splittingTraceEvents) {
            this.logPolymorphicEvent(depth, "Early return: " + this.needsSplit + " callCount: " + this.getCallCount() + ", numberOfKnownCallNodes: " + numberOfKnownCallNodes);
        }
    }

    private void logPolymorphicEvent(int depth, String message) {
        this.logPolymorphicEvent(depth, message, null);
    }

    private void logPolymorphicEvent(int depth, String message, Object arg) {
        if (this.engine.splittingTraceEvents) {
            String indent = new String(new char[depth]).replace("\u0000", "  ");
            Object argString = arg == null ? "" : " " + arg;
            this.log(String.format(SPLIT_LOG_FORMAT, indent + message + (String)argString, this.toString()));
        }
    }

    private static void pullOutParentChain(Node node, List<Node> toDump) {
        Node rootNode = node;
        while (rootNode.getParent() != null) {
            toDump.add(rootNode);
            rootNode = rootNode.getParent();
        }
        toDump.add(rootNode);
    }

    final void setNonTrivialNodeCount(int nonTrivialNodeCount) {
        this.cachedNonTrivialNodeCount = nonTrivialNodeCount;
    }

    final boolean isLoaded() {
        return this.loaded;
    }

    final void setLoaded() {
        CompilerAsserts.neverPartOfCompilation();
        this.loaded = true;
    }

    public final boolean prepareForAOT() {
        if (this.wasExecuted()) {
            throw new IllegalStateException("Cannot prepare for AOT if call target was already executed.");
        }
        this.initialize(false);
        return this.prepareForAOTImpl();
    }

    private boolean prepareForAOTImpl() {
        if (this.aotInitialized) {
            return false;
        }
        ExecutionSignature profile = OptimizedRuntimeAccessor.NODES.prepareForAOT(this.rootNode);
        if (profile == null) {
            return false;
        }
        if (this.callProfiled) {
            return true;
        }
        assert (this.returnProfile == null) : "return profile already initialized";
        assert (this.argumentsProfile == null) : "argument profile already initialized";
        Class[] argumentTypes = profile.getArgumentTypes();
        ArgumentsProfile newProfile = argumentTypes != null && argumentTypes.length <= 256 && this.engine.argumentTypeSpeculation ? new ArgumentsProfile(argumentTypes, "Profiled Argument Types") : ArgumentsProfile.INVALID;
        Class returnType = profile.getReturnType();
        ReturnProfile returnProfile = returnType != null && returnType != Object.class ? new ReturnProfile(returnType) : ReturnProfile.INVALID;
        this.returnProfile = returnProfile;
        this.argumentsProfile = newProfile;
        this.aotInitialized = true;
        return true;
    }

    boolean isOSR() {
        return this.rootNode instanceof BaseOSRRootNode;
    }

    public long engineId() {
        return this.engine.id;
    }

    public Map<String, String> getCompilerOptions() {
        return this.engine.getCompilerOptions();
    }

    private static class PresubmitFailureCompilationTask
    extends AbstractCompilationTask {
        private final boolean firstTierOnly;
        private final boolean lastTier;

        PresubmitFailureCompilationTask(boolean firstTierOnly, boolean lastTier) {
            this.firstTierOnly = firstTierOnly;
            this.lastTier = lastTier;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isLastTier() {
            return this.lastTier;
        }

        public boolean hasNextTier() {
            if (this.lastTier) {
                return false;
            }
            return !this.firstTierOnly;
        }
    }

    private static final class NonTrivialNodeCountVisitor
    implements NodeVisitor {
        public int nodeCount;

        private NonTrivialNodeCountVisitor() {
        }

        public boolean visit(Node node) {
            if (!node.getCost().isTrivial()) {
                ++this.nodeCount;
            }
            return true;
        }
    }

    private static final class DirectCallCounter
    implements NodeVisitor {
        int count = 0;

        private DirectCallCounter() {
        }

        public boolean visit(Node node) {
            if (node instanceof OptimizedDirectCallNode) {
                ++this.count;
            }
            return true;
        }
    }

    public static final class ArgumentsProfile {
        private static final String ARGUMENT_TYPES_ASSUMPTION_NAME = "Profiled Argument Types";
        private static final Class<?>[] EMPTY_ARGUMENT_TYPES = new Class[0];
        private static final ArgumentsProfile INVALID = new ArgumentsProfile();
        final OptimizedAssumption assumption;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Class<?>[] types;

        private ArgumentsProfile() {
            this.assumption = (OptimizedAssumption)Assumption.NEVER_VALID;
            this.types = null;
        }

        private ArgumentsProfile(Class<?>[] types, String assumptionName) {
            assert (types != null);
            this.assumption = (OptimizedAssumption)Assumption.create((String)assumptionName);
            this.types = types;
        }

        public OptimizedAssumption getAssumption() {
            return this.assumption;
        }

        public Class<?>[] getTypes() {
            return this.types;
        }
    }

    public static final class ReturnProfile {
        private static final String RETURN_TYPE_ASSUMPTION_NAME = "Profiled Return Type";
        private static final ReturnProfile INVALID = new ReturnProfile();
        final OptimizedAssumption assumption;
        final Class<?> type;

        private ReturnProfile() {
            this.assumption = (OptimizedAssumption)Assumption.NEVER_VALID;
            this.type = null;
        }

        private ReturnProfile(Class<?> type) {
            assert (type != null);
            this.assumption = (OptimizedAssumption)Assumption.create((String)RETURN_TYPE_ASSUMPTION_NAME);
            this.type = type;
        }

        public OptimizedAssumption getAssumption() {
            return this.assumption;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

