/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.debug;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import com.oracle.truffle.runtime.AbstractCompilationTask;
import com.oracle.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import java.util.LinkedHashMap;

public final class TraceCompilationPolymorphismListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceCompilationPolymorphismListener(OptimizedTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(OptimizedTruffleRuntime runtime) {
        runtime.addListener(new TraceCompilationPolymorphismListener(runtime));
    }

    @Override
    public void onCompilationSuccess(final OptimizedCallTarget target, AbstractCompilationTask task, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        if (target.getOptionValue(OptimizedRuntimeOptions.TraceCompilationPolymorphism).booleanValue()) {
            target.accept(new NodeVisitor(){

                public boolean visit(Node node) {
                    if (node != null && (node.getCost() == NodeCost.MEGAMORPHIC || node.getCost() == NodeCost.POLYMORPHIC)) {
                        NodeCost cost = node.getCost();
                        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
                        props.put("simpleName", node.getClass().getSimpleName());
                        props.put("subtree", "\n" + NodeUtil.printCompactTreeToString((Node)node));
                        String msg = cost == NodeCost.MEGAMORPHIC ? "megamorphic" : "polymorphic";
                        TraceCompilationPolymorphismListener.this.runtime.logEvent(target, 0, msg, node.toString(), props, null);
                    }
                    return true;
                }
            });
        }
    }
}

