/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;

final class SLEvaluateLocalNode
extends RootNode {
    private final TruffleString variable;
    private final MaterializedFrame inspectFrame;

    SLEvaluateLocalNode(SLLanguage language, TruffleString variableName, MaterializedFrame frame) {
        super((TruffleLanguage)language);
        this.variable = variableName;
        this.inspectFrame = frame;
    }

    public Object execute(VirtualFrame currentFrame) {
        FrameDescriptor frameDescriptor = this.inspectFrame.getFrameDescriptor();
        for (int i = 0; i < frameDescriptor.getNumberOfSlots(); ++i) {
            if (!this.variable.equals(frameDescriptor.getSlotName(i))) continue;
            return this.inspectFrame.getValue(i);
        }
        return null;
    }
}

