/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.runtime.SLLanguageView;

public class SLException
extends AbstractTruffleException {
    private static final long serialVersionUID = -6799734410727348507L;
    private static final InteropLibrary UNCACHED_LIB = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    @CompilerDirectives.TruffleBoundary
    public SLException(String message, Node location) {
        super(message, location);
    }

    @CompilerDirectives.TruffleBoundary
    public static SLException typeError(Node operation, Object ... values) {
        NodeInfo nodeInfo;
        SourceSection ss;
        StringBuilder result = new StringBuilder();
        result.append("Type error");
        if (operation != null && (ss = operation.getEncapsulatingSourceSection()) != null && ss.isAvailable()) {
            result.append(" at ").append(ss.getSource().getName()).append(" line ").append(ss.getStartLine()).append(" col ").append(ss.getStartColumn());
        }
        result.append(": operation");
        if (operation != null && (nodeInfo = SLLanguage.lookupNodeInfo(operation.getClass())) != null) {
            result.append(" \"").append(nodeInfo.shortName()).append("\"");
        }
        result.append(" not defined for");
        String sep = " ";
        for (int i = 0; i < values.length; ++i) {
            Object value = SLLanguageView.forValue(values[i]);
            result.append(sep);
            sep = ", ";
            if (value == null) {
                result.append("ANY");
                continue;
            }
            InteropLibrary valueLib = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
            if (valueLib.hasMetaObject(value) && !valueLib.isNull(value)) {
                String qualifiedName;
                try {
                    qualifiedName = UNCACHED_LIB.asString(UNCACHED_LIB.getMetaQualifiedName(valueLib.getMetaObject(value)));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                result.append(qualifiedName);
                result.append(" ");
            }
            if (valueLib.isString(value)) {
                result.append("\"");
            }
            result.append(valueLib.toDisplayString(value));
            if (!valueLib.isString(value)) continue;
            result.append("\"");
        }
        return new SLException(result.toString(), operation);
    }
}

