/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.sl.builtins.SLIsExecutableBuiltin;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLIsExecutableBuiltin.class)
public final class SLIsExecutableBuiltinFactory
implements NodeFactory<SLIsExecutableBuiltin> {
    private static final SLIsExecutableBuiltinFactory INSTANCE = new SLIsExecutableBuiltinFactory();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private SLIsExecutableBuiltinFactory() {
    }

    public Class<SLIsExecutableBuiltin> getNodeClass() {
        return SLIsExecutableBuiltin.class;
    }

    public List<Class<? extends Node>> getExecutionSignature() {
        return Arrays.asList(SLExpressionNode.class);
    }

    public List<List<Class<?>>> getNodeSignatures() {
        return Arrays.asList(Arrays.asList(SLExpressionNode[].class));
    }

    public SLIsExecutableBuiltin createNode(Object ... arguments) {
        if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof SLExpressionNode[])) {
            return SLIsExecutableBuiltinFactory.create((SLExpressionNode[])arguments[0]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static NodeFactory<SLIsExecutableBuiltin> getInstance() {
        return INSTANCE;
    }

    public static SLIsExecutableBuiltin create(SLExpressionNode[] arguments) {
        return new SLIsExecutableBuiltinNodeGen(arguments);
    }

    @GeneratedBy(value=SLIsExecutableBuiltin.class)
    public static final class SLIsExecutableBuiltinNodeGen
    extends SLIsExecutableBuiltin {
        @Node.Child
        private SLExpressionNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private IsExecutable0Data isExecutable0_cache;

        private SLIsExecutableBuiltinNodeGen(SLExpressionNode[] arguments) {
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        @ExplodeLoop
        protected Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.executeGeneric(frameValue);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    IsExecutable0Data s0_ = this.isExecutable0_cache;
                    while (s0_ != null) {
                        if (s0_.executables_.accepts(arguments0Value_)) {
                            return this.isExecutable(arguments0Value_, s0_.executables_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.isExecutable1Boundary(state_0, arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object isExecutable1Boundary(int state_0, Object arguments0Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary isExecutable1_executables__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                Boolean bl = this.isExecutable(arguments0Value_, isExecutable1_executables__);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                boolean bl;
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if (exclude == 0) {
                    int count0_ = 0;
                    IsExecutable0Data s0_ = this.isExecutable0_cache;
                    if ((state_0 & 1) != 0) {
                        while (s0_ != null && !s0_.executables_.accepts(arguments0Value)) {
                            s0_ = s0_.next_;
                            ++count0_;
                        }
                    }
                    if (s0_ == null && count0_ < 3) {
                        s0_ = (IsExecutable0Data)super.insert((Node)new IsExecutable0Data(this.isExecutable0_cache));
                        s0_.executables_ = s0_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arguments0Value));
                        VarHandle.storeStoreFence();
                        this.isExecutable0_cache = s0_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl2 = this.isExecutable(arguments0Value, s0_.executables_);
                        return bl2;
                    }
                }
                InteropLibrary isExecutable1_executables__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    isExecutable1_executables__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                    this.exclude_ = exclude |= 1;
                    this.isExecutable0_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    bl = this.isExecutable(arguments0Value, isExecutable1_executables__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            IsExecutable0Data s0_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.isExecutable0_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @GeneratedBy(value=SLIsExecutableBuiltin.class)
        private static final class IsExecutable0Data
        extends Node {
            @Node.Child
            IsExecutable0Data next_;
            @Node.Child
            InteropLibrary executables_;

            IsExecutable0Data(IsExecutable0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

