/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.nodes.SLEvalRootNode;
import com.oracle.truffle.sl.nodes.SLRootNode;
import com.oracle.truffle.sl.runtime.SLStrings;

@NodeInfo(shortName="stacktrace")
public abstract class SLStackTraceBuiltin
extends SLBuiltinNode {
    public static final TruffleString FRAME = SLStrings.constant("Frame: root ");
    public static final TruffleString SEPARATOR = SLStrings.constant(", ");
    public static final TruffleString EQUALS = SLStrings.constant("=");

    @Specialization
    public TruffleString trace() {
        return SLStackTraceBuiltin.createStackTrace();
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString createStackTrace() {
        final TruffleStringBuilder str = TruffleStringBuilder.create((TruffleString.Encoding)SLLanguage.STRING_ENCODING);
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Integer>(){
            private int skip = 1;

            public Integer visitFrame(FrameInstance frameInstance) {
                if (this.skip > 0) {
                    --this.skip;
                    return null;
                }
                CallTarget callTarget = frameInstance.getCallTarget();
                Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                RootNode rn = ((RootCallTarget)callTarget).getRootNode();
                if (rn.isInternal() || rn.getLanguageInfo() == null) {
                    return 1;
                }
                if (str.byteLength() > 0) {
                    str.appendStringUncached(SLStrings.fromJavaString(System.getProperty("line.separator")));
                }
                str.appendStringUncached(FRAME);
                str.appendStringUncached(SLStackTraceBuiltin.getRootNodeName(rn));
                FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
                int count = frameDescriptor.getNumberOfSlots();
                for (int i = 0; i < count; ++i) {
                    str.appendStringUncached(SEPARATOR);
                    str.appendStringUncached((TruffleString)frameDescriptor.getSlotName(i));
                    str.appendStringUncached(EQUALS);
                    str.appendStringUncached(SLStrings.fromObject(frame.getValue(i)));
                }
                return null;
            }
        });
        return str.toStringUncached();
    }

    private static TruffleString getRootNodeName(RootNode rootNode) {
        if (rootNode instanceof SLRootNode) {
            return ((SLRootNode)rootNode).getTSName();
        }
        if (rootNode instanceof SLEvalRootNode) {
            return SLEvalRootNode.getTSName();
        }
        return SLStrings.fromJavaString(rootNode.getName());
    }
}

