/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLBinaryNode;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;

@NodeInfo(shortName="==")
public abstract class SLEqualNode
extends SLBinaryNode {
    @Specialization
    protected boolean doLong(long left, long right) {
        return left == right;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected boolean doBigNumber(SLBigNumber left, SLBigNumber right) {
        return left.equals(right);
    }

    @Specialization
    protected boolean doBoolean(boolean left, boolean right) {
        return left == right;
    }

    @Specialization
    protected boolean doString(String left, String right) {
        return left.equals(right);
    }

    @Specialization
    protected boolean doTruffleString(TruffleString left, TruffleString right, @Cached TruffleString.EqualNode equalNode) {
        return equalNode.execute((AbstractTruffleString)left, (AbstractTruffleString)right, SLLanguage.STRING_ENCODING);
    }

    @Specialization
    protected boolean doNull(SLNull left, SLNull right) {
        return left == right;
    }

    @Specialization
    protected boolean doFunction(SLFunction left, Object right) {
        return left == right;
    }

    @Specialization(limit="4")
    public boolean doGeneric(Object left, Object right, @CachedLibrary(value="left") InteropLibrary leftInterop, @CachedLibrary(value="right") InteropLibrary rightInterop) {
        try {
            if (leftInterop.isBoolean(left) && rightInterop.isBoolean(right)) {
                return this.doBoolean(leftInterop.asBoolean(left), rightInterop.asBoolean(right));
            }
            if (leftInterop.isString(left) && rightInterop.isString(right)) {
                return this.doString(leftInterop.asString(left), rightInterop.asString(right));
            }
            if (leftInterop.isNull(left) && rightInterop.isNull(right)) {
                return true;
            }
            if (leftInterop.fitsInLong(left) && rightInterop.fitsInLong(right)) {
                return this.doLong(leftInterop.asLong(left), rightInterop.asLong(right));
            }
            if (left instanceof SLBigNumber && right instanceof SLBigNumber) {
                return this.doBigNumber((SLBigNumber)left, (SLBigNumber)right);
            }
            if (leftInterop.hasIdentity(left) && rightInterop.hasIdentity(right)) {
                return leftInterop.isIdentical(left, right, rightInterop);
            }
            return false;
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

