/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.nodes.SLTypesGen;
import com.oracle.truffle.sl.nodes.expression.SLEqualNode;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLEqualNode.class)
public final class SLEqualNodeGen
extends SLEqualNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private SLExpressionNode leftNode_;
    @Node.Child
    private SLExpressionNode rightNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private TruffleString.EqualNode truffleString_equalNode_;
    @Node.Child
    private Generic0Data generic0_cache;

    private SLEqualNodeGen(SLExpressionNode leftNode, SLExpressionNode rightNode) {
        this.leftNode_ = leftNode;
        this.rightNode_ = rightNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1FE) == 0 && (state_0 & 0x1FF) != 0) {
            return this.executeGeneric_long_long0(state_0, frameValue);
        }
        if ((state_0 & 0x1FB) == 0 && (state_0 & 0x1FF) != 0) {
            return this.executeGeneric_boolean_boolean1(state_0, frameValue);
        }
        return this.executeGeneric_generic2(state_0, frameValue);
    }

    private Object executeGeneric_long_long0(int state_0, VirtualFrame frameValue) {
        long rightNodeValue_;
        long leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return this.doLong(leftNodeValue_, rightNodeValue_);
    }

    private Object executeGeneric_boolean_boolean1(int state_0, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object generic1Boundary(int state_0, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary generic1_leftInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue_);
            InteropLibrary generic1_rightInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue_);
            Boolean bl = this.doGeneric(leftNodeValue_, rightNodeValue_, generic1_leftInterop__, generic1_rightInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private Object executeGeneric_generic2(int state_0, VirtualFrame frameValue) {
        Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
        Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && leftNodeValue_ instanceof Long) {
            long leftNodeValue__ = (Long)leftNodeValue_;
            if (rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                return this.doLong(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigNumber((state_0 & 0x600) >>> 9, leftNodeValue_)) {
            SLBigNumber leftNodeValue__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0x600) >>> 9, leftNodeValue_);
            if (SLTypesGen.isImplicitSLBigNumber((state_0 & 0x1800) >>> 11, rightNodeValue_)) {
                SLBigNumber rightNodeValue__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0x1800) >>> 11, rightNodeValue_);
                return this.doBigNumber(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 4) != 0 && leftNodeValue_ instanceof Boolean) {
            boolean leftNodeValue__ = (Boolean)leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__ = (Boolean)rightNodeValue_;
                return this.doBoolean(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 8) != 0 && leftNodeValue_ instanceof String) {
            String leftNodeValue__ = (String)leftNodeValue_;
            if (rightNodeValue_ instanceof String) {
                String rightNodeValue__ = (String)rightNodeValue_;
                return this.doString(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0x10) != 0 && leftNodeValue_ instanceof TruffleString) {
            TruffleString leftNodeValue__ = (TruffleString)leftNodeValue_;
            if (rightNodeValue_ instanceof TruffleString) {
                TruffleString rightNodeValue__ = (TruffleString)rightNodeValue_;
                return this.doTruffleString(leftNodeValue__, rightNodeValue__, this.truffleString_equalNode_);
            }
        }
        if ((state_0 & 0x20) != 0 && SLTypes.isSLNull(leftNodeValue_)) {
            SLNull leftNodeValue__ = SLTypes.asSLNull(leftNodeValue_);
            if (SLTypes.isSLNull(rightNodeValue_)) {
                SLNull rightNodeValue__ = SLTypes.asSLNull(rightNodeValue_);
                return this.doNull(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0x1C0) != 0) {
            if ((state_0 & 0x40) != 0 && leftNodeValue_ instanceof SLFunction) {
                SLFunction leftNodeValue__ = (SLFunction)leftNodeValue_;
                return this.doFunction(leftNodeValue__, rightNodeValue_);
            }
            if ((state_0 & 0x180) != 0) {
                if ((state_0 & 0x80) != 0) {
                    Generic0Data s7_ = this.generic0_cache;
                    while (s7_ != null) {
                        if (s7_.leftInterop_.accepts(leftNodeValue_) && s7_.rightInterop_.accepts(rightNodeValue_)) {
                            return this.doGeneric(leftNodeValue_, rightNodeValue_, s7_.leftInterop_, s7_.rightInterop_);
                        }
                        s7_ = s7_.next_;
                    }
                }
                if ((state_0 & 0x100) != 0) {
                    return this.generic1Boundary(state_0, leftNodeValue_, rightNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1FE) == 0 && (state_0 & 0x1FF) != 0) {
            return this.executeBoolean_long_long3(state_0, frameValue);
        }
        if ((state_0 & 0x1FB) == 0 && (state_0 & 0x1FF) != 0) {
            return this.executeBoolean_boolean_boolean4(state_0, frameValue);
        }
        return this.executeBoolean_generic5(state_0, frameValue);
    }

    private boolean executeBoolean_long_long3(int state_0, VirtualFrame frameValue) {
        long rightNodeValue_;
        long leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return this.doLong(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean4(int state_0, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean generic1Boundary0(int state_0, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary generic1_leftInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue_);
            InteropLibrary generic1_rightInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue_);
            boolean bl = this.doGeneric(leftNodeValue_, rightNodeValue_, generic1_leftInterop__, generic1_rightInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private boolean executeBoolean_generic5(int state_0, VirtualFrame frameValue) {
        Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
        Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && leftNodeValue_ instanceof Long) {
            long leftNodeValue__ = (Long)leftNodeValue_;
            if (rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                return this.doLong(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 2) != 0 && SLTypesGen.isImplicitSLBigNumber((state_0 & 0x600) >>> 9, leftNodeValue_)) {
            SLBigNumber leftNodeValue__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0x600) >>> 9, leftNodeValue_);
            if (SLTypesGen.isImplicitSLBigNumber((state_0 & 0x1800) >>> 11, rightNodeValue_)) {
                SLBigNumber rightNodeValue__ = SLTypesGen.asImplicitSLBigNumber((state_0 & 0x1800) >>> 11, rightNodeValue_);
                return this.doBigNumber(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 4) != 0 && leftNodeValue_ instanceof Boolean) {
            boolean leftNodeValue__ = (Boolean)leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__ = (Boolean)rightNodeValue_;
                return this.doBoolean(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 8) != 0 && leftNodeValue_ instanceof String) {
            String leftNodeValue__ = (String)leftNodeValue_;
            if (rightNodeValue_ instanceof String) {
                String rightNodeValue__ = (String)rightNodeValue_;
                return this.doString(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0x10) != 0 && leftNodeValue_ instanceof TruffleString) {
            TruffleString leftNodeValue__ = (TruffleString)leftNodeValue_;
            if (rightNodeValue_ instanceof TruffleString) {
                TruffleString rightNodeValue__ = (TruffleString)rightNodeValue_;
                return this.doTruffleString(leftNodeValue__, rightNodeValue__, this.truffleString_equalNode_);
            }
        }
        if ((state_0 & 0x20) != 0 && SLTypes.isSLNull(leftNodeValue_)) {
            SLNull leftNodeValue__ = SLTypes.asSLNull(leftNodeValue_);
            if (SLTypes.isSLNull(rightNodeValue_)) {
                SLNull rightNodeValue__ = SLTypes.asSLNull(rightNodeValue_);
                return this.doNull(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0x1C0) != 0) {
            if ((state_0 & 0x40) != 0 && leftNodeValue_ instanceof SLFunction) {
                SLFunction leftNodeValue__ = (SLFunction)leftNodeValue_;
                return this.doFunction(leftNodeValue__, rightNodeValue_);
            }
            if ((state_0 & 0x180) != 0) {
                if ((state_0 & 0x80) != 0) {
                    Generic0Data s7_ = this.generic0_cache;
                    while (s7_ != null) {
                        if (s7_.leftInterop_.accepts(leftNodeValue_) && s7_.rightInterop_.accepts(rightNodeValue_)) {
                            return this.doGeneric(leftNodeValue_, rightNodeValue_, s7_.leftInterop_, s7_.rightInterop_);
                        }
                        s7_ = s7_.next_;
                    }
                }
                if ((state_0 & 0x100) != 0) {
                    return this.generic1Boundary0(state_0, leftNodeValue_, rightNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            boolean bl;
            Object rightNodeValue_;
            int sLBigNumberCast1;
            int sLBigNumberCast0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if (leftNodeValue instanceof Long) {
                long leftNodeValue_ = (Long)leftNodeValue;
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_2 = (Long)rightNodeValue;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl2 = this.doLong(leftNodeValue_, rightNodeValue_2);
                    return bl2;
                }
            }
            if ((sLBigNumberCast0 = SLTypesGen.specializeImplicitSLBigNumber(leftNodeValue)) != 0) {
                SLBigNumber leftNodeValue_ = SLTypesGen.asImplicitSLBigNumber(sLBigNumberCast0, leftNodeValue);
                sLBigNumberCast1 = SLTypesGen.specializeImplicitSLBigNumber(rightNodeValue);
                if (sLBigNumberCast1 != 0) {
                    SLBigNumber rightNodeValue_3 = SLTypesGen.asImplicitSLBigNumber(sLBigNumberCast1, rightNodeValue);
                    state_0 |= sLBigNumberCast0 << 9;
                    state_0 |= sLBigNumberCast1 << 11;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl3 = this.doBigNumber(leftNodeValue_, rightNodeValue_3);
                    return bl3;
                }
            }
            if (leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_ = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_4 = (Boolean)rightNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    sLBigNumberCast1 = this.doBoolean(leftNodeValue_, rightNodeValue_4) ? 1 : 0;
                    return sLBigNumberCast1 != 0;
                }
            }
            if (leftNodeValue instanceof String) {
                String leftNodeValue_ = (String)leftNodeValue;
                if (rightNodeValue instanceof String) {
                    rightNodeValue_ = (String)rightNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    sLBigNumberCast1 = this.doString(leftNodeValue_, (String)rightNodeValue_) ? 1 : 0;
                    return sLBigNumberCast1 != 0;
                }
            }
            if (leftNodeValue instanceof TruffleString) {
                TruffleString leftNodeValue_ = (TruffleString)leftNodeValue;
                if (rightNodeValue instanceof TruffleString) {
                    rightNodeValue_ = (TruffleString)rightNodeValue;
                    this.truffleString_equalNode_ = (TruffleString.EqualNode)super.insert((Node)TruffleString.EqualNode.create());
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    sLBigNumberCast1 = this.doTruffleString(leftNodeValue_, (TruffleString)rightNodeValue_, this.truffleString_equalNode_);
                    return sLBigNumberCast1 != 0;
                }
            }
            if (SLTypes.isSLNull(leftNodeValue)) {
                SLNull leftNodeValue_ = SLTypes.asSLNull(leftNodeValue);
                if (SLTypes.isSLNull(rightNodeValue)) {
                    rightNodeValue_ = SLTypes.asSLNull(rightNodeValue);
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    sLBigNumberCast1 = this.doNull(leftNodeValue_, (SLNull)rightNodeValue_);
                    return sLBigNumberCast1 != 0;
                }
            }
            if (leftNodeValue instanceof SLFunction) {
                SLFunction leftNodeValue_ = (SLFunction)leftNodeValue;
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                boolean rightNodeValue_5 = this.doFunction(leftNodeValue_, rightNodeValue);
                return rightNodeValue_5;
            }
            if (exclude == 0) {
                int count7_ = 0;
                Generic0Data s7_ = this.generic0_cache;
                if ((state_0 & 0x80) != 0) {
                    while (!(s7_ == null || s7_.leftInterop_.accepts(leftNodeValue) && s7_.rightInterop_.accepts(rightNodeValue))) {
                        s7_ = s7_.next_;
                        ++count7_;
                    }
                }
                if (s7_ == null && count7_ < 4) {
                    s7_ = (Generic0Data)super.insert((Node)new Generic0Data(this.generic0_cache));
                    s7_.leftInterop_ = s7_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(leftNodeValue));
                    s7_.rightInterop_ = s7_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(rightNodeValue));
                    VarHandle.storeStoreFence();
                    this.generic0_cache = s7_;
                    this.state_0_ = state_0 |= 0x80;
                }
                if (s7_ != null) {
                    lock.unlock();
                    hasLock = false;
                    sLBigNumberCast1 = this.doGeneric(leftNodeValue, rightNodeValue, s7_.leftInterop_, s7_.rightInterop_);
                    return sLBigNumberCast1 != 0;
                }
            }
            InteropLibrary generic1_rightInterop__ = null;
            InteropLibrary generic1_leftInterop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                generic1_leftInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue);
                generic1_rightInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue);
                this.exclude_ = exclude |= 1;
                this.generic0_cache = null;
                state_0 &= 0xFFFFFF7F;
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                bl = this.doGeneric(leftNodeValue, rightNodeValue, generic1_leftInterop__, generic1_rightInterop__);
            }
            catch (Throwable throwable) {
                encapsulating_.set(prev_);
                throw throwable;
            }
            encapsulating_.set(prev_);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        Generic0Data s7_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x1FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x1FF & (state_0 & 0x1FF) - 1) == 0 && ((s7_ = this.generic0_cache) == null || s7_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SLEqualNode create(SLExpressionNode leftNode, SLExpressionNode rightNode) {
        return new SLEqualNodeGen(leftNode, rightNode);
    }

    @GeneratedBy(value=SLEqualNode.class)
    private static final class Generic0Data
    extends Node {
        @Node.Child
        Generic0Data next_;
        @Node.Child
        InteropLibrary leftInterop_;
        @Node.Child
        InteropLibrary rightInterop_;

        Generic0Data(Generic0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

