/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;

public abstract class SLShortCircuitNode
extends SLExpressionNode {
    @Node.Child
    private SLExpressionNode left;
    @Node.Child
    private SLExpressionNode right;
    private final ConditionProfile evaluateRightProfile = ConditionProfile.createCountingProfile();

    public SLShortCircuitNode(SLExpressionNode left, SLExpressionNode right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public final Object executeGeneric(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public final boolean executeBoolean(VirtualFrame frame) {
        boolean rightValue;
        boolean leftValue;
        try {
            leftValue = this.left.executeBoolean(frame);
        }
        catch (UnexpectedResultException e) {
            throw SLException.typeError(this, e.getResult(), null);
        }
        try {
            rightValue = this.evaluateRightProfile.profile(this.isEvaluateRight(leftValue)) ? this.right.executeBoolean(frame) : false;
        }
        catch (UnexpectedResultException e) {
            throw SLException.typeError(this, leftValue, e.getResult());
        }
        return this.execute(leftValue, rightValue);
    }

    protected abstract boolean isEvaluateRight(boolean var1);

    protected abstract boolean execute(boolean var1, boolean var2);
}

