/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.local;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLRootNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBlockNode;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNode;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;
import com.oracle.truffle.sl.runtime.SLStrings;

@ExportLibrary(value=NodeLibrary.class)
public abstract class SLScopedNode
extends Node {
    @CompilerDirectives.CompilationFinal
    private volatile int visibleVariablesIndexOnEnter = -1;
    @CompilerDirectives.CompilationFinal
    private volatile int visibleVariablesIndexOnExit = -1;

    @ExportMessage
    boolean accepts(@Cached.Shared(value="node") @Cached(value="this", adopt=false) SLScopedNode cachedNode) {
        return this == cachedNode;
    }

    @ExportMessage
    public boolean hasScope(Frame frame) {
        return true;
    }

    @ExportMessage
    final Object getScope(Frame frame, boolean nodeEnter, @Cached.Shared(value="node") @Cached(value="this", adopt=false) SLScopedNode cachedNode, @Cached(value="this.findBlock()", adopt=false, allowUncached=true) Node blockNode) {
        if (blockNode instanceof SLBlockNode) {
            return new VariablesObject(frame, cachedNode, nodeEnter, (SLBlockNode)blockNode);
        }
        return new ArgumentsObject(frame, (SLRootNode)blockNode);
    }

    @ExportMessage
    final boolean hasRootInstance(Frame frame) {
        return this.hasRootInstanceSlowPath();
    }

    @CompilerDirectives.TruffleBoundary
    private boolean hasRootInstanceSlowPath() {
        return SLContext.get(this).getFunctionRegistry().getFunction(SLStrings.getSLRootName(this.getRootNode())) != null;
    }

    @ExportMessage
    final Object getRootInstance(Frame frame) throws UnsupportedMessageException {
        return this.getRootInstanceSlowPath();
    }

    @CompilerDirectives.TruffleBoundary
    private Object getRootInstanceSlowPath() throws UnsupportedMessageException {
        SLFunction function = SLContext.get(this).getFunctionRegistry().getFunction(SLStrings.getSLRootName(this.getRootNode()));
        if (function != null) {
            return function;
        }
        throw UnsupportedMessageException.create();
    }

    public final Node findBlock() {
        Node parent = this.getParent();
        while (parent != null && !(parent instanceof SLBlockNode)) {
            Node p = parent.getParent();
            if (p == null) {
                assert (parent instanceof RootNode) : String.format("Not adopted node under %s.", parent);
                return parent;
            }
            parent = p;
        }
        return parent;
    }

    public final void setVisibleVariablesIndexOnEnter(int index) {
        assert (this.visibleVariablesIndexOnEnter == -1) : "The index is set just once";
        assert (0 <= index);
        this.visibleVariablesIndexOnEnter = index;
    }

    public final void setVisibleVariablesIndexOnExit(int index) {
        assert (this.visibleVariablesIndexOnExit == -1) : "The index is set just once";
        assert (0 <= index);
        this.visibleVariablesIndexOnExit = index;
    }

    protected final int getVisibleVariablesIndexOnEnter() {
        return this.visibleVariablesIndexOnEnter;
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Key
    implements TruffleObject {
        private final SLWriteLocalVariableNode writeNode;

        Key(SLWriteLocalVariableNode writeNode) {
            this.writeNode = writeNode;
        }

        @ExportMessage
        boolean isString() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        String asString() {
            return this.writeNode.getSlotName().toJavaStringUncached();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        TruffleString asTruffleString() {
            return this.writeNode.getSlotName();
        }

        @ExportMessage
        boolean hasSourceLocation() {
            return this.writeNode.getNameNode().getSourceCharIndex() >= 0;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        SourceSection getSourceLocation() throws UnsupportedMessageException {
            if (!this.hasSourceLocation()) {
                throw UnsupportedMessageException.create();
            }
            SLExpressionNode nameNode = this.writeNode.getNameNode();
            return this.writeNode.getRootNode().getSourceSection().getSource().createSection(nameNode.getSourceCharIndex(), nameNode.getSourceLength());
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class KeysArray
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final SLWriteLocalVariableNode[] writeNodes;
        private final int variableIndex;
        private final int parentBlockIndex;

        KeysArray(SLWriteLocalVariableNode[] writeNodes, int variableIndex, int parentBlockIndex) {
            this.writeNodes = writeNodes;
            this.variableIndex = variableIndex;
            this.parentBlockIndex = parentBlockIndex;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.writeNodes.length - this.parentBlockIndex + this.variableIndex;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)(this.writeNodes.length - this.parentBlockIndex + this.variableIndex);
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create((long)index);
            }
            if (index < (long)this.variableIndex) {
                return new Key(this.writeNodes[(int)index]);
            }
            return new Key(this.writeNodes[(int)index - this.variableIndex + this.parentBlockIndex]);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VariablesObject
    implements TruffleObject {
        static int LIMIT = 4;
        private final Frame frame;
        protected final SLScopedNode node;
        final boolean nodeEnter;
        protected final SLBlockNode block;

        VariablesObject(Frame frame, SLScopedNode node, boolean nodeEnter, SLBlockNode blockNode) {
            this.frame = frame;
            this.node = node;
            this.nodeEnter = nodeEnter;
            this.block = blockNode;
        }

        @ExportMessage
        boolean accepts(@Cached(value="this.node", adopt=false) SLScopedNode cachedNode, @Cached(value="this.nodeEnter") boolean cachedNodeEnter) {
            return this.node == cachedNode && this.nodeEnter == cachedNodeEnter;
        }

        @ExportMessage
        boolean isScope() {
            return true;
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return SLLanguage.class;
        }

        @ExportMessage
        Object toDisplayString(boolean allowSideEffects, @Cached.Shared(value="block") @Cached(value="this.block", adopt=false) SLBlockNode cachedBlock, @Cached.Shared(value="parentBlock") @Cached(value="this.block.findBlock()", adopt=false, allowUncached=true) Node parentBlock) {
            if (parentBlock instanceof SLBlockNode) {
                return "block";
            }
            return ((SLRootNode)parentBlock).getTSName();
        }

        @ExportMessage
        boolean hasScopeParent(@Cached.Shared(value="block") @Cached(value="this.block", adopt=false) SLBlockNode cachedBlock, @Cached.Shared(value="parentBlock") @Cached(value="this.block.findBlock()", adopt=false, allowUncached=true) Node parentBlock) {
            return parentBlock instanceof SLBlockNode;
        }

        @ExportMessage
        Object getScopeParent(@Cached.Shared(value="block") @Cached(value="this.block", adopt=false) SLBlockNode cachedBlock, @Cached.Shared(value="parentBlock") @Cached(value="this.block.findBlock()", adopt=false, allowUncached=true) Node parentBlock) throws UnsupportedMessageException {
            if (!(parentBlock instanceof SLBlockNode)) {
                throw UnsupportedMessageException.create();
            }
            return new VariablesObject(this.frame, cachedBlock, true, (SLBlockNode)parentBlock);
        }

        @ExportMessage
        boolean hasSourceLocation() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        SourceSection getSourceLocation() {
            Node parentBlock = this.block.findBlock();
            if (parentBlock instanceof RootNode) {
                assert (parentBlock instanceof SLRootNode) : String.format("In SLLanguage we expect SLRootNode, not %s", parentBlock.getClass());
                return ((SLRootNode)parentBlock).getSourceSection();
            }
            return this.block.getSourceSection();
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        boolean isMemberInsertable(String member) {
            return false;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal, @Cached(value="this.block.getDeclaredLocalVariables()", adopt=false, dimensions=1, allowUncached=true) SLWriteLocalVariableNode[] writeNodes, @Cached(value="this.getVisibleVariablesIndex()", allowUncached=true) int visibleVariablesIndex, @Cached(value="this.block.getParentBlockIndex()", allowUncached=true) int parentBlockIndex) {
            return new KeysArray(writeNodes, visibleVariablesIndex, parentBlockIndex);
        }

        int getVisibleVariablesIndex() {
            assert (this.node.visibleVariablesIndexOnEnter >= 0);
            assert (this.node.visibleVariablesIndexOnExit >= 0);
            return this.nodeEnter ? this.node.visibleVariablesIndexOnEnter : this.node.visibleVariablesIndexOnExit;
        }

        boolean hasWriteNode(String member) {
            return this.findWriteNode(member) != null;
        }

        int findSlot(String member) {
            SLWriteLocalVariableNode writeNode = this.findWriteNode(member);
            if (writeNode != null) {
                return writeNode.getSlot();
            }
            return -1;
        }

        SLWriteLocalVariableNode findWriteNode(String member) {
            SLWriteLocalVariableNode writeNode;
            int i;
            TruffleString memberTS = SLStrings.fromJavaString(member);
            SLWriteLocalVariableNode[] writeNodes = this.block.getDeclaredLocalVariables();
            int parentBlockIndex = this.block.getParentBlockIndex();
            int index = this.getVisibleVariablesIndex();
            for (i = 0; i < index; ++i) {
                writeNode = writeNodes[i];
                if (!memberTS.equalsUncached((AbstractTruffleString)writeNode.getSlotName(), SLLanguage.STRING_ENCODING)) continue;
                return writeNode;
            }
            for (i = parentBlockIndex; i < writeNodes.length; ++i) {
                writeNode = writeNodes[i];
                if (!memberTS.equalsUncached((AbstractTruffleString)writeNode.getSlotName(), SLLanguage.STRING_ENCODING)) continue;
                return writeNode;
            }
            return null;
        }

        @ExportMessage(name="writeMember")
        static final class WriteMember {
            WriteMember() {
            }

            @Specialization(limit="LIMIT", guards={"cachedMember.equals(member)"})
            static void doCached(VariablesObject receiver, String member, Object value, @Cached(value="member") String cachedMember, @Cached(value="receiver.findWriteNode(member)", adopt=false) SLWriteLocalVariableNode writeNode) throws UnknownIdentifierException, UnsupportedMessageException {
                WriteMember.doWrite(receiver, cachedMember, writeNode, value);
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static void doGeneric(VariablesObject receiver, String member, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
                SLWriteLocalVariableNode writeNode = receiver.findWriteNode(member);
                WriteMember.doWrite(receiver, member, writeNode, value);
            }

            private static void doWrite(VariablesObject receiver, String member, SLWriteLocalVariableNode writeNode, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
                if (writeNode == null) {
                    throw UnknownIdentifierException.create((String)member);
                }
                if (receiver.frame == null) {
                    throw UnsupportedMessageException.create();
                }
                writeNode.executeWrite((VirtualFrame)receiver.frame, value);
            }
        }

        @ExportMessage(name="readMember")
        static final class ReadMember {
            ReadMember() {
            }

            @Specialization(limit="LIMIT", guards={"cachedMember.equals(member)"})
            static Object doCached(VariablesObject receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="receiver.findSlot(member)") int slot) throws UnknownIdentifierException {
                return ReadMember.doRead(receiver, cachedMember, slot);
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static Object doGeneric(VariablesObject receiver, String member) throws UnknownIdentifierException {
                int slot = receiver.findSlot(member);
                return ReadMember.doRead(receiver, member, slot);
            }

            private static Object doRead(VariablesObject receiver, String member, int slot) throws UnknownIdentifierException {
                if (slot == -1) {
                    throw UnknownIdentifierException.create((String)member);
                }
                if (receiver.frame != null) {
                    return receiver.frame.getValue(slot);
                }
                return SLNull.SINGLETON;
            }
        }

        @ExportMessage(name="isMemberModifiable")
        static final class ModifiableMember {
            ModifiableMember() {
            }

            @Specialization(limit="LIMIT", guards={"cachedMember.equals(member)"})
            static boolean doCached(VariablesObject receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="receiver.hasWriteNode(member)") boolean cachedResult) {
                return cachedResult && receiver.frame != null;
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static boolean doGeneric(VariablesObject receiver, String member) {
                return receiver.hasWriteNode(member) && receiver.frame != null;
            }
        }

        @ExportMessage(name="isMemberReadable")
        static final class ExistsMember {
            ExistsMember() {
            }

            @Specialization(limit="LIMIT", guards={"cachedMember.equals(member)"})
            static boolean doCached(VariablesObject receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="doGeneric(receiver, member)") boolean cachedResult) {
                assert (cachedResult == ExistsMember.doGeneric(receiver, member));
                return cachedResult;
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static boolean doGeneric(VariablesObject receiver, String member) {
                return receiver.hasWriteNode(member);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ArgumentsObject
    implements TruffleObject {
        static int LIMIT = 3;
        private final Frame frame;
        protected final SLRootNode root;

        ArgumentsObject(Frame frame, SLRootNode root) {
            this.frame = frame;
            this.root = root;
        }

        @ExportMessage
        boolean accepts(@Cached(value="this.root", adopt=false) SLRootNode cachedRoot) {
            return this.root == cachedRoot;
        }

        @ExportMessage
        boolean isScope() {
            return true;
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return SLLanguage.class;
        }

        @ExportMessage
        Object toDisplayString(boolean allowSideEffects) {
            return this.root.getTSName();
        }

        @ExportMessage
        boolean hasSourceLocation() {
            return true;
        }

        @ExportMessage
        SourceSection getSourceLocation() {
            return this.root.getSourceSection();
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            SLWriteLocalVariableNode[] writeNodes = this.root.getDeclaredArguments();
            return new KeysArray(writeNodes, writeNodes.length, writeNodes.length);
        }

        @ExportMessage
        boolean isMemberInsertable(String member) {
            return false;
        }

        boolean hasArgumentIndex(String member) {
            return this.findArgumentIndex(member) >= 0;
        }

        int findArgumentIndex(String member) {
            TruffleString memberTS = SLStrings.fromJavaString(member);
            SLWriteLocalVariableNode[] writeNodes = this.root.getDeclaredArguments();
            for (int i = 0; i < writeNodes.length; ++i) {
                SLWriteLocalVariableNode writeNode = writeNodes[i];
                if (!memberTS.equalsUncached((AbstractTruffleString)writeNode.getSlotName(), SLLanguage.STRING_ENCODING)) continue;
                return i;
            }
            return -1;
        }

        @ExportMessage(name="writeMember")
        static final class WriteMember {
            WriteMember() {
            }

            @Specialization(limit="LIMIT", guards={"cachedMember.equals(member)"})
            static void doCached(ArgumentsObject receiver, String member, Object value, @Cached(value="member") String cachedMember, @Cached(value="receiver.findArgumentIndex(member)") int index) throws UnknownIdentifierException, UnsupportedMessageException {
                WriteMember.doWrite(receiver, member, index, value);
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static void doGeneric(ArgumentsObject receiver, String member, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
                int index = receiver.findArgumentIndex(member);
                WriteMember.doWrite(receiver, member, index, value);
            }

            private static void doWrite(ArgumentsObject receiver, String member, int index, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
                if (index < 0) {
                    throw UnknownIdentifierException.create((String)member);
                }
                if (receiver.frame == null) {
                    throw UnsupportedMessageException.create();
                }
                receiver.frame.getArguments()[index] = value;
            }
        }

        @ExportMessage(name="readMember")
        static final class ReadMember {
            ReadMember() {
            }

            @Specialization(limit="LIMIT", guards={"cachedMember.equals(member)"})
            static Object doCached(ArgumentsObject receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="receiver.findArgumentIndex(member)") int index) throws UnknownIdentifierException {
                return ReadMember.doRead(receiver, cachedMember, index);
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static Object doGeneric(ArgumentsObject receiver, String member) throws UnknownIdentifierException {
                int index = receiver.findArgumentIndex(member);
                return ReadMember.doRead(receiver, member, index);
            }

            private static Object doRead(ArgumentsObject receiver, String member, int index) throws UnknownIdentifierException {
                if (index < 0) {
                    throw UnknownIdentifierException.create((String)member);
                }
                if (receiver.frame != null) {
                    return receiver.frame.getArguments()[index];
                }
                return SLNull.SINGLETON;
            }
        }

        @ExportMessage(name="isMemberModifiable")
        static final class ModifiableMember {
            ModifiableMember() {
            }

            @Specialization(limit="LIMIT", guards={"cachedMember.equals(member)"})
            static boolean doCached(ArgumentsObject receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="receiver.hasArgumentIndex(member)") boolean cachedResult) {
                return cachedResult && receiver.frame != null;
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static boolean doGeneric(ArgumentsObject receiver, String member) {
                return receiver.findArgumentIndex(member) >= 0 && receiver.frame != null;
            }
        }

        @ExportMessage(name="isMemberReadable")
        static final class ExistsMember {
            ExistsMember() {
            }

            @Specialization(limit="LIMIT", guards={"cachedMember.equals(member)"})
            static boolean doCached(ArgumentsObject receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="doGeneric(receiver, member)") boolean cachedResult) {
                assert (cachedResult == ExistsMember.doGeneric(receiver, member));
                return cachedResult;
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static boolean doGeneric(ArgumentsObject receiver, String member) {
                return receiver.hasArgumentIndex(member);
            }
        }
    }
}

