/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.local;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLTypesGen;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLWriteLocalVariableNode.class)
public final class SLWriteLocalVariableNodeGen
extends SLWriteLocalVariableNode {
    private final int slot;
    private final SLExpressionNode nameNode;
    private final boolean declaration;
    @Node.Child
    private SLExpressionNode valueNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private SLWriteLocalVariableNodeGen(SLExpressionNode valueNode, int slot, SLExpressionNode nameNode, boolean declaration) {
        this.slot = slot;
        this.nameNode = nameNode;
        this.declaration = declaration;
        this.valueNode_ = valueNode;
    }

    @Override
    protected int getSlot() {
        return this.slot;
    }

    @Override
    protected SLExpressionNode getNameNode() {
        return this.nameNode;
    }

    @Override
    public boolean isDeclaration() {
        return this.declaration;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 6) == 0 && state_0 != 0) {
            return this.executeGeneric_long0(state_0, frameValue);
        }
        if ((state_0 & 5) == 0 && state_0 != 0) {
            return this.executeGeneric_boolean1(state_0, frameValue);
        }
        return this.executeGeneric_generic2(state_0, frameValue);
    }

    private Object executeGeneric_long0(int state_0, VirtualFrame frameValue) {
        long valueNodeValue_;
        try {
            valueNodeValue_ = this.valueNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        if (this.isLongOrIllegal(frameValue)) {
            return this.writeLong(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valueNodeValue_);
    }

    private Object executeGeneric_boolean1(int state_0, VirtualFrame frameValue) {
        boolean valueNodeValue_;
        try {
            valueNodeValue_ = this.valueNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        if (this.isBooleanOrIllegal(frameValue)) {
            return this.writeBoolean(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valueNodeValue_);
    }

    private Object executeGeneric_generic2(int state_0, VirtualFrame frameValue) {
        Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && valueNodeValue_ instanceof Long) {
            long valueNodeValue__ = (Long)valueNodeValue_;
            if (this.isLongOrIllegal(frameValue)) {
                return this.writeLong(frameValue, valueNodeValue__);
            }
        }
        if ((state_0 & 2) != 0 && valueNodeValue_ instanceof Boolean) {
            boolean valueNodeValue__ = (Boolean)valueNodeValue_;
            if (this.isBooleanOrIllegal(frameValue)) {
                return this.writeBoolean(frameValue, valueNodeValue__);
            }
        }
        if ((state_0 & 4) != 0) {
            return this.write(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valueNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean valueNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 4) != 0) {
            return SLTypesGen.expectBoolean(this.executeGeneric(frameValue));
        }
        try {
            valueNodeValue_ = this.valueNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return SLTypesGen.expectBoolean(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 2) != 0 && this.isBooleanOrIllegal(frameValue)) {
            return this.writeBoolean(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLTypesGen.expectBoolean(this.executeAndSpecialize(frameValue, valueNodeValue_));
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        long valueNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 4) != 0) {
            return SLTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        try {
            valueNodeValue_ = this.valueNode_.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return SLTypesGen.expectLong(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 1) != 0 && this.isLongOrIllegal(frameValue)) {
            return this.writeLong(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return SLTypesGen.expectLong(this.executeAndSpecialize(frameValue, valueNodeValue_));
    }

    @Override
    public void executeWrite(VirtualFrame frameValue, Object valueNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && valueNodeValue instanceof Long) {
            long valueNodeValue_ = (Long)valueNodeValue;
            if (this.isLongOrIllegal(frameValue)) {
                this.writeLong(frameValue, valueNodeValue_);
                return;
            }
        }
        if ((state_0 & 2) != 0 && valueNodeValue instanceof Boolean) {
            boolean valueNodeValue_ = (Boolean)valueNodeValue;
            if (this.isBooleanOrIllegal(frameValue)) {
                this.writeBoolean(frameValue, valueNodeValue_);
                return;
            }
        }
        if ((state_0 & 4) != 0) {
            this.write(frameValue, valueNodeValue);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, valueNodeValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 6) == 0 && state_0 != 0) {
                this.executeLong(frameValue);
                return;
            }
            if ((state_0 & 5) == 0 && state_0 != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.executeGeneric(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if ((exclude & 1) == 0 && valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                if (this.isLongOrIllegal(frameValue)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Long l = this.writeLong(frameValue, valueNodeValue_);
                    return l;
                }
            }
            if ((exclude & 2) == 0 && valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                if (this.isBooleanOrIllegal(frameValue)) {
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = this.writeBoolean(frameValue, valueNodeValue_);
                    return bl;
                }
            }
            this.exclude_ = exclude |= 3;
            state_0 &= 0xFFFFFFFC;
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            Object object = this.write(frameValue, valueNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SLWriteLocalVariableNode create(SLExpressionNode valueNode, int slot, SLExpressionNode nameNode, boolean declaration) {
        return new SLWriteLocalVariableNodeGen(valueNode, slot, nameNode, declaration);
    }
}

