/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;
import com.oracle.truffle.sl.runtime.SLStrings;

@TypeSystemReference(value=SLTypes.class)
@GenerateUncached
public abstract class SLToTruffleStringNode
extends Node {
    static final int LIMIT = 5;
    private static final TruffleString TRUE = SLStrings.constant("true");
    private static final TruffleString FALSE = SLStrings.constant("false");
    private static final TruffleString FOREIGN_OBJECT = SLStrings.constant("[foreign object]");

    public abstract TruffleString execute(Object var1);

    @Specialization
    protected static TruffleString fromNull(SLNull value) {
        return SLStrings.NULL;
    }

    @Specialization
    protected static TruffleString fromString(String value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return fromJavaStringNode.execute(value, SLLanguage.STRING_ENCODING);
    }

    @Specialization
    protected static TruffleString fromTruffleString(TruffleString value) {
        return value;
    }

    @Specialization
    protected static TruffleString fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static TruffleString fromLong(long value, @Cached TruffleString.FromLongNode fromLongNode) {
        return fromLongNode.execute(value, SLLanguage.STRING_ENCODING, true);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static TruffleString fromBigNumber(SLBigNumber value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return fromJavaStringNode.execute(value.toString(), SLLanguage.STRING_ENCODING);
    }

    @Specialization
    protected static TruffleString fromFunction(SLFunction value) {
        return value.getName();
    }

    @Specialization(limit="LIMIT")
    protected static TruffleString fromInterop(Object value, @CachedLibrary(value="value") InteropLibrary interop, @Cached TruffleString.FromLongNode fromLongNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        try {
            if (interop.fitsInLong(value)) {
                return fromLongNode.execute(interop.asLong(value), SLLanguage.STRING_ENCODING, true);
            }
            if (interop.isString(value)) {
                return fromJavaStringNode.execute(interop.asString(value), SLLanguage.STRING_ENCODING);
            }
            if (interop.isNumber(value) && value instanceof SLBigNumber) {
                return fromJavaStringNode.execute(SLToTruffleStringNode.bigNumberToString((SLBigNumber)value), SLLanguage.STRING_ENCODING);
            }
            if (interop.isNull(value)) {
                return SLStrings.NULL_LC;
            }
            return FOREIGN_OBJECT;
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String bigNumberToString(SLBigNumber value) {
        return value.toString();
    }
}

