/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.runtime.SLBigNumber;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;

@TypeSystemReference(value=SLTypes.class)
@NodeChild
public abstract class SLUnboxNode
extends SLExpressionNode {
    static final int LIMIT = 5;

    @Specialization
    protected static TruffleString fromString(String value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return fromJavaStringNode.execute(value, SLLanguage.STRING_ENCODING);
    }

    @Specialization
    protected static TruffleString fromTruffleString(TruffleString value) {
        return value;
    }

    @Specialization
    protected static boolean fromBoolean(boolean value) {
        return value;
    }

    @Specialization
    protected static long fromLong(long value) {
        return value;
    }

    @Specialization
    protected static SLBigNumber fromBigNumber(SLBigNumber value) {
        return value;
    }

    @Specialization
    protected static SLFunction fromFunction(SLFunction value) {
        return value;
    }

    @Specialization
    protected static SLNull fromFunction(SLNull value) {
        return value;
    }

    @Specialization(limit="LIMIT")
    public static Object fromForeign(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        try {
            if (interop.fitsInLong(value)) {
                return interop.asLong(value);
            }
            if (interop.fitsInDouble(value)) {
                return (long)interop.asDouble(value);
            }
            if (interop.isString(value)) {
                return interop.asTruffleString(value);
            }
            if (interop.isBoolean(value)) {
                return interop.asBoolean(value);
            }
            return value;
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

