/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.sl.runtime.SLFunction;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SLFunction.class)
final class SLFunctionGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private SLFunctionGen() {
    }

    static {
        LibraryExport.register(SLFunction.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=SLFunction.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, SLFunction.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof SLFunction);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof SLFunction);
            return new Cached();
        }

        @GeneratedBy(value=SLFunction.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof SLFunction) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SLFunction;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SLFunction arg0Value = (SLFunction)arg0Value_;
                if (arg1Value instanceof SLFunction) {
                    SLFunction arg1Value_ = (SLFunction)arg1Value;
                    return SLFunction.IsIdenticalOrUndefined.doSLFunction(arg0Value, arg1Value_);
                }
                return SLFunction.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SLFunction arg0Value = (SLFunction)arg0Value_;
                return SLFunction.Execute.doIndirect(arg0Value, arg1Value, IndirectCallNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLFunction)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLFunction)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLFunction)receiver).getSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLFunction)receiver).hasSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLFunction)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLFunction)receiver).hasMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLFunction)receiver).getMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return SLFunction.identityHashCode((SLFunction)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLFunction)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=SLFunction.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private ExecuteDirectData execute_direct_cache;
            @Node.Child
            private IndirectCallNode execute_indirect_callNode_;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof SLFunction) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SLFunction;
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                SLFunction arg0Value = (SLFunction)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof SLFunction) {
                        SLFunction arg1Value_ = (SLFunction)arg1Value;
                        return SLFunction.IsIdenticalOrUndefined.doSLFunction(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && Cached.isIdenticalOrUndefinedFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return SLFunction.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TriState isIdenticalOrUndefinedAndSpecialize(SLFunction arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int state_0 = this.state_0_;
                    if (arg1Value instanceof SLFunction) {
                        SLFunction arg1Value_ = (SLFunction)arg1Value;
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        TriState triState = SLFunction.IsIdenticalOrUndefined.doSLFunction(arg0Value, arg1Value_);
                        return triState;
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    TriState triState = SLFunction.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    return triState;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @ExplodeLoop
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                SLFunction arg0Value = (SLFunction)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0) {
                        ExecuteDirectData s0_ = this.execute_direct_cache;
                        while (s0_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s0_.callTargetStable_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeDirect_((Object)s0_);
                                return this.executeAndSpecialize(arg0Value, arg1Value);
                            }
                            if (arg0Value.getCallTarget() == s0_.cachedTarget_) {
                                return SLFunction.Execute.doDirect(arg0Value, arg1Value, s0_.callTargetStable_, s0_.cachedTarget_, s0_.callNode_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        return SLFunction.Execute.doIndirect(arg0Value, arg1Value, this.execute_indirect_callNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(SLFunction arg0Value, Object[] arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int oldCacheCount;
                    int oldExclude;
                    int oldState_0;
                    block16: {
                        int state_0 = this.state_0_;
                        int exclude = this.exclude_;
                        oldState_0 = state_0 & 0xC;
                        oldExclude = exclude;
                        oldCacheCount = this.execute_countCaches();
                        try {
                            if (exclude != 0) break block16;
                            int count0_ = 0;
                            ExecuteDirectData s0_ = this.execute_direct_cache;
                            if ((state_0 & 4) != 0) {
                                while (!(s0_ == null || arg0Value.getCallTarget() == s0_.cachedTarget_ && Assumption.isValidAssumption((Assumption)s0_.callTargetStable_))) {
                                    s0_ = s0_.next_;
                                    ++count0_;
                                }
                            }
                            if (s0_ == null) {
                                Assumption callTargetStable__;
                                Assumption assumption0;
                                RootCallTarget cachedTarget__ = arg0Value.getCallTarget();
                                if (arg0Value.getCallTarget() == cachedTarget__ && Assumption.isValidAssumption((Assumption)(assumption0 = (callTargetStable__ = arg0Value.getCallTargetStable()))) && count0_ < 2) {
                                    s0_ = (ExecuteDirectData)super.insert((Node)new ExecuteDirectData(this.execute_direct_cache));
                                    s0_.callTargetStable_ = callTargetStable__;
                                    s0_.cachedTarget_ = cachedTarget__;
                                    s0_.callNode_ = s0_.insertAccessor(DirectCallNode.create((CallTarget)cachedTarget__));
                                    VarHandle.storeStoreFence();
                                    this.execute_direct_cache = s0_;
                                    this.state_0_ = state_0 |= 4;
                                }
                            }
                            if (s0_ == null) break block16;
                            lock.unlock();
                            hasLock = false;
                            Object object = SLFunction.Execute.doDirect(arg0Value, arg1Value, s0_.callTargetStable_, s0_.cachedTarget_, s0_.callNode_);
                            if (oldState_0 != 0 || oldExclude != 0) {
                                this.execute_checkForPolymorphicSpecialize(oldState_0, oldExclude, oldCacheCount);
                            }
                            return object;
                        }
                        catch (Throwable throwable) {
                            if (oldState_0 != 0 || oldExclude != 0) {
                                this.execute_checkForPolymorphicSpecialize(oldState_0, oldExclude, oldCacheCount);
                            }
                            throw throwable;
                        }
                    }
                    this.execute_indirect_callNode_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                    this.exclude_ = exclude |= 1;
                    this.execute_direct_cache = null;
                    state_0 &= 0xFFFFFFFB;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = SLFunction.Execute.doIndirect(arg0Value, arg1Value, this.execute_indirect_callNode_);
                    if (oldState_0 != 0 || oldExclude != 0) {
                        this.execute_checkForPolymorphicSpecialize(oldState_0, oldExclude, oldCacheCount);
                    }
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            private void execute_checkForPolymorphicSpecialize(int oldState_0, int oldExclude, int oldCacheCount) {
                int newState_0 = this.state_0_ & 0xC;
                int newExclude = this.exclude_;
                if ((oldState_0 ^ newState_0) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.execute_countCaches()) {
                    this.reportPolymorphicSpecialize();
                }
            }

            private int execute_countCaches() {
                int cacheCount = 0;
                ExecuteDirectData s0_ = this.execute_direct_cache;
                while (s0_ != null) {
                    ++cacheCount;
                    s0_ = s0_.next_;
                }
                return cacheCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeDirect_(Object s0_) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    ExecuteDirectData prev = null;
                    ExecuteDirectData cur = this.execute_direct_cache;
                    while (cur != null) {
                        if (cur == s0_) {
                            if (prev == null) {
                                this.execute_direct_cache = cur.next_;
                                this.adoptChildren();
                                break;
                            }
                            prev.next_ = cur.next_;
                            prev.adoptChildren();
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.execute_direct_cache == null) {
                        this.state_0_ &= 0xFFFFFFFB;
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SLFunction)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SLFunction)receiver).getLanguage();
            }

            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SLFunction)receiver).getSourceLocation();
            }

            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SLFunction)receiver).hasSourceLocation();
            }

            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SLFunction)receiver).isExecutable();
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SLFunction)receiver).hasMetaObject();
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SLFunction)receiver).getMetaObject();
            }

            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return SLFunction.identityHashCode((SLFunction)receiver);
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SLFunction)receiver).toDisplayString(allowSideEffects);
            }

            private static boolean isIdenticalOrUndefinedFallbackGuard_(int state_0, SLFunction arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof SLFunction);
            }

            @GeneratedBy(value=SLFunction.class)
            private static final class ExecuteDirectData
            extends Node {
                @Node.Child
                ExecuteDirectData next_;
                @CompilerDirectives.CompilationFinal
                Assumption callTargetStable_;
                @CompilerDirectives.CompilationFinal
                RootCallTarget cachedTarget_;
                @Node.Child
                DirectCallNode callNode_;

                ExecuteDirectData(ExecuteDirectData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

