/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.tests.TestContext;
import com.oracle.truffle.tck.tests.TestRun;
import com.oracle.truffle.tck.tests.TestUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.tck.Snippet;
import org.graalvm.polyglot.tck.TypeDescriptor;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ErrorTypeTest {
    private static final TestUtil.CollectingMatcher<TestRun> TEST_RESULT_MATCHER = TestUtil.createTooManyFailuresMatcher();
    private static TestContext context;
    private final TestRun testRun;

    @Parameterized.Parameters(name="{0}")
    public static Collection<? extends TestRun> createErrorTypeTests() {
        context = new TestContext(ErrorTypeTest.class);
        Set<? extends String> requiredLanguages = TestUtil.getRequiredLanguages(context);
        TreeSet<TestRun> testRuns = new TreeSet<TestRun>(Comparator.comparing(TestRun::toString));
        for (String string : requiredLanguages) {
            Collection<? extends Snippet> snippets = context.getExpressions(null, null, string);
            Map<String, Collection<? extends Snippet>> overloads = ErrorTypeTest.computeOverloads(snippets);
            ErrorTypeTest.computeSnippets(string, snippets, overloads, testRuns);
            snippets = context.getStatements(null, null, string);
            overloads = ErrorTypeTest.computeOverloads(snippets);
            ErrorTypeTest.computeSnippets(string, snippets, overloads, testRuns);
        }
        if (testRuns.isEmpty()) {
            ErrorTypeTest.afterClass();
        }
        return testRuns;
    }

    @BeforeClass
    public static void setUpClass() {
        TestUtil.assertNoCurrentContext();
    }

    @AfterClass
    public static void afterClass() {
        context.close();
        context = null;
    }

    private static void computeSnippets(String snippetLanguage, Collection<? extends Snippet> snippets, Map<String, Collection<? extends Snippet>> overloads, Collection<? super TestRun> collector) {
        Set<? extends String> requiredValueLanguages = TestUtil.getRequiredValueLanguages(context);
        for (Snippet snippet : snippets) {
            for (String string : requiredValueLanguages) {
                if (snippetLanguage.equals(string)) continue;
                TreeSet<Map.Entry<String, ? extends Snippet>> valueConstructors = new TreeSet<Map.Entry<String, ? extends Snippet>>(Comparator.comparing(a -> ((Snippet)a.getValue()).getId()));
                for (Snippet snippet2 : context.getValueConstructors(null, string)) {
                    valueConstructors.add(new AbstractMap.SimpleImmutableEntry<String, Snippet>(string, snippet2));
                }
                List<List<Map.Entry<String, ? extends Snippet>>> applicableParams = TestUtil.findApplicableParameters(snippet, valueConstructors);
                if (applicableParams.isEmpty()) continue;
                ArrayList<? extends Snippet> arrayList = new ArrayList<Snippet>(overloads.get(snippet.getId()));
                arrayList.remove(snippet);
                ErrorTypeTest.computeAllInvalidPermutations(new AbstractMap.SimpleImmutableEntry<String, Snippet>(snippetLanguage, snippet), applicableParams, valueConstructors, arrayList, collector);
            }
        }
    }

    private static Map<String, Collection<? extends Snippet>> computeOverloads(Collection<? extends Snippet> snippets) {
        HashMap<String, Collection<? extends Snippet>> res = new HashMap<String, Collection<? extends Snippet>>();
        for (Snippet snippet : snippets) {
            res.computeIfAbsent(snippet.getId(), id -> new ArrayList()).add(snippet);
        }
        return res;
    }

    private static void computeAllInvalidPermutations(Map.Entry<String, ? extends Snippet> operator, List<List<Map.Entry<String, ? extends Snippet>>> applicableArgs, Collection<Map.Entry<String, ? extends Snippet>> allValueConstructors, Collection<? extends Snippet> overloads, Collection<? super TestRun> collector) {
        for (int i = 0; i < applicableArgs.size(); ++i) {
            HashSet<Map.Entry<String, ? extends Snippet>> nonApplicableArgs = new HashSet<Map.Entry<String, ? extends Snippet>>(allValueConstructors);
            nonApplicableArgs.removeAll((Collection)applicableArgs.get(i));
            if (nonApplicableArgs.isEmpty()) continue;
            ArrayList<List<Map.Entry<String, ? extends Snippet>>> args = new ArrayList<List<Map.Entry<String, ? extends Snippet>>>(applicableArgs.size());
            boolean canBeInvoked = true;
            for (int j = 0; j < applicableArgs.size(); ++j) {
                if (i == j) {
                    args.add(new ArrayList<Map.Entry<String, ? extends Snippet>>(nonApplicableArgs));
                    continue;
                }
                List<Map.Entry<String, ? extends Snippet>> slotArgs = applicableArgs.get(j);
                if (slotArgs.isEmpty()) {
                    canBeInvoked = false;
                    break;
                }
                args.add(Collections.singletonList(ErrorTypeTest.findBestApplicableArg(slotArgs, overloads, j)));
            }
            if (!canBeInvoked) continue;
            ArrayList tmp = new ArrayList();
            TestUtil.computeAllPermutations(operator, args, tmp);
            if (!overloads.isEmpty()) {
                Iterator it = tmp.iterator();
                while (it.hasNext()) {
                    TestRun test = (TestRun)it.next();
                    boolean remove = false;
                    for (Snippet snippet : overloads) {
                        if (!ErrorTypeTest.areParametersAssignable(snippet.getParameterTypes(), test.getActualParameterTypes())) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    it.remove();
                }
            }
            collector.addAll(tmp);
        }
    }

    private static Map.Entry<String, ? extends Snippet> findBestApplicableArg(List<Map.Entry<String, ? extends Snippet>> applicableTypes, Collection<? extends Snippet> overloads, int parameterIndex) {
        Iterator<Map.Entry<String, ? extends Snippet>> it = applicableTypes.iterator();
        ArrayList<TypeDescriptor> overloadsTypes = new ArrayList<TypeDescriptor>();
        for (Snippet snippet : overloads) {
            List params = snippet.getParameterTypes();
            if (parameterIndex >= params.size()) continue;
            overloadsTypes.add((TypeDescriptor)params.get(parameterIndex));
        }
        Map.Entry<String, ? extends Snippet> bestSoFar = it.next();
        while (ErrorTypeTest.isCoveredByOverload(bestSoFar, overloadsTypes) && it.hasNext()) {
            bestSoFar = it.next();
        }
        return bestSoFar;
    }

    private static boolean isCoveredByOverload(Map.Entry<String, ? extends Snippet> value, Collection<? extends TypeDescriptor> overloadsTypes) {
        TypeDescriptor valueType = value.getValue().getReturnType();
        for (TypeDescriptor typeDescriptor : overloadsTypes) {
            if (!typeDescriptor.isAssignable(valueType)) continue;
            return true;
        }
        return false;
    }

    private static boolean areParametersAssignable(List<? extends TypeDescriptor> into, List<? extends TypeDescriptor> from) {
        if (into.size() != from.size()) {
            return false;
        }
        for (int i = 0; i < into.size(); ++i) {
            if (into.get(i).isAssignable(from.get(i))) continue;
            return false;
        }
        return true;
    }

    public ErrorTypeTest(TestRun testRun) {
        Objects.requireNonNull(testRun);
        this.testRun = testRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorType() {
        Assume.assumeThat((Object)this.testRun, TEST_RESULT_MATCHER);
        boolean passed = false;
        try {
            PolyglotException polyglotException = null;
            try {
                this.testRun.getSnippet().getExecutableValue().execute(this.testRun.getActualParameters().toArray());
            }
            catch (PolyglotException e) {
                polyglotException = e;
            }
            catch (IllegalArgumentException e) {
                polyglotException = (PolyglotException)((Object)context.getContext().asValue((Object)e).as(PolyglotException.class));
            }
            if (polyglotException != null) {
                try {
                    TestUtil.validateResult(this.testRun, polyglotException);
                }
                catch (AssertionError | PolyglotException e) {
                    if (polyglotException.equals(e)) {
                        passed = true;
                    }
                    throw new AssertionError(TestUtil.formatErrorMessage("Unexpected Exception: " + ((Throwable)e).getMessage() + ", expected: " + polyglotException.getMessage(), this.testRun, context), (Throwable)e);
                }
            }
            if (!passed) {
                throw new AssertionError((Object)TestUtil.formatErrorMessage("Expected PolyglotException, but executed successfully.", this.testRun, context));
            }
        }
        finally {
            TEST_RESULT_MATCHER.accept(new AbstractMap.SimpleImmutableEntry<TestRun, Boolean>(this.testRun, passed));
        }
    }
}

