/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.common.inline.InlineVerifier;
import com.oracle.truffle.tck.tests.InlineTestRun;
import com.oracle.truffle.tck.tests.TestContext;
import com.oracle.truffle.tck.tests.TestRun;
import com.oracle.truffle.tck.tests.TestUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.InlineSnippet;
import org.graalvm.polyglot.tck.Snippet;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InlineExecutionTest {
    private static final TestUtil.CollectingMatcher<TestRun> TEST_RESULT_MATCHER = TestUtil.createTooManyFailuresMatcher();
    private static TestContext context;
    private final InlineTestRun testRun;

    @Parameterized.Parameters(name="{0}")
    public static Collection<InlineTestRun> createScriptTests() {
        context = new TestContext(InlineExecutionTest.class);
        TreeSet<InlineTestRun> res = new TreeSet<InlineTestRun>(Comparator.comparing(TestRun::toString));
        for (String string : TestUtil.getRequiredLanguages(context)) {
            for (InlineSnippet inlineSnippet : context.getInlineScripts(string)) {
                res.add(new InlineTestRun(new AbstractMap.SimpleImmutableEntry<String, Snippet>(string, inlineSnippet.getScript()), inlineSnippet));
            }
        }
        if (res.isEmpty()) {
            InlineExecutionTest.afterClass();
        }
        return res;
    }

    @BeforeClass
    public static void setUpClass() {
        TestUtil.assertNoCurrentContext();
    }

    @AfterClass
    public static void afterClass() {
        context.close();
        context = null;
    }

    public InlineExecutionTest(InlineTestRun testRun) {
        Objects.requireNonNull(testRun);
        this.testRun = testRun;
    }

    @Test
    public void testInline() throws Exception {
        Assume.assumeThat((Object)this.testRun, TEST_RESULT_MATCHER);
        boolean success = false;
        InlineSnippet inlineSnippet = this.testRun.getInlineSnippet();
        TestResultVerifier verifier = this.testRun.getInlineSnippet().getResultVerifier() != null ? new TestResultVerifier() : null;
        context.getContext().initialize(this.testRun.getID());
        context.setInlineSnippet(this.testRun.getID(), inlineSnippet, verifier);
        try {
            Value result = null;
            try {
                result = this.testRun.getSnippet().getExecutableValue().execute(this.testRun.getActualParameters().toArray());
            }
            catch (IllegalArgumentException e) {
                TestUtil.validateResult(this.testRun, (PolyglotException)((Object)context.getContext().asValue((Object)e).as(PolyglotException.class)));
                success = true;
            }
            catch (PolyglotException e) {
                TestUtil.validateResult(this.testRun, e);
                success = true;
            }
            if (result != null) {
                TestUtil.validateResult(this.testRun, result, true);
                success = true;
            }
            if (verifier != null && verifier.exception != null) {
                success = false;
                throw verifier.exception;
            }
        }
        catch (AssertionError | PolyglotException e) {
            throw new AssertionError(TestUtil.formatErrorMessage("Unexpected Exception: " + ((Throwable)e).getMessage(), this.testRun, context), (Throwable)e);
        }
        finally {
            context.setInlineSnippet(null, null, null);
            TEST_RESULT_MATCHER.accept(new AbstractMap.SimpleImmutableEntry<InlineTestRun, Boolean>(this.testRun, success));
        }
    }

    private class TestResultVerifier
    implements InlineVerifier.ResultVerifier {
        Exception exception;

        private TestResultVerifier() {
        }

        public void verify(Object ret) {
            Value result = context.getValue(ret);
            InlineSnippet inlineSnippet = InlineExecutionTest.this.testRun.getInlineSnippet();
            TestUtil.validateResult(inlineSnippet.getResultVerifier(), InlineExecutionTest.this.testRun, result, true);
        }

        public void verify(PolyglotException pe) {
            InlineSnippet inlineSnippet = InlineExecutionTest.this.testRun.getInlineSnippet();
            try {
                TestUtil.validateResult(inlineSnippet.getResultVerifier(), InlineExecutionTest.this.testRun, pe);
            }
            catch (Exception exc) {
                this.exception = exc;
            }
        }
    }
}

