/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.tests.TestContext;
import com.oracle.truffle.tck.tests.TestUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InvalidSyntaxTest {
    private static final TestUtil.CollectingMatcher<Source> TEST_RESULT_MATCHER = TestUtil.createTooManyFailuresMatcher();
    private static TestContext context;
    private final Source source;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> createInvalidSyntaxTests() {
        context = new TestContext(InvalidSyntaxTest.class);
        TreeSet<Object[]> result = new TreeSet<Object[]>(Comparator.comparing(a -> (String)a[0]));
        for (String string : TestUtil.getRequiredLanguages(context)) {
            for (Source src : context.getInstalledProviders().get(string).createInvalidSyntaxScripts(context.getContext())) {
                result.add(new Object[]{String.format("%s::%s", string, src.getName()), src});
            }
        }
        if (result.isEmpty()) {
            InvalidSyntaxTest.afterClass();
        }
        return result;
    }

    @BeforeClass
    public static void setUpClass() {
        TestUtil.assertNoCurrentContext();
    }

    @AfterClass
    public static void afterClass() {
        context.close();
        context = null;
    }

    public InvalidSyntaxTest(String testName, Source source) {
        Objects.requireNonNull(testName);
        Objects.requireNonNull(source);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSyntax() {
        Assume.assumeThat((Object)this.source, TEST_RESULT_MATCHER);
        boolean exception = false;
        boolean syntaxErrot = false;
        boolean hasSourceSection = false;
        try {
            try {
                context.getContext().eval(this.source);
            }
            catch (PolyglotException e) {
                exception = true;
                syntaxErrot = e.isSyntaxError();
                boolean bl = hasSourceSection = e.getSourceLocation() != null;
            }
            if (!exception) {
                throw new AssertionError((Object)"Expected exception.");
            }
            if (!syntaxErrot) {
                throw new AssertionError((Object)"Exception should be a syntax error.");
            }
            if (!hasSourceSection) {
                throw new AssertionError((Object)"Syntax error should have a SourceSection.");
            }
        }
        finally {
            TEST_RESULT_MATCHER.accept(new AbstractMap.SimpleImmutableEntry<Source, Boolean>(this.source, exception));
        }
    }
}

