/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyDate;
import org.graalvm.polyglot.proxy.ProxyDuration;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyHashMap;
import org.graalvm.polyglot.proxy.ProxyIterable;
import org.graalvm.polyglot.proxy.ProxyIterator;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.graalvm.polyglot.proxy.ProxyTime;
import org.graalvm.polyglot.proxy.ProxyTimeZone;
import org.graalvm.polyglot.tck.LanguageProvider;
import org.graalvm.polyglot.tck.Snippet;
import org.graalvm.polyglot.tck.TypeDescriptor;

public final class JavaHostLanguageProvider
implements LanguageProvider {
    private static final String ID = "java-host";

    public String getId() {
        return ID;
    }

    public Collection<? extends Snippet> createValueConstructors(Context context) {
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        HashMap<Class, Primitive> primitives = new HashMap<Class, Primitive>();
        primitives.put(Boolean.class, Primitive.create("boolean", false, TypeDescriptor.BOOLEAN));
        primitives.put(Byte.class, Primitive.create("byte", (byte)-128, TypeDescriptor.NUMBER));
        primitives.put(Short.class, Primitive.create("short", (short)Short.MIN_VALUE, TypeDescriptor.NUMBER));
        primitives.put(Character.class, Primitive.create("char", Character.valueOf(' '), TypeDescriptor.STRING));
        primitives.put(Integer.class, Primitive.create("int", Integer.MIN_VALUE, TypeDescriptor.NUMBER));
        primitives.put(Long.class, Primitive.create("long", Long.MIN_VALUE, TypeDescriptor.NUMBER));
        primitives.put(Float.class, Primitive.create("float", Float.valueOf(Float.MAX_VALUE), TypeDescriptor.NUMBER));
        primitives.put(Double.class, Primitive.create("double", Double.MAX_VALUE, TypeDescriptor.NUMBER));
        primitives.put(String.class, Primitive.create("java.lang.String", "TEST", TypeDescriptor.STRING));
        primitives.put(Instant.class, Primitive.create("java.time.Instant", Instant.now(), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.DATE, TypeDescriptor.TIME, TypeDescriptor.TIME_ZONE})));
        primitives.put(LocalDate.class, Primitive.create("java.time.LocalDate", LocalDate.now(), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.DATE})));
        primitives.put(LocalTime.class, Primitive.create("java.time.LocalTime", LocalTime.now(), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.TIME})));
        primitives.put(LocalDateTime.class, Primitive.create("java.time.LocalDateTime", LocalDateTime.now(), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.TIME, TypeDescriptor.DATE})));
        primitives.put(ZonedDateTime.class, Primitive.create("java.time.ZonedDateTime", ZonedDateTime.now(), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.TIME, TypeDescriptor.DATE, TypeDescriptor.TIME_ZONE})));
        primitives.put(ZoneId.class, Primitive.create("java.time.ZoneId", ZoneId.systemDefault(), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.TIME_ZONE})));
        primitives.put(Duration.class, Primitive.create("java.time.Duration", Duration.ofMillis(42L), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.DURATION})));
        primitives.put(ProxyDate.class, Primitive.create("ProxyDate", ProxyDate.from((LocalDate)LocalDate.now()), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.DATE})));
        primitives.put(ProxyTime.class, Primitive.create("ProxyTime", ProxyTime.from((LocalTime)LocalTime.now()), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.TIME})));
        primitives.put(ProxyTimeZone.class, Primitive.create("ProxyTimeZone", ProxyTimeZone.from((ZoneId)ZoneId.of("UTC")), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.TIME_ZONE})));
        primitives.put(ProxyDuration.class, Primitive.create("ProxyDuration", ProxyDuration.from((Duration)Duration.ofMillis(100L)), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.DURATION})));
        primitives.put(Throwable.class, Primitive.create("java.lang.Throwable", new RuntimeException(), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.EXCEPTION})));
        primitives.put(Class.class, Primitive.create("Float.class", Float.class, TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.META_OBJECT})));
        for (Primitive[] primitive : primitives.values()) {
            result.add(JavaHostLanguageProvider.createPrimitive(context, (Primitive)primitive));
        }
        result.add(Snippet.newBuilder((String)"Array<int>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<int[]>(new int[]{1, 2})), (TypeDescriptor)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)).build());
        result.add(Snippet.newBuilder((String)"Array<java.lang.Object>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object[]>(new Object[]{1, "TEST"})), (TypeDescriptor)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}))).build());
        result.add(JavaHostLanguageProvider.createProxyArray(context, null));
        for (Primitive[] primitive : primitives.values()) {
            result.add(JavaHostLanguageProvider.createProxyArray(context, (Primitive)primitive));
        }
        result.add(Snippet.newBuilder((String)"Iterable<int>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new IterableImpl(1, 2))), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER)})).build());
        result.add(Snippet.newBuilder((String)"Iterable<java.lang.Object>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new IterableImpl(1, "TEST"))), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}))})).build());
        result.add(Snippet.newBuilder((String)"Proxy<Iterable<int>>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<ProxyIterable>(ProxyIterable.from((Iterable)new IterableImpl(1, 2)))), (TypeDescriptor)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER)).build());
        result.add(Snippet.newBuilder((String)"Proxy<Iterable<java.lang.Object>>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<ProxyIterable>(ProxyIterable.from((Iterable)new IterableImpl(1, "TEST")))), (TypeDescriptor)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}))).build());
        result.add(Snippet.newBuilder((String)"Iterator<int>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new IteratorImpl(1, 2))), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER)})).build());
        result.add(Snippet.newBuilder((String)"Iterator<java.lang.Object>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new IteratorImpl(1, "TEST"))), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}))})).build());
        result.add(Snippet.newBuilder((String)"Proxy<Iterator<int>>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<ProxyIterator>(ProxyIterator.from((Iterator)new IteratorImpl(1, 2)))), (TypeDescriptor)TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER)).build());
        result.add(Snippet.newBuilder((String)"Proxy<Iterator<java.lang.Object>>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<ProxyIterator>(ProxyIterator.from((Iterator)new IteratorImpl(1, "TEST")))), (TypeDescriptor)TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}))).build());
        result.add(Snippet.newBuilder((String)"Map<int,string>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(Collections.singletonMap(1, "string"))), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING)})).build());
        result.add(Snippet.newBuilder((String)"Proxy<HashMap<int,string>>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<ProxyHashMap>(ProxyHashMap.from(Collections.singletonMap(1, "string")))), (TypeDescriptor)TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING)).build());
        result.add(Snippet.newBuilder((String)"Map.Entry<int,string>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new AbstractMap.SimpleEntry<Integer, String>(1, "string"))), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.array((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}))})).build());
        result.add(Snippet.newBuilder((String)"HeapByteBuffer", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(ByteBuffer.wrap(new byte[]{1, 2, 3}))), (TypeDescriptor)TypeDescriptor.OBJECT).build());
        result.add(Snippet.newBuilder((String)"HeapByteBufferR", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(ByteBuffer.wrap(new byte[]{1, 2, 3}).asReadOnlyBuffer())), (TypeDescriptor)TypeDescriptor.OBJECT).build());
        result.add(Snippet.newBuilder((String)"Proxy<java.lang.Object{}>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<ProxyObject>(ProxyObject.fromMap(Collections.emptyMap()))), (TypeDescriptor)TypeDescriptor.OBJECT).build());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "test");
        result.add(Snippet.newBuilder((String)"Proxy<java.lang.Object{name}>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<ProxyObject>(ProxyObject.fromMap(props))), (TypeDescriptor)TypeDescriptor.OBJECT).build());
        result.add(Snippet.newBuilder((String)"ProxyExecutable<...>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new ProxyExecutableImpl())), (TypeDescriptor)TypeDescriptor.EXECUTABLE).build());
        result.add(Snippet.newBuilder((String)"ProxyExecutable<>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new ProxyExecutableImpl(ProxyExecutableImpl.EMPTY, 0))), (TypeDescriptor)TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[0])).build());
        for (Primitive primitive : new Primitive[]{(Primitive)primitives.get(Boolean.class), (Primitive)primitives.get(Integer.class), (Primitive)primitives.get(String.class)}) {
            result.add(JavaHostLanguageProvider.createProxyExecutable(context, primitive));
        }
        result.add(Snippet.newBuilder((String)"java.lang.Object", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new Object())), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT})).build());
        result.add(Snippet.newBuilder((String)"POJO", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new Complex(1.0, 2.0))), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT})).build());
        result.add(Snippet.newBuilder((String)"java.util.List<Integer>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new ArrayList<Integer>(Arrays.asList(1, 2)))), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)})).build());
        Function<Object, Object> func = new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return t;
            }
        };
        result.add(Snippet.newBuilder((String)"java.util.function.Function<Object,Object>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(func)), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (boolean)false, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ANY})})).build());
        result.add(Snippet.newBuilder((String)"java.lang.Class<java.lang.Object>", (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(Object.class)), (TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.META_OBJECT, TypeDescriptor.OBJECT, TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT}), (boolean)false, (TypeDescriptor[])new TypeDescriptor[0])})).build());
        return Collections.unmodifiableCollection(result);
    }

    public Value createIdentityFunction(Context context) {
        return context.asValue((Object)new ProxyExecutable(){

            public Object execute(Value ... arguments) {
                return arguments[0];
            }
        });
    }

    public Collection<? extends Snippet> createExpressions(Context context) {
        return Collections.emptyList();
    }

    public Collection<? extends Snippet> createStatements(Context context) {
        return Collections.emptyList();
    }

    public Collection<? extends Snippet> createScripts(Context context) {
        return Collections.emptySet();
    }

    public Collection<? extends Source> createInvalidSyntaxScripts(Context context) {
        return Collections.emptySet();
    }

    private static Snippet createPrimitive(Context context, Primitive primitive) {
        return Snippet.newBuilder((String)primitive.name, (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(primitive.value)), (TypeDescriptor)primitive.type).build();
    }

    private static Snippet createProxyArray(Context context, Primitive primitive) {
        return Snippet.newBuilder((String)String.format("Proxy<Array<%s>>", primitive == null ? "" : primitive.name), (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<ProxyArray>(primitive == null ? ProxyArray.fromArray((Object[])new Object[0]) : ProxyArray.fromArray((Object[])new Object[]{primitive.value, primitive.value}))), (TypeDescriptor)(primitive == null ? TypeDescriptor.array((TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ARRAY, TypeDescriptor.BOOLEAN, TypeDescriptor.EXECUTABLE, TypeDescriptor.HOST_OBJECT, TypeDescriptor.NATIVE_POINTER, TypeDescriptor.NULL, TypeDescriptor.NUMBER, TypeDescriptor.OBJECT, TypeDescriptor.STRING})) : TypeDescriptor.array((TypeDescriptor)primitive.type))).build();
    }

    private static Snippet createProxyExecutable(Context context, Primitive primitive) {
        return Snippet.newBuilder((String)String.format("ProxyExecutable<%s,%s>", primitive.name, primitive.name), (Value)JavaHostLanguageProvider.export(context, new ValueSupplier<Object>(new ProxyExecutableImpl(primitive, 2))), (TypeDescriptor)TypeDescriptor.executable((TypeDescriptor)primitive.type, (TypeDescriptor[])new TypeDescriptor[]{primitive.type, primitive.type})).build();
    }

    private static Value export(Context context, Supplier<Object> s) {
        return context.asValue(s);
    }

    public static final class IterableImpl
    implements Iterable<Object> {
        private final Object[] values;

        IterableImpl(Object ... values) {
            this.values = values;
        }

        @Override
        public Iterator<Object> iterator() {
            return new IteratorImpl(this.values);
        }
    }

    public static final class IteratorImpl
    implements Iterator<Object> {
        private final Object[] values;
        private int index;

        IteratorImpl(Object ... values) {
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.values.length;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.values[this.index++];
        }
    }

    public static final class Complex {
        public double real;
        public double imag;

        Complex(double real, double imag) {
            this.real = real;
            this.imag = imag;
        }

        public double abs() {
            return Math.sqrt(this.real * this.real + this.imag * this.imag);
        }
    }

    private static final class ProxyExecutableImpl
    implements ProxyExecutable {
        private static final Consumer<? super Value> EMPTY = new Consumer<Value>(){

            @Override
            public void accept(Value t) {
            }
        };
        private Consumer<? super Value> verifier;
        private final int arity;

        ProxyExecutableImpl() {
            this(EMPTY, -1);
        }

        ProxyExecutableImpl(Primitive primitive, int arity) {
            this(ProxyExecutableImpl.createVerifier(primitive), arity);
        }

        ProxyExecutableImpl(Consumer<? super Value> verifier, int arity) {
            Objects.requireNonNull(verifier);
            this.verifier = verifier;
            this.arity = arity;
        }

        public Object execute(Value ... arguments) {
            if (this.arity > arguments.length) {
                throw new AssertionError((Object)String.format("Not enought arguments, required: %d, given: %d", this.arity, arguments.length));
            }
            for (int i = 0; i < this.arity; ++i) {
                this.verifier.accept((Value)arguments[i]);
            }
            return null;
        }

        private static Consumer<? super Value> createVerifier(Primitive primitive) {
            if (TypeDescriptor.NUMBER == primitive.type) {
                return new Consumer<Value>(){

                    @Override
                    public void accept(Value value) {
                        if (!value.isNumber()) {
                            throw new AssertionError((Object)String.format("Expected NUMBER, got: %s", value));
                        }
                        if (value.fitsInByte()) {
                            value.asByte();
                        }
                        if (value.fitsInInt()) {
                            value.asInt();
                        }
                        if (value.fitsInLong()) {
                            value.asLong();
                        }
                        if (value.fitsInFloat()) {
                            value.asFloat();
                        }
                        if (value.fitsInDouble()) {
                            value.asDouble();
                        }
                    }
                };
            }
            if (TypeDescriptor.BOOLEAN == primitive.type) {
                return new Consumer<Value>(){

                    @Override
                    public void accept(Value value) {
                        value.asBoolean();
                    }
                };
            }
            if (TypeDescriptor.STRING == primitive.type) {
                return new Consumer<Value>(){

                    @Override
                    public void accept(Value value) {
                        value.asString();
                    }
                };
            }
            return EMPTY;
        }
    }

    private static final class Primitive {
        final String name;
        final Object value;
        final TypeDescriptor type;

        private Primitive(String name, Object value, TypeDescriptor type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }

        static Primitive create(String name, Object value, TypeDescriptor type) {
            return new Primitive(name, value, type);
        }
    }

    private static final class ValueSupplier<T>
    implements Supplier<T> {
        private final T value;

        ValueSupplier(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

