/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.tests.TestContext;
import com.oracle.truffle.tck.tests.TestRun;
import com.oracle.truffle.tck.tests.TestUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.Snippet;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ScriptTest {
    private static final TestUtil.CollectingMatcher<TestRun> TEST_RESULT_MATCHER = TestUtil.createTooManyFailuresMatcher();
    private static TestContext context;
    private final TestRun testRun;

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestRun> createScriptTests() {
        context = new TestContext(ScriptTest.class);
        TreeSet<TestRun> res = new TreeSet<TestRun>(Comparator.comparing(TestRun::toString));
        for (String string : TestUtil.getRequiredLanguages(context)) {
            for (Snippet snippet : context.getScripts(null, string)) {
                res.add(new TestRun(new AbstractMap.SimpleImmutableEntry<String, Snippet>(string, snippet), Collections.emptyList()));
            }
        }
        if (res.isEmpty()) {
            ScriptTest.afterClass();
        }
        return res;
    }

    @BeforeClass
    public static void setUpClass() {
        TestUtil.assertNoCurrentContext();
    }

    @AfterClass
    public static void afterClass() {
        context.close();
        context = null;
    }

    public ScriptTest(TestRun testRun) {
        Objects.requireNonNull(testRun);
        this.testRun = testRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScript() {
        Assume.assumeThat((Object)this.testRun, TEST_RESULT_MATCHER);
        boolean success = false;
        try {
            Value result = null;
            try {
                result = this.testRun.getSnippet().getExecutableValue().execute(this.testRun.getActualParameters().toArray());
            }
            catch (IllegalArgumentException e) {
                TestUtil.validateResult(this.testRun, (PolyglotException)((Object)context.getContext().asValue((Object)e).as(PolyglotException.class)));
                success = true;
            }
            catch (PolyglotException e) {
                TestUtil.validateResult(this.testRun, e);
                success = true;
            }
            if (result != null) {
                TestUtil.validateResult(this.testRun, result, true);
                success = true;
            }
        }
        finally {
            TEST_RESULT_MATCHER.accept(new AbstractMap.SimpleImmutableEntry<TestRun, Boolean>(this.testRun, success));
        }
    }
}

