/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.tests.TestContext;
import com.oracle.truffle.tck.tests.TestRun;
import com.oracle.truffle.tck.tests.TestUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Objects;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StatementTest {
    private static final TestUtil.CollectingMatcher<TestRun> TEST_RESULT_MATCHER = TestUtil.createTooManyFailuresMatcher();
    private static TestContext context;
    private final TestRun testRun;

    @Parameterized.Parameters(name="{0}")
    public static Collection<? extends TestRun> createControlFlowTests() {
        context = new TestContext(StatementTest.class);
        Collection<? extends TestRun> testRuns = TestUtil.createTestRuns(TestUtil.getRequiredLanguages(context), TestUtil.getRequiredValueLanguages(context), lang -> context.getStatements(null, null, (String)lang), lang -> context.getValueConstructors(null, (String)lang));
        if (testRuns.isEmpty()) {
            StatementTest.afterClass();
        }
        return testRuns;
    }

    @BeforeClass
    public static void setUpClass() {
        TestUtil.assertNoCurrentContext();
    }

    @AfterClass
    public static void afterClass() {
        context.close();
        context = null;
    }

    public StatementTest(TestRun testRun) {
        Objects.requireNonNull(testRun);
        this.testRun = testRun;
    }

    @Test
    public void testStatement() {
        Assume.assumeThat((Object)this.testRun, TEST_RESULT_MATCHER);
        boolean success = false;
        try {
            Value result = null;
            try {
                result = this.testRun.getSnippet().getExecutableValue().execute(this.testRun.getActualParameters().toArray());
            }
            catch (IllegalArgumentException e) {
                TestUtil.validateResult(this.testRun, (PolyglotException)((Object)context.getContext().asValue((Object)e).as(PolyglotException.class)));
                success = true;
            }
            catch (PolyglotException e) {
                TestUtil.validateResult(this.testRun, e);
                success = true;
            }
            if (result != null) {
                TestUtil.validateResult(this.testRun, result, true);
                success = true;
            }
        }
        catch (AssertionError | PolyglotException e) {
            throw new AssertionError(TestUtil.formatErrorMessage("Unexpected Exception: " + ((Throwable)e).getMessage(), this.testRun, context), (Throwable)e);
        }
        finally {
            TEST_RESULT_MATCHER.accept(new AbstractMap.SimpleImmutableEntry<TestRun, Boolean>(this.testRun, success));
        }
    }
}

