/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.common.inline.InlineVerifier;
import com.oracle.truffle.tck.tests.JavaHostLanguageProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.InlineSnippet;
import org.graalvm.polyglot.tck.LanguageProvider;
import org.graalvm.polyglot.tck.Snippet;
import org.graalvm.polyglot.tck.TypeDescriptor;
import org.junit.Assert;

final class TestContext
implements Closeable {
    private static final Object contextCacheLock = new Object();
    private static RefCountedContextReference contextCache;
    private Map<String, LanguageProvider> providers;
    private final Map<String, Collection<? extends Snippet>> valueConstructors;
    private final Map<String, Collection<? extends Snippet>> expressions;
    private final Map<String, Collection<? extends Snippet>> statements;
    private final Map<String, Collection<? extends Snippet>> scripts;
    private final Map<String, Collection<? extends InlineSnippet>> inlineScripts;
    private final boolean printOutput;
    private final boolean enableInlineVerifier;
    private Context context;
    private InlineVerifier inlineVerifier;
    private State state = State.NEW;

    TestContext(Class<?> testClass) {
        this.valueConstructors = new HashMap<String, Collection<? extends Snippet>>();
        this.expressions = new HashMap<String, Collection<? extends Snippet>>();
        this.statements = new HashMap<String, Collection<? extends Snippet>>();
        this.scripts = new HashMap<String, Collection<? extends Snippet>>();
        this.inlineScripts = new HashMap<String, Collection<? extends InlineSnippet>>();
        boolean verbose = true;
        String propValue = System.getProperty("tck.verbose");
        if (propValue != null) {
            verbose = Boolean.parseBoolean(propValue);
        }
        if ((propValue = System.getProperty(String.format("tck.%s.verbose", testClass.getSimpleName()))) != null) {
            verbose = Boolean.parseBoolean(propValue);
        }
        this.printOutput = verbose;
        propValue = System.getProperty("tck.inlineVerifierInstrument");
        this.enableInlineVerifier = propValue == null ? true : Boolean.parseBoolean(propValue);
    }

    Map<String, ? extends LanguageProvider> getInstalledProviders() {
        this.checkState(State.NEW, State.INITIALIZED);
        if (this.providers == null) {
            this.state = State.INITIALIZING;
            try {
                this.providers = TestContext.getInstalledProvidersForEngine(this.getContext().getEngine());
            }
            finally {
                this.state = State.INITIALIZED;
            }
        }
        return this.providers;
    }

    private static Map<String, LanguageProvider> getInstalledProvidersForEngine(Engine engine) {
        HashMap<String, LanguageProvider> tmpProviders = new HashMap<String, LanguageProvider>();
        Set languages = engine.getLanguages().keySet();
        for (LanguageProvider provider : ServiceLoader.load(LanguageProvider.class)) {
            String id = provider.getId();
            if (languages.contains(id) || TestContext.isHost(provider)) {
                tmpProviders.put(id, provider);
                continue;
            }
            throw new IllegalStateException("Provider " + provider.getClass().getName() + " requires a non installed language " + id + "\nInstalled languages: " + String.join((CharSequence)", ", languages));
        }
        return Collections.unmodifiableMap(tmpProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.checkState(State.NEW, State.INITIALIZED);
        this.state = State.CLOSED;
        if (this.context != null) {
            Object object = contextCacheLock;
            synchronized (object) {
                contextCache.close();
                if (!contextCache.isValid()) {
                    this.context.close();
                    contextCache = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Context getContext() {
        this.checkState(State.NEW, State.INITIALIZING, State.INITIALIZED);
        if (this.context == null) {
            Object object = contextCacheLock;
            synchronized (object) {
                Map<String, LanguageProvider> knownProviders;
                if (contextCache != null) {
                    this.context = contextCache.retain();
                    try {
                        contextCache.out().setDelegate(this.printOutput ? System.out : NullOutputStream.INSTANCE);
                        contextCache.err().setDelegate(this.printOutput ? System.err : NullOutputStream.INSTANCE);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Failed to flush stdout, stderr.", ioe);
                    }
                }
                ProxyOutputStream out = new ProxyOutputStream(this.printOutput ? System.out : NullOutputStream.INSTANCE);
                ProxyOutputStream err = new ProxyOutputStream(this.printOutput ? System.err : NullOutputStream.INSTANCE);
                try (Engine dummyCtx = Engine.newBuilder().build();){
                    knownProviders = TestContext.getInstalledProvidersForEngine(dummyCtx);
                }
                Context.Builder builder = Context.newBuilder((String[])new String[0]);
                knownProviders.forEach((id, provider) -> {
                    Map languageOptions = provider.additionalOptions();
                    TestContext.checkAdditionalOptions(languageOptions, provider.getId());
                    builder.options(languageOptions);
                });
                this.context = builder.allowExperimentalOptions(true).allowAllAccess(true).out((OutputStream)out).err((OutputStream)err).build();
                assert (contextCache == null);
                contextCache = new RefCountedContextReference(this.context, out, err);
            }
            if (this.enableInlineVerifier) {
                Instrument instrument = (Instrument)this.context.getEngine().getInstruments().get("TckVerifierInstrument");
                this.inlineVerifier = (InlineVerifier)instrument.lookup(InlineVerifier.class);
                Assert.assertNotNull((Object)this.inlineVerifier);
            }
        }
        return this.context;
    }

    Collection<? extends Snippet> getValueConstructors(TypeDescriptor type, String ... ids) {
        Objects.requireNonNull(ids);
        this.checkState(State.NEW, State.INITIALIZED);
        return this.filter(this.valueConstructors, LanguageIdPredicate.create(ids), TypePredicate.create(type, null), new Function<LanguageProvider, Collection<? extends Snippet>>(){

            @Override
            public Collection<? extends Snippet> apply(LanguageProvider tli) {
                Collection result = tli.createValueConstructors(TestContext.this.context);
                for (Snippet snippet : result) {
                    if (!snippet.getParameterTypes().isEmpty()) {
                        Assert.fail((String)("Value constructors cannot have parameters, invalid Snippet: " + snippet));
                    }
                    if (!snippet.getReturnType().isUnion()) continue;
                    Assert.fail((String)("Value constructors cannot return union types (use intersection type), invalid Snippet: " + snippet));
                }
                return result;
            }
        });
    }

    Collection<? extends Snippet> getExpressions(TypeDescriptor type, List<? extends TypeDescriptor> parameterTypes, String ... ids) {
        Objects.requireNonNull(ids);
        this.checkState(State.NEW, State.INITIALIZED);
        return this.filter(this.expressions, LanguageIdPredicate.create(ids), TypePredicate.create(type, parameterTypes), new Function<LanguageProvider, Collection<? extends Snippet>>(){

            @Override
            public Collection<? extends Snippet> apply(LanguageProvider tli) {
                return tli.createExpressions(TestContext.this.context);
            }
        });
    }

    Collection<? extends Snippet> getScripts(TypeDescriptor type, String ... ids) {
        Objects.requireNonNull(ids);
        this.checkState(State.NEW, State.INITIALIZED);
        return this.filter(this.scripts, LanguageIdPredicate.create(ids), TypePredicate.create(type, Collections.emptyList()), new Function<LanguageProvider, Collection<? extends Snippet>>(){

            @Override
            public Collection<? extends Snippet> apply(LanguageProvider tli) {
                return tli.createScripts(TestContext.this.context);
            }
        });
    }

    Collection<? extends Snippet> getStatements(TypeDescriptor type, List<? extends TypeDescriptor> parameterTypes, String ... ids) {
        Objects.requireNonNull(ids);
        this.checkState(State.NEW, State.INITIALIZED);
        return this.filter(this.statements, LanguageIdPredicate.create(ids), TypePredicate.create(type, parameterTypes), new Function<LanguageProvider, Collection<? extends Snippet>>(){

            @Override
            public Collection<? extends Snippet> apply(LanguageProvider tli) {
                return tli.createStatements(TestContext.this.context);
            }
        });
    }

    Collection<? extends InlineSnippet> getInlineScripts(String ... ids) {
        return this.filter(this.inlineScripts, LanguageIdPredicate.create(ids), new Predicate<InlineSnippet>(){

            @Override
            public boolean test(InlineSnippet s) {
                return true;
            }
        }, new Function<LanguageProvider, Collection<? extends InlineSnippet>>(){

            @Override
            public Collection<? extends InlineSnippet> apply(LanguageProvider tli) {
                return tli.createInlineScripts(TestContext.this.context);
            }
        });
    }

    private <S> Collection<? extends S> filter(final Map<String, Collection<? extends S>> cache, Predicate<Map.Entry<String, ? extends LanguageProvider>> idPredicate, Predicate<S> typePredicate, final Function<LanguageProvider, Collection<? extends S>> provider) {
        return this.getInstalledProviders().entrySet().stream().filter(idPredicate).flatMap(new Function<Map.Entry<String, ? extends LanguageProvider>, Stream<? extends S>>(){

            @Override
            public Stream<? extends S> apply(final Map.Entry<String, ? extends LanguageProvider> e) {
                return ((Collection)cache.computeIfAbsent(e.getKey(), new Function<String, Collection<? extends S>>(){

                    @Override
                    public Collection<? extends S> apply(String k) {
                        return (Collection)provider.apply((LanguageProvider)e.getValue());
                    }
                })).stream();
            }
        }).filter(typePredicate).collect(Collectors.toList());
    }

    private void checkState(State ... allowedInStates) {
        boolean allowed = false;
        for (State allowedState : allowedInStates) {
            if (this.state != allowedState) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            throw new IllegalStateException("Cannot be called in state: " + this.state);
        }
    }

    private static boolean isHost(LanguageProvider provider) {
        return provider.getClass() == JavaHostLanguageProvider.class;
    }

    private static void checkAdditionalOptions(Map<String, String> languageOptions, String languageId) {
        String prefix = languageId + ".";
        for (String key : languageOptions.keySet()) {
            if (key.startsWith(prefix)) continue;
            throw new IllegalArgumentException("Provider for language '" + languageId + "' attempts to set option " + key);
        }
    }

    Value getValue(Object object) {
        return this.context.asValue(object);
    }

    void setInlineSnippet(String languageId, InlineSnippet inlineSnippet, InlineVerifier.ResultVerifier verifier) {
        if (this.inlineVerifier != null) {
            this.inlineVerifier.setInlineSnippet(languageId, inlineSnippet, verifier);
        }
    }

    private static final class RefCountedContextReference
    implements Closeable {
        private final ProxyOutputStream out;
        private final ProxyOutputStream err;
        private Context context;
        private int refCount;

        RefCountedContextReference(Context context, ProxyOutputStream out, ProxyOutputStream err) {
            this.context = context;
            this.refCount = 1;
            this.out = out;
            this.err = err;
        }

        ProxyOutputStream out() {
            return this.out;
        }

        ProxyOutputStream err() {
            return this.err;
        }

        Context retain() {
            if (this.refCount == 0) {
                throw new IllegalStateException("Released reference");
            }
            ++this.refCount;
            return this.context;
        }

        boolean isValid() {
            return this.refCount > 0;
        }

        @Override
        public void close() {
            if (this.refCount == 0) {
                throw new IllegalStateException("Released reference");
            }
            --this.refCount;
            if (this.refCount == 0) {
                this.context = null;
            }
        }
    }

    private static final class ProxyOutputStream
    extends OutputStream {
        private OutputStream delegate;

        ProxyOutputStream(OutputStream delegate) {
            Objects.requireNonNull(delegate, "Delegate must be non null.");
            this.delegate = delegate;
        }

        void setDelegate(OutputStream newDelegate) throws IOException {
            this.delegate.flush();
            this.delegate = newDelegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        static OutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private static final class TypePredicate
    implements Predicate<Snippet> {
        private final TypeDescriptor type;
        private final List<? extends TypeDescriptor> parameterTypes;

        private TypePredicate(TypeDescriptor type, List<? extends TypeDescriptor> parameterTypes) {
            this.type = type;
            this.parameterTypes = parameterTypes;
        }

        @Override
        public boolean test(Snippet op) {
            if (this.type != null && !op.getReturnType().isAssignable(this.type)) {
                return false;
            }
            if (this.parameterTypes != null) {
                List opParameterTypes = op.getParameterTypes();
                if (this.parameterTypes.size() != opParameterTypes.size()) {
                    return false;
                }
                for (int i = 0; i < this.parameterTypes.size(); ++i) {
                    if (((TypeDescriptor)opParameterTypes.get(i)).isAssignable(this.parameterTypes.get(i))) continue;
                    return false;
                }
            }
            return true;
        }

        static Predicate<Snippet> create(TypeDescriptor type, List<? extends TypeDescriptor> parameterTypes) {
            return new TypePredicate(type, parameterTypes);
        }
    }

    private static final class LanguageIdPredicate
    implements Predicate<Map.Entry<String, ? extends LanguageProvider>> {
        private static final Predicate<Map.Entry<String, ? extends LanguageProvider>> TRUE = new Predicate<Map.Entry<String, ? extends LanguageProvider>>(){

            @Override
            public boolean test(Map.Entry<String, ? extends LanguageProvider> e) {
                return true;
            }
        };
        private final Set<String> requiredIds = new HashSet<String>();

        private LanguageIdPredicate(String ... ids) {
            Collections.addAll(this.requiredIds, ids);
        }

        @Override
        public boolean test(Map.Entry<String, ? extends LanguageProvider> e) {
            return this.requiredIds.contains(e.getKey());
        }

        static Predicate<Map.Entry<String, ? extends LanguageProvider>> create(String ... ids) {
            return ids.length == 0 ? TRUE : new LanguageIdPredicate(ids);
        }
    }

    private static enum State {
        NEW,
        INITIALIZING,
        INITIALIZED,
        CLOSED;

    }
}

