/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.Snippet;
import org.graalvm.polyglot.tck.TypeDescriptor;

public class TestRun {
    private final Map.Entry<String, ? extends Snippet> snippet;
    private final List<Map.Entry<String, ? extends Snippet>> arguments;
    private volatile String cachedToString;

    TestRun(Map.Entry<String, ? extends Snippet> snippet, List<Map.Entry<String, ? extends Snippet>> arguments) {
        Objects.requireNonNull(snippet);
        Objects.requireNonNull(arguments);
        this.snippet = snippet;
        this.arguments = arguments;
    }

    String getID() {
        return this.snippet.getKey();
    }

    Snippet getSnippet() {
        return this.snippet.getValue();
    }

    List<? extends TypeDescriptor> getActualParameterTypes() {
        ArrayList<TypeDescriptor> res = new ArrayList<TypeDescriptor>();
        for (Map.Entry<String, ? extends Snippet> argument : this.arguments) {
            res.add(argument.getValue().getReturnType());
        }
        return res;
    }

    List<? extends Value> getActualParameters() {
        ArrayList<Value> res = new ArrayList<Value>(this.arguments.size());
        for (Map.Entry<String, ? extends Snippet> arg : this.arguments) {
            Value value = arg.getValue().getExecutableValue();
            res.add(value.execute(new Object[0]));
        }
        return res;
    }

    List<? extends Map.Entry<String, ? extends Snippet>> getActualParameterSnippets() {
        return this.arguments;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TestRun otherRun = (TestRun)obj;
        if (!this.snippet.getKey().equals(otherRun.snippet.getKey()) || !this.snippet.getValue().getId().equals(otherRun.snippet.getValue().getId()) || this.snippet.getValue().getExecutableValue() != otherRun.snippet.getValue().getExecutableValue() || this.arguments.size() != otherRun.arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            Map.Entry<String, ? extends Snippet> thisArg = this.arguments.get(i);
            Map.Entry<String, ? extends Snippet> otherArg = otherRun.arguments.get(i);
            if (thisArg.getKey().equals(otherArg.getKey()) && thisArg.getValue().getId().equals(otherArg.getValue().getId()) && thisArg.getValue().getReturnType().equals((Object)otherArg.getValue().getReturnType())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int res = 17;
        res = res * 31 + this.snippet.getKey().hashCode();
        res = res * 31 + this.snippet.getValue().getId().hashCode();
        for (Map.Entry<String, ? extends Snippet> argument : this.arguments) {
            res = res * 31 + argument.getKey().hashCode();
            res = res * 31 + argument.getValue().getId().hashCode();
        }
        return res;
    }

    public String toString() {
        String res = this.cachedToString;
        if (res == null) {
            this.cachedToString = res = this.arguments.stream().map(new Function<Map.Entry<String, ? extends Snippet>, String>(){

                @Override
                public String apply(Map.Entry<String, ? extends Snippet> e) {
                    return e.getKey() + "::" + e.getValue().getId();
                }
            }).collect(Collectors.joining(", ", this.snippet.getKey() + "::" + this.snippet.getValue().getId() + "(", ")"));
        }
        return res;
    }
}

