/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.tests.TestContext;
import com.oracle.truffle.tck.tests.TestRun;
import com.oracle.truffle.tck.tests.ValueAssert;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.ResultVerifier;
import org.graalvm.polyglot.tck.Snippet;
import org.graalvm.polyglot.tck.TypeDescriptor;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

final class TestUtil {
    private static final int MAX_FAILURES = Integer.getInteger("tck.maxFailures", 100);
    private static final String LANGUAGE = System.getProperty("tck.language");
    private static final String VALUES = System.getProperty("tck.values");

    private TestUtil() {
        throw new IllegalStateException("No instance allowed.");
    }

    static void assertNoCurrentContext() {
        try {
            Context ctx = Context.getCurrent();
            throw new AssertionError((Object)String.format("Context cannot be explicitly entered while running TCK tests. Entered context: 0x%x", ctx.hashCode()));
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    static Set<? extends String> getRequiredLanguages(TestContext context) {
        Set<String> installedProviders = context.getInstalledProviders().keySet();
        if (LANGUAGE != null && !installedProviders.contains(LANGUAGE)) {
            throw TestUtil.providerNotFound("tck.language", Collections.singleton(LANGUAGE), installedProviders);
        }
        return TestUtil.filterLanguages(context, LANGUAGE == null ? null : LANGUAGE::equals);
    }

    static Set<? extends String> getRequiredValueLanguages(TestContext context) {
        Predicate<String> predicate;
        if (VALUES != null) {
            HashSet<String> requiredValues = new HashSet<String>();
            Collections.addAll(requiredValues, VALUES.split(","));
            Set<String> installedProviders = context.getInstalledProviders().keySet();
            if (!installedProviders.containsAll(requiredValues)) {
                requiredValues.removeAll(installedProviders);
                throw TestUtil.providerNotFound("tck.values", requiredValues, installedProviders);
            }
            predicate = requiredValues::contains;
        } else {
            predicate = null;
        }
        return TestUtil.filterLanguages(context, predicate);
    }

    static <T> CollectingMatcher<T> createTooManyFailuresMatcher() {
        return new TooManyFailuresMatcher();
    }

    static Collection<? extends TestRun> createTestRuns(Set<? extends String> requiredLanguages, Set<? extends String> requiredValueLanguages, Function<String, ? extends Collection<? extends Snippet>> snippetsProvider, Function<String, ? extends Collection<? extends Snippet>> valuesProvider) {
        TreeSet<TestRun> testRuns = new TreeSet<TestRun>(Comparator.comparing(TestRun::toString));
        for (String string : requiredLanguages) {
            for (Snippet snippet : snippetsProvider.apply(string)) {
                for (String string2 : requiredValueLanguages) {
                    List<Map.Entry<String, ? extends Snippet>> param;
                    boolean bl;
                    HashSet<Map.Entry<String, ? extends Snippet>> valueConstructors = new HashSet<Map.Entry<String, ? extends Snippet>>();
                    for (Snippet snippet2 : valuesProvider.apply(string2)) {
                        valueConstructors.add(new AbstractMap.SimpleImmutableEntry<String, Snippet>(string2, snippet2));
                    }
                    List<List<Map.Entry<String, ? extends Snippet>>> applicableParams = TestUtil.findApplicableParameters(snippet, valueConstructors);
                    boolean bl2 = true;
                    Iterator<List<Map.Entry<String, ? extends Snippet>>> iterator = applicableParams.iterator();
                    while (iterator.hasNext() && (bl = !(param = iterator.next()).isEmpty())) {
                    }
                    if (!bl) continue;
                    TestUtil.computeAllPermutations(new AbstractMap.SimpleImmutableEntry<String, Snippet>(string, snippet), applicableParams, testRuns);
                }
            }
        }
        return testRuns;
    }

    static void validateResult(TestRun testRun, Value result, boolean fastAssertions) {
        ResultVerifier verifier = testRun.getSnippet().getResultVerifier();
        TestUtil.validateResult(verifier, testRun, result, fastAssertions);
    }

    static void validateResult(TestRun testRun, PolyglotException exception) {
        ResultVerifier verifier = testRun.getSnippet().getResultVerifier();
        TestUtil.validateResult(verifier, testRun, exception);
    }

    static void validateResult(ResultVerifier verifier, TestRun testRun, Value result, boolean fastAssertions) {
        verifier.accept(ResultVerifier.SnippetRun.create((Snippet)testRun.getSnippet(), testRun.getActualParameters(), (Value)result));
        TestUtil.assertValue(result, fastAssertions);
    }

    static void validateResult(ResultVerifier verifier, TestRun testRun, PolyglotException polyglotException) {
        verifier.accept(ResultVerifier.SnippetRun.create((Snippet)testRun.getSnippet(), testRun.getActualParameters(), (PolyglotException)polyglotException));
        Value exceptionObject = polyglotException.getGuestObject();
        if (exceptionObject != null) {
            TestUtil.assertValue(exceptionObject, true);
        }
    }

    private static void assertValue(Value result, boolean fastAssertions) {
        if (fastAssertions) {
            ValueAssert.assertValueFast(result);
        } else {
            ValueAssert.assertValue(result);
        }
    }

    static List<List<Map.Entry<String, ? extends Snippet>>> findApplicableParameters(Snippet operator, Collection<Map.Entry<String, ? extends Snippet>> valueConstructors) {
        List opParameterTypes = operator.getParameterTypes();
        ArrayList<List<Map.Entry<String, ? extends Snippet>>> params = new ArrayList<List<Map.Entry<String, ? extends Snippet>>>(opParameterTypes.size());
        for (int i = 0; i < opParameterTypes.size(); ++i) {
            params.add(new ArrayList());
            TypeDescriptor paramTypeDesc = (TypeDescriptor)opParameterTypes.get(i);
            for (Map.Entry<String, ? extends Snippet> constructor : valueConstructors) {
                if (!paramTypeDesc.isAssignable(constructor.getValue().getReturnType())) continue;
                ((List)params.get(i)).add(constructor);
            }
        }
        return params;
    }

    static void computeAllPermutations(Map.Entry<String, ? extends Snippet> operator, List<List<Map.Entry<String, ? extends Snippet>>> applicableParameters, Collection<? super TestRun> collector) {
        TestUtil.computeAllPermutationsImpl(operator, applicableParameters, collector, 0, new int[applicableParameters.size()]);
    }

    static String formatErrorMessage(String errorMessage, TestRun testRun, TestContext testContext) {
        Snippet paramSnippet;
        int i;
        String language = testRun.getID();
        Snippet snippet = testRun.getSnippet();
        StringBuilder message = new StringBuilder();
        message.append(String.format("Running snippet '%s' retrieved from '%s' provider (java class %s) with parameters:\n", snippet.getId(), language, testContext.getInstalledProviders().get(language).getClass().getName()));
        List<? extends Map.Entry<String, ? extends Snippet>> actualParameterSnippets = testRun.getActualParameterSnippets();
        List<? extends Value> actualParameters = testRun.getActualParameters();
        for (i = 0; i < actualParameterSnippets.size(); ++i) {
            Map.Entry<String, ? extends Snippet> actualParameterSnippet = actualParameterSnippets.get(i);
            String string = actualParameterSnippet.getKey();
            paramSnippet = actualParameterSnippet.getValue();
            Value actualParameter = actualParameters.get(i);
            message.append(String.format("'%s' from '%s' provider, value: %s (Meta Object: %s)\n", paramSnippet.getId(), string, actualParameter, actualParameter.getMetaObject()));
        }
        message.append("failed:\n");
        message.append(errorMessage);
        message.append('\n');
        message.append("Snippet: ").append(TestUtil.getSource(snippet.getExecutableValue())).append('\n');
        i = 0;
        for (Map.Entry<String, ? extends Snippet> entry : testRun.getActualParameterSnippets()) {
            paramSnippet = entry.getValue();
            message.append(String.format("Parameter %d Snippet: ", i++)).append(TestUtil.getSource(paramSnippet.getExecutableValue())).append('\n');
        }
        return message.toString();
    }

    private static CharSequence getSource(Value value) {
        SourceSection section = value.getSourceLocation();
        return section == null ? null : section.getCharacters();
    }

    private static void computeAllPermutationsImpl(Map.Entry<String, ? extends Snippet> operator, List<List<Map.Entry<String, ? extends Snippet>>> applicableArgs, Collection<? super TestRun> collector, int index, int[] selected) {
        if (index == applicableArgs.size()) {
            ArrayList<Map.Entry<String, ? extends Snippet>> args = new ArrayList<Map.Entry<String, ? extends Snippet>>(applicableArgs.size());
            for (int i = 0; i < index; ++i) {
                args.add(applicableArgs.get(i).get(selected[i]));
            }
            collector.add(new TestRun(operator, args));
        } else {
            List<Map.Entry<String, ? extends Snippet>> applicableForArg = applicableArgs.get(index);
            int i = 0;
            while (i < applicableForArg.size()) {
                selected[index] = i++;
                TestUtil.computeAllPermutationsImpl(operator, applicableArgs, collector, index + 1, selected);
            }
        }
    }

    private static Set<? extends String> filterLanguages(TestContext context, Predicate<String> predicte) {
        Set<String> installedLangs = context.getInstalledProviders().keySet();
        return predicte == null ? installedLangs : installedLangs.stream().filter(predicte).collect(Collectors.toSet());
    }

    private static IllegalStateException providerNotFound(String property, Set<String> providerIds, Set<String> installedProviders) {
        throw new IllegalStateException(String.format("Following providers %s required by the '%s' property are not installed.%nInstalled providers are %s", String.join((CharSequence)", ", providerIds), property, String.join((CharSequence)", ", installedProviders)));
    }

    private static final class TooManyFailuresMatcher<T>
    extends CollectingMatcher<T> {
        private int failures;
        private boolean loggedTooManyFailures;

        TooManyFailuresMatcher() {
        }

        public boolean matches(Object item) {
            return this.failures < MAX_FAILURES;
        }

        public void describeTo(Description description) {
            if (!this.loggedTooManyFailures) {
                this.loggedTooManyFailures = true;
                description.appendText("Too many failures.");
            }
        }

        @Override
        public void accept(Map.Entry<T, Boolean> testRun) {
            if (!testRun.getValue().booleanValue()) {
                ++this.failures;
            }
        }
    }

    static abstract class CollectingMatcher<T>
    extends BaseMatcher<T>
    implements Consumer<Map.Entry<T, Boolean>> {
        CollectingMatcher() {
        }
    }
}

