/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TruffleTCKFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            TruffleTCKFeature.registerParameterizedRunner();
            TruffleTCKFeature.registerJavaHostLanguageProvider();
            for (String testClass : TruffleTCKFeature.findTCKTests()) {
                TruffleTCKFeature.registerTCKTest(access, testClass);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void registerParameterizedRunner() throws NoSuchMethodException {
        RuntimeReflection.register((Executable[])new Executable[]{Parameterized.class.getDeclaredConstructor(Class.class)});
    }

    private static void registerJavaHostLanguageProvider() throws NoSuchMethodException {
        RuntimeReflection.register((Executable[])new Executable[]{Supplier.class.getDeclaredMethod("get", new Class[0])});
        RuntimeReflection.register((Executable[])new Executable[]{Function.class.getDeclaredMethod("apply", Object.class)});
        RuntimeReflection.register((Executable[])new Executable[]{Object.class.getDeclaredConstructor(new Class[0])});
    }

    private static void registerTCKTest(Feature.BeforeAnalysisAccess access, String testClassFqn) {
        Class testClass = access.findClassByName(testClassFqn);
        access.registerAsInHeap(testClass);
        RuntimeReflection.register((Class[])new Class[]{testClass});
        for (Constructor<?> constructor : testClass.getDeclaredConstructors()) {
            RuntimeReflection.register((Executable[])new Executable[]{constructor});
        }
        for (Executable executable : testClass.getDeclaredMethods()) {
            if (!TruffleTCKFeature.isJUnitEntryPoint((Method)executable)) continue;
            RuntimeReflection.register((Executable[])new Executable[]{executable});
        }
    }

    private static boolean isJUnitEntryPoint(Method method) {
        return method.isAnnotationPresent(After.class) || method.isAnnotationPresent(AfterClass.class) || method.isAnnotationPresent(Before.class) || method.isAnnotationPresent(BeforeClass.class) || method.isAnnotationPresent(Parameterized.Parameters.class) || method.isAnnotationPresent(Test.class);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Collection<String> findTCKTests() {
        try {
            URL resource = TruffleTCKFeature.class.getResource("TruffleTCKFeature.class");
            try (FileSystem fileSystem = "jar".equals(resource.getProtocol()) ? FileSystems.newFileSystem(resource.toURI(), Map.of()) : null;){
                Collection collection;
                block15: {
                    Path path = Path.of(resource.toURI());
                    Stream<Path> siblingResources = Files.list(path.getParent());
                    try {
                        String packageName = TruffleTCKFeature.class.getPackageName();
                        String suffix = ".class";
                        collection = siblingResources.map(Path::getFileName).map(Path::toString).filter(name -> name.endsWith("Test" + suffix)).map(name -> packageName + "." + name.substring(0, name.length() - suffix.length())).collect(Collectors.toList());
                        if (siblingResources == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (siblingResources != null) {
                            try {
                                siblingResources.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    siblingResources.close();
                }
                return collection;
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot access TruffleTCKFeature class as resource");
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot list TruffleTCKFeature class sibling resources");
        }
    }
}

