/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.tests.TestContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyHashMap;
import org.graalvm.polyglot.proxy.ProxyIterable;
import org.graalvm.polyglot.proxy.ProxyIterator;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.graalvm.polyglot.tck.TypeDescriptor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TypeDescriptorTest {
    private static final TypeDescriptor[] PREDEFINED = new TypeDescriptor[]{TypeDescriptor.ARRAY, TypeDescriptor.BOOLEAN, TypeDescriptor.HOST_OBJECT, TypeDescriptor.NATIVE_POINTER, TypeDescriptor.NULL, TypeDescriptor.NUMBER, TypeDescriptor.OBJECT, TypeDescriptor.STRING, TypeDescriptor.EXECUTABLE, TypeDescriptor.EXECUTABLE_ANY, TypeDescriptor.INSTANTIABLE, TypeDescriptor.INSTANTIABLE_ANY, TypeDescriptor.ITERATOR, TypeDescriptor.ITERABLE, TypeDescriptor.HASH, TypeDescriptor.DATE, TypeDescriptor.TIME, TypeDescriptor.TIME_ZONE, TypeDescriptor.DURATION, TypeDescriptor.META_OBJECT, TypeDescriptor.EXCEPTION};

    @BeforeClass
    public static void setUpClass() {
        TypeDescriptor noType = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[0]);
        TypeDescriptor predefinedAndNoType = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])PREDEFINED), noType});
        TypeDescriptor any = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ANY, TypeDescriptor.INSTANTIABLE, TypeDescriptor.EXECUTABLE});
        Assert.assertEquals((String)"Seems you added a new TypeDescriptor type but didn't update the TypeDescriptorTest#PREDEFINED field.", (Object)any, (Object)predefinedAndNoType);
    }

    @Test
    public void testCreate() {
        TypeDescriptor t = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.array((TypeDescriptor)TypeDescriptor.STRING), TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertEquals((Object)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.NUMBER})), (Object)t);
        t = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.array((TypeDescriptor)TypeDescriptor.STRING), TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertEquals((Object)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.array((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.NUMBER}))}), (Object)t);
        t = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ARRAY, TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertEquals((Object)TypeDescriptor.ARRAY, (Object)t);
    }

    @Test
    public void testPrimitive() {
        for (TypeDescriptor td1 : PREDEFINED) {
            for (TypeDescriptor td2 : PREDEFINED) {
                Assert.assertTrue((td1 == td2 || td1 == TypeDescriptor.EXECUTABLE_ANY && td2 == TypeDescriptor.EXECUTABLE || td1 == TypeDescriptor.INSTANTIABLE_ANY && td2 == TypeDescriptor.INSTANTIABLE || td1 == TypeDescriptor.ITERABLE && td2 == TypeDescriptor.ARRAY || !td1.isAssignable(td2) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testArray() {
        TypeDescriptor numArray = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor strArray = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor numArrayArray = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER));
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertFalse((boolean)numArray.isAssignable(td));
            Assert.assertFalse((boolean)strArray.isAssignable(td));
            Assert.assertFalse((boolean)numArrayArray.isAssignable(td));
        }
        for (TypeDescriptor td : PREDEFINED) {
            boolean iterable = td == TypeDescriptor.ARRAY || td == TypeDescriptor.ITERABLE;
            Assert.assertFalse((!iterable && td.isAssignable(numArray) ? 1 : 0) != 0);
            Assert.assertFalse((!iterable && td.isAssignable(strArray) ? 1 : 0) != 0);
            Assert.assertFalse((!iterable && td.isAssignable(numArrayArray) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)TypeDescriptor.ARRAY.isAssignable(numArray));
        Assert.assertTrue((boolean)TypeDescriptor.ARRAY.isAssignable(strArray));
        Assert.assertTrue((boolean)TypeDescriptor.ARRAY.isAssignable(numArrayArray));
        Assert.assertFalse((boolean)numArray.isAssignable(strArray));
        Assert.assertFalse((boolean)numArray.isAssignable(numArrayArray));
        Assert.assertFalse((boolean)strArray.isAssignable(numArray));
        Assert.assertFalse((boolean)strArray.isAssignable(numArrayArray));
        Assert.assertFalse((boolean)numArrayArray.isAssignable(numArray));
        Assert.assertFalse((boolean)numArrayArray.isAssignable(strArray));
        Assert.assertTrue((boolean)numArray.isAssignable(numArray));
        Assert.assertTrue((boolean)strArray.isAssignable(strArray));
        Assert.assertTrue((boolean)numArrayArray.isAssignable(numArrayArray));
        TypeDescriptor objOrArrayNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, numArray});
        Assert.assertFalse((boolean)numArray.isAssignable(objOrArrayNum));
        Assert.assertTrue((boolean)objOrArrayNum.isAssignable(numArray));
    }

    @Test
    public void testIterable() {
        TypeDescriptor numIterable = TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor strIterable = TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor numIterableIterable = TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER));
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertFalse((boolean)numIterable.isAssignable(td));
            Assert.assertFalse((boolean)strIterable.isAssignable(td));
            Assert.assertFalse((boolean)numIterableIterable.isAssignable(td));
        }
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertFalse((td != TypeDescriptor.ITERABLE && td.isAssignable(numIterable) ? 1 : 0) != 0);
            Assert.assertFalse((td != TypeDescriptor.ITERABLE && td.isAssignable(strIterable) ? 1 : 0) != 0);
            Assert.assertFalse((td != TypeDescriptor.ITERABLE && td.isAssignable(numIterableIterable) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)TypeDescriptor.ITERABLE.isAssignable(numIterable));
        Assert.assertTrue((boolean)TypeDescriptor.ITERABLE.isAssignable(strIterable));
        Assert.assertTrue((boolean)TypeDescriptor.ITERABLE.isAssignable(numIterableIterable));
        Assert.assertFalse((boolean)numIterable.isAssignable(strIterable));
        Assert.assertFalse((boolean)numIterable.isAssignable(numIterableIterable));
        Assert.assertFalse((boolean)strIterable.isAssignable(numIterable));
        Assert.assertFalse((boolean)strIterable.isAssignable(numIterableIterable));
        Assert.assertFalse((boolean)numIterableIterable.isAssignable(numIterable));
        Assert.assertFalse((boolean)numIterableIterable.isAssignable(strIterable));
        Assert.assertTrue((boolean)numIterable.isAssignable(numIterable));
        Assert.assertTrue((boolean)strIterable.isAssignable(strIterable));
        Assert.assertTrue((boolean)numIterableIterable.isAssignable(numIterableIterable));
        TypeDescriptor objOrArrayNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, numIterable});
        Assert.assertFalse((boolean)numIterable.isAssignable(objOrArrayNum));
        Assert.assertTrue((boolean)objOrArrayNum.isAssignable(numIterable));
    }

    @Test
    public void testIterator() {
        TypeDescriptor numIterator = TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor strIterator = TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.STRING);
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertFalse((boolean)numIterator.isAssignable(td));
            Assert.assertFalse((boolean)strIterator.isAssignable(td));
        }
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertFalse((td != TypeDescriptor.ITERATOR && td.isAssignable(numIterator) ? 1 : 0) != 0);
            Assert.assertFalse((td != TypeDescriptor.ITERATOR && td.isAssignable(strIterator) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)TypeDescriptor.ITERATOR.isAssignable(numIterator));
        Assert.assertTrue((boolean)TypeDescriptor.ITERATOR.isAssignable(strIterator));
        Assert.assertFalse((boolean)numIterator.isAssignable(strIterator));
        Assert.assertFalse((boolean)strIterator.isAssignable(numIterator));
        Assert.assertTrue((boolean)numIterator.isAssignable(numIterator));
        Assert.assertTrue((boolean)strIterator.isAssignable(strIterator));
        TypeDescriptor objOrIteratorNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, numIterator});
        Assert.assertFalse((boolean)numIterator.isAssignable(objOrIteratorNum));
        Assert.assertTrue((boolean)objOrIteratorNum.isAssignable(numIterator));
    }

    @Test
    public void testHash() {
        TypeDescriptor numStrHash = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor numNumHash = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor strStrHash = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.STRING, (TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor strNumHash = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.STRING, (TypeDescriptor)TypeDescriptor.NUMBER);
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertFalse((boolean)numStrHash.isAssignable(td));
            Assert.assertFalse((boolean)numNumHash.isAssignable(td));
            Assert.assertFalse((boolean)strStrHash.isAssignable(td));
            Assert.assertFalse((boolean)strNumHash.isAssignable(td));
        }
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertFalse((td != TypeDescriptor.HASH && td.isAssignable(numStrHash) ? 1 : 0) != 0);
            Assert.assertFalse((td != TypeDescriptor.HASH && td.isAssignable(numNumHash) ? 1 : 0) != 0);
            Assert.assertFalse((td != TypeDescriptor.HASH && td.isAssignable(strStrHash) ? 1 : 0) != 0);
            Assert.assertFalse((td != TypeDescriptor.HASH && td.isAssignable(strNumHash) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)TypeDescriptor.HASH.isAssignable(numStrHash));
        Assert.assertTrue((boolean)TypeDescriptor.HASH.isAssignable(numNumHash));
        Assert.assertTrue((boolean)TypeDescriptor.HASH.isAssignable(strStrHash));
        Assert.assertTrue((boolean)TypeDescriptor.HASH.isAssignable(strNumHash));
        Assert.assertTrue((boolean)numStrHash.isAssignable(numStrHash));
        Assert.assertFalse((boolean)numStrHash.isAssignable(numNumHash));
        Assert.assertFalse((boolean)numStrHash.isAssignable(strStrHash));
        Assert.assertFalse((boolean)numStrHash.isAssignable(strNumHash));
        Assert.assertFalse((boolean)numNumHash.isAssignable(numStrHash));
        Assert.assertTrue((boolean)numNumHash.isAssignable(numNumHash));
        Assert.assertFalse((boolean)numNumHash.isAssignable(strStrHash));
        Assert.assertFalse((boolean)numNumHash.isAssignable(strNumHash));
        Assert.assertFalse((boolean)strStrHash.isAssignable(numStrHash));
        Assert.assertFalse((boolean)strStrHash.isAssignable(numNumHash));
        Assert.assertTrue((boolean)strStrHash.isAssignable(strStrHash));
        Assert.assertFalse((boolean)strStrHash.isAssignable(strNumHash));
        Assert.assertFalse((boolean)strNumHash.isAssignable(numStrHash));
        Assert.assertFalse((boolean)strNumHash.isAssignable(numNumHash));
        Assert.assertFalse((boolean)strNumHash.isAssignable(strStrHash));
        Assert.assertTrue((boolean)strNumHash.isAssignable(strNumHash));
        TypeDescriptor objOrNumNumHash = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, numNumHash});
        Assert.assertFalse((boolean)numNumHash.isAssignable(objOrNumNumHash));
        Assert.assertTrue((boolean)objOrNumNumHash.isAssignable(numNumHash));
    }

    @Test
    public void testUnion() {
        TypeDescriptor numOrBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.BOOLEAN});
        TypeDescriptor numOrBoolOrStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{numOrBool, TypeDescriptor.STRING});
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertFalse((td != TypeDescriptor.NUMBER && td != TypeDescriptor.BOOLEAN && td.isAssignable(numOrBool) ? 1 : 0) != 0);
            Assert.assertFalse((td != TypeDescriptor.NUMBER && td != TypeDescriptor.BOOLEAN && numOrBool.isAssignable(td) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)numOrBool.isAssignable(TypeDescriptor.BOOLEAN));
        Assert.assertTrue((boolean)numOrBoolOrStr.isAssignable(TypeDescriptor.BOOLEAN));
        Assert.assertFalse((boolean)TypeDescriptor.BOOLEAN.isAssignable(numOrBool));
        Assert.assertFalse((boolean)TypeDescriptor.BOOLEAN.isAssignable(numOrBoolOrStr));
        Assert.assertTrue((boolean)numOrBool.isAssignable(TypeDescriptor.NUMBER));
        Assert.assertTrue((boolean)numOrBoolOrStr.isAssignable(TypeDescriptor.NUMBER));
        Assert.assertFalse((boolean)TypeDescriptor.NUMBER.isAssignable(numOrBool));
        Assert.assertFalse((boolean)TypeDescriptor.NUMBER.isAssignable(numOrBoolOrStr));
        Assert.assertTrue((boolean)numOrBoolOrStr.isAssignable(TypeDescriptor.STRING));
        Assert.assertFalse((boolean)TypeDescriptor.STRING.isAssignable(numOrBoolOrStr));
        Assert.assertTrue((boolean)numOrBoolOrStr.isAssignable(numOrBool));
        Assert.assertFalse((boolean)numOrBool.isAssignable(numOrBoolOrStr));
        TypeDescriptor arrNumberOrBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.BOOLEAN});
        TypeDescriptor arrNumberOrString = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.STRING});
        TypeDescriptor arrBoolOrString = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.array((TypeDescriptor)TypeDescriptor.BOOLEAN), TypeDescriptor.STRING});
        TypeDescriptor arrNumberOrBoolOrStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.BOOLEAN, TypeDescriptor.STRING});
        Assert.assertFalse((boolean)arrNumberOrBool.isAssignable(arrNumberOrString));
        Assert.assertFalse((boolean)arrNumberOrBool.isAssignable(arrBoolOrString));
        Assert.assertTrue((boolean)arrNumberOrBoolOrStr.isAssignable(arrNumberOrString));
        TypeDescriptor arrNumBool = TypeDescriptor.array((TypeDescriptor)numOrBool);
        TypeDescriptor arrNum = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor numOrBoolOrArrNumBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{numOrBool, arrNumBool});
        Assert.assertTrue((boolean)numOrBoolOrArrNumBool.isAssignable(arrNum));
        TypeDescriptor objOrArrNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, arrNum});
        TypeDescriptor boolOrArrNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, arrNum});
        Assert.assertFalse((boolean)numOrBoolOrArrNumBool.isAssignable(objOrArrNum));
        Assert.assertTrue((boolean)numOrBoolOrArrNumBool.isAssignable(boolOrArrNum));
        TypeDescriptor iterableNumberOrBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.BOOLEAN});
        TypeDescriptor iterableNumberOrString = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.STRING});
        TypeDescriptor iterableBoolOrString = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.BOOLEAN), TypeDescriptor.STRING});
        TypeDescriptor iterableNumberOrBoolOrStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.BOOLEAN, TypeDescriptor.STRING});
        Assert.assertFalse((boolean)iterableNumberOrBool.isAssignable(iterableNumberOrString));
        Assert.assertFalse((boolean)iterableNumberOrBool.isAssignable(iterableBoolOrString));
        Assert.assertTrue((boolean)iterableNumberOrBoolOrStr.isAssignable(iterableNumberOrString));
        TypeDescriptor iterableNumBool = TypeDescriptor.iterable((TypeDescriptor)numOrBool);
        TypeDescriptor iterableNum = TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor numOrBoolOrIterableNumBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{numOrBool, iterableNumBool});
        Assert.assertTrue((boolean)numOrBoolOrIterableNumBool.isAssignable(iterableNum));
        TypeDescriptor objOrIterableNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, iterableNum});
        TypeDescriptor boolOrIterableNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, iterableNum});
        Assert.assertFalse((boolean)numOrBoolOrIterableNumBool.isAssignable(objOrIterableNum));
        Assert.assertTrue((boolean)numOrBoolOrIterableNumBool.isAssignable(boolOrIterableNum));
        TypeDescriptor iteratorNumberOrBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.BOOLEAN});
        TypeDescriptor iteratorNumberOrString = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.STRING});
        TypeDescriptor iteratorBoolOrString = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.BOOLEAN), TypeDescriptor.STRING});
        TypeDescriptor iteratorNumberOrBoolOrStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.BOOLEAN, TypeDescriptor.STRING});
        Assert.assertFalse((boolean)iteratorNumberOrBool.isAssignable(iteratorNumberOrString));
        Assert.assertFalse((boolean)iteratorNumberOrBool.isAssignable(iteratorBoolOrString));
        Assert.assertTrue((boolean)iteratorNumberOrBoolOrStr.isAssignable(iteratorNumberOrString));
        TypeDescriptor iteratorNumBool = TypeDescriptor.iterator((TypeDescriptor)numOrBool);
        TypeDescriptor iteratorNum = TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor numOrBoolOrIteratorNumBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{numOrBool, iteratorNumBool});
        Assert.assertTrue((boolean)numOrBoolOrIteratorNumBool.isAssignable(iteratorNum));
        TypeDescriptor objOrIteratorNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, iteratorNum});
        TypeDescriptor boolOrIteratorNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, iteratorNum});
        Assert.assertFalse((boolean)numOrBoolOrIteratorNumBool.isAssignable(objOrIteratorNum));
        Assert.assertTrue((boolean)numOrBoolOrIteratorNumBool.isAssignable(boolOrIteratorNum));
        TypeDescriptor hashNumToStrOrBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING), TypeDescriptor.BOOLEAN});
        TypeDescriptor hashNumToStrOrString = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING), TypeDescriptor.STRING});
        TypeDescriptor hashBoolToStrOrString = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.BOOLEAN, (TypeDescriptor)TypeDescriptor.STRING), TypeDescriptor.STRING});
        TypeDescriptor hashNumToStrOrBoolOrStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING), TypeDescriptor.BOOLEAN, TypeDescriptor.STRING});
        Assert.assertFalse((boolean)hashNumToStrOrBool.isAssignable(hashNumToStrOrString));
        Assert.assertFalse((boolean)hashNumToStrOrBool.isAssignable(hashBoolToStrOrString));
        Assert.assertTrue((boolean)hashNumToStrOrBoolOrStr.isAssignable(hashNumToStrOrString));
        TypeDescriptor hashNumBoolToStr = TypeDescriptor.hash((TypeDescriptor)numOrBool, (TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor hashNumToStr = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor numOrBoolOrHashNumBoolToStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{numOrBool, hashNumBoolToStr});
        Assert.assertTrue((boolean)numOrBoolOrHashNumBoolToStr.isAssignable(hashNumToStr));
        TypeDescriptor objOrHashNumToStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, hashNumToStr});
        TypeDescriptor boolOrHashNumToStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, hashNumToStr});
        Assert.assertFalse((boolean)numOrBoolOrHashNumBoolToStr.isAssignable(objOrHashNumToStr));
        Assert.assertTrue((boolean)numOrBoolOrHashNumBoolToStr.isAssignable(boolOrHashNumToStr));
        TypeDescriptor arrString = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor arrBool = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.BOOLEAN);
        TypeDescriptor union = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{arrString, arrBool});
        Assert.assertFalse((String)union.toString(), (boolean)union.isUnion());
        TypeDescriptor iterableString = TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor iterableBool = TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.BOOLEAN);
        union = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{iterableString, iterableBool});
        Assert.assertFalse((String)union.toString(), (boolean)union.isUnion());
        TypeDescriptor iteratorString = TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor iteratorBool = TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.BOOLEAN);
        union = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{iteratorString, iteratorBool});
        Assert.assertFalse((String)union.toString(), (boolean)union.isUnion());
        TypeDescriptor hashStringToNumber = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.STRING, (TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor hashBoolToString = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.BOOLEAN, (TypeDescriptor)TypeDescriptor.STRING);
        union = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{hashStringToNumber, hashBoolToString});
        Assert.assertFalse((String)union.toString(), (boolean)union.isUnion());
    }

    @Test
    public void testSubtract() {
        TypeDescriptor noType = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[0]);
        for (TypeDescriptor a : PREDEFINED) {
            for (TypeDescriptor b : PREDEFINED) {
                if (a == TypeDescriptor.ARRAY && b == TypeDescriptor.ITERABLE) continue;
                TypeDescriptor expected = a.equals((Object)b) ? noType : a;
                Assert.assertEquals((Object)expected, (Object)a.subtract(b));
            }
        }
        TypeDescriptor numOrStrOrObj = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        TypeDescriptor strOrObj = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        Assert.assertEquals((Object)strOrObj, (Object)numOrStrOrObj.subtract(TypeDescriptor.NUMBER));
        Assert.assertEquals((Object)TypeDescriptor.OBJECT, (Object)numOrStrOrObj.subtract(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING})));
        Assert.assertEquals((Object)noType, (Object)numOrStrOrObj.subtract(numOrStrOrObj));
        TypeDescriptor numOrBool = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.BOOLEAN});
        Assert.assertEquals((Object)strOrObj, (Object)strOrObj.subtract(numOrBool));
        TypeDescriptor iterNum = TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor numOrIterNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, iterNum});
        Assert.assertEquals((Object)TypeDescriptor.NUMBER, (Object)numOrIterNum.subtract(iterNum));
        Assert.assertEquals((Object)iterNum, (Object)numOrIterNum.subtract(TypeDescriptor.NUMBER));
        TypeDescriptor hashNumStr = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor numOrHashNumStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, hashNumStr});
        Assert.assertEquals((Object)TypeDescriptor.NUMBER, (Object)numOrHashNumStr.subtract(hashNumStr));
        Assert.assertEquals((Object)hashNumStr, (Object)numOrHashNumStr.subtract(TypeDescriptor.NUMBER));
        TypeDescriptor arrNum = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor numOrArrNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, arrNum});
        Assert.assertEquals((Object)TypeDescriptor.NUMBER, (Object)numOrArrNum.subtract(arrNum));
        Assert.assertEquals((Object)arrNum, (Object)numOrArrNum.subtract(TypeDescriptor.NUMBER));
        TypeDescriptor numOrHashOrArrOrIt = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, iterNum, hashNumStr, arrNum});
        Assert.assertEquals((Object)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{iterNum, hashNumStr, arrNum}), (Object)numOrHashOrArrOrIt.subtract(TypeDescriptor.NUMBER));
        Assert.assertEquals((Object)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, hashNumStr, arrNum}), (Object)numOrHashOrArrOrIt.subtract(iterNum));
        Assert.assertEquals((Object)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, iterNum, arrNum}), (Object)numOrHashOrArrOrIt.subtract(hashNumStr));
        Assert.assertEquals((Object)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, iterNum, hashNumStr}), (Object)numOrHashOrArrOrIt.subtract(arrNum));
        TypeDescriptor numOrIterNumOrStr = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}))});
        Assert.assertEquals((Object)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER)}), (Object)numOrIterNumOrStr.subtract(TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.STRING)));
        TypeDescriptor numAndStrAndObj = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        TypeDescriptor strAndObj = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        Assert.assertEquals((Object)strAndObj, (Object)numAndStrAndObj.subtract(TypeDescriptor.NUMBER));
        Assert.assertEquals((Object)TypeDescriptor.OBJECT, (Object)numAndStrAndObj.subtract(TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING})));
        Assert.assertEquals((Object)noType, (Object)numAndStrAndObj.subtract(numAndStrAndObj));
        TypeDescriptor numAndBool = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.BOOLEAN});
        Assert.assertEquals((Object)strAndObj, (Object)strAndObj.subtract(numAndBool));
        TypeDescriptor numAndIterNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, iterNum});
        Assert.assertEquals((Object)TypeDescriptor.NUMBER, (Object)numAndIterNum.subtract(iterNum));
        Assert.assertEquals((Object)iterNum, (Object)numAndIterNum.subtract(TypeDescriptor.NUMBER));
        TypeDescriptor numAndHashNumStr = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, hashNumStr});
        Assert.assertEquals((Object)TypeDescriptor.NUMBER, (Object)numAndHashNumStr.subtract(hashNumStr));
        Assert.assertEquals((Object)hashNumStr, (Object)numAndHashNumStr.subtract(TypeDescriptor.NUMBER));
        TypeDescriptor numAndArrNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, arrNum});
        Assert.assertEquals((Object)TypeDescriptor.NUMBER, (Object)numAndArrNum.subtract(arrNum));
        Assert.assertEquals((Object)arrNum, (Object)numAndArrNum.subtract(TypeDescriptor.NUMBER));
        TypeDescriptor numAndHashAndArrAndIt = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, iterNum, hashNumStr, arrNum});
        Assert.assertEquals((Object)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{iterNum, hashNumStr, arrNum}), (Object)numAndHashAndArrAndIt.subtract(TypeDescriptor.NUMBER));
        Assert.assertEquals((Object)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, hashNumStr, arrNum}), (Object)numAndHashAndArrAndIt.subtract(iterNum));
        Assert.assertEquals((Object)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, iterNum, arrNum}), (Object)numAndHashAndArrAndIt.subtract(hashNumStr));
        Assert.assertEquals((Object)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, iterNum, hashNumStr}), (Object)numAndHashAndArrAndIt.subtract(arrNum));
        TypeDescriptor numAndIterNumAndStr = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}))});
        Assert.assertEquals((Object)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER)}), (Object)numAndIterNumAndStr.subtract(TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.STRING)));
        TypeDescriptor predefinedAndNoType = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])PREDEFINED), noType});
        TypeDescriptor expected = predefinedAndNoType.subtract(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.EXECUTABLE, TypeDescriptor.INSTANTIABLE}));
        Assert.assertEquals((Object)expected, (Object)TypeDescriptor.ANY.subtract(TypeDescriptor.NUMBER));
        Assert.assertEquals((Object)noType, (Object)TypeDescriptor.ANY.subtract(predefinedAndNoType));
        TypeDescriptor unionNumOrStrOrObj = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        Assert.assertEquals((Object)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.OBJECT}), (Object)unionNumOrStrOrObj.subtract(TypeDescriptor.NUMBER));
        Assert.assertEquals((Object)TypeDescriptor.OBJECT, (Object)unionNumOrStrOrObj.subtract(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING})));
        TypeDescriptor intersectionNumOrStrOrObj = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        Assert.assertEquals((Object)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.OBJECT}), (Object)intersectionNumOrStrOrObj.subtract(TypeDescriptor.NUMBER));
        Assert.assertEquals((Object)TypeDescriptor.OBJECT, (Object)intersectionNumOrStrOrObj.subtract(TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING})));
        Assert.assertEquals((Object)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.STRING), (Object)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING})).subtract(TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)));
        Assert.assertEquals((Object)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.STRING), (Object)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING})).subtract(TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)));
    }

    @Test
    public void testExecutable() {
        TypeDescriptor exeBottom = TypeDescriptor.EXECUTABLE;
        TypeDescriptor exeTop = TypeDescriptor.EXECUTABLE_ANY;
        TypeDescriptor exeAnyNoArgs = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[0]);
        TypeDescriptor exeAnyStr = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING});
        TypeDescriptor exeAnyStrNum = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.NUMBER});
        TypeDescriptor exeStrNoArgs = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.STRING, (TypeDescriptor[])new TypeDescriptor[0]);
        TypeDescriptor exeStrStr = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.STRING, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING});
        TypeDescriptor exeAnyUnionUnion = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}), TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.OBJECT})});
        ArrayList eds = new ArrayList();
        Collections.addAll(eds, exeBottom, exeAnyNoArgs, exeAnyStr, exeAnyStrNum, exeStrNoArgs, exeStrStr, exeAnyUnionUnion);
        ArrayList<TypeDescriptor> otherTypes = new ArrayList<TypeDescriptor>();
        Collections.addAll(otherTypes, PREDEFINED);
        otherTypes.remove(TypeDescriptor.EXECUTABLE);
        otherTypes.remove(TypeDescriptor.EXECUTABLE_ANY);
        otherTypes.add(TypeDescriptor.array((TypeDescriptor)TypeDescriptor.BOOLEAN));
        otherTypes.add(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER}));
        for (TypeDescriptor td : otherTypes) {
            for (TypeDescriptor ed : eds) {
                Assert.assertFalse((boolean)ed.isAssignable(td));
                Assert.assertFalse((boolean)td.isAssignable(ed));
            }
        }
        Assert.assertTrue((boolean)exeTop.isAssignable(exeTop));
        Assert.assertTrue((boolean)exeTop.isAssignable(exeBottom));
        Assert.assertTrue((boolean)exeTop.isAssignable(exeAnyNoArgs));
        Assert.assertTrue((boolean)exeTop.isAssignable(exeAnyStr));
        Assert.assertTrue((boolean)exeTop.isAssignable(exeAnyStrNum));
        Assert.assertTrue((boolean)exeTop.isAssignable(exeStrNoArgs));
        Assert.assertTrue((boolean)exeTop.isAssignable(exeStrStr));
        Assert.assertTrue((boolean)exeTop.isAssignable(exeAnyUnionUnion));
        Assert.assertFalse((boolean)exeBottom.isAssignable(exeTop));
        Assert.assertTrue((boolean)exeBottom.isAssignable(exeAnyNoArgs));
        Assert.assertFalse((boolean)exeBottom.isAssignable(exeAnyStr));
        Assert.assertFalse((boolean)exeBottom.isAssignable(exeAnyStrNum));
        Assert.assertTrue((boolean)exeBottom.isAssignable(exeStrNoArgs));
        Assert.assertFalse((boolean)exeBottom.isAssignable(exeStrStr));
        Assert.assertFalse((boolean)exeBottom.isAssignable(exeAnyUnionUnion));
        Assert.assertFalse((boolean)exeAnyNoArgs.isAssignable(exeTop));
        Assert.assertTrue((boolean)exeAnyNoArgs.isAssignable(exeBottom));
        Assert.assertFalse((boolean)exeAnyNoArgs.isAssignable(exeAnyStr));
        Assert.assertFalse((boolean)exeAnyNoArgs.isAssignable(exeAnyStrNum));
        Assert.assertTrue((boolean)exeAnyNoArgs.isAssignable(exeStrNoArgs));
        Assert.assertFalse((boolean)exeAnyNoArgs.isAssignable(exeStrStr));
        Assert.assertFalse((boolean)exeAnyNoArgs.isAssignable(exeAnyUnionUnion));
        Assert.assertFalse((boolean)exeAnyStr.isAssignable(exeTop));
        Assert.assertTrue((boolean)exeAnyStr.isAssignable(exeBottom));
        Assert.assertTrue((boolean)exeAnyStr.isAssignable(exeAnyNoArgs));
        Assert.assertFalse((boolean)exeAnyStr.isAssignable(exeAnyStrNum));
        Assert.assertTrue((boolean)exeAnyStr.isAssignable(exeStrNoArgs));
        Assert.assertTrue((boolean)exeAnyStr.isAssignable(exeStrStr));
        Assert.assertFalse((boolean)exeAnyStr.isAssignable(exeAnyUnionUnion));
        Assert.assertFalse((boolean)exeAnyStrNum.isAssignable(exeTop));
        Assert.assertTrue((boolean)exeAnyStrNum.isAssignable(exeBottom));
        Assert.assertTrue((boolean)exeAnyStrNum.isAssignable(exeAnyNoArgs));
        Assert.assertTrue((boolean)exeAnyStrNum.isAssignable(exeAnyStr));
        Assert.assertTrue((boolean)exeAnyStrNum.isAssignable(exeStrNoArgs));
        Assert.assertTrue((boolean)exeAnyStrNum.isAssignable(exeStrStr));
        Assert.assertTrue((boolean)exeAnyStrNum.isAssignable(exeAnyUnionUnion));
        Assert.assertFalse((boolean)exeStrNoArgs.isAssignable(exeTop));
        Assert.assertFalse((boolean)exeStrNoArgs.isAssignable(exeBottom));
        Assert.assertFalse((boolean)exeStrNoArgs.isAssignable(exeAnyNoArgs));
        Assert.assertFalse((boolean)exeStrNoArgs.isAssignable(exeAnyStr));
        Assert.assertFalse((boolean)exeStrNoArgs.isAssignable(exeAnyStrNum));
        Assert.assertFalse((boolean)exeStrNoArgs.isAssignable(exeStrStr));
        Assert.assertFalse((boolean)exeStrNoArgs.isAssignable(exeAnyUnionUnion));
        Assert.assertFalse((boolean)exeStrStr.isAssignable(exeTop));
        Assert.assertFalse((boolean)exeStrStr.isAssignable(exeBottom));
        Assert.assertFalse((boolean)exeStrStr.isAssignable(exeAnyNoArgs));
        Assert.assertFalse((boolean)exeStrStr.isAssignable(exeAnyStr));
        Assert.assertFalse((boolean)exeStrStr.isAssignable(exeAnyStrNum));
        Assert.assertTrue((boolean)exeStrStr.isAssignable(exeStrNoArgs));
        Assert.assertFalse((boolean)exeStrStr.isAssignable(exeAnyUnionUnion));
        Assert.assertFalse((boolean)exeAnyUnionUnion.isAssignable(exeTop));
        Assert.assertTrue((boolean)exeAnyUnionUnion.isAssignable(exeBottom));
        Assert.assertTrue((boolean)exeAnyUnionUnion.isAssignable(exeAnyNoArgs));
        Assert.assertFalse((boolean)exeAnyUnionUnion.isAssignable(exeAnyStr));
        Assert.assertFalse((boolean)exeAnyUnionUnion.isAssignable(exeAnyStrNum));
        Assert.assertTrue((boolean)exeAnyUnionUnion.isAssignable(exeStrNoArgs));
        Assert.assertFalse((boolean)exeAnyUnionUnion.isAssignable(exeStrStr));
        TypeDescriptor ae1 = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.EXECUTABLE);
        TypeDescriptor ae2 = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN}));
        TypeDescriptor ae3 = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.EXECUTABLE_ANY);
        TypeDescriptor ab = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.BOOLEAN);
        Assert.assertFalse((boolean)ae1.isAssignable(ae2));
        Assert.assertFalse((boolean)ae1.isAssignable(ae3));
        Assert.assertFalse((boolean)ae1.isAssignable(ab));
        Assert.assertTrue((boolean)ae2.isAssignable(ae1));
        Assert.assertFalse((boolean)ae2.isAssignable(ae3));
        Assert.assertFalse((boolean)ae2.isAssignable(ab));
        Assert.assertTrue((boolean)ae3.isAssignable(ae1));
        Assert.assertTrue((boolean)ae3.isAssignable(ae2));
        Assert.assertFalse((boolean)ae3.isAssignable(ab));
        TypeDescriptor ue1 = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.EXECUTABLE, TypeDescriptor.OBJECT});
        TypeDescriptor ue2 = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN}), TypeDescriptor.STRING});
        TypeDescriptor ue3 = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN}), TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        TypeDescriptor ue4 = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.EXECUTABLE_ANY, TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        TypeDescriptor up = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER});
        Assert.assertFalse((boolean)ue1.isAssignable(ue2));
        Assert.assertFalse((boolean)ue1.isAssignable(ue3));
        Assert.assertFalse((boolean)ue1.isAssignable(up));
        Assert.assertFalse((boolean)ue1.isAssignable(ue4));
        Assert.assertFalse((boolean)ue2.isAssignable(ue1));
        Assert.assertFalse((boolean)ue2.isAssignable(ue3));
        Assert.assertFalse((boolean)ue2.isAssignable(up));
        Assert.assertFalse((boolean)ue2.isAssignable(ue4));
        Assert.assertTrue((boolean)ue3.isAssignable(ue1));
        Assert.assertTrue((boolean)ue3.isAssignable(ue2));
        Assert.assertFalse((boolean)ue3.isAssignable(up));
        Assert.assertFalse((boolean)ue3.isAssignable(ue4));
        Assert.assertTrue((boolean)ue4.isAssignable(ue1));
        Assert.assertTrue((boolean)ue4.isAssignable(ue2));
        Assert.assertTrue((boolean)ue4.isAssignable(ue3));
        Assert.assertFalse((boolean)ue4.isAssignable(up));
        TypeDescriptor exeStrictAnyAny = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (boolean)false, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ANY});
        TypeDescriptor exeAnyNum = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER});
        TypeDescriptor exeAnyNumNum = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.NUMBER});
        Assert.assertTrue((boolean)exeAnyNum.isAssignable(exeStrictAnyAny));
        Assert.assertFalse((boolean)exeAnyNumNum.isAssignable(exeStrictAnyAny));
        TypeDescriptor exeStrictAny = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (boolean)false, (TypeDescriptor[])new TypeDescriptor[0]);
        Assert.assertFalse((boolean)exeAnyNum.isAssignable(exeStrictAny));
    }

    @Test
    public void testInstantiable() {
        TypeDescriptor instantiableBottom = TypeDescriptor.INSTANTIABLE;
        TypeDescriptor instantiableTop = TypeDescriptor.INSTANTIABLE_ANY;
        TypeDescriptor instantiableAnyNoArgs = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[0]);
        TypeDescriptor instantiableAnyStr = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING});
        TypeDescriptor instantiableAnyStrNum = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.NUMBER});
        TypeDescriptor instantiableStrNoArgs = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.STRING, (boolean)true, (TypeDescriptor[])new TypeDescriptor[0]);
        TypeDescriptor instantiableStrStr = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.STRING, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING});
        TypeDescriptor instantiableAnyUnionUnion = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING}), TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.OBJECT})});
        ArrayList instantiables = new ArrayList();
        Collections.addAll(instantiables, instantiableBottom, instantiableAnyNoArgs, instantiableAnyStr, instantiableAnyStrNum, instantiableStrNoArgs, instantiableStrStr, instantiableAnyUnionUnion);
        ArrayList<TypeDescriptor> otherTypes = new ArrayList<TypeDescriptor>();
        Collections.addAll(otherTypes, PREDEFINED);
        otherTypes.remove(TypeDescriptor.INSTANTIABLE);
        otherTypes.remove(TypeDescriptor.INSTANTIABLE_ANY);
        otherTypes.add(TypeDescriptor.array((TypeDescriptor)TypeDescriptor.BOOLEAN));
        otherTypes.add(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER}));
        for (TypeDescriptor td : otherTypes) {
            for (TypeDescriptor instantiable : instantiables) {
                Assert.assertFalse((boolean)instantiable.isAssignable(td));
                Assert.assertFalse((boolean)td.isAssignable(instantiable));
            }
        }
        Assert.assertTrue((boolean)instantiableTop.isAssignable(instantiableTop));
        Assert.assertTrue((boolean)instantiableTop.isAssignable(instantiableBottom));
        Assert.assertTrue((boolean)instantiableTop.isAssignable(instantiableAnyNoArgs));
        Assert.assertTrue((boolean)instantiableTop.isAssignable(instantiableAnyStr));
        Assert.assertTrue((boolean)instantiableTop.isAssignable(instantiableAnyStrNum));
        Assert.assertTrue((boolean)instantiableTop.isAssignable(instantiableStrNoArgs));
        Assert.assertTrue((boolean)instantiableTop.isAssignable(instantiableStrStr));
        Assert.assertTrue((boolean)instantiableTop.isAssignable(instantiableAnyUnionUnion));
        Assert.assertFalse((boolean)instantiableBottom.isAssignable(instantiableTop));
        Assert.assertTrue((boolean)instantiableBottom.isAssignable(instantiableAnyNoArgs));
        Assert.assertFalse((boolean)instantiableBottom.isAssignable(instantiableAnyStr));
        Assert.assertFalse((boolean)instantiableBottom.isAssignable(instantiableAnyStrNum));
        Assert.assertTrue((boolean)instantiableBottom.isAssignable(instantiableStrNoArgs));
        Assert.assertFalse((boolean)instantiableBottom.isAssignable(instantiableStrStr));
        Assert.assertFalse((boolean)instantiableBottom.isAssignable(instantiableAnyUnionUnion));
        Assert.assertFalse((boolean)instantiableAnyNoArgs.isAssignable(instantiableTop));
        Assert.assertTrue((boolean)instantiableAnyNoArgs.isAssignable(instantiableBottom));
        Assert.assertFalse((boolean)instantiableAnyNoArgs.isAssignable(instantiableAnyStr));
        Assert.assertFalse((boolean)instantiableAnyNoArgs.isAssignable(instantiableAnyStrNum));
        Assert.assertTrue((boolean)instantiableAnyNoArgs.isAssignable(instantiableStrNoArgs));
        Assert.assertFalse((boolean)instantiableAnyNoArgs.isAssignable(instantiableStrStr));
        Assert.assertFalse((boolean)instantiableAnyNoArgs.isAssignable(instantiableAnyUnionUnion));
        Assert.assertFalse((boolean)instantiableAnyStr.isAssignable(instantiableTop));
        Assert.assertTrue((boolean)instantiableAnyStr.isAssignable(instantiableBottom));
        Assert.assertTrue((boolean)instantiableAnyStr.isAssignable(instantiableAnyNoArgs));
        Assert.assertFalse((boolean)instantiableAnyStr.isAssignable(instantiableAnyStrNum));
        Assert.assertTrue((boolean)instantiableAnyStr.isAssignable(instantiableStrNoArgs));
        Assert.assertTrue((boolean)instantiableAnyStr.isAssignable(instantiableStrStr));
        Assert.assertFalse((boolean)instantiableAnyStr.isAssignable(instantiableAnyUnionUnion));
        Assert.assertFalse((boolean)instantiableAnyStrNum.isAssignable(instantiableTop));
        Assert.assertTrue((boolean)instantiableAnyStrNum.isAssignable(instantiableBottom));
        Assert.assertTrue((boolean)instantiableAnyStrNum.isAssignable(instantiableAnyNoArgs));
        Assert.assertTrue((boolean)instantiableAnyStrNum.isAssignable(instantiableAnyStr));
        Assert.assertTrue((boolean)instantiableAnyStrNum.isAssignable(instantiableStrNoArgs));
        Assert.assertTrue((boolean)instantiableAnyStrNum.isAssignable(instantiableStrStr));
        Assert.assertTrue((boolean)instantiableAnyStrNum.isAssignable(instantiableAnyUnionUnion));
        Assert.assertFalse((boolean)instantiableStrNoArgs.isAssignable(instantiableTop));
        Assert.assertFalse((boolean)instantiableStrNoArgs.isAssignable(instantiableBottom));
        Assert.assertFalse((boolean)instantiableStrNoArgs.isAssignable(instantiableAnyNoArgs));
        Assert.assertFalse((boolean)instantiableStrNoArgs.isAssignable(instantiableAnyStr));
        Assert.assertFalse((boolean)instantiableStrNoArgs.isAssignable(instantiableAnyStrNum));
        Assert.assertFalse((boolean)instantiableStrNoArgs.isAssignable(instantiableStrStr));
        Assert.assertFalse((boolean)instantiableStrNoArgs.isAssignable(instantiableAnyUnionUnion));
        Assert.assertFalse((boolean)instantiableStrStr.isAssignable(instantiableTop));
        Assert.assertFalse((boolean)instantiableStrStr.isAssignable(instantiableBottom));
        Assert.assertFalse((boolean)instantiableStrStr.isAssignable(instantiableAnyNoArgs));
        Assert.assertFalse((boolean)instantiableStrStr.isAssignable(instantiableAnyStr));
        Assert.assertFalse((boolean)instantiableStrStr.isAssignable(instantiableAnyStrNum));
        Assert.assertTrue((boolean)instantiableStrStr.isAssignable(instantiableStrNoArgs));
        Assert.assertFalse((boolean)instantiableStrStr.isAssignable(instantiableAnyUnionUnion));
        Assert.assertFalse((boolean)instantiableAnyUnionUnion.isAssignable(instantiableTop));
        Assert.assertTrue((boolean)instantiableAnyUnionUnion.isAssignable(instantiableBottom));
        Assert.assertTrue((boolean)instantiableAnyUnionUnion.isAssignable(instantiableAnyNoArgs));
        Assert.assertFalse((boolean)instantiableAnyUnionUnion.isAssignable(instantiableAnyStr));
        Assert.assertFalse((boolean)instantiableAnyUnionUnion.isAssignable(instantiableAnyStrNum));
        Assert.assertTrue((boolean)instantiableAnyUnionUnion.isAssignable(instantiableStrNoArgs));
        Assert.assertFalse((boolean)instantiableAnyUnionUnion.isAssignable(instantiableStrStr));
        TypeDescriptor arrInstantiableBottom = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.INSTANTIABLE);
        TypeDescriptor arrInstantiableUnit = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN}));
        TypeDescriptor arrInstantiableTop = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.INSTANTIABLE_ANY);
        TypeDescriptor arrBoolean = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.BOOLEAN);
        Assert.assertFalse((boolean)arrInstantiableBottom.isAssignable(arrInstantiableUnit));
        Assert.assertFalse((boolean)arrInstantiableBottom.isAssignable(arrInstantiableTop));
        Assert.assertFalse((boolean)arrInstantiableBottom.isAssignable(arrBoolean));
        Assert.assertTrue((boolean)arrInstantiableUnit.isAssignable(arrInstantiableBottom));
        Assert.assertFalse((boolean)arrInstantiableUnit.isAssignable(arrInstantiableTop));
        Assert.assertFalse((boolean)arrInstantiableUnit.isAssignable(arrBoolean));
        Assert.assertTrue((boolean)arrInstantiableTop.isAssignable(arrInstantiableBottom));
        Assert.assertTrue((boolean)arrInstantiableTop.isAssignable(arrInstantiableUnit));
        Assert.assertFalse((boolean)arrInstantiableTop.isAssignable(arrBoolean));
        TypeDescriptor uinstantiable1 = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.INSTANTIABLE, TypeDescriptor.OBJECT});
        TypeDescriptor uinstantiable2 = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN}), TypeDescriptor.STRING});
        TypeDescriptor uinstantiable3 = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN}), TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        TypeDescriptor uinstantiable4 = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.INSTANTIABLE_ANY, TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        TypeDescriptor uprimitive = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER});
        Assert.assertFalse((boolean)uinstantiable1.isAssignable(uinstantiable2));
        Assert.assertFalse((boolean)uinstantiable1.isAssignable(uinstantiable3));
        Assert.assertFalse((boolean)uinstantiable1.isAssignable(uprimitive));
        Assert.assertFalse((boolean)uinstantiable1.isAssignable(uinstantiable4));
        Assert.assertFalse((boolean)uinstantiable2.isAssignable(uinstantiable1));
        Assert.assertFalse((boolean)uinstantiable2.isAssignable(uinstantiable3));
        Assert.assertFalse((boolean)uinstantiable2.isAssignable(uprimitive));
        Assert.assertFalse((boolean)uinstantiable2.isAssignable(uinstantiable4));
        Assert.assertTrue((boolean)uinstantiable3.isAssignable(uinstantiable1));
        Assert.assertTrue((boolean)uinstantiable3.isAssignable(uinstantiable2));
        Assert.assertFalse((boolean)uinstantiable3.isAssignable(uprimitive));
        Assert.assertFalse((boolean)uinstantiable3.isAssignable(uinstantiable4));
        Assert.assertTrue((boolean)uinstantiable4.isAssignable(uinstantiable1));
        Assert.assertTrue((boolean)uinstantiable4.isAssignable(uinstantiable2));
        Assert.assertTrue((boolean)uinstantiable4.isAssignable(uinstantiable3));
        Assert.assertFalse((boolean)uinstantiable4.isAssignable(uprimitive));
        TypeDescriptor instantiableStrictAnyAny = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)false, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ANY});
        TypeDescriptor instantiableAnyNum = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER});
        TypeDescriptor instantiableAnyNumNum = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.NUMBER});
        Assert.assertTrue((boolean)instantiableAnyNum.isAssignable(instantiableStrictAnyAny));
        Assert.assertFalse((boolean)instantiableAnyNumNum.isAssignable(instantiableStrictAnyAny));
        TypeDescriptor instantiableStrictAny = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (boolean)false, (TypeDescriptor[])new TypeDescriptor[0]);
        Assert.assertFalse((boolean)instantiableAnyNum.isAssignable(instantiableStrictAny));
    }

    @Test
    public void testAny() {
        Assert.assertTrue((boolean)TypeDescriptor.ARRAY.isAssignable(TypeDescriptor.array((TypeDescriptor)TypeDescriptor.ANY)));
        Assert.assertTrue((boolean)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.ANY).isAssignable(TypeDescriptor.ARRAY));
        Assert.assertTrue((boolean)TypeDescriptor.ITERABLE.isAssignable(TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.ANY)));
        Assert.assertTrue((boolean)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.ANY).isAssignable(TypeDescriptor.ITERABLE));
        Assert.assertTrue((boolean)TypeDescriptor.ITERATOR.isAssignable(TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.ANY)));
        Assert.assertTrue((boolean)TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.ANY).isAssignable(TypeDescriptor.ITERATOR));
        Assert.assertFalse((boolean)TypeDescriptor.EXECUTABLE.isAssignable(TypeDescriptor.ANY));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(TypeDescriptor.EXECUTABLE));
        Assert.assertFalse((boolean)TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[0]).isAssignable(TypeDescriptor.ANY));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[0])));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.NUMBER})));
        Assert.assertTrue((boolean)TypeDescriptor.EXECUTABLE.isAssignable(TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[0])));
        Assert.assertTrue((boolean)TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor[])new TypeDescriptor[0]).isAssignable(TypeDescriptor.EXECUTABLE));
        Assert.assertFalse((boolean)TypeDescriptor.INSTANTIABLE.isAssignable(TypeDescriptor.ANY));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(TypeDescriptor.INSTANTIABLE));
        Assert.assertFalse((boolean)TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[0]).isAssignable(TypeDescriptor.ANY));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[0])));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.NUMBER})));
        Assert.assertTrue((boolean)TypeDescriptor.INSTANTIABLE.isAssignable(TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[0])));
        Assert.assertTrue((boolean)TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.ANY, (boolean)true, (TypeDescriptor[])new TypeDescriptor[0]).isAssignable(TypeDescriptor.INSTANTIABLE));
        for (TypeDescriptor td : PREDEFINED) {
            Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(td));
            Assert.assertFalse((boolean)td.isAssignable(TypeDescriptor.ANY));
        }
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(TypeDescriptor.ANY));
        TypeDescriptor union = TypeDescriptor.union((TypeDescriptor[])PREDEFINED);
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(union));
        Assert.assertFalse((boolean)union.isAssignable(TypeDescriptor.ANY));
        TypeDescriptor unionWithAny = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{union, TypeDescriptor.ANY});
        Assert.assertTrue((boolean)unionWithAny.isAssignable(TypeDescriptor.ANY));
        TypeDescriptor intersection = TypeDescriptor.intersection((TypeDescriptor[])PREDEFINED);
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(intersection));
        Assert.assertFalse((boolean)intersection.isAssignable(TypeDescriptor.ANY));
        TypeDescriptor arrayNum = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor arrayAny = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.ANY);
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(arrayNum));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(arrayAny));
        Assert.assertFalse((boolean)arrayNum.isAssignable(TypeDescriptor.ANY));
        Assert.assertFalse((boolean)arrayAny.isAssignable(TypeDescriptor.ANY));
        Assert.assertTrue((boolean)arrayAny.isAssignable(arrayNum));
        Assert.assertFalse((boolean)arrayNum.isAssignable(arrayAny));
        TypeDescriptor iterableNum = TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor iterableAny = TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.ANY);
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(iterableNum));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(iterableAny));
        Assert.assertFalse((boolean)iterableNum.isAssignable(TypeDescriptor.ANY));
        Assert.assertFalse((boolean)iterableAny.isAssignable(TypeDescriptor.ANY));
        Assert.assertTrue((boolean)iterableAny.isAssignable(iterableNum));
        Assert.assertFalse((boolean)iterableNum.isAssignable(iterableAny));
        TypeDescriptor iteratorNum = TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER);
        TypeDescriptor iteratorAny = TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.ANY);
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(iteratorNum));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(iteratorAny));
        Assert.assertFalse((boolean)iteratorNum.isAssignable(TypeDescriptor.ANY));
        Assert.assertFalse((boolean)iteratorAny.isAssignable(TypeDescriptor.ANY));
        Assert.assertTrue((boolean)iteratorAny.isAssignable(iteratorNum));
        Assert.assertFalse((boolean)iteratorNum.isAssignable(iteratorAny));
        TypeDescriptor hashNumToStr = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING);
        TypeDescriptor hashAnyToAny = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.ANY, (TypeDescriptor)TypeDescriptor.ANY);
        TypeDescriptor hashNumToAny = TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.ANY);
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(hashNumToStr));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(hashAnyToAny));
        Assert.assertTrue((boolean)TypeDescriptor.ANY.isAssignable(hashNumToAny));
        Assert.assertFalse((boolean)hashNumToStr.isAssignable(TypeDescriptor.ANY));
        Assert.assertFalse((boolean)hashAnyToAny.isAssignable(TypeDescriptor.ANY));
        Assert.assertFalse((boolean)hashNumToAny.isAssignable(TypeDescriptor.ANY));
        Assert.assertTrue((boolean)hashAnyToAny.isAssignable(hashNumToStr));
        Assert.assertTrue((boolean)hashAnyToAny.isAssignable(hashNumToAny));
        Assert.assertFalse((boolean)hashNumToStr.isAssignable(hashAnyToAny));
        Assert.assertFalse((boolean)hashNumToStr.isAssignable(hashNumToAny));
        Assert.assertTrue((boolean)hashNumToAny.isAssignable(hashNumToStr));
        Assert.assertFalse((boolean)hashNumToAny.isAssignable(hashAnyToAny));
    }

    @Test
    public void testIntersection() {
        TypeDescriptor strAndObj = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        TypeDescriptor strAndNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.NUMBER});
        TypeDescriptor strAndNumAndObj = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{strAndObj, strAndNum});
        Assert.assertTrue((boolean)strAndObj.isAssignable(strAndObj));
        Assert.assertFalse((boolean)strAndObj.isAssignable(strAndNum));
        Assert.assertTrue((boolean)strAndObj.isAssignable(strAndNumAndObj));
        Assert.assertTrue((boolean)strAndNum.isAssignable(strAndNum));
        Assert.assertFalse((boolean)strAndNum.isAssignable(strAndObj));
        Assert.assertTrue((boolean)strAndNum.isAssignable(strAndNumAndObj));
        Assert.assertTrue((boolean)strAndNumAndObj.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)strAndNumAndObj.isAssignable(strAndNum));
        Assert.assertFalse((boolean)strAndNumAndObj.isAssignable(strAndObj));
        for (TypeDescriptor predefined : PREDEFINED) {
            Assert.assertFalse((boolean)strAndNum.isAssignable(predefined));
            Assert.assertFalse((boolean)strAndObj.isAssignable(predefined));
            Assert.assertFalse((boolean)strAndNumAndObj.isAssignable(predefined));
        }
        Assert.assertFalse((boolean)TypeDescriptor.ARRAY.isAssignable(strAndNum));
        Assert.assertFalse((boolean)TypeDescriptor.ARRAY.isAssignable(strAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.ARRAY.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.ITERABLE.isAssignable(strAndNum));
        Assert.assertFalse((boolean)TypeDescriptor.ITERABLE.isAssignable(strAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.ITERABLE.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.ITERATOR.isAssignable(strAndNum));
        Assert.assertFalse((boolean)TypeDescriptor.ITERATOR.isAssignable(strAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.ITERATOR.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.BOOLEAN.isAssignable(strAndNum));
        Assert.assertFalse((boolean)TypeDescriptor.BOOLEAN.isAssignable(strAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.BOOLEAN.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.HOST_OBJECT.isAssignable(strAndNum));
        Assert.assertFalse((boolean)TypeDescriptor.HOST_OBJECT.isAssignable(strAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.HOST_OBJECT.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.NATIVE_POINTER.isAssignable(strAndNum));
        Assert.assertFalse((boolean)TypeDescriptor.NATIVE_POINTER.isAssignable(strAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.NATIVE_POINTER.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.NULL.isAssignable(strAndNum));
        Assert.assertFalse((boolean)TypeDescriptor.NULL.isAssignable(strAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.NULL.isAssignable(strAndNumAndObj));
        Assert.assertTrue((boolean)TypeDescriptor.NUMBER.isAssignable(strAndNum));
        Assert.assertFalse((boolean)TypeDescriptor.NUMBER.isAssignable(strAndObj));
        Assert.assertTrue((boolean)TypeDescriptor.NUMBER.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)TypeDescriptor.OBJECT.isAssignable(strAndNum));
        Assert.assertTrue((boolean)TypeDescriptor.OBJECT.isAssignable(strAndObj));
        Assert.assertTrue((boolean)TypeDescriptor.OBJECT.isAssignable(strAndNumAndObj));
        Assert.assertTrue((boolean)TypeDescriptor.STRING.isAssignable(strAndNum));
        Assert.assertTrue((boolean)TypeDescriptor.STRING.isAssignable(strAndObj));
        Assert.assertTrue((boolean)TypeDescriptor.STRING.isAssignable(strAndNumAndObj));
        TypeDescriptor boolOrNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER});
        TypeDescriptor strOrNum = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING, TypeDescriptor.NUMBER});
        Assert.assertFalse((boolean)strAndNum.isAssignable(boolOrNum));
        Assert.assertFalse((boolean)strAndNum.isAssignable(strOrNum));
        Assert.assertTrue((boolean)boolOrNum.isAssignable(strAndNum));
        Assert.assertTrue((boolean)strOrNum.isAssignable(strAndNum));
        TypeDescriptor product = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{boolOrNum, strOrNum});
        Assert.assertTrue((boolean)product.equals((Object)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER}), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, TypeDescriptor.STRING}), TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING})})));
        Assert.assertTrue((boolean)product.isAssignable(strAndNum));
        Assert.assertFalse((boolean)product.isAssignable(strAndObj));
        Assert.assertTrue((boolean)product.isAssignable(strAndNumAndObj));
        Assert.assertFalse((boolean)strAndNum.isAssignable(product));
        Assert.assertFalse((boolean)strAndObj.isAssignable(product));
        Assert.assertFalse((boolean)strAndNumAndObj.isAssignable(product));
        TypeDescriptor numAndArrNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertFalse((boolean)numAndArrNum.isAssignable(TypeDescriptor.NUMBER));
        Assert.assertFalse((boolean)numAndArrNum.isAssignable(TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)));
        Assert.assertTrue((boolean)TypeDescriptor.NUMBER.isAssignable(numAndArrNum));
        Assert.assertTrue((boolean)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(numAndArrNum));
        Assert.assertTrue((boolean)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.OBJECT}).isAssignable(numAndArrNum));
        TypeDescriptor arrAndArrNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ARRAY, TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertTrue((boolean)arrAndArrNum.isAssignable(TypeDescriptor.ARRAY));
        Assert.assertTrue((boolean)arrAndArrNum.isAssignable(TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER)));
        Assert.assertTrue((boolean)TypeDescriptor.ARRAY.isAssignable(arrAndArrNum));
        Assert.assertFalse((boolean)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(arrAndArrNum));
        TypeDescriptor numAndIterableNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertFalse((boolean)numAndIterableNum.isAssignable(TypeDescriptor.NUMBER));
        Assert.assertFalse((boolean)numAndIterableNum.isAssignable(TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER)));
        Assert.assertTrue((boolean)TypeDescriptor.NUMBER.isAssignable(numAndIterableNum));
        Assert.assertTrue((boolean)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(numAndIterableNum));
        Assert.assertTrue((boolean)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.OBJECT}).isAssignable(numAndIterableNum));
        TypeDescriptor iterableAnyAndIterableNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ITERABLE, TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertTrue((boolean)iterableAnyAndIterableNum.isAssignable(TypeDescriptor.ITERABLE));
        Assert.assertTrue((boolean)iterableAnyAndIterableNum.isAssignable(TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER)));
        Assert.assertTrue((boolean)TypeDescriptor.ITERABLE.isAssignable(iterableAnyAndIterableNum));
        Assert.assertFalse((boolean)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(iterableAnyAndIterableNum));
        TypeDescriptor numAndIteratorNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertFalse((boolean)numAndIteratorNum.isAssignable(TypeDescriptor.NUMBER));
        Assert.assertFalse((boolean)numAndIteratorNum.isAssignable(TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER)));
        Assert.assertTrue((boolean)TypeDescriptor.NUMBER.isAssignable(numAndIteratorNum));
        Assert.assertTrue((boolean)TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(numAndIteratorNum));
        Assert.assertTrue((boolean)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER), TypeDescriptor.OBJECT}).isAssignable(numAndIteratorNum));
        TypeDescriptor iteratorAnyAndIteratorNum = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.ITERATOR, TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER)});
        Assert.assertTrue((boolean)iteratorAnyAndIteratorNum.isAssignable(TypeDescriptor.ITERATOR));
        Assert.assertTrue((boolean)iteratorAnyAndIteratorNum.isAssignable(TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER)));
        Assert.assertTrue((boolean)TypeDescriptor.ITERATOR.isAssignable(iteratorAnyAndIteratorNum));
        Assert.assertFalse((boolean)TypeDescriptor.iterator((TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(iteratorAnyAndIteratorNum));
        TypeDescriptor numAndHashNumToStr = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING)});
        Assert.assertFalse((boolean)numAndHashNumToStr.isAssignable(TypeDescriptor.NUMBER));
        Assert.assertFalse((boolean)numAndHashNumToStr.isAssignable(TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING)));
        Assert.assertTrue((boolean)TypeDescriptor.NUMBER.isAssignable(numAndHashNumToStr));
        Assert.assertTrue((boolean)TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING).isAssignable(numAndHashNumToStr));
        Assert.assertTrue((boolean)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING), TypeDescriptor.OBJECT}).isAssignable(numAndHashNumToStr));
        TypeDescriptor hashAnyToAnyAndHashNumStr = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HASH, TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING)});
        Assert.assertTrue((boolean)hashAnyToAnyAndHashNumStr.isAssignable(TypeDescriptor.HASH));
        Assert.assertTrue((boolean)hashAnyToAnyAndHashNumStr.isAssignable(TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING)));
        Assert.assertTrue((boolean)TypeDescriptor.HASH.isAssignable(hashAnyToAnyAndHashNumStr));
        Assert.assertFalse((boolean)TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.STRING).isAssignable(hashAnyToAnyAndHashNumStr));
        TypeDescriptor numAndStr = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING});
        TypeDescriptor numAndStrAndBool = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING, TypeDescriptor.BOOLEAN});
        TypeDescriptor numAndStrAndObj = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING, TypeDescriptor.OBJECT});
        Assert.assertTrue((boolean)numAndStr.isAssignable(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{numAndStrAndBool, numAndStrAndObj})));
        TypeDescriptor instantiableAndHostObject = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.HOST_OBJECT, (boolean)false, (TypeDescriptor[])new TypeDescriptor[0]), TypeDescriptor.HOST_OBJECT});
        TypeDescriptor instantiableAndHostObjectAndObject = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT}), (boolean)false, (TypeDescriptor[])new TypeDescriptor[0]), TypeDescriptor.HOST_OBJECT, TypeDescriptor.OBJECT});
        Assert.assertTrue((boolean)TypeDescriptor.INSTANTIABLE_ANY.isAssignable(instantiableAndHostObject));
        Assert.assertTrue((boolean)TypeDescriptor.INSTANTIABLE_ANY.isAssignable(instantiableAndHostObjectAndObject));
        Assert.assertTrue((boolean)instantiableAndHostObject.isAssignable(instantiableAndHostObjectAndObject));
        Assert.assertFalse((boolean)instantiableAndHostObjectAndObject.isAssignable(instantiableAndHostObject));
    }

    @Test
    public void testUnionBothExecutables() {
        Assert.assertTrue((boolean)TypeDescriptor.EXECUTABLE_ANY.isAssignable(TypeDescriptor.EXECUTABLE));
        TypeDescriptor objOrExecUp = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, TypeDescriptor.EXECUTABLE_ANY});
        TypeDescriptor objOrExecLow = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, TypeDescriptor.EXECUTABLE});
        Assert.assertTrue((boolean)objOrExecUp.isAssignable(objOrExecLow));
        TypeDescriptor objOrExecUpOrExecLow = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.OBJECT, TypeDescriptor.EXECUTABLE_ANY, TypeDescriptor.EXECUTABLE});
        Assert.assertTrue((boolean)objOrExecUp.isAssignable(objOrExecUpOrExecLow));
    }

    @Test
    public void testInstantiablesWithExecutables() {
        Assert.assertFalse((boolean)TypeDescriptor.EXECUTABLE_ANY.isAssignable(TypeDescriptor.INSTANTIABLE));
        Assert.assertFalse((boolean)TypeDescriptor.EXECUTABLE_ANY.isAssignable(TypeDescriptor.INSTANTIABLE_ANY));
        Assert.assertFalse((boolean)TypeDescriptor.EXECUTABLE.isAssignable(TypeDescriptor.INSTANTIABLE));
        Assert.assertFalse((boolean)TypeDescriptor.EXECUTABLE.isAssignable(TypeDescriptor.INSTANTIABLE_ANY));
        Assert.assertFalse((boolean)TypeDescriptor.INSTANTIABLE_ANY.isAssignable(TypeDescriptor.EXECUTABLE));
        Assert.assertFalse((boolean)TypeDescriptor.INSTANTIABLE_ANY.isAssignable(TypeDescriptor.EXECUTABLE_ANY));
        Assert.assertFalse((boolean)TypeDescriptor.INSTANTIABLE.isAssignable(TypeDescriptor.EXECUTABLE));
        Assert.assertFalse((boolean)TypeDescriptor.INSTANTIABLE.isAssignable(TypeDescriptor.EXECUTABLE_ANY));
        TypeDescriptor executable = TypeDescriptor.executable((TypeDescriptor)TypeDescriptor.OBJECT, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING});
        TypeDescriptor instantiable = TypeDescriptor.instantiable((TypeDescriptor)TypeDescriptor.OBJECT, (boolean)true, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.STRING});
        Assert.assertFalse((boolean)executable.isAssignable(instantiable));
        Assert.assertFalse((boolean)instantiable.isAssignable(executable));
        Assert.assertFalse((boolean)TypeDescriptor.EXECUTABLE_ANY.isAssignable(instantiable));
        Assert.assertFalse((boolean)TypeDescriptor.INSTANTIABLE_ANY.isAssignable(executable));
    }

    @Test
    public void testForValue() {
        TypeDescriptor all = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NULL, TypeDescriptor.BOOLEAN, TypeDescriptor.NUMBER, TypeDescriptor.STRING, TypeDescriptor.HOST_OBJECT, TypeDescriptor.NATIVE_POINTER, TypeDescriptor.OBJECT, TypeDescriptor.ARRAY, TypeDescriptor.EXECUTABLE, TypeDescriptor.INSTANTIABLE, TypeDescriptor.ITERABLE, TypeDescriptor.ITERATOR, TypeDescriptor.DATE, TypeDescriptor.TIME, TypeDescriptor.TIME_ZONE, TypeDescriptor.DURATION, TypeDescriptor.META_OBJECT, TypeDescriptor.EXCEPTION});
        try (TestContext testContext = new TestContext(TypeDescriptorTest.class);){
            Context ctx = testContext.getContext();
            Value v = ctx.asValue((Object)1);
            Assert.assertTrue((boolean)TypeDescriptor.NUMBER.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)true);
            Assert.assertTrue((boolean)TypeDescriptor.BOOLEAN.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)"a");
            Assert.assertTrue((boolean)TypeDescriptor.STRING.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue(null);
            Assert.assertTrue((boolean)TypeDescriptor.NULL.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyObject.fromMap(Collections.singletonMap("key", "value")));
            Assert.assertTrue((boolean)TypeDescriptor.OBJECT.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)new Function<Object, Object>(){

                @Override
                public Object apply(Object t) {
                    return null;
                }
            });
            Assert.assertTrue((boolean)TypeDescriptor.EXECUTABLE.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue(Object.class);
            Assert.assertTrue((boolean)TypeDescriptor.INSTANTIABLE.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue(new Object());
            Assert.assertTrue((boolean)TypeDescriptor.HOST_OBJECT.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyArray.fromArray((Object[])new Object[]{1}));
            Assert.assertTrue((boolean)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyArray.fromArray((Object[])new Object[]{true}));
            Assert.assertTrue((boolean)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.BOOLEAN).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyArray.fromArray((Object[])new Object[]{1, true, "value"}));
            Assert.assertTrue((boolean)TypeDescriptor.array((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.BOOLEAN, TypeDescriptor.STRING})).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyArray.fromArray((Object[])new Object[0]));
            Assert.assertTrue((boolean)TypeDescriptor.array((TypeDescriptor)all).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyIterable.from(Collections.singleton(1)));
            Assert.assertTrue((boolean)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyIterable.from(Collections.singleton(true)));
            Assert.assertTrue((boolean)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.BOOLEAN).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyIterable.from(Arrays.asList(1, true, "value")));
            Assert.assertTrue((boolean)TypeDescriptor.iterable((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.BOOLEAN, TypeDescriptor.STRING})).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyIterable.from(Collections.emptySet()));
            Assert.assertTrue((boolean)TypeDescriptor.iterable((TypeDescriptor)all).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyIterator.from(Collections.singleton(1).iterator()));
            Assert.assertTrue((boolean)TypeDescriptor.ITERATOR.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyIterator.from(Collections.singleton(true).iterator()));
            Assert.assertTrue((boolean)TypeDescriptor.ITERATOR.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyIterator.from(Arrays.asList(1, true, "value").iterator()));
            Assert.assertTrue((boolean)TypeDescriptor.ITERATOR.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyIterator.from(Collections.emptySet().iterator()));
            Assert.assertTrue((boolean)TypeDescriptor.ITERATOR.isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyHashMap.from(Collections.emptyMap()));
            Assert.assertTrue((boolean)TypeDescriptor.hash((TypeDescriptor)all, (TypeDescriptor)all).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyHashMap.from(Collections.singletonMap("str", 1)));
            Assert.assertTrue((boolean)TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.STRING, (TypeDescriptor)TypeDescriptor.NUMBER).isAssignable(TypeDescriptor.forValue((Value)v)));
            v = ctx.asValue((Object)ProxyHashMap.from(Collections.singletonMap(1, true)));
            Assert.assertTrue((boolean)TypeDescriptor.hash((TypeDescriptor)TypeDescriptor.NUMBER, (TypeDescriptor)TypeDescriptor.BOOLEAN).isAssignable(TypeDescriptor.forValue((Value)v)));
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            m.put(1, true);
            m.put(2, "str");
            m.put("str", 1);
            v = ctx.asValue((Object)ProxyHashMap.from(m));
            TypeDescriptor keyType = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.NUMBER, TypeDescriptor.STRING});
            TypeDescriptor valueType = TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.BOOLEAN, TypeDescriptor.STRING, TypeDescriptor.NUMBER});
            Assert.assertTrue((boolean)TypeDescriptor.hash((TypeDescriptor)keyType, (TypeDescriptor)valueType).isAssignable(TypeDescriptor.forValue((Value)v)));
        }
    }
}

