/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;
import org.junit.Assert;

public class ValueAssert {
    private static final TypeLiteral<List<Object>> OBJECT_LIST = new TypeLiteral<List<Object>>(){};
    private static final TypeLiteral<Map<Object, Object>> OBJECT_OBJECT_MAP = new TypeLiteral<Map<Object, Object>>(){};
    private static final TypeLiteral<Map<String, Object>> STRING_OBJECT_MAP = new TypeLiteral<Map<String, Object>>(){};
    private static final TypeLiteral<Map<Long, Object>> LONG_OBJECT_MAP = new TypeLiteral<Map<Long, Object>>(){};
    private static final TypeLiteral<Map<Integer, Object>> INTEGER_OBJECT_MAP = new TypeLiteral<Map<Integer, Object>>(){};
    private static final TypeLiteral<Map<Short, Object>> SHORT_OBJECT_MAP = new TypeLiteral<Map<Short, Object>>(){};
    private static final TypeLiteral<Map<Byte, Object>> BYTE_OBJECT_MAP = new TypeLiteral<Map<Byte, Object>>(){};
    private static final TypeLiteral<Map<Number, Object>> NUMBER_OBJECT_MAP = new TypeLiteral<Map<Number, Object>>(){};
    private static final TypeLiteral<Map<Float, Object>> FLOAT_OBJECT_MAP = new TypeLiteral<Map<Float, Object>>(){};
    private static final TypeLiteral<Map<Double, Object>> DOUBLE_OBJECT_MAP = new TypeLiteral<Map<Double, Object>>(){};
    private static final TypeLiteral<Function<Object, Object>> FUNCTION = new TypeLiteral<Function<Object, Object>>(){};
    private static final TypeLiteral<Iterable<Object>> OBJECT_ITERABLE = new TypeLiteral<Iterable<Object>>(){};
    private static final TypeLiteral<Iterator<Object>> OBJECT_ITERATOR = new TypeLiteral<Iterator<Object>>(){};

    public static void assertValue(Value value) {
        ValueAssert.assertValue(value, ValueAssert.detectSupportedTypes(value));
    }

    public static void assertValue(Value value, Trait ... expectedTypes) {
        try {
            ValueAssert.assertValueImpl(value, 0, true, expectedTypes);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)((Object)new AssertionError((Object)String.format("assertValue: %s traits: %s", value, Arrays.asList(expectedTypes)))));
            throw e;
        }
    }

    public static void assertValue(Value value, boolean hasHostAccess, Trait ... expectedTypes) {
        try {
            ValueAssert.assertValueImpl(value, 0, hasHostAccess, expectedTypes);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)((Object)new AssertionError((Object)String.format("assertValue: %s traits: %s", value, Arrays.asList(expectedTypes)))));
            throw e;
        }
    }

    public static void assertValueFast(Value value) {
        try {
            ValueAssert.detectSupportedTypes(value);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)((Object)new AssertionError((Object)String.format("assertValue: %s", value))));
            throw e;
        }
    }

    public static void assertUnsupported(Value value, Trait ... supported) {
        HashSet<Trait> supportedSet = new HashSet<Trait>(Arrays.asList(supported));
        block23: for (Trait unsupportedType : Trait.values()) {
            if (supportedSet.contains((Object)unsupportedType)) continue;
            switch (unsupportedType) {
                case NUMBER: {
                    Assert.assertFalse((boolean)value.isNumber());
                    Assert.assertFalse((boolean)value.fitsInByte());
                    Assert.assertFalse((boolean)value.fitsInShort());
                    Assert.assertFalse((boolean)value.fitsInInt());
                    Assert.assertFalse((boolean)value.fitsInLong());
                    Assert.assertFalse((boolean)value.fitsInFloat());
                    Assert.assertFalse((boolean)value.fitsInDouble());
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.as(Number.class));
                        Assert.assertNull((Object)value.as(Byte.class));
                        Assert.assertNull((Object)value.as(Short.class));
                        Assert.assertNull((Object)value.as(Integer.class));
                        Assert.assertNull((Object)value.as(Long.class));
                        Assert.assertNull((Object)value.as(Float.class));
                        ValueAssert.assertFails(() -> value.as(Byte.TYPE), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.as(Short.TYPE), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.as(Integer.TYPE), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.as(Long.TYPE), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.as(Float.TYPE), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.asByte(), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.asShort(), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.asInt(), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.asLong(), NullPointerException.class);
                        ValueAssert.assertFails(() -> Float.valueOf(value.asFloat()), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.asDouble(), NullPointerException.class);
                        continue block23;
                    }
                    if (value.isHostObject() && value.asHostObject() instanceof Number) {
                        Assert.assertSame((Object)value.asHostObject(), (Object)value.as(Number.class));
                    } else {
                        ValueAssert.assertFails(() -> value.as(Number.class), ClassCastException.class);
                    }
                    ValueAssert.assertFails(() -> value.as(Byte.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Short.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Integer.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Long.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Float.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Byte.TYPE), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Short.TYPE), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Integer.TYPE), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Long.TYPE), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Float.TYPE), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.asByte(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.asShort(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.asInt(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.asLong(), ClassCastException.class);
                    ValueAssert.assertFails(() -> Float.valueOf(value.asFloat()), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.asDouble(), ClassCastException.class);
                    continue block23;
                }
                case BOOLEAN: {
                    Assert.assertFalse((boolean)value.isBoolean());
                    if (value.isNull()) {
                        ValueAssert.assertFails(() -> value.asBoolean(), NullPointerException.class);
                        ValueAssert.assertFails(() -> value.as(Boolean.TYPE), NullPointerException.class);
                        Assert.assertNull((Object)value.as(Boolean.class));
                        continue block23;
                    }
                    ValueAssert.assertFails(() -> value.asBoolean(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Boolean.TYPE), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Boolean.class), ClassCastException.class);
                    continue block23;
                }
                case STRING: {
                    Assert.assertFalse((boolean)value.isString());
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.as(String.class));
                        Assert.assertNull((Object)value.as(Character.class));
                        Assert.assertNull((Object)value.asString());
                        continue block23;
                    }
                    ValueAssert.assertFails(() -> value.asString(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(String.class), ClassCastException.class);
                    if (value.fitsInInt() && value.asInt() >= 0 && value.asInt() < 65536) {
                        Assert.assertEquals((Object)Character.valueOf((char)value.asInt()), (Object)value.as(Character.class));
                        Assert.assertEquals((Object)Character.valueOf((char)value.asInt()), (Object)value.as(Character.TYPE));
                        continue block23;
                    }
                    ValueAssert.assertFails(() -> value.as(Character.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Character.TYPE), ClassCastException.class);
                    continue block23;
                }
                case MEMBERS: {
                    Assert.assertFalse((boolean)value.hasMembers());
                    Assert.assertFalse((boolean)value.hasMember("asdf"));
                    ValueAssert.assertFails(() -> value.getMember("asdf"), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.putMember("", (Object)""), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.removeMember(""), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.invokeMember("", new Object[0]), UnsupportedOperationException.class);
                    Assert.assertTrue((boolean)value.getMemberKeys().isEmpty());
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.as(Map.class));
                        continue block23;
                    }
                    if (value.isHostObject() && value.asHostObject() instanceof Map || value.hasHashEntries()) continue block23;
                    ValueAssert.assertFails(() -> value.as(Map.class), ClassCastException.class);
                    continue block23;
                }
                case EXECUTABLE: {
                    Assert.assertFalse((String)value.toString(), (boolean)value.canExecute());
                    ValueAssert.assertFails(() -> value.execute(new Object[0]), UnsupportedOperationException.class);
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.as(Function.class));
                        Assert.assertNull((Object)value.as(IsFunctionalInterfaceVarArgs.class));
                        continue block23;
                    }
                    if (value.canInstantiate()) continue block23;
                    if (value.hasMembers()) {
                        ValueAssert.assertFails(() -> ((Function)value.as(FUNCTION)).apply(null), UnsupportedOperationException.class);
                        ValueAssert.assertFails(() -> ((IsFunctionalInterfaceVarArgs)value.as(IsFunctionalInterfaceVarArgs.class)).foobarbaz(123), UnsupportedOperationException.class);
                        continue block23;
                    }
                    if (value.isHostObject() && value.asHostObject() instanceof Function) continue block23;
                    ValueAssert.assertFails(() -> value.as(FUNCTION), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(IsFunctionalInterfaceVarArgs.class), ClassCastException.class);
                    continue block23;
                }
                case INSTANTIABLE: {
                    Assert.assertFalse((boolean)value.canInstantiate());
                    ValueAssert.assertFails(() -> value.newInstance(new Object[0]), UnsupportedOperationException.class);
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.as(Function.class));
                        Assert.assertNull((Object)value.as(IsFunctionalInterfaceVarArgs.class));
                        continue block23;
                    }
                    if (value.canExecute()) continue block23;
                    if (value.hasMembers()) {
                        ValueAssert.assertFails(() -> ((Function)value.as(FUNCTION)).apply(null), UnsupportedOperationException.class);
                        ValueAssert.assertFails(() -> ((IsFunctionalInterfaceVarArgs)value.as(IsFunctionalInterfaceVarArgs.class)).foobarbaz(123), UnsupportedOperationException.class);
                        continue block23;
                    }
                    if (value.isHostObject() && value.asHostObject() instanceof Function) continue block23;
                    ValueAssert.assertFails(() -> value.as(FUNCTION), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(IsFunctionalInterfaceVarArgs.class), ClassCastException.class);
                    continue block23;
                }
                case NULL: {
                    Assert.assertFalse((boolean)value.isNull());
                    continue block23;
                }
                case ARRAY_ELEMENTS: {
                    Assert.assertFalse((boolean)value.hasArrayElements());
                    ValueAssert.assertFails(() -> value.getArrayElement(0L), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.setArrayElement(0L, null), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.getArraySize(), UnsupportedOperationException.class);
                    if (!value.isNull()) {
                        if (value.isHostObject() && (value.asHostObject() instanceof List || value.asHostObject() instanceof Object[])) continue block23;
                        ValueAssert.assertFails(() -> value.as(List.class), ClassCastException.class);
                        ValueAssert.assertFails(() -> value.as(Object[].class), ClassCastException.class);
                        continue block23;
                    }
                    Assert.assertNull((Object)value.as(List.class));
                    Assert.assertNull((Object)value.as(Object[].class));
                    continue block23;
                }
                case BUFFER_ELEMENTS: {
                    Assert.assertFalse((boolean)value.hasBufferElements());
                    ValueAssert.assertFails(() -> value.isBufferWritable(), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.getBufferSize(), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.readBufferByte(0L), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.writeBufferByte(0L, (byte)0), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.readBufferShort(ByteOrder.LITTLE_ENDIAN, 0L), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.writeBufferShort(ByteOrder.LITTLE_ENDIAN, 0L, (short)0), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.readBufferInt(ByteOrder.LITTLE_ENDIAN, 0L), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.writeBufferInt(ByteOrder.LITTLE_ENDIAN, 0L, 0), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.readBufferLong(ByteOrder.LITTLE_ENDIAN, 0L), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.writeBufferLong(ByteOrder.LITTLE_ENDIAN, 0L, 0L), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> Float.valueOf(value.readBufferFloat(ByteOrder.LITTLE_ENDIAN, 0L)), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.writeBufferFloat(ByteOrder.LITTLE_ENDIAN, 0L, 0.0f), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.readBufferDouble(ByteOrder.LITTLE_ENDIAN, 0L), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.writeBufferDouble(ByteOrder.LITTLE_ENDIAN, 0L, 0.0), UnsupportedOperationException.class);
                    if (!value.isNull()) {
                        if (value.isHostObject() && value.asHostObject() instanceof ByteBuffer) continue block23;
                        ValueAssert.assertFails(() -> value.as(ByteBuffer.class), ClassCastException.class);
                        continue block23;
                    }
                    Assert.assertNull((Object)value.as(ByteBuffer.class));
                    continue block23;
                }
                case HOST_OBJECT: {
                    Assert.assertFalse((boolean)value.isHostObject());
                    ValueAssert.assertFails(() -> value.asHostObject(), ClassCastException.class);
                    continue block23;
                }
                case PROXY_OBJECT: {
                    Assert.assertFalse((boolean)value.isProxyObject());
                    ValueAssert.assertFails(() -> value.asProxyObject(), ClassCastException.class);
                    continue block23;
                }
                case NATIVE: {
                    Assert.assertFalse((boolean)value.isNativePointer());
                    ValueAssert.assertFails(() -> value.asNativePointer(), ClassCastException.class);
                    continue block23;
                }
                case DATE: {
                    Assert.assertFalse((boolean)value.isDate());
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.asDate());
                        Assert.assertNull((Object)value.asInstant());
                        Assert.assertNull((Object)value.as(LocalDateTime.class));
                        Assert.assertNull((Object)value.as(LocalDate.class));
                        Assert.assertNull((Object)value.as(ZonedDateTime.class));
                        Assert.assertNull((Object)value.as(Date.class));
                        continue block23;
                    }
                    ValueAssert.assertFails(() -> value.asDate(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.asInstant(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(LocalDateTime.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(LocalDate.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(ZonedDateTime.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Date.class), ClassCastException.class);
                    continue block23;
                }
                case TIME: {
                    Assert.assertFalse((boolean)value.isTime());
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.asTime());
                        Assert.assertNull((Object)value.asInstant());
                        Assert.assertNull((Object)value.as(LocalDateTime.class));
                        Assert.assertNull((Object)value.as(LocalTime.class));
                        Assert.assertNull((Object)value.as(ZonedDateTime.class));
                        Assert.assertNull((Object)value.as(Date.class));
                        continue block23;
                    }
                    ValueAssert.assertFails(() -> value.asTime(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.asInstant(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(LocalDateTime.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(LocalTime.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(ZonedDateTime.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Date.class), ClassCastException.class);
                    continue block23;
                }
                case TIMEZONE: {
                    Assert.assertFalse((boolean)value.isTimeZone());
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.asTimeZone());
                        Assert.assertNull((Object)value.asInstant());
                        Assert.assertNull((Object)value.as(ZoneId.class));
                        Assert.assertNull((Object)value.as(ZoneOffset.class));
                        Assert.assertNull((Object)value.as(ZonedDateTime.class));
                        Assert.assertNull((Object)value.as(Date.class));
                        continue block23;
                    }
                    ValueAssert.assertFails(() -> value.asTimeZone(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.asInstant(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(ZoneId.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(ZoneOffset.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(ZonedDateTime.class), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Date.class), ClassCastException.class);
                    continue block23;
                }
                case DURATION: {
                    Assert.assertFalse((boolean)value.isDuration());
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.asDuration());
                        Assert.assertNull((Object)value.as(Duration.class));
                        continue block23;
                    }
                    ValueAssert.assertFails(() -> value.asDuration(), ClassCastException.class);
                    ValueAssert.assertFails(() -> value.as(Duration.class), ClassCastException.class);
                    continue block23;
                }
                case EXCEPTION: {
                    Assert.assertFalse((boolean)value.isException());
                    ValueAssert.assertFails(() -> value.throwException(), UnsupportedOperationException.class);
                    continue block23;
                }
                case META: {
                    Assert.assertFalse((boolean)value.isMetaObject());
                    ValueAssert.assertFails(() -> value.getMetaQualifiedName(), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.getMetaSimpleName(), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.isMetaInstance((Object)""), UnsupportedOperationException.class);
                    Assert.assertFalse((boolean)value.hasMetaParents());
                    ValueAssert.assertFails(() -> value.getMetaParents(), UnsupportedOperationException.class);
                    continue block23;
                }
                case ITERABLE: {
                    Assert.assertFalse((boolean)value.hasIterator());
                    ValueAssert.assertFails(() -> value.getIterator(), UnsupportedOperationException.class);
                    continue block23;
                }
                case ITERATOR: {
                    Assert.assertFalse((boolean)value.isIterator());
                    ValueAssert.assertFails(() -> value.hasIteratorNextElement(), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.getIteratorNextElement(), UnsupportedOperationException.class);
                    continue block23;
                }
                case HASH: {
                    Assert.assertFalse((boolean)value.hasHashEntries());
                    Assert.assertFalse((boolean)value.hasHashEntry((Object)"asdf"));
                    ValueAssert.assertFails(() -> value.getHashValue((Object)"asdf"), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.putHashEntry((Object)"", (Object)""), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.removeHashEntry((Object)""), UnsupportedOperationException.class);
                    ValueAssert.assertFails(() -> value.getHashEntriesIterator(), UnsupportedOperationException.class);
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.as(Map.class));
                        continue block23;
                    }
                    if (value.isHostObject() && value.asHostObject() instanceof Map || value.hasMembers()) continue block23;
                    ValueAssert.assertFails(() -> value.as(Map.class), ClassCastException.class);
                    continue block23;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private static void assertValueImpl(Value value, int depth, boolean hasHostAccess, Trait ... expectedTypes) {
        if (depth > 1) {
            return;
        }
        Assert.assertNotNull((Object)value.toString());
        Value metaObject = value.getMetaObject();
        if (metaObject != null && depth == 0) {
            ValueAssert.assertValueImpl(metaObject, depth + 1, hasHostAccess, ValueAssert.detectSupportedTypes(metaObject));
            Assert.assertNotNull((Object)metaObject.toString());
        }
        Assert.assertSame((Object)value, (Object)value.as(Value.class));
        block32: for (Trait supportedType : expectedTypes) {
            String msg = "expected " + supportedType.name() + " but was " + value.toString();
            switch (supportedType) {
                case NULL: {
                    Assert.assertTrue((String)msg, (boolean)value.isNull());
                    continue block32;
                }
                case BOOLEAN: {
                    Assert.assertTrue((String)msg, (boolean)value.isBoolean());
                    boolean booleanValue = value.asBoolean();
                    Assert.assertEquals((Object)booleanValue, (Object)value.as(Boolean.class));
                    Assert.assertEquals((Object)booleanValue, (Object)value.as(Boolean.TYPE));
                    continue block32;
                }
                case STRING: {
                    Assert.assertTrue((String)msg, (boolean)value.isString());
                    String stringValue = value.asString();
                    Assert.assertEquals((Object)stringValue, (Object)value.as(String.class));
                    if (stringValue.length() != 1) continue block32;
                    Assert.assertEquals((long)stringValue.charAt(0), (long)((Character)value.as(Character.class)).charValue());
                    Assert.assertEquals((long)stringValue.charAt(0), (long)((Character)value.as(Character.TYPE)).charValue());
                    continue block32;
                }
                case NUMBER: {
                    ValueAssert.assertValueNumber(value);
                    continue block32;
                }
                case ARRAY_ELEMENTS: {
                    Assert.assertTrue((String)msg, (boolean)value.hasArrayElements());
                    ValueAssert.assertValueArrayElements(value, depth, hasHostAccess);
                    continue block32;
                }
                case BUFFER_ELEMENTS: {
                    Assert.assertTrue((String)msg, (boolean)value.hasBufferElements());
                    ValueAssert.assertValueBufferElements(value);
                    continue block32;
                }
                case EXECUTABLE: {
                    Assert.assertTrue((String)msg, (boolean)value.canExecute());
                    ValueAssert.assertFunctionalInterfaceMapping(value);
                    continue block32;
                }
                case INSTANTIABLE: {
                    Assert.assertTrue((String)msg, (boolean)value.canInstantiate());
                    value.as(Function.class);
                    if (value.canExecute()) continue block32;
                    ValueAssert.assertFunctionalInterfaceMapping(value);
                    continue block32;
                }
                case HOST_OBJECT: {
                    Assert.assertTrue((String)msg, (boolean)value.isHostObject());
                    Object hostObject = value.asHostObject();
                    Assert.assertFalse((boolean)(hostObject instanceof Proxy));
                    boolean isStaticClass = false;
                    if (hasHostAccess && hostObject != null && value.hasMembers() && !java.lang.reflect.Proxy.isProxyClass(hostObject.getClass())) {
                        if (hostObject instanceof Class) {
                            isStaticClass = value.hasMember("class");
                            if (isStaticClass) {
                                ValueAssert.assertClassMembers(value, (Class)hostObject, true);
                            } else {
                                ValueAssert.assertClassMembers(value, Class.class, false);
                                Assert.assertTrue((boolean)value.hasMember("static"));
                            }
                        } else {
                            for (Class<?> clazz = hostObject.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                                if (!Modifier.isPublic(clazz.getModifiers())) continue;
                                ValueAssert.assertClassMembers(value, clazz, false);
                                break;
                            }
                        }
                    }
                    if (isStaticClass) {
                        Assert.assertNotEquals((Object)Value.asValue((Object)hostObject), (Object)value);
                    } else {
                        Assert.assertEquals((Object)Value.asValue((Object)hostObject), (Object)value);
                    }
                    Assert.assertEquals((long)Value.asValue((Object)hostObject).hashCode(), (long)value.hashCode());
                    continue block32;
                }
                case PROXY_OBJECT: {
                    Assert.assertTrue((String)msg, (boolean)value.isProxyObject());
                    Proxy proxyObject = value.asProxyObject();
                    Assert.assertTrue((boolean)(proxyObject instanceof Proxy));
                    Assert.assertEquals((Object)Value.asValue((Object)proxyObject), (Object)value);
                    Assert.assertEquals((long)Value.asValue((Object)proxyObject).hashCode(), (long)value.hashCode());
                    continue block32;
                }
                case MEMBERS: {
                    Map<String, Object> expectedValues;
                    Object key2;
                    Assert.assertTrue((String)msg, (boolean)value.hasMembers());
                    for (Object key2 : value.getMemberKeys()) {
                        Value child = value.getMember((String)key2);
                        if (child == null) {
                            Assert.assertTrue((String)"A non-readable member must at least be modifiable, removable, or invocable", (boolean)value.hasMember((String)key2));
                            continue;
                        }
                        if (ValueAssert.isSameHostObject(value, child)) continue;
                        ValueAssert.assertValueImpl(child, depth + 1, hasHostAccess, ValueAssert.detectSupportedTypes(child));
                    }
                    if (value.isNull()) {
                        Assert.assertNull((Object)value.as(STRING_OBJECT_MAP));
                        continue block32;
                    }
                    if (value.isHostObject() && value.asHostObject() instanceof Map) {
                        expectedValues = (Map)value.asHostObject();
                        Assert.assertEquals((Object)value.as(OBJECT_OBJECT_MAP), expectedValues);
                        continue block32;
                    }
                    if (value.hasHashEntries()) {
                        ValueAssert.assertHashKeys(value);
                        continue block32;
                    }
                    expectedValues = new HashMap();
                    key2 = value.getMemberKeys().iterator();
                    while (key2.hasNext()) {
                        String key3 = (String)key2.next();
                        Value child = value.getMember(key3);
                        expectedValues.put(key3, child.as(Object.class));
                    }
                    Map stringMap = (Map)value.as(STRING_OBJECT_MAP);
                    Assert.assertEquals((String)"PolyglotMap should be equal with itself", (Object)stringMap, (Object)stringMap);
                    Assert.assertEquals((String)"Two PolyglotMaps wrapping the same host object should be equal", (Object)value.as(STRING_OBJECT_MAP), (Object)value.as(STRING_OBJECT_MAP));
                    Assert.assertNotEquals((String)"A PolyglotMap should not be equal with a Map", (Object)value.as(STRING_OBJECT_MAP), expectedValues);
                    Set keySet = ((Map)value.as(Map.class)).keySet();
                    Assert.assertEquals((Object)value.getMemberKeys(), keySet);
                    for (String key4 : keySet) {
                        Assert.assertTrue((boolean)value.hasMember(key4));
                    }
                    Assert.assertNotNull((Object)((Map)value.as(STRING_OBJECT_MAP)).toString());
                    Assert.assertEquals((Object)value.toString(), (Object)((Map)value.as(Map.class)).toString());
                    continue block32;
                }
                case NATIVE: {
                    Assert.assertTrue((String)msg, (boolean)value.isNativePointer());
                    value.asNativePointer();
                    continue block32;
                }
                case DATE: {
                    Assert.assertFalse((boolean)value.isNull());
                    Assert.assertTrue((boolean)value.isDate());
                    Assert.assertNotNull((Object)value.asDate());
                    Assert.assertNotNull((Object)value.as(LocalDate.class));
                    if (!value.isTime()) continue block32;
                    Assert.assertEquals((Object)((LocalDateTime)value.as(LocalDateTime.class)).toLocalDate(), (Object)value.as(LocalDate.class));
                    Assert.assertEquals((Object)((LocalDateTime)value.as(LocalDateTime.class)).toLocalTime(), (Object)value.as(LocalTime.class));
                    if (!value.isTimeZone()) continue block32;
                    Assert.assertNotNull((Object)value.asInstant());
                    Assert.assertEquals((Object)((ZonedDateTime)value.as(ZonedDateTime.class)).toLocalDate(), (Object)value.as(LocalDate.class));
                    Assert.assertNotNull((Object)value.as(Instant.class));
                    Assert.assertNotNull((Object)value.as(Date.class));
                    continue block32;
                }
                case TIME: {
                    Assert.assertTrue((boolean)value.isTime());
                    Assert.assertNotNull((Object)value.asTime());
                    Assert.assertNotNull((Object)value.as(LocalTime.class));
                    if (value.isDate() || !value.isTimeZone()) continue block32;
                    ValueAssert.assertFails(() -> value.asTime(), AssertionError.class);
                    ValueAssert.assertFails(() -> value.asTimeZone(), AssertionError.class);
                    continue block32;
                }
                case TIMEZONE: {
                    Assert.assertTrue((boolean)value.isTimeZone());
                    Assert.assertNotNull((Object)value.asTimeZone());
                    Assert.assertNotNull((Object)value.as(ZoneId.class));
                    continue block32;
                }
                case DURATION: {
                    Assert.assertTrue((boolean)value.isDuration());
                    Assert.assertNotNull((Object)value.asDuration());
                    Assert.assertNotNull((Object)value.as(Duration.class));
                    continue block32;
                }
                case EXCEPTION: {
                    Assert.assertTrue((boolean)value.isException());
                    try {
                        value.throwException();
                        Assert.fail((String)"should have thrown");
                        continue block32;
                    }
                    catch (PolyglotException expectedValues) {
                        continue block32;
                    }
                    catch (UnsupportedOperationException unsupported) {
                        throw new AssertionError((Object)unsupported);
                    }
                }
                case META: {
                    Assert.assertTrue((boolean)value.isMetaObject());
                    Assert.assertNotNull((Object)value.getMetaQualifiedName());
                    Assert.assertNotNull((Object)value.getMetaSimpleName());
                    value.isMetaInstance((Object)"");
                    if (value.hasMetaParents()) {
                        try {
                            Value metaParents = value.getMetaParents();
                            Assert.assertTrue((boolean)metaParents.hasArrayElements());
                            long size = metaParents.getArraySize();
                            for (long i = 0L; i < size; ++i) {
                                Value metaParent = metaParents.getArrayElement(i);
                                ValueAssert.assertValueImpl(metaParent, depth + 1, hasHostAccess, ValueAssert.detectSupportedTypes(metaParent));
                            }
                            continue block32;
                        }
                        catch (PolyglotException notExpected) {
                            throw new AssertionError((Object)notExpected);
                        }
                        catch (UnsupportedOperationException notExpected) {
                            continue block32;
                        }
                    }
                    try {
                        value.getMetaParents();
                        Assert.fail((String)"should have thrown");
                        continue block32;
                    }
                    catch (PolyglotException expected) {
                        throw new AssertionError((Object)expected);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        continue block32;
                    }
                }
                case ITERABLE: {
                    Assert.assertTrue((String)msg, (boolean)value.hasIterator());
                    ValueAssert.assertValueIterable(value, depth, hasHostAccess);
                    continue block32;
                }
                case ITERATOR: {
                    Assert.assertTrue((String)msg, (boolean)value.isIterator());
                    value.hasIteratorNextElement();
                    continue block32;
                }
                case HASH: {
                    Assert.assertTrue((String)msg, (boolean)value.hasHashEntries());
                    ValueAssert.assertValueHash(value, depth, hasHostAccess);
                    continue block32;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        ValueAssert.assertUnsupported(value, expectedTypes);
    }

    private static boolean isSameHostObject(Value a, Value b) {
        return a.isHostObject() && b.isHostObject() && a.asHostObject() == b.asHostObject();
    }

    private static void assertValueArrayElements(Value value, int depth, boolean hasHostAccess) {
        Assert.assertTrue((boolean)value.hasArrayElements());
        ArrayList<Object> receivedObjects = new ArrayList<Object>();
        HashMap<Long, Object> receivedObjectsLongMap = new HashMap<Long, Object>();
        HashMap<Integer, Object> receivedObjectsIntMap = new HashMap<Integer, Object>();
        for (long i = 0L; i < value.getArraySize(); ++i) {
            Value arrayElement = value.getArrayElement(i);
            receivedObjects.add(arrayElement.as(Object.class));
            receivedObjectsLongMap.put(i, arrayElement.as(Object.class));
            receivedObjectsIntMap.put((int)i, arrayElement.as(Object.class));
            ValueAssert.assertValueImpl(arrayElement, depth + 1, hasHostAccess, ValueAssert.detectSupportedTypes(arrayElement));
        }
        List objectList1 = (List)value.as(OBJECT_LIST);
        List<Object> objectList2 = Arrays.asList((Object[])value.as(Object[].class));
        if (!value.isHostObject() || !(value.asHostObject() instanceof List)) {
            Assert.assertFalse((boolean)objectList1.equals(objectList2));
        }
        Assert.assertTrue((boolean)objectList1.equals(objectList1));
        Assert.assertTrue((boolean)((List)value.as(OBJECT_LIST)).equals(value.as(OBJECT_LIST)));
        Assert.assertNotEquals((long)0L, (long)objectList1.hashCode());
        Assert.assertNotNull((Object)objectList1.toString());
        ValueAssert.assertCollectionEqualValues(receivedObjects, objectList1);
        ValueAssert.assertCollectionEqualValues(receivedObjects, objectList2);
        if (value.hasHashEntries()) {
            ValueAssert.assertHashKeys(value);
        } else {
            if (value.hasMembers()) {
                Map objectMap1 = (Map)value.as(OBJECT_OBJECT_MAP);
                Assert.assertTrue((boolean)objectMap1.keySet().equals(value.getMemberKeys()));
            } else {
                ValueAssert.assertFails(() -> value.as(OBJECT_OBJECT_MAP), ClassCastException.class);
            }
            Map objectMap2 = (Map)value.as(LONG_OBJECT_MAP);
            Map objectMap3 = (Map)value.as(INTEGER_OBJECT_MAP);
            Map objectMap4 = (Map)value.as(NUMBER_OBJECT_MAP);
            ValueAssert.assertFails(() -> value.as(SHORT_OBJECT_MAP), ClassCastException.class);
            ValueAssert.assertFails(() -> value.as(BYTE_OBJECT_MAP), ClassCastException.class);
            ValueAssert.assertFails(() -> value.as(FLOAT_OBJECT_MAP), ClassCastException.class);
            ValueAssert.assertFails(() -> value.as(DOUBLE_OBJECT_MAP), ClassCastException.class);
            ValueAssert.assertCollectionEqualValues(receivedObjectsLongMap.values(), objectMap2.values());
            ValueAssert.assertCollectionEqualValues(receivedObjectsIntMap.values(), objectMap3.values());
            ValueAssert.assertCollectionEqualValues(receivedObjectsLongMap.values(), objectMap4.values());
        }
    }

    private static void assertValueBufferElements(Value value) {
        int result;
        long i;
        Assert.assertTrue((boolean)value.hasBufferElements());
        boolean isWritable = value.isBufferWritable();
        for (i = 0L; i < value.getBufferSize(); ++i) {
            result = value.readBufferByte(i);
            if (!isWritable) continue;
            value.writeBufferByte(i, (byte)result);
        }
        for (i = 0L; i < value.getBufferSize() - 1L; i += 2L) {
            result = value.readBufferShort(ByteOrder.LITTLE_ENDIAN, i);
            if (!isWritable) continue;
            value.writeBufferShort(ByteOrder.LITTLE_ENDIAN, i, (short)result);
        }
        for (i = 0L; i < value.getBufferSize() - 3L; i += 4L) {
            result = value.readBufferInt(ByteOrder.LITTLE_ENDIAN, i);
            if (!isWritable) continue;
            value.writeBufferInt(ByteOrder.LITTLE_ENDIAN, i, result);
        }
        for (i = 0L; i < value.getBufferSize() - 7L; i += 8L) {
            long result2 = value.readBufferLong(ByteOrder.LITTLE_ENDIAN, i);
            if (!isWritable) continue;
            value.writeBufferLong(ByteOrder.LITTLE_ENDIAN, i, result2);
        }
        for (i = 0L; i < value.getBufferSize() - 3L; i += 4L) {
            float result3 = value.readBufferFloat(ByteOrder.LITTLE_ENDIAN, i);
            if (!isWritable) continue;
            value.writeBufferFloat(ByteOrder.LITTLE_ENDIAN, i, result3);
        }
        for (i = 0L; i < value.getBufferSize() - 7L; i += 8L) {
            double result4 = value.readBufferDouble(ByteOrder.LITTLE_ENDIAN, i);
            if (!isWritable) continue;
            value.writeBufferDouble(ByteOrder.LITTLE_ENDIAN, i, result4);
        }
    }

    private static void assertCollectionEqualValues(Collection<? extends Object> expected, Collection<? extends Object> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<? extends Object> expectedi = expected.iterator();
        Iterator<? extends Object> actuali = actual.iterator();
        while (expectedi.hasNext()) {
            ValueAssert.assertEqualValues(expectedi.next(), actuali.next());
        }
    }

    private static void assertEqualValues(Object expected, Object actual) {
        Value v0 = Value.asValue((Object)expected);
        Value v1 = Value.asValue((Object)actual);
        List<Trait> expectTraits = Arrays.asList(ValueAssert.detectSupportedTypes(v0));
        List<Trait> actualTraits = Arrays.asList(ValueAssert.detectSupportedTypes(v1));
        Assert.assertEquals(expectTraits, actualTraits);
        for (Trait trait : actualTraits) {
            switch (trait) {
                case NUMBER: {
                    if (v0.fitsInLong()) {
                        Assert.assertEquals((long)v0.asLong(), (long)v1.asLong());
                    } else {
                        Assert.assertFalse((boolean)v1.fitsInLong());
                    }
                    if (v0.fitsInDouble()) {
                        Assert.assertEquals((long)Double.doubleToLongBits(v0.asDouble()), (long)Double.doubleToLongBits(v1.asDouble()));
                        break;
                    }
                    Assert.assertFalse((boolean)v1.fitsInDouble());
                    break;
                }
                case STRING: {
                    Assert.assertEquals((Object)v0.asString(), (Object)v1.asString());
                    break;
                }
                case BOOLEAN: {
                    Assert.assertEquals((Object)v0.asBoolean(), (Object)v1.asBoolean());
                    break;
                }
                case HOST_OBJECT: {
                    Assert.assertEquals((Object)v0, (Object)v1);
                    break;
                }
                case PROXY_OBJECT: {
                    Assert.assertEquals((Object)v0, (Object)v1);
                    break;
                }
                case DURATION: {
                    Assert.assertEquals((Object)v0.asDuration(), (Object)v1.asDuration());
                    break;
                }
                case DATE: {
                    Assert.assertEquals((Object)v0.asDate(), (Object)v1.asDate());
                    break;
                }
                case TIME: {
                    Assert.assertEquals((Object)v0.asTime(), (Object)v1.asTime());
                    break;
                }
                case TIMEZONE: {
                    Assert.assertEquals((Object)v0.asTimeZone(), (Object)v1.asTimeZone());
                    break;
                }
            }
        }
    }

    private static void assertValueIterable(Value value, int depth, boolean hasHostAccess) {
        Assert.assertTrue((boolean)value.hasIterator());
        ArrayList<Object> receivedObjects = new ArrayList<Object>();
        Value iterator = value.getIterator();
        while (iterator.hasIteratorNextElement()) {
            Value element = iterator.getIteratorNextElement();
            receivedObjects.add(element.as(Object.class));
            ValueAssert.assertValueImpl(element, depth + 1, hasHostAccess, ValueAssert.detectSupportedTypes(element));
        }
        Iterable objectIterable = (Iterable)value.as(OBJECT_ITERABLE);
        Assert.assertTrue((boolean)objectIterable.equals(objectIterable));
        Assert.assertTrue((boolean)((Iterable)value.as(OBJECT_ITERABLE)).equals(value.as(OBJECT_ITERABLE)));
        Assert.assertNotEquals((long)0L, (long)objectIterable.hashCode());
        Assert.assertNotNull((Object)objectIterable.toString());
        Iterator receivedIterator = receivedObjects.iterator();
        Iterator objectIterator1 = objectIterable.iterator();
        Iterator objectIterator2 = (Iterator)value.getIterator().as(OBJECT_ITERATOR);
        while (objectIterator1.hasNext() && objectIterator2.hasNext() && receivedIterator.hasNext()) {
            Object expected = receivedIterator.next();
            ValueAssert.assertEqualValues(expected, objectIterator1.next());
            ValueAssert.assertEqualValues(expected, objectIterator2.next());
        }
        Assert.assertFalse((objectIterator1.hasNext() || objectIterator2.hasNext() || receivedIterator.hasNext() ? 1 : 0) != 0);
    }

    private static void assertValueHash(Value value, int depth, boolean hasHostAccess) {
        Assert.assertTrue((boolean)value.hasHashEntries());
        HashMap<Object, Object> receivedObjects = new HashMap<Object, Object>();
        Value iterator = value.getHashEntriesIterator();
        while (iterator.hasIteratorNextElement()) {
            Value element = iterator.getIteratorNextElement();
            Assert.assertTrue((boolean)element.hasArrayElements());
            receivedObjects.put(element.getArrayElement(0L).as(Object.class), element.getArrayElement(1L).as(Object.class));
            ValueAssert.assertValueImpl(element, depth + 1, hasHostAccess, ValueAssert.detectSupportedTypes(element));
        }
        Map objectMap = (Map)value.as(OBJECT_OBJECT_MAP);
        Assert.assertTrue((boolean)objectMap.equals(objectMap));
        Assert.assertTrue((boolean)((Map)value.as(OBJECT_OBJECT_MAP)).equals(value.as(OBJECT_OBJECT_MAP)));
        Assert.assertNotNull((Object)objectMap.toString());
        Iterator receivedIterator = receivedObjects.entrySet().iterator();
        Iterator objectIterator1 = objectMap.entrySet().iterator();
        while (objectIterator1.hasNext() && receivedIterator.hasNext()) {
            Map.Entry expected = receivedIterator.next();
            Map.Entry actual = objectIterator1.next();
            ValueAssert.assertEqualValues(expected.getKey(), actual.getKey());
            ValueAssert.assertEqualValues(expected.getValue(), actual.getValue());
        }
        Assert.assertFalse((objectIterator1.hasNext() || receivedIterator.hasNext() ? 1 : 0) != 0);
    }

    private static void assertHashKeys(Value value) {
        HashSet<Object> hashKeys = new HashSet<Object>();
        Value iterator = value.getHashKeysIterator();
        while (iterator.hasIteratorNextElement()) {
            hashKeys.add(iterator.getIteratorNextElement().as(Object.class));
        }
        Map hashMap = (Map)value.as(OBJECT_OBJECT_MAP);
        Assert.assertTrue((boolean)hashMap.keySet().equals(hashKeys));
    }

    @SafeVarargs
    private static void assertFails(Runnable runnable, Class<? extends Throwable> ... exceptionType) {
        ValueAssert.assertFails(() -> {
            runnable.run();
            return null;
        }, exceptionType);
    }

    @SafeVarargs
    private static void assertFails(Callable<?> callable, Class<? extends Throwable> ... exceptionTypes) {
        try {
            callable.call();
        }
        catch (Throwable t) {
            boolean found = false;
            for (Class<? extends Throwable> exceptionType : exceptionTypes) {
                if (!exceptionType.isInstance(t)) continue;
                found = true;
            }
            if (!found) {
                LinkedHashSet<String> names = new LinkedHashSet<String>();
                for (Class<? extends Throwable> exceptionType : exceptionTypes) {
                    names.add(exceptionType.getName());
                }
                throw new AssertionError("expected instanceof " + names + " was " + t.getClass().getName(), t);
            }
            return;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Class<? extends Throwable> exceptionType : exceptionTypes) {
            names.add(exceptionType.getName());
        }
        Assert.fail((String)("expected " + names + " but no exception was thrown"));
    }

    private static void assertValueNumber(Value value) {
        Assert.assertTrue((boolean)value.isNumber());
        if (value.fitsInByte()) {
            value.asByte();
        } else {
            ValueAssert.assertFails(() -> value.asByte(), ClassCastException.class);
        }
        if (value.fitsInShort()) {
            short shortValue = value.asShort();
            Assert.assertEquals((Object)((byte)shortValue == shortValue ? 1 : 0), (Object)value.fitsInByte());
        } else {
            ValueAssert.assertFails(() -> value.asShort(), ClassCastException.class);
        }
        if (value.fitsInInt()) {
            int intValue = value.asInt();
            Assert.assertEquals((Object)((byte)intValue == intValue ? 1 : 0), (Object)value.fitsInByte());
            Assert.assertEquals((Object)((short)intValue == intValue ? 1 : 0), (Object)value.fitsInShort());
        } else {
            ValueAssert.assertFails(() -> value.asInt(), ClassCastException.class);
        }
        if (value.fitsInLong()) {
            long longValue = value.asLong();
            Assert.assertEquals((Object)((long)((byte)longValue) == longValue ? 1 : 0), (Object)value.fitsInByte());
            Assert.assertEquals((Object)((long)((short)longValue) == longValue ? 1 : 0), (Object)value.fitsInShort());
            Assert.assertEquals((Object)((long)((int)longValue) == longValue ? 1 : 0), (Object)value.fitsInInt());
        } else {
            ValueAssert.assertFails(() -> value.asLong(), ClassCastException.class);
        }
        if (value.fitsInFloat()) {
            value.asFloat();
        } else {
            ValueAssert.assertFails(() -> Float.valueOf(value.asFloat()), ClassCastException.class);
        }
        if (value.fitsInDouble()) {
            value.asDouble();
        } else {
            ValueAssert.assertFails(() -> value.asDouble(), ClassCastException.class);
        }
    }

    private static void assertClassMembers(Value value, Class<?> expectedClass, boolean staticMembers) {
        for (Method m : expectedClass.getMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) != staticMembers) continue;
            Assert.assertTrue((String)m.getName(), (boolean)value.hasMember(m.getName()));
        }
    }

    private static void assertFunctionalInterfaceMapping(Value value) {
        if (value.isHostObject()) {
            Assert.assertNotNull((Object)value.as(Function.class));
        } else {
            Assert.assertNotNull((Object)((Function)value.as(Object.class)));
        }
        Assert.assertNotNull((Object)value.as(Function.class));
        Assert.assertNotNull((Object)value.as(IsFunctionalInterfaceVarArgs.class));
        if (value.isNull()) {
            Assert.assertNull((Object)value.as(EmptyInterface.class));
        } else if (value.hasMembers()) {
            Assert.assertTrue((boolean)(value.as(EmptyInterface.class) instanceof EmptyInterface));
        } else {
            ValueAssert.assertFails(() -> value.as(EmptyInterface.class), ClassCastException.class);
        }
        Function f = (Function)value.as(Function.class);
        Assert.assertEquals((Object)f, (Object)f);
        Assert.assertEquals((Object)value.as(Function.class), (Object)value.as(Function.class));
        Assert.assertNotEquals((Object)value.as(Function.class), e -> e);
        Assert.assertNotNull((Object)((Function)value.as(Function.class)).toString());
        Assert.assertNotEquals((long)0L, (long)((Function)value.as(Function.class)).hashCode());
        if (value.hasMembers() && !value.hasMember("foobarbaz")) {
            ValueAssert.assertFails(() -> ((NonFunctionalInterface)value.as(NonFunctionalInterface.class)).foobarbaz(), UnsupportedOperationException.class);
        }
    }

    private static Trait[] detectSupportedTypes(Value value) {
        ArrayList<Trait> valueTypes = new ArrayList<Trait>();
        if (value.isBoolean()) {
            valueTypes.add(Trait.BOOLEAN);
        }
        if (value.isHostObject()) {
            valueTypes.add(Trait.HOST_OBJECT);
        }
        if (value.isNativePointer()) {
            valueTypes.add(Trait.NATIVE);
        }
        if (value.isString()) {
            valueTypes.add(Trait.STRING);
        }
        if (value.isNumber()) {
            valueTypes.add(Trait.NUMBER);
        }
        if (value.hasMembers()) {
            valueTypes.add(Trait.MEMBERS);
        }
        if (value.hasArrayElements()) {
            valueTypes.add(Trait.ARRAY_ELEMENTS);
        }
        if (value.hasBufferElements()) {
            valueTypes.add(Trait.BUFFER_ELEMENTS);
        }
        if (value.canInstantiate()) {
            valueTypes.add(Trait.INSTANTIABLE);
        }
        if (value.canExecute()) {
            valueTypes.add(Trait.EXECUTABLE);
        }
        if (value.isNull()) {
            valueTypes.add(Trait.NULL);
        }
        if (value.isProxyObject()) {
            valueTypes.add(Trait.PROXY_OBJECT);
        }
        if (value.isDate()) {
            valueTypes.add(Trait.DATE);
        }
        if (value.isTime()) {
            valueTypes.add(Trait.TIME);
        }
        if (value.isTimeZone()) {
            valueTypes.add(Trait.TIMEZONE);
        }
        if (value.isDuration()) {
            valueTypes.add(Trait.DURATION);
        }
        if (value.isException()) {
            valueTypes.add(Trait.EXCEPTION);
        }
        if (value.isMetaObject()) {
            valueTypes.add(Trait.META);
        }
        if (value.hasIterator()) {
            valueTypes.add(Trait.ITERABLE);
        }
        if (value.isIterator()) {
            valueTypes.add(Trait.ITERATOR);
        }
        if (value.hasHashEntries()) {
            valueTypes.add(Trait.HASH);
        }
        return valueTypes.toArray(new Trait[0]);
    }

    public static enum Trait {
        NULL,
        HOST_OBJECT,
        PROXY_OBJECT,
        NUMBER,
        STRING,
        BOOLEAN,
        NATIVE,
        EXECUTABLE,
        INSTANTIABLE,
        MEMBERS,
        ARRAY_ELEMENTS,
        BUFFER_ELEMENTS,
        DATE,
        TIME,
        TIMEZONE,
        DURATION,
        EXCEPTION,
        META,
        ITERABLE,
        ITERATOR,
        HASH;

    }

    @FunctionalInterface
    public static interface IsFunctionalInterfaceVarArgs {
        public Object foobarbaz(Object ... var1);
    }

    @HostAccess.Implementable
    public static interface NonFunctionalInterface {
        public void foobarbaz();

        public void oldmacdonaldhadafarm();
    }

    @HostAccess.Implementable
    public static interface EmptyInterface {
    }
}

