/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck.tests;

import com.oracle.truffle.tck.tests.TestContext;
import com.oracle.truffle.tck.tests.TestRun;
import com.oracle.truffle.tck.tests.TestUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.Snippet;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ValueTest {
    private static final TestUtil.CollectingMatcher<TestRun> TEST_RESULT_MATCHER = TestUtil.createTooManyFailuresMatcher();
    private static TestContext context;
    private final TestRun testRun;

    @Parameterized.Parameters(name="{0}")
    public static Collection<? extends TestRun> createExpressionTests() {
        context = new TestContext(ValueTest.class);
        String javaHostId = "java-host";
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        Snippet identity = context.getInstalledProviders().get(javaHostId).createIdentityFunctionSnippet(context.getContext());
        for (String string : TestUtil.getRequiredValueLanguages(context)) {
            for (Snippet snippet : context.getValueConstructors(null, string)) {
                TestRun testRun = new TestRun(new AbstractMap.SimpleImmutableEntry<String, Snippet>(javaHostId, identity), Collections.singletonList(new AbstractMap.SimpleImmutableEntry<String, Snippet>(string, snippet)));
                testRuns.add(testRun);
            }
        }
        if (testRuns.isEmpty()) {
            ValueTest.afterClass();
        }
        return testRuns;
    }

    @BeforeClass
    public static void setUpClass() {
        TestUtil.assertNoCurrentContext();
    }

    @AfterClass
    public static void afterClass() {
        context.close();
        context = null;
    }

    public ValueTest(TestRun testRun) {
        Objects.requireNonNull(testRun);
        this.testRun = testRun;
    }

    @Test
    public void testValues() {
        Assume.assumeThat((Object)this.testRun, TEST_RESULT_MATCHER);
        boolean success = false;
        try {
            Value value = this.testRun.getActualParameters().get(0);
            TestUtil.validateResult(this.testRun, value, false);
            success = true;
        }
        finally {
            TEST_RESULT_MATCHER.accept(new AbstractMap.SimpleImmutableEntry<TestRun, Boolean>(this.testRun, success));
        }
    }
}

