/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck;

import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.SuspendedCallback;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.collections.Pair;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.junit.Assert;

public final class DebuggerTester
implements AutoCloseable {
    static final boolean TRACE = Boolean.getBoolean("truffle.debug.trace");
    private final BlockingQueue<Object> newEvent;
    private final Semaphore executing;
    private final Semaphore initialized;
    private final Thread evalThread;
    private final Engine engine;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private volatile boolean closed;
    private volatile ExecutingSource executingSource;
    private final ExecutingLoop executingLoop;
    private SuspendedCallback handler;

    private static void trace(String message) {
        if (TRACE) {
            PrintStream out = System.out;
            out.println("DebuggerTester: " + message);
        }
    }

    private static void err(String message) {
        PrintStream out = System.err;
        out.println("DebuggerTester: " + message);
    }

    public DebuggerTester() {
        this(null);
    }

    public DebuggerTester(Context.Builder contextBuilder) {
        this.newEvent = new ArrayBlockingQueue<Object>(1);
        this.executing = new Semaphore(0);
        this.initialized = new Semaphore(0);
        AtomicReference<Engine> engineRef = new AtomicReference<Engine>();
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        this.executingLoop = new ExecutingLoop(contextBuilder, engineRef, error);
        this.evalThread = new Thread(this.executingLoop);
        this.evalThread.start();
        try {
            this.initialized.acquire();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.engine = engineRef.get();
        if (error.get() != null) {
            throw new AssertionError("Engine initialization failed", error.get());
        }
    }

    public String getErr() {
        try {
            this.err.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(this.err.toByteArray());
    }

    public String getOut() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(this.out.toByteArray());
    }

    public Debugger getDebugger() {
        return (Debugger)((Instrument)this.engine.getInstruments().get("debugger")).lookup(Debugger.class);
    }

    public DebuggerSession startSession() {
        return this.getDebugger().startSession(new SuspendedCallback(){

            public void onSuspend(SuspendedEvent event) {
                DebuggerTester.this.onSuspend(event);
            }
        });
    }

    public DebuggerSession startSession(SourceElement ... sourceElements) {
        return this.getDebugger().startSession(new SuspendedCallback(){

            public void onSuspend(SuspendedEvent event) {
                DebuggerTester.this.onSuspend(event);
            }
        }, sourceElements);
    }

    public void startEval(final org.graalvm.polyglot.Source s) {
        this.startExecute(new Function<Context, Value>(){

            @Override
            public Value apply(Context c) {
                return c.eval(s);
            }
        });
    }

    public void startExecute(Function<Context, Value> script) {
        if (this.executingSource != null) {
            throw new IllegalStateException("Already executing other source ");
        }
        this.executingSource = new ExecutingSource(script);
    }

    public void expectSuspended(SuspendedCallback callback) {
        Object event;
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        SuspendedCallback previous = this.handler;
        this.handler = callback;
        this.notifyNextAction();
        try {
            event = this.takeEvent();
            String e = this.getErr();
            if (!e.isEmpty()) {
                throw new AssertionError((Object)("Error output is not empty: " + e));
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        if (event instanceof ExecutingSource) {
            ExecutingSource s = (ExecutingSource)event;
            if (s.error != null) {
                throw new AssertionError("Error in eval", s.error);
            }
            throw new AssertionError((Object)("Expected suspended event got return value " + s.returnValue));
        }
        if (!(event instanceof SuspendedEvent)) {
            if (event instanceof Error) {
                throw (Error)event;
            }
            if (event instanceof RuntimeException) {
                throw (RuntimeException)event;
            }
            throw new AssertionError("Got unknown event.", event instanceof Throwable ? (Throwable)event : null);
        }
        this.handler = previous;
    }

    public Throwable expectThrowable() {
        return (Throwable)this.expectDoneImpl(true);
    }

    public String expectDone() {
        return (String)this.expectDoneImpl(false);
    }

    private Object expectDoneImpl(boolean expectError) throws AssertionError {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        try {
            Object event;
            this.notifyNextAction();
            try {
                event = this.takeEvent();
                String e = this.getErr();
                if (!e.isEmpty()) {
                    throw new AssertionError((Object)("Error output is not empty: " + e));
                }
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            if (event instanceof ExecutingSource) {
                ExecutingSource s = (ExecutingSource)event;
                if (expectError) {
                    if (s.error == null) {
                        throw new AssertionError((Object)("Error expected exception bug got return value: " + s.returnValue));
                    }
                    Throwable throwable = s.error;
                    return throwable;
                }
                if (s.error != null) {
                    throw new AssertionError("Error in eval", s.error);
                }
                String string = s.returnValue;
                return string;
            }
            if (event instanceof SuspendedEvent) {
                throw new AssertionError((Object)("Expected done but got " + event));
            }
            if (event instanceof Throwable) {
                throw new AssertionError("Got exception", (Throwable)event);
            }
            throw new AssertionError((Object)("Got unknown: " + event));
        }
        finally {
            this.executingSource = null;
        }
    }

    public void expectKilled() {
        Throwable error = this.expectThrowable();
        if (error instanceof PolyglotException) {
            Assert.assertTrue((boolean)((PolyglotException)error).isCancelled());
            Assert.assertTrue((String)error.getMessage(), (boolean)error.getMessage().contains("Execution cancelled by a debugging session."));
            return;
        }
        throw new AssertionError("Expected killed bug got error: " + error, error);
    }

    public Thread getEvalThread() {
        return this.evalThread;
    }

    public void closeEngine() {
        this.engine.close();
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        this.closed = true;
        DebuggerTester.trace("kill session " + this);
        this.notifyNextAction();
        try {
            this.evalThread.join();
        }
        catch (InterruptedException iex) {
            throw new AssertionError("Interrupted while joining eval thread.", iex);
        }
        this.engine.close();
    }

    public void assertLineBreakpointsResolution(String sourceWithMarks, String resolvedMarkName, String language) {
        this.assertLineBreakpointsResolution(sourceWithMarks, null, resolvedMarkName, language);
    }

    public void assertLineBreakpointsResolution(String sourceWithMarks, PositionPredicate positionPredicate, String resolvedMarkName, String language) {
        Pattern br = Pattern.compile("(" + resolvedMarkName + "\\d+_|" + resolvedMarkName + "\\d+-\\d+_)");
        HashMap<Integer, Integer> bps = new HashMap<Integer, Integer>();
        String sourceString = sourceWithMarks;
        Matcher bm = br.matcher(sourceString);
        while (bm.find()) {
            int bn2;
            String bg = bm.group();
            int index = bm.start();
            String bpNums = bg.substring(1, bg.length() - 1);
            int rangeIndex = bpNums.indexOf(45);
            if (rangeIndex > 0) {
                bn1 = Integer.parseInt(bpNums.substring(0, rangeIndex));
                bn2 = Integer.parseInt(bpNums.substring(rangeIndex + 1));
            } else {
                bn1 = bn2 = Integer.parseInt(bpNums);
            }
            for (int bn = bn1; bn <= bn2; ++bn) {
                Integer bp = (Integer)bps.get(bn);
                if (bp == null) {
                    bps.put(bn, index + 1);
                    continue;
                }
                Assert.fail((String)(bg + " specified more than once."));
            }
            sourceString = bm.replaceFirst("");
            bm.reset(sourceString);
        }
        if (TRACE) {
            DebuggerTester.trace("sourceString = '" + sourceString + "'");
        }
        org.graalvm.polyglot.Source source = org.graalvm.polyglot.Source.newBuilder((String)language, (CharSequence)sourceString, (String)("testMisplacedLineBreakpoint." + language)).buildLiteral();
        Source tsource = DebuggerTester.getSourceImpl(source);
        for (int l = 1; l < source.getLineCount(); ++l) {
            if (positionPredicate != null && !positionPredicate.testLine(l) || bps.containsKey(l)) continue;
            Assert.fail((String)("Line " + l + " is missing."));
        }
        for (Map.Entry bentry : bps.entrySet()) {
            int line = (Integer)bentry.getKey();
            int indexResolved = (Integer)bentry.getValue();
            int lineResolved = source.getLineNumber(indexResolved - 1);
            if (TRACE) {
                DebuggerTester.trace("TESTING breakpoint '" + line + "' => " + lineResolved + ":");
            }
            DebuggerSession session = this.startSession();
            try {
                this.startEval(source);
                final int[] resolvedIndexPtr = new int[]{0};
                Breakpoint breakpoint = session.install(Breakpoint.newBuilder((Source)tsource).lineIs(line).oneShot().resolveListener(new Breakpoint.ResolveListener(){

                    public void breakpointResolved(Breakpoint brkp, SourceSection section) {
                        resolvedIndexPtr[0] = section.getCharIndex() + 1;
                        if (TRACE) {
                            DebuggerTester.trace("BREAKPOINT resolved to " + section.getStartLine() + ":" + section.getStartColumn());
                        }
                    }
                }).build());
                this.expectSuspended(event -> {
                    Assert.assertEquals((String)("Expected " + line + " => " + lineResolved), (long)lineResolved, (long)event.getSourceSection().getStartLine());
                    Assert.assertSame((Object)breakpoint, event.getBreakpoints().iterator().next());
                    event.prepareContinue();
                });
                this.expectDone();
                Assert.assertEquals((String)("Expected resolved " + line + " => " + indexResolved), (long)indexResolved, (long)resolvedIndexPtr[0]);
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
    }

    public void assertColumnBreakpointsResolution(String sourceWithMarks, String breakpointMarkName, String resolvedMarkName, String language) {
        this.assertColumnBreakpointsResolution(sourceWithMarks, breakpointMarkName, resolvedMarkName, language, null);
    }

    public void assertColumnBreakpointsResolution(String sourceWithMarks, String breakpointMarkName, String resolvedMarkName, String language, URI bpURI) {
        Pattern br = Pattern.compile("([" + breakpointMarkName + resolvedMarkName + "]\\d+_|" + resolvedMarkName + "\\d+-\\d+_)");
        HashMap<Integer, int[]> bps = new HashMap<Integer, int[]>();
        String sourceString = sourceWithMarks;
        Matcher bm = br.matcher(sourceString);
        while (bm.find()) {
            int bn2;
            String bg = bm.group();
            int index = bm.start();
            int state = bg.charAt(0) == 'B' ? 0 : 1;
            String bpNums = bg.substring(1, bg.length() - 1);
            int rangeIndex = bpNums.indexOf(45);
            if (rangeIndex > 0) {
                bn1 = Integer.parseInt(bpNums.substring(0, rangeIndex));
                bn2 = Integer.parseInt(bpNums.substring(rangeIndex + 1));
            } else {
                bn1 = bn2 = Integer.parseInt(bpNums);
            }
            for (int bn = bn1; bn <= bn2; ++bn) {
                int[] bp = (int[])bps.get(bn);
                if (bp == null) {
                    bp = new int[2];
                    bps.put(bn, bp);
                }
                if (bp[state] > 0) {
                    Assert.fail((String)(bg + " specified more than once."));
                }
                bp[state] = index + 1;
            }
            sourceString = bm.replaceFirst("");
            bm.reset(sourceString);
        }
        if (TRACE) {
            DebuggerTester.trace("sourceString = '" + sourceString + "'");
        }
        org.graalvm.polyglot.Source source = org.graalvm.polyglot.Source.newBuilder((String)language, (CharSequence)sourceString, (String)("testMisplacedColumnBreakpoint." + language)).buildLiteral();
        for (Map.Entry bentry : bps.entrySet()) {
            int bpId = (Integer)bentry.getKey();
            int[] bp = (int[])bentry.getValue();
            Assert.assertTrue((String)Integer.toString(bpId), (bp[0] > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)Integer.toString(bpId), (bp[1] > 0 ? 1 : 0) != 0);
            int line = source.getLineNumber(bp[0] - 1);
            int column = source.getColumnNumber(bp[0] - 1);
            if (TRACE) {
                DebuggerTester.trace("TESTING BP_" + bpId + ": " + bp[0] + " (" + line + ":" + column + ") => " + bp[1] + ":");
            }
            DebuggerSession session = this.startSession();
            try {
                this.startEval(source);
                final int[] resolvedLineColumn = new int[]{0, 0};
                Breakpoint.Builder bpBuilder = bpURI != null ? Breakpoint.newBuilder((URI)bpURI) : Breakpoint.newBuilder((Source)DebuggerTester.getSourceImpl(source));
                Breakpoint breakpoint = session.install(bpBuilder.lineIs(line).columnIs(column).oneShot().resolveListener(new Breakpoint.ResolveListener(){

                    public void breakpointResolved(Breakpoint brkp, SourceSection section) {
                        resolvedLineColumn[0] = section.getStartLine();
                        resolvedLineColumn[1] = section.getStartColumn();
                        if (TRACE) {
                            DebuggerTester.trace("  resolved: " + resolvedLineColumn[0] + ":" + resolvedLineColumn[1]);
                        }
                    }
                }).build());
                int bpLine = source.getLineNumber(bp[1] - 1);
                int bpColumn = source.getColumnNumber(bp[1] - 1);
                Pair breakpointPosition = Pair.create((Object)bpLine, (Object)bpColumn);
                this.expectSuspended(event -> {
                    Pair eventPosition = Pair.create((Object)event.getSourceSection().getStartLine(), (Object)event.getSourceSection().getStartColumn());
                    Assert.assertEquals((String)("B" + bpId + ": Expected " + bp[0] + " => " + breakpointPosition + ", event at " + eventPosition), (Object)breakpointPosition, (Object)eventPosition);
                    Assert.assertSame((Object)breakpoint, event.getBreakpoints().iterator().next());
                    event.prepareContinue();
                });
                this.expectDone();
                Pair resolvedPosition = Pair.create((Object)resolvedLineColumn[0], (Object)resolvedLineColumn[1]);
                Assert.assertEquals((String)("B" + bpId + ": Expected resolved " + bp[0] + " => " + bp[1]), (Object)breakpointPosition, (Object)resolvedPosition);
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
    }

    public void assertBreakpointsBreakEverywhere(org.graalvm.polyglot.Source source) {
        this.assertBreakpointsBreakEverywhere(source, null);
    }

    public void assertBreakpointsBreakEverywhere(org.graalvm.polyglot.Source source, PositionPredicate positionPredicate) {
        int l;
        int numLines = source.getLineCount();
        int numColumns = 0;
        for (int i = 1; i <= numLines; ++i) {
            int ll = source.getLineLength(i);
            if (ll <= numColumns) continue;
            numColumns = ll;
        }
        Source tsource = DebuggerTester.getSourceImpl(source);
        ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
        final HashMap<Breakpoint, SourceSection> breakpointsResolved = new HashMap<Breakpoint, SourceSection>();
        ArrayList<Breakpoint> breakpointsHit = new ArrayList<Breakpoint>();
        Breakpoint.ResolveListener resolveListener = new Breakpoint.ResolveListener(){

            public void breakpointResolved(Breakpoint breakpoint, SourceSection section) {
                Assert.assertTrue((String)("Resolved at " + section + ", have " + breakpointsResolved.get(breakpoint)), (!breakpointsResolved.containsKey(breakpoint) || !section.equals(breakpointsResolved.get(breakpoint)) ? 1 : 0) != 0);
                breakpointsResolved.put(breakpoint, section);
            }
        };
        for (l = 1; l <= numLines; ++l) {
            if (positionPredicate != null && !positionPredicate.testLine(l)) continue;
            Breakpoint breakpoint = Breakpoint.newBuilder((Source)tsource).lineIs(l).oneShot().resolveListener(resolveListener).build();
            breakpoints.add(breakpoint);
        }
        this.assertBreakpoints(source, breakpoints, breakpointsResolved, breakpointsHit);
        breakpoints.clear();
        breakpointsResolved.clear();
        breakpointsHit.clear();
        for (l = 1; l <= numLines; ++l) {
            int endColumn = l == numLines ? source.getLineLength(l) : numColumns + 5;
            for (int c = 1; c < endColumn; ++c) {
                if (positionPredicate != null && !positionPredicate.testLineColumn(l, c)) continue;
                Breakpoint breakpoint = Breakpoint.newBuilder((Source)tsource).lineIs(l).columnIs(c).oneShot().resolveListener(resolveListener).build();
                breakpoints.add(breakpoint);
            }
        }
        this.assertBreakpoints(source, breakpoints, breakpointsResolved, breakpointsHit);
    }

    private void assertBreakpoints(org.graalvm.polyglot.Source source, List<Breakpoint> breakpoints, Map<Breakpoint, SourceSection> breakpointsResolved, List<Breakpoint> breakpointsHit) {
        try (DebuggerSession session = this.startSession(new SourceElement[0]);){
            for (Breakpoint breakpoint : breakpoints) {
                session.install(breakpoint);
            }
            this.startEval(source);
            while (breakpointsHit.size() != breakpoints.size()) {
                try {
                    this.expectSuspended(event -> {
                        breakpointsHit.addAll(event.getBreakpoints());
                        event.prepareContinue();
                    });
                }
                catch (Throwable t) {
                    HashSet<Breakpoint> notHit = new HashSet<Breakpoint>(breakpoints);
                    notHit.removeAll(breakpointsHit);
                    for (Breakpoint b : notHit) {
                        DebuggerTester.err("Not hit " + b + ": " + b.getLocationDescription());
                    }
                    DebuggerTester.err("---");
                    for (Breakpoint b : breakpointsHit) {
                        DebuggerTester.err("Hit     " + b + ": " + b.getLocationDescription());
                    }
                    throw t;
                }
            }
            this.expectDone();
        }
        Assert.assertEquals((long)breakpoints.size(), (long)breakpointsResolved.size());
        Assert.assertEquals((long)breakpoints.size(), (long)breakpointsHit.size());
    }

    public static Source getSourceImpl(org.graalvm.polyglot.Source source) {
        return (Source)DebuggerTester.getField(source, "receiver");
    }

    private static Object getField(Object value, String name) {
        try {
            Field f = value.getClass().getDeclaredField(name);
            DebuggerTester.setAccessible(f, true);
            return f.get(value);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void setAccessible(Field field, boolean flag) {
        DebuggerTester.openForReflectionTo(field.getDeclaringClass(), DebuggerTester.class);
        field.setAccessible(flag);
    }

    private static void openForReflectionTo(Class<?> declaringClass, Class<?> accessor) {
        try {
            Object accessorModule;
            Object moduleToOpen;
            Method getModule = Class.class.getMethod("getModule", new Class[0]);
            Class<?> moduleClass = getModule.getReturnType();
            Class<?> modulesClass = Class.forName("jdk.internal.module.Modules");
            Method addOpens = DebuggerTester.maybeGetAddOpensMethod(moduleClass, modulesClass);
            if (addOpens != null && (moduleToOpen = getModule.invoke(declaringClass, new Object[0])) != (accessorModule = getModule.invoke(accessor, new Object[0]))) {
                addOpens.invoke(null, moduleToOpen, declaringClass.getPackage().getName(), accessorModule);
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Method maybeGetAddOpensMethod(Class<?> moduleClass, Class<?> modulesClass) {
        try {
            return modulesClass.getDeclaredMethod("addOpens", moduleClass, String.class, moduleClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void putEvent(Object event) {
        DebuggerTester.trace("Put event " + event + " to " + this + ": " + Thread.currentThread());
        if (event instanceof SuspendedEvent) {
            try {
                if (this.handler == null) {
                    throw new AssertionError((Object)("Expected done but got event " + event));
                }
                this.handler.onSuspend((SuspendedEvent)event);
            }
            catch (Throwable e) {
                this.newEvent.add(e);
                return;
            }
        }
        this.newEvent.add(event);
    }

    private Object takeEvent() throws InterruptedException {
        DebuggerTester.trace("Take event " + this + ": " + Thread.currentThread());
        try {
            Object object = this.newEvent.take();
            return object;
        }
        finally {
            DebuggerTester.trace("Taken event " + this + ": " + Thread.currentThread());
        }
    }

    private void onSuspend(SuspendedEvent event) {
        DebuggerTester.trace("On SUSPEND " + event + " of " + this + ": " + Thread.currentThread());
        if (this.closed) {
            return;
        }
        try {
            this.putEvent(event);
        }
        finally {
            this.waitForExecuting();
        }
    }

    private void waitForExecuting() {
        DebuggerTester.trace("Wait for executing " + this + ": " + Thread.currentThread());
        if (this.closed) {
            return;
        }
        try {
            this.executing.acquire();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        DebuggerTester.trace("Wait for executing released " + this + ": " + Thread.currentThread());
    }

    private void notifyNextAction() {
        DebuggerTester.trace("Notify next action " + this + ": " + Thread.currentThread());
        this.executing.release();
    }

    class ExecutingLoop
    implements Runnable {
        private final Context.Builder contextBuilder;
        private final AtomicReference<Engine> engineRef;
        private final AtomicReference<Throwable> error;

        ExecutingLoop(Context.Builder contextBuilder, AtomicReference<Engine> engineRef, AtomicReference<Throwable> error) {
            this.contextBuilder = contextBuilder != null ? contextBuilder : Context.newBuilder((String[])new String[0]);
            this.engineRef = engineRef;
            this.error = error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            context = null;
            try {
                context = this.contextBuilder.out((OutputStream)DebuggerTester.this.out).err((OutputStream)DebuggerTester.this.err).build();
                this.engineRef.set(context.getEngine());
                DebuggerTester.this.initialized.release();
            }
            catch (Throwable t) {
                block24: {
                    this.error.set(t);
                    if (context == null) break block24;
                    try {
                        context.close();
                    }
                    catch (PolyglotException pe) {
                        if (pe.isCancelled() || pe.isExit()) break block24;
                        throw pe;
                    }
                }
                return;
                catch (Throwable var4_7) {
                    throw var4_7;
                }
                finally {
                    DebuggerTester.this.initialized.release();
                }
            }
            while (true) lbl-1000:
            // 4 sources

            {
                DebuggerTester.this.waitForExecuting();
                if (DebuggerTester.this.closed) {
                    return;
                }
                s = DebuggerTester.this.executingSource;
                try {
                    DebuggerTester.trace("Start executing " + s + " on " + DebuggerTester.this + ": " + Thread.currentThread());
                    s.returnValue = s.function.apply(context).toString();
                }
                catch (Throwable e) {
                    s.error = e;
                }
                finally {
                    DebuggerTester.trace("Done executing " + s + " on " + DebuggerTester.this + ": " + Thread.currentThread());
                    DebuggerTester.this.putEvent(s);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                block25: {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (PolyglotException pe) {
                            if (pe.isCancelled() || pe.isExit()) break block25;
                            throw pe;
                        }
                    }
                }
            }
        }
    }

    private static final class ExecutingSource {
        private final Function<Context, Value> function;
        private Throwable error;
        private String returnValue;

        ExecutingSource(Function<Context, Value> function) {
            this.function = function;
        }

        public String toString() {
            return "ExecutingSource[" + this.function + "], error = " + this.error + ", returnValue = " + this.returnValue;
        }
    }

    public static interface PositionPredicate {
        public boolean testLine(int var1);

        public boolean testLineColumn(int var1, int var2);
    }
}

