/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tck;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.tck.TruffleTestInvoker;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.graalvm.polyglot.Context;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.junit.runners.parameterized.BlockJUnit4ClassRunnerWithParameters;
import org.junit.runners.parameterized.ParametersRunnerFactory;
import org.junit.runners.parameterized.TestWithParameters;

public class TruffleRunner
extends BlockJUnit4ClassRunner {
    private static final TruffleTestInvoker<?, ?> truffleTestInvoker = TruffleTestInvoker.create();

    public TruffleRunner(Class<?> klass) throws InitializationError {
        super((TestClass)new TruffleTestInvoker.TruffleTestClass(klass));
    }

    public TruffleRunner(TestClass testClass) throws InitializationError {
        super((TestClass)new TruffleTestInvoker.TruffleTestClass(testClass.getJavaClass()));
    }

    protected final Statement methodInvoker(FrameworkMethod method, Object test) {
        Statement ret = truffleTestInvoker.createStatement(this.getTestClass().getJavaClass().getSimpleName() + "#" + this.testName(method), method, test);
        if (ret == null) {
            ret = super.methodInvoker(method, test);
        }
        return ret;
    }

    protected final void validateTestMethods(List<Throwable> errors) {
        TruffleTestInvoker.validateTestMethods(this.getTestClass(), errors);
    }

    private static final class ParameterizedRunner
    extends BlockJUnit4ClassRunnerWithParameters {
        ParameterizedRunner(TestWithParameters test) throws InitializationError {
            super(new TestWithParameters(test.getName(), (TestClass)new TruffleTestInvoker.TruffleTestClass(test.getTestClass().getJavaClass()), test.getParameters()));
        }

        protected Statement methodInvoker(FrameworkMethod method, Object test) {
            Statement ret = truffleTestInvoker.createStatement(this.getTestClass().getJavaClass().getSimpleName() + "#" + this.testName(method), method, test);
            if (ret == null) {
                ret = super.methodInvoker(method, test);
            }
            return ret;
        }

        protected void validateTestMethods(List<Throwable> errors) {
            TruffleTestInvoker.validateTestMethods(this.getTestClass(), errors);
        }
    }

    public static final class RunWithPolyglotRule
    implements TestRule {
        Context.Builder contextBuilder;
        Context context = null;
        TruffleLanguage<?> testLanguage = null;
        TruffleLanguage.Env testEnv = null;

        public RunWithPolyglotRule() {
            this(Context.newBuilder((String[])new String[0]).allowAllAccess(true));
        }

        public RunWithPolyglotRule(Context.Builder contextBuilder) {
            this.contextBuilder = contextBuilder;
        }

        public Statement apply(Statement stmt, Description description) {
            return TruffleTestInvoker.withTruffleContext(this, stmt);
        }

        public Context getPolyglotContext() {
            assert (this.context != null);
            return this.context;
        }

        public TruffleLanguage.Env getTruffleTestEnv() {
            assert (this.testEnv != null);
            return this.testEnv;
        }

        public TruffleLanguage<?> getTestLanguage() {
            assert (this.testLanguage != null);
            return this.testLanguage;
        }
    }

    public static final class ParametersFactory
    implements ParametersRunnerFactory {
        public Runner createRunnerForTestWithParameters(TestWithParameters test) throws InitializationError {
            return new ParameterizedRunner(test);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Warmup {
        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Inject {
        public Class<? extends RootNode> value();
    }
}

