/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;

@ExportLibrary(value=InteropLibrary.class)
public class WasmType
implements TruffleObject {
    public static final byte VOID_TYPE = 64;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] VOID_TYPE_ARRAY = new byte[0];
    public static final byte NULL_TYPE = 0;
    public static final byte UNKNOWN_TYPE = -1;
    public static final byte I32_TYPE = 127;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] I32_TYPE_ARRAY = new byte[]{127};
    public static final byte I64_TYPE = 126;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] I64_TYPE_ARRAY = new byte[]{126};
    public static final byte F32_TYPE = 125;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] F32_TYPE_ARRAY = new byte[]{125};
    public static final byte F64_TYPE = 124;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] F64_TYPE_ARRAY = new byte[]{124};
    public static final byte V128_TYPE = 123;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] V128_TYPE_ARRAY = new byte[]{123};
    public static final byte FUNCREF_TYPE = 112;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] FUNCREF_TYPE_ARRAY = new byte[]{112};
    public static final byte EXTERNREF_TYPE = 111;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] EXTERNREF_TYPE_ARRAY = new byte[]{111};
    public static final WasmType VOID = new WasmType("void");
    public static final WasmType NULL = new WasmType("null");
    public static final WasmType MULTI_VALUE = new WasmType("multi-value");
    public static final int NONE_COMMON_TYPE = 0;
    public static final int NUM_COMMON_TYPE = 1;
    public static final int OBJ_COMMON_TYPE = 2;
    public static final int MIX_COMMON_TYPE = 3;
    private final String name;

    public static String toString(int valueType) {
        CompilerAsserts.neverPartOfCompilation();
        switch (valueType) {
            case 127: {
                return "i32";
            }
            case 126: {
                return "i64";
            }
            case 125: {
                return "f32";
            }
            case 124: {
                return "f64";
            }
            case 123: {
                return "v128";
            }
            case 64: {
                return "void";
            }
            case 112: {
                return "funcref";
            }
            case 111: {
                return "externref";
            }
        }
        throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, null, "Unknown value type: 0x" + Integer.toHexString(valueType));
    }

    public static boolean isNumberType(byte type) {
        return type == 127 || type == 126 || type == 125 || type == 124 || type == -1;
    }

    public static boolean isVectorType(byte type) {
        return type == 123 || type == -1;
    }

    public static boolean isReferenceType(byte type) {
        return type == 112 || type == 111 || type == -1;
    }

    public static int getCommonValueType(byte[] types) {
        int type = 0;
        for (byte resultType : types) {
            type |= WasmType.isNumberType(resultType) ? 1 : 0;
            type |= WasmType.isVectorType(resultType) || WasmType.isReferenceType(resultType) ? 2 : 0;
        }
        return type;
    }

    public WasmType(String name) {
        this.name = name;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return WasmLanguage.class;
    }

    @ExportMessage
    boolean isMetaObject() {
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="getMetaQualifiedName"), @ExportMessage(name="getMetaSimpleName")})
    public Object getName() {
        return this.name;
    }

    @ExportMessage(name="toDisplayString")
    Object toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    @ExportMessage
    final boolean isMetaInstance(Object instance) {
        return instance instanceof WasmConstant;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "wasm-value-type[" + this.name + "]";
    }
}

