/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.Arrays;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.api.Sequence;

@ExportLibrary(value=InteropLibrary.class)
public class Dictionary
implements TruffleObject {
    private final EconomicMap<String, Object> members = EconomicMap.create();

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    protected static UnknownIdentifierException unknown(String identifier) {
        return UnknownIdentifierException.create((String)identifier);
    }

    @ExportMessage
    public Object readMember(String member) throws UnknownIdentifierException {
        return this.get(member);
    }

    @CompilerDirectives.TruffleBoundary
    private Object get(String member) throws UnknownIdentifierException {
        Object x = this.members.get((Object)member);
        if (x != null) {
            return x;
        }
        throw Dictionary.unknown(member);
    }

    public void addMembers(Object[] nameValuePairs) {
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            String name = (String)nameValuePairs[i];
            Object value = nameValuePairs[i + 1];
            this.addMember(name, value);
        }
    }

    public void addMember(String name, Object value) {
        this.members.put((Object)name, value);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object getMembers(boolean includeInternal) {
        String[] keys = new String[this.members.size()];
        int i = 0;
        for (String key : this.members.getKeys()) {
            keys[i++] = key;
        }
        assert (i == keys.length);
        return new Sequence<String>(Arrays.asList(keys));
    }

    @ExportMessage
    public boolean isMemberReadable(String member) {
        return this.containsKey(member);
    }

    @CompilerDirectives.TruffleBoundary
    private boolean containsKey(String member) {
        return this.members.containsKey((Object)member);
    }

    public static Dictionary create(Object[] nameValuePairs) {
        Dictionary dictionary = new Dictionary();
        dictionary.addMembers(nameValuePairs);
        return dictionary;
    }

    @ExportMessage(name="toDisplayString")
    public Object toDisplayString(boolean allowSideEffects) {
        return this.format();
    }

    @CompilerDirectives.TruffleBoundary
    private Object format() {
        return this.getClass().getName() + "[" + String.valueOf(this.members) + "]";
    }
}

